/* Copyright (C) 2005 Bjoern Beutel. */

/* Description. =============================================================*/

/* This module manages child processes with optional input and/or output
 * pipes. */

/* Types. ===================================================================*/

/* The description of a Malaga child process. */
typedef struct
{
  bool_t use_input; /* If TRUE, open a pipe from the child process to the
		     * parent process. Connect it to stdout in the child
		     * process and to INPUT_STREAM in the parent process. */
  FILE *input_stream;
  bool_t use_output; /* If TRUE, open a pipe from the parent process to the
		      * child process. Connect it to OUTPUT_STREAM in the
		      * parent process and to stdin in the child process. */
  FILE *output_stream;
  string_t name; /* Child process name, e.g. "display process". */
  string_t command_line; /* Command line that is executed when the child
			  * process is started. */
  ptr_t id; /* OS-dependent child process id. */
} process_t;

/* Functions. ===============================================================*/

bool_t start_process( process_t *process );
/* Check whether PROCESS is still running. If not, start PROCESS anew by
 * executing PROCESS->COMMAND_LINE.
 * The fields PROCESS->USE_INPUT, PROCESS->USE_OUTPUT, PROCESS->NAME and
 * PROCESS->COMMAND_LINE must have been set.
 * If PROCESS->USE_INPUT == TRUE, open a pipe from the child process to the
 * parent process. Connect it to stdout in the child process and to
 * INPUT_STREAM in the parent process.
 * If PROCESS->USE_OUTPUT == TRUE, open a pipe from the parent process to the
 * child process. Connect it to OUTPUT_STREAM in the parent process and to
 * stdin in the child process.
 * Return TRUE if process has actually been started now. */

void stop_process( process_t *process );
/* Stop the Malaga PROCESS. */

/* End of file. =============================================================*/
