!{\src2tex{textfont=tt}}
!!****f* ABINIT/initro
!!
!! NAME
!! initro
!!
!! FUNCTION
!! Initialize the density using a gaussian of adjustable decay length
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! atindx(natom)=index table for atoms (see scfcv.f)
!! densty(ntypat,4)=parameters for initialisation of the density of each atom type
!! gmet(3,3)=reciprocal space metric (Bohr**-2)
!! gsqcut=cutoff G**2 for included G s in fft box (larger sphere).
!! izero=if 1, unbalanced components of rho(g) have to be set to zero
!! mgfft=maximum size of 1D FFTs
!! mpi_enreg=informations about mpi parallelization
!! natom=number of atoms in cell.
!! nattyp(ntypat)=number of atoms of each type in cell.
!! nfft=(effective) number of FFT grid points (for this processor)
!! ngfft(18)=contain all needed information about 3D FFT, see ~abinit/doc/input_variables/vargs.htm#ngfft
!! ntypat=number of types of atoms in cell.
!! nspden=number of spin-density components
!! ph1d(2,3*(2*mgfft+1)*natom)=1-dim phase information for given atom coordinates.
!! spinat(3,natom)=initial spin of each atom, in unit of hbar/2.
!! ucvol=unit cell volume (Bohr**3).
!! zion(ntypat)=charge on each type of atom (real number)
!! znucl(ntypat)=atomic number, for each type of atom
!!
!! OUTPUT
!! rhog(2,nfft)=initialized total density in reciprocal space
!! rhor(nfft,nspden)=initialized total density in real space.
!!         as well as spin-up part if spin-polarized
!!
!! PARENTS
!!      gstate
!!
!! CHILDREN
!!      fourdp,wrtout,zerosym
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine initro(atindx,densty,gmet,gsqcut,izero,mgfft,mpi_enreg,natom,nattyp,&
&  nfft,ngfft,nspden,ntypat,ph1d,rhog,rhor,spinat,ucvol,zion,znucl)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_12ffts
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: izero,mgfft,natom,nfft,nspden,ntypat
 real(dp),intent(in) :: gsqcut,ucvol
 type(mpi_type) :: mpi_enreg
!arrays
 integer,intent(in) :: atindx(natom),nattyp(ntypat),ngfft(18)
 real(dp),intent(in) :: densty(ntypat,4),gmet(3,3),ph1d(2,3*(2*mgfft+1)*natom)
 real(dp),intent(in) :: spinat(3,natom),zion(ntypat),znucl(ntypat)
 real(dp),intent(out) :: rhog(2,nfft),rhor(nfft,nspden)

!Local variables-------------------------------
!The decay lengths should be optimized element by element, and even
!pseudopotential by pseudopotential.
!scalars
 integer,parameter :: im=2,natnum=110,re=1
 integer :: i1,i2,i3,ia,ia1,ia2,id1,id2,id3,ig1,ig2,ig3,ii,ir,isign,ispden
 integer :: itypat,jtemp,me_fft,n1,n2,n3,nproc_fft,nri,nval
 real(dp),parameter :: tolfix=1.000000001_dp
 real(dp) :: alf2pi2,coreel,cutoff,fact,gsq,gsquar,ph1,ph2,ph3,phi,phimag,phr
 real(dp) :: phre,rhoat,sfi,sfr,x1,x2,x3,xnorm,y1,y2,y3
 character(len=500) :: message
!arrays
 real(dp) :: data_length(16)
 real(dp),allocatable :: length(:),spinat_indx(:,:),work(:)

! *************************************************************************

!Real and imaginary parts of phase--statment functions:
 phr(x1,y1,x2,y2,x3,y3)=(x1*x2-y1*y2)*x3-(y1*x2+x1*y2)*y3
 phi(x1,y1,x2,y2,x3,y3)=(x1*x2-y1*y2)*y3+(y1*x2+x1*y2)*x3
 ph1(nri,ig1,ia)=ph1d(nri,ig1+1+n1+(ia-1)*(2*n1+1))
 ph2(nri,ig2,ia)=ph1d(nri,ig2+1+n2+(ia-1)*(2*n2+1)+&
&               natom*(2*n1+1))
 ph3(nri,ig3,ia)=ph1d(nri,ig3+1+n3+(ia-1)*(2*n3+1)+&
&               natom*(2*n1+1+2*n2+1))
 phre(ig1,ig2,ig3,ia)=phr(ph1(re,ig1,ia),ph1(im,ig1,ia),&
&    ph2(re,ig2,ia),ph2(im,ig2,ia),ph3(re,ig3,ia),ph3(im,ig3,ia))
 phimag(ig1,ig2,ig3,ia)=phi(ph1(re,ig1,ia),ph1(im,ig1,ia),&
&    ph2(re,ig2,ia),ph2(im,ig2,ia),ph3(re,ig3,ia),ph3(im,ig3,ia))

 gsq(i1,i2,i3)=dble(i1*i1)*gmet(1,1)+dble(i2*i2)*gmet(2,2)+&
& dble(i3*i3)*gmet(3,3)+dble(2*i1*i2)*gmet(1,2)+&
& dble(2*i2*i3)*gmet(2,3)+dble(2*i3*i1)*gmet(3,1)

 if(nspden==4)then
  write(6,*)' initro : might work yet for nspden=4 (not checked)'
  write(6,*)'spinat',spinat(1:3,1:natom)
!  stop
 end if

!Check whether the values of spinat are acceptable
 if(nspden==2)then
  ia1=1
  do itypat=1,ntypat
!  ia1,ia2 sets range of loop over atoms:
   ia2=ia1+nattyp(itypat)-1
   do ia=ia1,ia2
    if( sqrt(spinat(1,ia)**2+spinat(2,ia)**2+spinat(3,ia)**2) &
&                       > abs(zion(itypat))*(1.0_dp + epsilon(0.0_dp)) ) then
     write(message, '(a,a,a,a,i4,a,a,3es10.4,a,a,a,es10.4)' ) ch10,&
&     ' initro : WARNING - ',ch10,&
&     '  For atom number ',ia,ch10,&
&     '  input spinat=',spinat(:,ia),'  is larger, in magnitude,',ch10,&
&     '  than zion(ia)=',zion(itypat)
     call wrtout(6,message,'COLL')
     call wrtout(ab_out,message,'COLL')
    end if
   end do
   ia1=ia2+1
  end do
 end if

 n1=ngfft(1)
 n2=ngfft(2)
 n3=ngfft(3)
 me_fft=ngfft(11)
 nproc_fft=ngfft(10)
 allocate(work(nfft),spinat_indx(3,natom))

!Transfer the spinat array to an array in which the atoms have the
!proper order, type by type.
 do ia=1,natom
  spinat_indx(:,atindx(ia))=spinat(:,ia)
 end do

!Compute the decay length of each type of atom
 allocate(length(ntypat))
 do itypat=1,ntypat

! Either use the input value, or the default value, tabulated now.
  if(abs(densty(itypat,1))>1.0d-10)then
   length(itypat)=densty(itypat,1)
  else

!  Count the number of core electrons.
   coreel=znucl(itypat)-zion(itypat)
!  Round the number of valence electrons
   nval=nint(zion(itypat))

!  For each set of core electron numbers, there are different decay lengths,
!  they start from nval=1, and proceed by group of 5, until a default is used

!  Bare ions : adjusted on 1h and 2he only
   if(coreel<0.5)then
    data_length(1:4)=(/ .6_dp,.4_dp,.3_dp,.25_dp /)
    length(itypat)=.2_dp
    if(nval<=4)length(itypat)=data_length(nval)

!  1s2 core : adjusted on 3li, 6c, 7n, and 8o
   else if(coreel<2.5)then
    data_length(1:8)=(/ 1.8_dp,1.4_dp,1.0_dp ,.7_dp,.6_dp,&
&                        .5_dp, .4_dp, .35_dp /)
    length(itypat)=.3_dp
    if(nval<=8)length(itypat)=data_length(nval)

!  Ne core (1s2 2s2 2p6) : adjusted on 11na, 13al, 14si and 17cl
   else if(coreel<10.5)then
    data_length(1:10)=(/ 2.0_dp,1.6_dp,1.25_dp,1.1_dp,1.0_dp,&
&                         .9_dp, .8_dp, .7_dp , .7_dp, .7_dp  /)
    length(itypat)=.6_dp
    if(nval<=10)length(itypat)=data_length(nval)

!  Mg core (1s2 2s2 2p6 3s2) : adjusted on 19k, and on coreel==10
   else if(coreel<12.5)then
    data_length(1:10)=(/ 1.9_dp,1.5_dp,1.15_dp,1.0_dp,0.9_dp,&
&                         .8_dp, .7_dp, .6_dp , .6_dp, .6_dp  /)
    length(itypat)=.5_dp
    if(nval<=10)length(itypat)=data_length(nval)

!  Ar core (Ne + 3s2 3p6) : adjusted on 20ca, 25mn and 30zn
   else if(coreel<18.5)then
    data_length(1:12)=(/ 2.0_dp ,1.8_dp ,1.5_dp,1.2_dp ,1.0_dp,&
&                         .9_dp , .85_dp, .8_dp, .75_dp, .7_dp,&
&                         .65_dp, .65_dp /)
    length(itypat)=.6_dp
    if(nval<=12)length(itypat)=data_length(nval)

!  Full 3rd shell core (Ar + 3d10) : adjusted on 31ga, 34se and 38sr
   else if(coreel<28.5)then
    data_length(1:14)=(/ 1.5_dp ,1.25_dp,1.15_dp,1.05_dp,1.00_dp,&
&                         .95_dp, .95_dp, .9_dp , .9_dp , .85_dp,&
&                         .85_dp, .80_dp, .8_dp , .75_dp         /)
    length(itypat)=.7_dp
    if(nval<=14)length(itypat)=data_length(nval)

!  Krypton core (Ar + 3d10 4s2 4p6) : adjusted on 39y, 42mo and 48cd
   else if(coreel<36.5)then
    data_length(1:12)=(/ 2.0_dp ,2.00_dp,1.60_dp,1.40_dp,1.25_dp,&
&                        1.10_dp,1.00_dp, .95_dp, .90_dp, .85_dp,&
&                         .80_dp, .75_dp /)
    length(itypat)=.7_dp
    if(nval<=12)length(itypat)=data_length(nval)

!  For the remaining elements, consider a function of nval only
   else
    data_length(1:12)=(/ 2.0_dp ,2.00_dp,1.55_dp,1.25_dp,1.15_dp,&
&                        1.10_dp,1.05_dp,1.0_dp , .95_dp , .9_dp,&
&                         .85_dp, .85_dp /)
    length(itypat)=.8_dp
    if(nval<=12)length(itypat)=data_length(nval)

   end if

! End the choice between default and no-default
  end if

!DEBUG
!  Here, use the previous default
!  length(itypat)=1.2_dp
!ENDDEBUG

  write(message,'(a,i3,a,f12.4,a,a,a,f12.4,a,i3,a,es12.4,a)' )&
&  ' initro : for itypat=',itypat,', take decay length=',length(itypat),',',&
&  ch10,' initro : indeed, coreel=',coreel,', nval=',nval,&
&      ' and densty=',densty(itypat,1),'.'
  call wrtout(6,message,'COLL')

 end do

 cutoff=gsqcut*tolfix
 xnorm=1.0_dp/ucvol
!
 id1=n1/2+2
 id2=n2/2+2
 id3=n3/2+2
 if(nspden /= 4) then

 do ispden=nspden,1,-1
!This loop overs spins will actually be as follows :
! ispden=2 for spin up
! ispden=1 for total spin (also valid for non-spin-polarized calculations)
! The reverse ispden order is chosen, in order to end up with
! rhog containing the proper total density.

  rhog(:,:)=0.0_dp

  ia1=1
  do itypat=1,ntypat

   alf2pi2=(two_pi*length(itypat))**2

!  ia1,ia2 sets range of loop over atoms:
   ia2=ia1+nattyp(itypat)-1
   ii=0
   jtemp=0
   do i3=1,n3
    ig3=i3-(i3/id3)*n3-1
    do i2=1,n2
     ig2=i2-(i2/id2)*n2-1
!    if (me_fft==modulo(i2,nproc_fft)) then
     if (((i2-1)/(n2/nproc_fft))==me_fft) then
     do i1=1,n1

      ig1=i1-(i1/id1)*n1-1
      ii=ii+1
      gsquar=gsq(ig1,ig2,ig3)

!     Skip G**2 outside cutoff:
      if (gsquar<=cutoff) then
!      Assemble structure factor over all atoms of given type,
!      also taking into account the spin-charge on each atom:
       sfr=0.0_dp
       sfi=0.0_dp
       if(ispden==1)then
        do ia=ia1,ia2
         sfr=sfr+phre(ig1,ig2,ig3,ia)
         sfi=sfi-phimag(ig1,ig2,ig3,ia)
        end do
        sfr=sfr*zion(itypat)
        sfi=sfi*zion(itypat)
       else
        do ia=ia1,ia2
!        Here, take care only of the z component
         fact=0.5_dp*(zion(itypat)+spinat_indx(3,ia))
         sfr=sfr+phre(ig1,ig2,ig3,ia)*fact
         sfi=sfi-phimag(ig1,ig2,ig3,ia)*fact
        end do
       end if
!      Charge density integrating to one
       rhoat=xnorm*exp(-gsquar*alf2pi2)
!      Multiply structure factor times rhoat (atomic density in reciprocal space)
       rhog(re,ii)=rhog(re,ii)+sfr*rhoat
       rhog(im,ii)=rhog(im,ii)+sfi*rhoat
      else
       jtemp=jtemp+1
      end if

!    End loop on i1
     end do
     end if
!   End loop on i2
    end do
!  End loop on i3
   end do
   ia1=ia2+1

! End loop on type of atoms
  end do

! Set contribution of unbalanced components to zero
  if (izero==1) call zerosym(rhog,2,mpi_enreg,n1,n2,n3)
! Note, we end with ispden=1, so that rhog contains the total density
  call fourdp(1,rhog,work,1,mpi_enreg,nfft,ngfft,0)
  rhor(:,ispden)=work(:)
!End loop on spins
 end do
 else if(nspden==4) then
  do ispden=nspden,1,-1
!This loop overs spins will actually be as follows :
! ispden=2,3,4 for mx,my,mz
! ispden=1 for total spin (also valid for non-spin-polarized calculations)
! The reverse ispden order is chosen, in order to end up with
! rhog containing the proper total density.

  rhog(:,:)=0.0_dp

  ia1=1
  do itypat=1,ntypat

   alf2pi2=(two_pi*length(itypat))**2

!  ia1,ia2 sets range of loop over atoms:
   ia2=ia1+nattyp(itypat)-1
   ii=0
   jtemp=0
   do i3=1,n3
    ig3=i3-(i3/id3)*n3-1
    do i2=1,n2
     ig2=i2-(i2/id2)*n2-1
!     if (me_fft==modulo(i2,nproc_fft)) then
     if (((i2-1)/(n2/nproc_fft))==me_fft) then
     do i1=1,n1

      ig1=i1-(i1/id1)*n1-1
      ii=ii+1
      gsquar=gsq(ig1,ig2,ig3)

!     Skip G**2 outside cutoff:
      if (gsquar<=cutoff) then
!      Assemble structure factor over all atoms of given type,
!      also taking into account the spin-charge on each atom:
       sfr=0.0_dp
       sfi=0.0_dp
       if(ispden==1)then
        do ia=ia1,ia2
         sfr=sfr+phre(ig1,ig2,ig3,ia)
         sfi=sfi-phimag(ig1,ig2,ig3,ia)
        end do
        sfr=sfr*zion(itypat)
        sfi=sfi*zion(itypat)
       else
        do ia=ia1,ia2
!        Here, take care of the components of m
         fact=spinat_indx(ispden-1,ia)
         sfr=sfr+phre(ig1,ig2,ig3,ia)*fact
         sfi=sfi-phimag(ig1,ig2,ig3,ia)*fact
        end do
       end if
!      Charge density integrating to one
       rhoat=xnorm*exp(-gsquar*alf2pi2)
!      Multiply structure factor times rhoat (atomic density in reciprocal space)
       rhog(re,ii)=rhog(re,ii)+sfr*rhoat
       rhog(im,ii)=rhog(im,ii)+sfi*rhoat
      else
       jtemp=jtemp+1
      end if

!    End loop on i1
     end do
     end if
!   End loop on i2
    end do
!  End loop on i3
   end do
   ia1=ia2+1

! End loop on type of atoms
  end do

! Set contribution of unbalanced components to zero
  if (izero==1) call zerosym(rhog,2,mpi_enreg,n1,n2,n3)

! Note, we end with ispden=1, so that rhog contains the total density
  call fourdp(1,rhog,work,1,mpi_enreg,nfft,ngfft,0)
  rhor(:,ispden)=work(:)

!End loop on spins
 end do
 end if
!DEBUG
! do ir=1,nfft,30
! do ir=1,nfft/(2*nproc_fft*20),24
!  write(6,*)'rhor',ir,rhor(ir,:)
! end do
! stop
!ENDDEBUG

 deallocate(length,spinat_indx,work)

end subroutine initro
!!***
