/*
Copyright (C) 2002 Pedro Zorzenon Neto <pzn@vztech.com.br>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Do not forget to visit Free Software Foundation site: http://fsf.org

$Id: parport.h,v 1.2 2003/06/30 17:20:25 pzn Exp $
*/
#ifndef _PARPORT_H
#define _PARPORT_H

/* SPP standard parallel port
 *     http://www.beyondlogic.org/spp/parallel.htm */

/* parallel port output bits */
#define PARPORT_D0 0
#define PARPORT_D1 1
#define PARPORT_D2 2
#define PARPORT_D3 3
#define PARPORT_D4 4
#define PARPORT_D5 5
#define PARPORT_D6 6
#define PARPORT_D7 7
#define PARPORT_STROBE   0 /* hardware inverted */
#define PARPORT_LINEFEED 1 /* hardware inverted */
#define PARPORT_RESET    2
#define PARPORT_SELECT   3

/* parallel port input bits */
#define PARPORT_ERROR    3
#define PARPORT_SELECTIN 4 /* hardware inverted */
#define PARPORT_PAPEROUT 5
#define PARPORT_ACK      6
#define PARPORT_BUSY     7 /* hardware inverted */

typedef struct parport {
  long int base_address;
  unsigned int last_write;
} parport_t;

parport_t * parport_init (long int base_address);
void parport_destroy (parport_t * self);

int parport_readbit (parport_t * self, int bit);
unsigned int parport_readbyte (parport_t * self);

void parport_writebit (parport_t * self, int bit, unsigned int value);
void parport_writebyte (parport_t * self, unsigned int value);

#endif
