/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.adapt.gnu.crypto.hash;

import jonelo.jacksum.adapt.gnu.crypto.hash.BaseHash;
import jonelo.jacksum.adapt.gnu.crypto.util.Util;

public class RipeMD128
extends BaseHash {
    private static final int BLOCK_SIZE = 64;
    private static final String DIGEST0 = "CDF26213A150DC3ECB610F18F6B38B46";
    private static final int[] R = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2};
    private static final int[] Rp = new int[]{5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14};
    private static final int[] S = new int[]{11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12};
    private static final int[] Sp = new int[]{8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8};
    private static Boolean valid;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int[] X = new int[16];

    public RipeMD128() {
        super("ripemd128", 16, 64);
    }

    private RipeMD128(RipeMD128 ripeMD128) {
        this();
        this.h0 = ripeMD128.h0;
        this.h1 = ripeMD128.h1;
        this.h2 = ripeMD128.h2;
        this.h3 = ripeMD128.h3;
        this.count = ripeMD128.count;
        this.buffer = (byte[])ripeMD128.buffer.clone();
    }

    public Object clone() {
        return new RipeMD128(this);
    }

    protected void transform(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        for (n8 = 0; n8 < 16; ++n8) {
            this.X[n8] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | byArray[n++] << 24;
        }
        int n9 = n7 = this.h0;
        int n10 = n6 = this.h1;
        int n11 = n5 = this.h2;
        int n12 = n4 = this.h3;
        for (n8 = 0; n8 < 16; ++n8) {
            n3 = S[n8];
            n2 = n9 + (n10 ^ n11 ^ n12) + this.X[n8];
            n9 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n2 << n3 | n2 >>> 32 - n3;
            n3 = Sp[n8];
            n2 = n7 + (n6 & n4 | n5 & ~n4) + this.X[Rp[n8]] + 1352829926;
            n7 = n4;
            n4 = n5;
            n5 = n6;
            n6 = n2 << n3 | n2 >>> 32 - n3;
        }
        while (n8 < 32) {
            n3 = S[n8];
            n2 = n9 + (n10 & n11 | ~n10 & n12) + this.X[R[n8]] + 1518500249;
            n9 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n2 << n3 | n2 >>> 32 - n3;
            n3 = Sp[n8];
            n2 = n7 + ((n6 | ~n5) ^ n4) + this.X[Rp[n8]] + 1548603684;
            n7 = n4;
            n4 = n5;
            n5 = n6;
            n6 = n2 << n3 | n2 >>> 32 - n3;
            ++n8;
        }
        while (n8 < 48) {
            n3 = S[n8];
            n2 = n9 + ((n10 | ~n11) ^ n12) + this.X[R[n8]] + 1859775393;
            n9 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n2 << n3 | n2 >>> 32 - n3;
            n3 = Sp[n8];
            n2 = n7 + (n6 & n5 | ~n6 & n4) + this.X[Rp[n8]] + 1836072691;
            n7 = n4;
            n4 = n5;
            n5 = n6;
            n6 = n2 << n3 | n2 >>> 32 - n3;
            ++n8;
        }
        while (n8 < 64) {
            n3 = S[n8];
            n2 = n9 + (n10 & n12 | n11 & ~n12) + this.X[R[n8]] + -1894007588;
            n9 = n12;
            n12 = n11;
            n11 = n10;
            n10 = n2 << n3 | n2 >>> 32 - n3;
            n3 = Sp[n8];
            n2 = n7 + (n6 ^ n5 ^ n4) + this.X[Rp[n8]];
            n7 = n4;
            n4 = n5;
            n5 = n6;
            n6 = n2 << n3 | n2 >>> 32 - n3;
            ++n8;
        }
        n2 = this.h1 + n11 + n4;
        this.h1 = this.h2 + n12 + n7;
        this.h2 = this.h3 + n9 + n6;
        this.h3 = this.h0 + n10 + n5;
        this.h0 = n2;
    }

    protected byte[] padBuffer() {
        int n = (int)(this.count % 64L);
        int n2 = n < 56 ? 56 - n : 120 - n;
        byte[] byArray = new byte[n2 + 8];
        byArray[0] = -128;
        long l = this.count << 3;
        byArray[n2++] = (byte)l;
        byArray[n2++] = (byte)(l >>> 8);
        byArray[n2++] = (byte)(l >>> 16);
        byArray[n2++] = (byte)(l >>> 24);
        byArray[n2++] = (byte)(l >>> 32);
        byArray[n2++] = (byte)(l >>> 40);
        byArray[n2++] = (byte)(l >>> 48);
        byArray[n2] = (byte)(l >>> 56);
        return byArray;
    }

    protected byte[] getResult() {
        byte[] byArray = new byte[]{(byte)this.h0, (byte)(this.h0 >>> 8), (byte)(this.h0 >>> 16), (byte)(this.h0 >>> 24), (byte)this.h1, (byte)(this.h1 >>> 8), (byte)(this.h1 >>> 16), (byte)(this.h1 >>> 24), (byte)this.h2, (byte)(this.h2 >>> 8), (byte)(this.h2 >>> 16), (byte)(this.h2 >>> 24), (byte)this.h3, (byte)(this.h3 >>> 8), (byte)(this.h3 >>> 16), (byte)(this.h3 >>> 24)};
        return byArray;
    }

    protected void resetContext() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
    }

    public boolean selfTest() {
        if (valid == null) {
            valid = new Boolean(DIGEST0.equals(Util.toString(new RipeMD128().digest())));
        }
        return valid;
    }
}

