<!--
.. title: Security advisory: CVE-2017-7651, CVE-2017-7652
.. slug: security-advisory-cve-2017-7651-cve-2017-7652
.. date: 2018-02-27 16:37:29 UTC
.. tags: Security,Releases
.. category:
.. link:
.. description:
.. type: text
-->

Mosquitto 1.4.15 has been released to address two security vulnerabilities.

# CVE-2017-7651

A vulnerability exists in all Mosquitto versions up to and including 1.4.14
known as [CVE-2017-7651].

Unauthenticated clients can send a crafted CONNECT packet which causes large
amounts of memory use in the broker. If multiple clients do this, an out of
memory situation can occur and the system may become unresponsive or the broker
will be killed by the operating system.

The issue is fixed in Mosquitto 1.4.15. Patches for older versions are
available at <https://mosquitto.org/files/cve/2017-7651>

The fix addresses the problem by limiting the permissible size for CONNECT
packet, and by adding a `memory_limit` configuration option that allows the
broker to self limit the amount of memory it uses.

Thanks to Felipe Balabanian for finding this vulnerability and responsibly
reporting it.

# CVE-2017-7652

A vulnerability exists in Mosquitto versions 1.0 to 1.4.14 inclusive
known as [CVE-2017-7652].

If the broker has exhausted all of its free sockets/file descriptors and then a
SIGHUP signal is received to trigger reloading of the configuration, then the
reloading will fail. This results in many of the configuration options,
including security options, being set to their default value. This means that
authorisation and access control may no longer be in place.

The issue is fixed in Mosquitto 1.4.15. Patches for older versions are
available at <https://mosquitto.org/files/cve/2017-7652>

The fix addresses the problem by only copying the new configuration options to
the in use configuration after a successful reload has taken place.

# Version 1.4.15 Changes

The complete list of fixes addressed in version 1.4.15 is:

## Security
* Fix [CVE-2017-7652]. If a SIGHUP is sent to the broker when there are no more
  file descriptors, then opening the configuration file will fail and security
  settings will be set back to their default values.
* Fix [CVE-2017-7651]. Unauthenticated clients can cause excessive memory use by
  setting "remaining length" to be a large value. This is now mitigated by
  limiting the size of remaining length to valid values. A `memory_limit`
  configuration option has also been added to allow the overall memory used by
  the broker to be limited.

## Broker
* Use constant time memcmp for password comparisons.
* Fix incorrect PSK key being used if it had leading zeroes.
* Fix memory leak if a client provided a username/password for a listener with
  `use_identity_as_username` configured.
* Fix `use_identity_as_username` not working on websockets clients.
* Don't crash if an auth plugin returns `MOSQ_ERR_AUTH` for a username check on
  a websockets client. Closes [#490].
* Fix 08-ssl-bridge.py test when using async dns lookups. Closes [#507].
* Lines in the config file are no longer limited to 1024 characters long.
  Closes [#652].
* Fix $SYS counters of messages and bytes sent when message is sent over
  a Websockets. Closes [#250].
* Fix `upgrade_outgoing_qos` for retained message. Closes [#534].
* Fix CONNACK message not being sent for unauthorised connect on websockets.
  Closes [#8].

## Client library
* Fix incorrect PSK key being used if it had leading zeroes.
* Initialise "result" variable as soon as possible in
  `mosquitto_topic_matches_sub`. Closes [#654].
* No need to close socket again if setting non-blocking failed. Closes [#649].
* Fix `mosquitto_topic_matches_sub()` not correctly matching `foo/bar` against
  `foo/+/#`. Closes [#670].

## Clients
* Correctly handle empty files with `mosquitto_pub -l`. Closes [#676].

## Build
* Don't run TLS-PSK tests if TLS-PSK disabled at compile time. Closes [#636].


[CVE-2017-7651]: http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-7651
[CVE-2017-7652]: http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-7652
[#8]: https://github.com/eclipse/mosquitto/issues/8
[#250]: https://github.com/eclipse/mosquitto/issues/250
[#490]: https://github.com/eclipse/mosquitto/issues/490
[#507]: https://github.com/eclipse/mosquitto/issues/507
[#534]: https://github.com/eclipse/mosquitto/issues/534
[#636]: https://github.com/eclipse/mosquitto/issues/636
[#649]: https://github.com/eclipse/mosquitto/issues/649
[#652]: https://github.com/eclipse/mosquitto/issues/652
[#654]: https://github.com/eclipse/mosquitto/issues/654
[#670]: https://github.com/eclipse/mosquitto/issues/670
[#676]: https://github.com/eclipse/mosquitto/issues/676
