/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2013  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_ACCENT_TYPE_RULE_H
#define NJD_SET_ACCENT_TYPE_RULE_H

#ifdef __cplusplus
#define NJD_SET_ACCENT_TYPE_RULE_H_START extern "C" {
#define NJD_SET_ACCENT_TYPE_RULE_H_END   }
#else
#define NJD_SET_ACCENT_TYPE_RULE_H_START
#define NJD_SET_ACCENT_TYPE_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_ACCENT_TYPE_RULE_H_START;

#define NJD_SET_ACCENT_TYPE_KAZU "\xbf\xf4"
#define NJD_SET_ACCENT_TYPE_ICHI "\xb0\xec"
#define NJD_SET_ACCENT_TYPE_NI "\xc6\xf3"
#define NJD_SET_ACCENT_TYPE_SAN "\xbb\xb0"
#define NJD_SET_ACCENT_TYPE_YON "\xbb\xcd"
#define NJD_SET_ACCENT_TYPE_GO "\xb8\xde"
#define NJD_SET_ACCENT_TYPE_ROKU "\xcf\xbb"
#define NJD_SET_ACCENT_TYPE_NANA "\xbc\xb7"
#define NJD_SET_ACCENT_TYPE_HACHI "\xc8\xac"
#define NJD_SET_ACCENT_TYPE_KYUU "\xb6\xe5"
#define NJD_SET_ACCENT_TYPE_JYUU "\xbd\xbd"
#define NJD_SET_ACCENT_TYPE_HYAKU "\xc9\xb4"
#define NJD_SET_ACCENT_TYPE_SEN "\xc0\xe9"
#define NJD_SET_ACCENT_TYPE_MAN "\xcb\xfc"
#define NJD_SET_ACCENT_TYPE_OKU "\xb2\xaf"
#define NJD_SET_ACCENT_TYPE_CHOU "\xc3\xfb"
#define NJD_SET_ACCENT_TYPE_SUU "\xbf\xf4"
#define NJD_SET_ACCENT_TYPE_NAN "\xb2\xbf"
#define NJD_SET_ACCENT_TYPE_IKU "\xb4\xf6"

NJD_SET_ACCENT_TYPE_RULE_H_END;

#endif                          /* !NJD_SET_ACCENT_TYPE_RULE_H */
