% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessToken.R
\name{accessToken}
\alias{accessToken}
\alias{setAccessToken}
\title{Get and set GitHub access tokens}
\usage{
accessToken(full = FALSE, request = TRUE, cache = cacheDirectory())

setAccessToken(
  token,
  app.url = restUrl(),
  app.key = NULL,
  app.secret = NULL,
  github.url = "https://api.github.com",
  user.agent = NULL,
  cache = cacheDirectory()
)
}
\arguments{
\item{full}{Logical scalar indicating whether to return the full token details.}

\item{request}{Logical scalar indicating whether to request a new token if no cached token is available or if the current token has expired.}

\item{cache}{String containing a path to the cache directory, to store the token across R sessions.
If \code{NULL}, the token is not cached to (or read from) disk, which improves security on shared filesystems.}

\item{token}{String containing a GitHub personal access token.
This should have the \code{"read:org"} and \code{"read:user"} scopes.
If missing, the user will be prompted to use GitHub's Oauth web application flow to acquire a token.
If \code{NULL}, any existing tokens are cleared from cache.}

\item{app.url}{String containing a URL of the gypsum REST API.
This is used to obtain \code{app.key} and \code{app.secret} if either are \code{NULL}.}

\item{app.key}{String containing the key for a GitHub Oauth app.}

\item{app.secret}{String containing the secret for a GitHub Oauth app.}

\item{github.url}{String containing the URL for the GitHub API.
This is used to acquire more information about the token.}

\item{user.agent}{String specifying the user agent for queries to various endpoints.}
}
\value{
\code{setAccessToken} sets the access token and invisibly returns a list containing:
\itemize{
\item \code{token}, a string containing the token.
\item \code{name}, the name of the GitHub user authenticated by the token.
\item \code{expires}, the Unix time at which the token expires.
}

If \code{full=TRUE}, \code{accessToken} returns the same list, typically retrieved from one of the caches.
If no token was cached or the cached token has expired, it will call \code{setAccessToken} with default arguments to obtain one if \code{request=TRUE};
otherwise if \code{request=FALSE}, \code{NULL} is returned.

If \code{full=FALSE}, \code{accessToken} will return a string containing a token (or \code{NULL}, if no token is available and \code{request=FALSE}).
}
\description{
Get and set GitHub access tokens for authentication to the gypsum API's endpoints.
}
\examples{
if (interactive()) {
    accessToken()
}
}
\author{
Aaron Lun
}
