% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSummary.R
\name{readFast5Summary}
\alias{readFast5Summary}
\title{Read summary data from fast5 files.}
\usage{
readFast5Summary(files)
}
\arguments{
\item{files}{Character vector of fast5 files to be read.}
}
\value{
Object of class \linkS4class{Fast5Summary}
}
\description{
Reads one or more fast5 files and collects summary information about them.
}
\details{
Currently this function assumes all files passed to it come from the same 
sequencing run.  It makes no effort to check for alternative file names or 
the like.  If files from multiple runs are passed to it they will be 
collated together and any analysis performed on them will represent the 
mixture of both experiments.
}
\examples{
\dontrun{
fast5files <- list.files('/foo/bar/', pattern = '.fast5$')
summaryData <- readFast5Summary(fast5files)
}
}
