% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowWeightedSds.R
\name{rowWeightedSds}
\alias{rowWeightedSds}
\alias{rowWeightedSds,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowWeightedSds,ANY-method}
\alias{colWeightedSds}
\alias{colWeightedSds,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colWeightedSds,ANY-method}
\title{Calculates the weighted standard deviation for each row (column) of a
matrix-like object}
\usage{
rowWeightedSds(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE,
  ..., useNames = TRUE)

\S4method{rowWeightedSds}{matrix_OR_array_OR_table_OR_numeric}(x, w = NULL,
  rows = NULL, cols = NULL, na.rm = FALSE, ..., useNames = TRUE)

\S4method{rowWeightedSds}{ANY}(x, w = NULL, rows = NULL, cols = NULL,
  na.rm = FALSE, ..., useNames = TRUE)

colWeightedSds(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE,
  ..., useNames = TRUE)

\S4method{colWeightedSds}{matrix_OR_array_OR_table_OR_numeric}(x, w = NULL,
  rows = NULL, cols = NULL, na.rm = FALSE, ..., useNames = TRUE)

\S4method{colWeightedSds}{ANY}(x, w = NULL, rows = NULL, cols = NULL,
  na.rm = FALSE, ..., useNames = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{w}{A \code{\link{numeric}} vector of length K (N) that specifies by
how much each element is weighted.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{TRUE}} (default), names attributes of result are set. Else if \code{\link{FALSE}}, no naming support is done.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the weighted standard deviation for each row (column) of a
matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowWeightedSds}} /
\code{matrixStats::\link[matrixStats]{colWeightedSds}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)
w <- rnorm(n = 5, mean = 3)
rowWeightedSds(mat, w = w[1:3])
colWeightedSds(mat, w = w)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:weightedVar]{rowWeightedSds}()} and
\code{matrixStats::\link[matrixStats:weightedVar]{colWeightedSds}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \link{rowSds} for the corresponding unweighted function.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
