% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitFeatureModel.R
\name{fitFeatureModel}
\alias{fitFeatureModel}
\title{Computes differential abundance analysis using a zero-inflated log-normal model}
\usage{
fitFeatureModel(obj, mod, coef = 2, B = 1, szero = FALSE, spos = TRUE)
}
\arguments{
\item{obj}{A MRexperiment object with count data.}

\item{mod}{The model for the count distribution.}

\item{coef}{Coefficient of interest to grab log fold-changes.}

\item{B}{Number of bootstraps to perform if >1. If >1 performs permutation test.}

\item{szero}{TRUE/FALSE, shrink zero component parameters.}

\item{spos}{TRUE/FALSE, shrink positive component parameters.}
}
\value{
A list of objects including:
\itemize{
 \item{call - the call made to fitFeatureModel}
 \item{fitZeroLogNormal  - list of parameter estimates for the zero-inflated log normal model}
 \item{design - model matrix}
 \item{taxa - taxa names}
 \item{counts - count matrix}
 \item{pvalues - calculated p-values}
 \item{permuttedfits - permutted z-score estimates under the null}
}
}
\description{
Wrapper to actually run zero-inflated log-normal model given a MRexperiment object
and model matrix. User can decide to shrink parameter estimates.
}
\examples{

data(lungData)
lungData = lungData[,-which(is.na(pData(lungData)$SmokingStatus))]
lungData=filterData(lungData,present=30,depth=1)
lungData <- cumNorm(lungData, p=.5)
s <- normFactors(lungData)
pd <- pData(lungData)
mod <- model.matrix(~1+SmokingStatus, data=pd)
lungres1 = fitFeatureModel(lungData,mod)

}
\seealso{
\code{\link{cumNorm}}
}
