% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mapValues.R
\name{mapValues}
\alias{mapValues}
\title{Replace values in atomic vectors}
\usage{
mapValues(x, from, to, regex = FALSE, ignore.case = FALSE, perl = FALSE,
  fixed = FALSE)
}
\arguments{
\item{x}{[\code{atomic}]\cr
Atomic vector. If \code{x} is a factor, all replacements work on the levels.}

\item{from}{[\code{atomic}]\cr
Atomic vector with values to replace, same length as \code{to}.}

\item{to}{[\code{atomic}]\cr
Atomic vector with replacements, same length as \code{from}.}

\item{regex}{[\code{logical}]\cr
Use regular expression matching? Default is \code{FALSE}.}

\item{ignore.case}{[\code{logical}]\cr
Argument passed to \code{\link[base]{gsub}}.}

\item{perl}{[\code{logical}]\cr
Argument passed to \code{\link[base]{gsub}}.}

\item{fixed}{[\code{logical}]\cr
Argument passed to \code{\link[base]{gsub}}.}
}
\value{
[\code{atomic}].
}
\description{
Replace values in atomic vectors
}
\details{
Replaces values specified in \code{from} with values in \code{to}.
Regular expression matching can be enabled which calls \code{\link[base]{gsub}} iteratively
on \code{x} to replace all patterns in \code{from} with replacements in \code{to}.
}
\examples{
# replace integers
x = 1:5
mapValues(x, c(2, 3), c(99, 100))

# replace factor levels using regex matching
x = factor(c("aab", "aba", "baa"))
mapValues(x, "a.a", "zzz", regex = TRUE)
}

