% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{Frechet}
\alias{Frechet}
\alias{dfrechet}
\alias{pfrechet}
\alias{qfrechet}
\alias{rfrechet}
\title{The Frechet Distribution}
\usage{
dfrechet(x, loc = 0, scale = 1, shape = 1, log = FALSE)

pfrechet(q, loc = 0, scale = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

qfrechet(p, loc = 0, scale = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

rfrechet(n, loc = 0, scale = 1, shape = 1)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{loc}{Vector of locations.}

\item{scale}{Vector of scales.}

\item{shape}{Vector of shapes.}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x). 
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{p}{Vector of probabilities.}

\item{n}{Number of samples to draw from the distribution.}
}
\description{
Density, distribution function, quantile function and random generation 
for the Frechet distribution with location \code{loc}, scale \code{scale},
and shape \code{shape}.
}
\details{
See \code{vignette("brms_families")} for details
on the parameterization.
}
