% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-ad.R
\name{addition-terms}
\alias{addition-terms}
\alias{resp_se}
\alias{resp_weights}
\alias{resp_trials}
\alias{resp_thres}
\alias{resp_cat}
\alias{resp_dec}
\alias{resp_cens}
\alias{resp_trunc}
\alias{resp_mi}
\alias{resp_index}
\alias{resp_rate}
\alias{resp_subset}
\alias{resp_vreal}
\alias{resp_vint}
\title{Additional Response Information}
\usage{
resp_se(x, sigma = FALSE)

resp_weights(x, scale = FALSE)

resp_trials(x)

resp_thres(x, gr = NA)

resp_cat(x)

resp_dec(x)

resp_cens(x, y2 = NA)

resp_trunc(lb = -Inf, ub = Inf)

resp_mi(sdy = NA)

resp_index(x)

resp_rate(denom)

resp_subset(x)

resp_vreal(...)

resp_vint(...)
}
\arguments{
\item{x}{A vector; usually a variable defined in the data. Allowed values
depend on the function: \code{resp_se} and \code{resp_weights} require
positive numeric values. \code{resp_trials}, \code{resp_thres}, and
\code{resp_cat} require positive integers. \code{resp_dec} requires
\code{0} and \code{1}, or alternatively \code{'lower'} and \code{'upper'}.
\code{resp_subset} requires \code{0} and \code{1}, or alternatively
\code{FALSE} and \code{TRUE}. \code{resp_cens} requires \code{'left'},
\code{'none'}, \code{'right'}, and \code{'interval'} (or equivalently
\code{-1}, \code{0}, \code{1}, and \code{2}) to indicate left, no, right,
or interval censoring. \code{resp_index} does not make any requirements
other than the value being unique for each observation.}

\item{sigma}{Logical; Indicates whether the residual standard deviation
parameter \code{sigma} should be included in addition to the known
measurement error. Defaults to \code{FALSE} for backwards compatibility,
but setting it to \code{TRUE} is usually the better choice.}

\item{scale}{Logical; Indicates whether weights should be scaled
so that the average weight equals one. Defaults to \code{FALSE}.}

\item{gr}{A vector of grouping indicators.}

\item{y2}{A vector specifying the upper bounds in interval censoring.
Will be ignored for non-interval censored observations. However, it 
should NOT be \code{NA} even for non-interval censored observations to
avoid accidental exclusion of these observations.}

\item{lb}{A numeric vector or single numeric value specifying 
the lower truncation bound.}

\item{ub}{A numeric vector or single numeric value specifying 
the upper truncation bound.}

\item{sdy}{Optional known measurement error of the response
treated as standard deviation. If specified, handles
measurement error and (completely) missing values
at the same time using the plausible-values-technique.}

\item{denom}{A vector of positive numeric values specifying
the denominator values from which the response rates are computed.}

\item{...}{For \code{resp_vreal}, vectors of real values. 
For \code{resp_vint}, vectors of integer values. In Stan,
these variables will be named \code{vreal1}, \code{vreal2}, ...,
and \code{vint1}, \code{vint2}, ..., respectively.}
}
\value{
A list of additional response information to be processed further
  by \pkg{brms}.
}
\description{
Provide additional information on the response variable 
in \pkg{brms} models, such as censoring, truncation, or
known measurement error.
}
\details{
These functions are almost solely useful when
  called in formulas passed to the \pkg{brms} package.
  Within formulas, the \code{resp_} prefix may be omitted.
  More information is given in the 'Details' section
  of \code{\link{brmsformula}}.
}
\examples{
\dontrun{
## Random effects meta-analysis
nstudies <- 20
true_effects <- rnorm(nstudies, 0.5, 0.2)
sei <- runif(nstudies, 0.05, 0.3)
outcomes <- rnorm(nstudies, true_effects, sei)
data1 <- data.frame(outcomes, sei)
fit1 <- brm(outcomes | se(sei, sigma = TRUE) ~ 1,
            data = data1)
summary(fit1)

## Probit regression using the binomial family
n <- sample(1:10, 100, TRUE)  # number of trials
success <- rbinom(100, size = n, prob = 0.4)
x <- rnorm(100)
data2 <- data.frame(n, success, x)
fit2 <- brm(success | trials(n) ~ x, data = data2,
            family = binomial("probit"))
summary(fit2)

## Survival regression modeling the time between the first 
## and second recurrence of an infection in kidney patients.
fit3 <- brm(time | cens(censored) ~ age * sex + disease + (1|patient), 
            data = kidney, family = lognormal())
summary(fit3)

## Poisson model with truncated counts  
fit4 <- brm(count | trunc(ub = 104) ~ zBase * Trt, 
            data = epilepsy, family = poisson())
summary(fit4)
}
  
}
\seealso{
\code{\link{brm}}, 
  \code{\link{brmsformula}}
}
