% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covr.R
\name{code_coverage}
\alias{code_coverage}
\title{Calculate coverage of code directly}
\usage{
code_coverage(
  source_code,
  test_code,
  line_exclusions = NULL,
  function_exclusions = NULL,
  ...
)
}
\arguments{
\item{source_code}{A character vector of source code}

\item{test_code}{A character vector of test code}

\item{line_exclusions}{a named list of files with the lines to exclude from
each file.}

\item{function_exclusions}{a vector of regular expressions matching function
names to exclude. Example \verb{print\\\\\\.} to match print methods.}

\item{...}{Additional arguments passed to \code{\link[=file_coverage]{file_coverage()}}}
}
\description{
This function is useful for testing, and is a thin wrapper around
\code{\link[=file_coverage]{file_coverage()}} because parseData is not populated properly
unless the functions are defined in a file.
}
\examples{
source <- "add <- function(x, y) { x + y }"
test <- "add(1, 2) == 3"
code_coverage(source, test)
}
