% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_hive.R
\name{layout_tbl_graph_hive}
\alias{layout_tbl_graph_hive}
\title{Place nodes in a Hive Plot layout}
\usage{
layout_tbl_graph_hive(
  graph,
  axis,
  axis.pos = NULL,
  sort.by = NULL,
  divide.by = NULL,
  divide.order = NULL,
  normalize = TRUE,
  center.size = 0.1,
  divide.size = 0.05,
  use.numeric = FALSE,
  offset = pi/2,
  split.axes = "none",
  split.angle = pi/6,
  circular = FALSE
)
}
\arguments{
\item{graph}{An \code{tbl_graph} object}

\item{axis}{The node attribute to use for assigning nodes to axes}

\item{axis.pos}{The relative distance to the prior axis. Default
(\code{NULL}) places axes equidistant.}

\item{sort.by}{The node attribute to use for placing nodes along their axis.
Defaults (\code{NULL}) places nodes sequentially.}

\item{divide.by}{An optional node attribute to subdivide each axis by.}

\item{divide.order}{The order the axis subdivisions should appear in}

\item{normalize}{Logical. Should axis lengths be equal or reflect the number
of nodes in each axis. Defaults to \code{TRUE}.}

\item{center.size}{The size of the blank center, that is, the start position
of the axes.}

\item{divide.size}{The distance between subdivided axis segments.}

\item{use.numeric}{Logical, If the \code{sort.by} attribute is numeric,
should these values be used directly in positioning the nodes along the axes.
Defaults to \code{FALSE} which sorts the numeric values and positions them
equidistant from each other.}

\item{offset}{Change the overall rotation of the hive plot by changing the
offset of the first axis.}

\item{split.axes}{Should axes be split to show edges between nodes on the
same axis? One of:
\describe{
\item{\code{'none'}}{Do not split axes and show in-between edges}
\item{\code{'loops'}}{Only split axes that contain in-between edges}
\item{\code{'all'}}{Split all axes}
}}

\item{split.angle}{The angular distance between the two axes resulting from a
split.}

\item{circular}{Ignored.}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{r},
\code{center_size}, \code{split}, \code{axis}, \code{section}, \code{angle},
\code{circular} as well as any information stored as node variables in the
tbl_graph object.
}
\description{
Hive plots were invented by Martin Krzywinski as a perceptually uniform and
scalable alternative to standard node-edge layouts. In hive plots nodes are
positioned on axes radiating out from a center based on their own information
e.g. membership of a class, size of neighborhood, etc. Edges are then drawn
between nodes as bezier curves. As the placement of nodes is not governed by
convoluted algorithms but directly reflects the qualities of the nodes itself
the resulting plot can be easier to interpret as well as compare to other
graphs.
}
\details{
In order to be able to draw all edges without edges crossing axes you should
not assign nodes to axes based on a variable with more than three levels.
}
\references{
Krzywinski, M., Birol, I., Jones, SJM., and Marra, MA. (2012). \emph{Hive
plots-rational approach to visualizing networks}. Brief Bioinform 13 (5):
627-644. https://doi.org/10.1093/bib/bbr069

\url{https://www.hiveplot.net/}
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_cactustree}()},
\code{\link{layout_tbl_graph_centrality}()},
\code{\link{layout_tbl_graph_circlepack}()},
\code{\link{layout_tbl_graph_dendrogram}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_fabric}()},
\code{\link{layout_tbl_graph_focus}()},
\code{\link{layout_tbl_graph_htree}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_matrix}()},
\code{\link{layout_tbl_graph_metro}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_sf}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()},
\code{\link{layout_tbl_graph_unrooted}()}
}
\concept{layout_tbl_graph_*}
