% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{c.igraph.es}
\alias{c.igraph.es}
\title{Concatenate edge sequences}
\usage{
\method{c}{igraph.es}(..., recursive = FALSE)
}
\arguments{
\item{...}{The edge sequences to concatenate. They must
all refer to the same graph.}

\item{recursive}{Ignored, included for S3 compatibility with the
base \code{c} function.}
}
\value{
An edge sequence, the input sequences concatenated.
}
\description{
Concatenate edge sequences
}
\examples{
g <- make_(ring(10), with_vertex_(name = LETTERS[1:10]))
c(E(g)[1], E(g)['A|B'], E(g)[1:4])
}
\seealso{
Other vertex and edge sequence operations: \code{\link{c.igraph.vs}},
  \code{\link{difference.igraph.es}},
  \code{\link{difference.igraph.vs}},
  \code{\link{igraph-es-indexing2}},
  \code{\link{igraph-es-indexing}},
  \code{\link{igraph-vs-indexing2}},
  \code{\link{igraph-vs-indexing}},
  \code{\link{intersection.igraph.es}},
  \code{\link{intersection.igraph.vs}},
  \code{\link{rev.igraph.es}}, \code{\link{rev.igraph.vs}},
  \code{\link{union.igraph.es}},
  \code{\link{union.igraph.vs}},
  \code{\link{unique.igraph.es}},
  \code{\link{unique.igraph.vs}}
}
