% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{sample_seq}
\alias{sample_seq}
\alias{igraph.sample}
\title{Sampling a random integer sequence}
\usage{
sample_seq(low, high, length)
}
\arguments{
\item{low}{The lower limit of the interval (inclusive).}

\item{high}{The higher limit of the interval (inclusive).}

\item{length}{The length of the sample.}
}
\value{
An increasing numeric vector containing integers, the sample.
}
\description{
This function provides a very efficient way to pull an integer random sample
sequence from an integer interval.
}
\details{
The algorithm runs in \code{O(length)} expected time, even if
\code{high-low} is big. It is much faster (but of course less general) than
the builtin \code{sample} function of R.
}
\examples{

rs <- sample_seq(1, 100000000, 10)
rs

}
\references{
Jeffrey Scott Vitter: An Efficient Algorithm for Sequential
Random Sampling, \emph{ACM Transactions on Mathematical Software}, 13/1,
58--67.
}
\seealso{
Other other: 
\code{\link{convex_hull}()},
\code{\link{running_mean}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{other}
\keyword{datagen}
