% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-conversion.R
\name{knit2wp}
\alias{knit2wp}
\title{Knit an R Markdown document and post it to WordPress}
\usage{
knit2wp(
  input,
  title = "A post from knitr",
  ...,
  envir = parent.frame(),
  shortcode = FALSE,
  action = c("newPost", "editPost", "newPage"),
  postid,
  publish = TRUE
)
}
\arguments{
\item{input}{Filename of the Rmd document.}

\item{title}{Title of the post.}

\item{...}{Other meta information of the post, e.g. \code{categories = c('R',
'Stats')} and \code{mt_keywords = c('knitr', 'wordpress')}, et cetera.}

\item{envir}{Environment in which code chunks are to be evaluated, for
example, \code{\link{parent.frame}()}, \code{\link{new.env}()}, or
\code{\link{globalenv}()}).}

\item{shortcode}{A length-2 logical vector: whether to use the shortcode
\samp{[sourcecode lang='lang']}, which can be useful to WordPress.com users
for syntax highlighting of source code and output. The first element
applies to source code, and the second applies to text output. By default,
both are \code{FALSE}.}

\item{action}{Whether to create a new post, update an existing post, or
create a new page.}

\item{postid}{If \code{action} is \code{editPost}, the post id \code{postid}
must be specified.}

\item{publish}{Boolean: publish the post immediately?}
}
\description{
This function is a wrapper around the \pkg{RWordPress} package. It compiles
an R Markdown document to HTML and post the results to WordPress. Please note
that \pkg{RWordPress} has not been updated for several years, which is
\href{https://github.com/yihui/knitr/issues/1866}{not a good sign}. For
blogging with R, you may want to try the \pkg{blogdown} package instead.
}
\note{
This function will convert the encoding of the post and the title to
  UTF-8 internally. If you have additional data to send to WordPress (e.g.
  keywords and categories), you may have to manually convert them to the
  UTF-8 encoding with the \code{\link{iconv}(x, to = 'UTF-8')} function
  (especially when using Windows).
}
\examples{
# see the reference
}
\references{
\url{https://yihui.org/knitr/demo/wordpress/}
}
\author{
William K. Morris, Yihui Xie, and Jared Lander
}
