% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oaqc.R
\docType{package}
\name{oaqc}
\alias{oaqc-package}
\alias{oaqc}
\title{Orbit-aware Quad Census computation}
\usage{
oaqc(graph, non_ind_freq = F, file = "")
}
\arguments{
\item{graph}{A matrix, data.frame or graph object.}

\item{non_ind_freq}{A flag indicating whether non-induced frequencies have to be returned or not.}

\item{file}{Name (and location) of the file to be written.}
}
\value{
orbit-aware quad census on a node and edge level. Consult
\code{vignette('oaqc')} to see the correspondence between orbit and quad.
}
\description{
Implements the efficient algorithm by Ortmann and Brandes (2017) \doi{10.1007/s41109-017-0027-2} to compute the orbit-aware frequency distribution of induced and non-induced quads, i.e. subgraphs of size four. Given an edge matrix, data frame, or a graph object (e.g., 'igraph'), the orbit-aware counts are computed respective each of the edges and nodes.
}
\examples{
k4 <- data.frame(
    source = c(0, 0, 0, 1, 1, 2),
    target = c(1, 2, 3, 2, 3, 3)
)

k4orbits <- oaqc(k4, non_ind_freq = TRUE)
print(k4orbits)
}
\author{
\strong{Maintainer}: David Schoch \email{david@schochastics.net} (\href{https://orcid.org/0000-0003-2952-4812}{ORCID})

Authors:
\itemize{
  \item Mark Ortmann
  \item Felix Schoenenberger
}

}
