% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holiday.R
\name{step_holiday}
\alias{step_holiday}
\alias{tidy.step_holiday}
\title{Holiday Feature Generator}
\usage{
step_holiday(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  holidays = c("LaborDay", "NewYearsDay", "ChristmasDay"),
  columns = NULL,
  skip = FALSE,
  id = rand_id("holiday")
)

\method{tidy}{step_holiday}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables will be used to create the new variables. The selected
variables should have class \code{Date} or \code{POSIXct}. See
\code{\link[=selections]{selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new variable columns created by the original variables
will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{holidays}{A character string that includes at least one
holiday supported by the \code{timeDate} package. See
\code{\link[timeDate:listHolidays]{timeDate::listHolidays()}} for a complete list.}

\item{columns}{A character string of variables that will be
used as inputs. This field is a placeholder and will be
populated once \code{\link[=prep.recipe]{prep.recipe()}} is used.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_holiday} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} which is
the columns that will be affected and \code{holiday}.
}
\description{
\code{step_holiday} creates a a \emph{specification} of a
recipe step that will convert date data into one or more binary
indicator variables for common holidays.
}
\details{
Unlike other steps, \code{step_holiday} does
\emph{not} remove the original date variables.
\code{\link[=step_rm]{step_rm()}} can be used for this purpose.
}
\examples{
library(lubridate)

examples <- data.frame(someday = ymd("2000-12-20") + days(0:40))
holiday_rec <- recipe(~ someday, examples) \%>\%
   step_holiday(all_predictors())

holiday_rec <- prep(holiday_rec, training = examples)
holiday_values <- bake(holiday_rec, new_data = examples)
holiday_values
}
\seealso{
\code{\link[=step_date]{step_date()}} \code{\link[=step_rm]{step_rm()}}
\code{\link[=recipe]{recipe()}} \code{\link[=prep.recipe]{prep.recipe()}}
\code{\link[=bake.recipe]{bake.recipe()}} \code{\link[timeDate:listHolidays]{timeDate::listHolidays()}}
}
\concept{dates}
\concept{model_specification}
\concept{preprocessing}
\concept{variable_encodings}
\keyword{datagen}
