% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub.R
\name{stri_sub_all}
\alias{stri_sub_all}
\alias{stri_sub_all<-}
\alias{stri_sub_replace_all}
\alias{stri_sub_all_replace}
\title{Extract or Replace Multiple Substrings}
\usage{
stri_sub_all(str, from = list(1L), to = list(-1L), length)

stri_sub_all(str, from=list(1L), to=list(-1L), length, omit_na=FALSE) <- value

stri_sub_replace_all(..., replacement, value = replacement)

stri_sub_all_replace(..., replacement, value = replacement)
}
\arguments{
\item{str}{a character vector}

\item{from}{a list of integer vectors giving the start indexes or a
list of two-column matrices, each of type \code{cbind(from, to)}}

\item{to}{a list of integer vectors giving the end indexes}

\item{length}{a list of integer vectors giving the substring lengths}

\item{omit_na}{a single logical value; indicates whether missing values
in any of the indexes or in \code{value} leave the part of the
corresponding input string
unchanged [replacement function only]}

\item{value}{a list of character vectors defining the replacement strings
[replacement function only]}

\item{...}{arguments to be passed to \code{stri_sub_all<-}}

\item{replacement}{alias of \code{value} [wherever applicable]}
}
\value{
\code{stri_sub_all} returns a list of character vectors.
Its replacement versions return a character vector.
}
\description{
\code{stri_sub_all} extracts multiple substrings from each string.
Its replacement version substitutes (in-place) multiple substrings with the
corresponding replacement strings.
\code{stri_sub_replace_all} (alias \code{stri_sub_all_replace})
is \pkg{magrittr}'s pipe-operator-friendly variant, returning
a copy of the input vector.

For extracting/replacing single substrings from/within each string, see
\code{\link{stri_sub}}.
}
\details{
Vectorized over \code{str}, [\code{value}], \code{from} and
(\code{to} or \code{length}). Just like in \code{\link{stri_sub}}, parameters
\code{to} and \code{length} are mutually exclusive.

In one of the simplest scenarios, \code{stri_sub_all(str, from, to)},
the i-th element of the resulting list
is generated by calling, e.g., \code{stri_sub(str[i], from[[i]], to[[i]])}.
As usual, if one of the inputs is of length smaller than the others,
recycling rule is applied.


If any of \code{from}, \code{to}, \code{length}, or \code{value} is not a list,
it is wrapped into a list.

\code{from} can be a list of two-column matrices.
In such a case, the two columns play a role of \code{from} and \code{to},
respectively. Such types of index matrices are generated by
\code{\link{stri_locate_all}}.
If extraction or replacement based on \code{\link{stri_locate_first}}
or \code{\link{stri_locate_last}} is needed, see \code{\link{stri_sub}}.

In the replacement function, the index ranges must be sorted
with respect to \code{from} are must be mutually disjoint.
}
\examples{
x <- c("12 3456 789", "abc", "", NA, "667")
stri_sub_all(x, stri_locate_all_regex(x, "[0-9]+")) # see stri_extract_all
stri_sub_all(x, stri_locate_all_regex(x, "[0-9]+", omit_no_match=TRUE))

stri_sub_all(x, stri_locate_all_regex(x, "[0-9]+", omit_no_match=TRUE)) <- "***"
print(x)

stri_sub_replace_all("a b c", c(1, 3, 5), c(1, 3, 5), replacement=c("A", "B", "C"))


}
\seealso{
Other indexing: 
\code{\link{stri_locate_all_boundaries}()},
\code{\link{stri_locate_all}()},
\code{\link{stri_sub}()}
}
\concept{indexing}
