% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-compiled-code.R
\name{use_catch}
\alias{use_catch}
\title{Use Catch for C++ Unit Testing}
\usage{
use_catch(dir = getwd())
}
\arguments{
\item{dir}{The directory containing an \R package.}
}
\description{
Add the necessary infrastructure to enable C++ unit testing
in \R packages with \href{https://github.com/catchorg/Catch2}{Catch} and
\code{testthat}.
}
\details{
Calling \code{use_catch()} will:
\enumerate{
\item Create a file \code{src/test-runner.cpp}, which ensures that the
\code{testthat} package will understand how to run your package's
unit tests,
\item Create an example test file \code{src/test-example.cpp}, which
showcases how you might use Catch to write a unit test,
\item Add a test file \code{tests/testthat/test-cpp.R}, which ensures that
\code{testthat} will run your compiled tests during invocations of
\code{devtools::test()} or \verb{R CMD check}, and
\item Create a file \code{R/catch-routine-registration.R}, which ensures that
\R will automatically register this routine when
\code{tools::package_native_routine_registration_skeleton()} is invoked.
}

You will also need to:
\itemize{
\item Add xml2 to Suggests, with e.g. \code{usethis::use_package("xml2", "Suggests")}
\item Add testthat to LinkingTo, with e.g.
\code{usethis::use_package("testthat", "LinkingTo")}
}

C++ unit tests can be added to C++ source files within the
\code{src} directory of your package, with a format similar
to \R code tested with \code{testthat}. Here's a simple example
of a unit test written with \code{testthat} + Catch:

\preformatted{
context("C++ Unit Test") {
  test_that("two plus two is four") {
    int result = 2 + 2;
    expect_true(result == 4);
  }
}
}

When your package is compiled, unit tests alongside a harness
for running these tests will be compiled into your \R package,
with the C entry point \code{run_testthat_tests()}. \code{testthat}
will use that entry point to run your unit tests when detected.
}
\section{Functions}{


All of the functions provided by Catch are
available with the \code{CATCH_} prefix -- see
\href{https://github.com/catchorg/Catch2/blob/master/docs/assertions.md}{here}
for a full list. \code{testthat} provides the
following wrappers, to conform with \code{testthat}'s
\R interface:

\tabular{lll}{
\strong{Function} \tab \strong{Catch} \tab \strong{Description} \cr
\code{context} \tab \code{CATCH_TEST_CASE} \tab The context of a set of tests. \cr
\code{test_that} \tab \code{CATCH_SECTION} \tab A test section. \cr
\code{expect_true} \tab \code{CATCH_CHECK} \tab Test that an expression evaluates to \code{true}. \cr
\code{expect_false} \tab \code{CATCH_CHECK_FALSE} \tab Test that an expression evalutes to \code{false}. \cr
\code{expect_error} \tab \code{CATCH_CHECK_THROWS} \tab Test that evaluation of an expression throws an exception. \cr
\code{expect_error_as} \tab \code{CATCH_CHECK_THROWS_AS} \tab Test that evaluation of an expression throws an exception of a specific class. \cr
}

In general, you should prefer using the \code{testthat}
wrappers, as \code{testthat} also does some work to
ensure that any unit tests within will not be compiled or
run when using the Solaris Studio compilers (as these are
currently unsupported by Catch). This should make it
easier to submit packages to CRAN that use Catch.
}

\section{Symbol Registration}{


If you've opted to disable dynamic symbol lookup in your
package, then you'll need to explicitly export a symbol
in your package that \code{testthat} can use to run your unit
tests. \code{testthat} will look for a routine with one of the names:

\preformatted{
    C_run_testthat_tests
    c_run_testthat_tests
    run_testthat_tests
}

See \href{https://cran.r-project.org/doc/manuals/r-release/R-exts.html#Controlling-visibility}{Controlling Visibility}
and \href{https://cran.r-project.org/doc/manuals/r-release/R-exts.html#Registering-symbols}{Registering Symbols}
in the \strong{Writing R Extensions} manual for more information.
}

\section{Advanced Usage}{


If you'd like to write your own Catch test runner, you can
instead use the \code{testthat::catchSession()} object in a file
with the form:

\preformatted{
#define TESTTHAT_TEST_RUNNER
#include <testthat.h>

void run()
{
    Catch::Session& session = testthat::catchSession();
    // interact with the session object as desired
}
}

This can be useful if you'd like to run your unit tests
with custom arguments passed to the Catch session.
}

\section{Standalone Usage}{


If you'd like to use the C++ unit testing facilities provided
by Catch, but would prefer not to use the regular \code{testthat}
\R testing infrastructure, you can manually run the unit tests
by inserting a call to:

\preformatted{
.Call("run_testthat_tests", PACKAGE = <pkgName>)
}

as necessary within your unit test suite.
}

\seealso{
\href{https://github.com/catchorg/Catch2/blob/master/docs/assertions.md}{Catch},
the library used to enable C++ unit testing.
}
