% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapter-httr.R
\name{HttrAdapter}
\alias{HttrAdapter}
\title{HttrAdapter}
\description{
\code{httr} library adapter
}
\details{
This adapter modifies \pkg{httr} to allow mocking HTTP requests
}
\examples{
\dontrun{
if (requireNamespace("httr", quietly = TRUE)) {
# library(httr)

# normal httr request, works fine
# real <- GET("https://httpbin.org/get")
# real

# with webmockr
# library(webmockr)
## turn on httr mocking
# httr_mock()
## now this request isn't allowed
# GET("https://httpbin.org/get")
## stub the request
# stub_request('get', uri = 'https://httpbin.org/get') \%>\%
#   wi_th(
#     headers = list('Accept' = 'application/json, text/xml, application/xml, */*')
#   ) \%>\%
#   to_return(status = 418, body = "I'm a teapot!", headers = list(a = 5))
## now the request succeeds and returns a mocked response
# (res <- GET("https://httpbin.org/get"))
# res$status_code
# rawToChar(res$content)

# allow real requests while webmockr is loaded
# webmockr_allow_net_connect()
# webmockr_net_connect_allowed()
# GET("https://httpbin.org/get?animal=chicken")
# webmockr_disable_net_connect()
# webmockr_net_connect_allowed()
# GET("https://httpbin.org/get?animal=chicken")

# httr_mock(FALSE)
}
}
}
\seealso{
Other http_lib_adapters: 
\code{\link{CrulAdapter}}
}
\concept{http_lib_adapters}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{adapter name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-enable}{\code{HttrAdapter$enable()}}
\item \href{#method-disable}{\code{HttrAdapter$disable()}}
\item \href{#method-handle_request}{\code{HttrAdapter$handle_request()}}
\item \href{#method-remove_httr_stubs}{\code{HttrAdapter$remove_httr_stubs()}}
\item \href{#method-clone}{\code{HttrAdapter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-enable"></a>}}
\subsection{Method \code{enable()}}{
Enable the adapter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttrAdapter$enable()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-disable"></a>}}
\subsection{Method \code{disable()}}{
Disable the adapter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttrAdapter$disable()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{FALSE}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-handle_request"></a>}}
\subsection{Method \code{handle_request()}}{
All logic for handling a request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttrAdapter$handle_request(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{a httr request}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
various outcomes
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove_httr_stubs"></a>}}
\subsection{Method \code{remove_httr_stubs()}}{
Remove all crul stubs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttrAdapter$remove_httr_stubs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing returned; removes all httr request stubs
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttrAdapter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
