% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans-explicit.R
\name{wk_trans_explicit}
\alias{wk_trans_explicit}
\title{Transform using explicit coordinate values}
\usage{
wk_trans_explicit(value, use_z = NA, use_m = NA)
}
\arguments{
\item{value}{An \code{\link[=xy]{xy()}}, \code{\link[=xyz]{xyz()}}, \code{\link[=xym]{xym()}}, or \code{\link[=xyzm]{xyzm()}} of coordinates
used to replace values in the input. Use \code{NA} to keep the existing
value.}

\item{use_z, use_m}{Used to declare the output type. Use \code{TRUE} to
ensure the output has that dimension, \code{FALSE} to ensure it does not,
and \code{NA} to leave the dimension unchanged.}
}
\description{
A \link[=wk_transform]{wk_trans} implementation that replaces coordinate values
using a vector of pre-calculated coordinates. This is used to perform generic
transforms using R functions and system calls that are impossible or impractical
to implement at the C level.
}
\examples{
trans <- wk_trans_explicit(xy(1:5, 1:5))
wk_transform(rep(xy(0, 0), 5), trans)
}
\seealso{
\code{\link[=wk_coords]{wk_coords()}} which has a replacement version  "\verb{wk_coords<-}"
}
