#line 1 "src/txt/readstat_spss_commands_read.rl"
#include <stdlib.h>
#include <inttypes.h>

#include "../readstat.h"
#include "../readstat_strings.h"
#include "readstat_schema.h"

#include "readstat_copy.h"
#include "commands_util.h"


#line 14 "src/txt/readstat_spss_commands_read.c"
static const signed char _spss_commands_actions[] = {
	0, 1, 1, 1, 2, 1, 4, 1,
	8, 1, 12, 1, 13, 1, 15, 1,
	16, 1, 17, 1, 18, 1, 19, 1,
	20, 1, 21, 1, 22, 1, 27, 1,
	30, 1, 31, 1, 32, 1, 34, 2,
	0, 1, 2, 1, 0, 2, 2, 28,
	2, 2, 29, 2, 3, 28, 2, 3,
	29, 2, 4, 9, 2, 4, 12, 2,
	4, 14, 2, 4, 20, 2, 8, 20,
	2, 15, 16, 2, 17, 18, 2, 19,
	13, 2, 19, 20, 2, 21, 6, 2,
	21, 7, 2, 21, 12, 2, 21, 20,
	2, 23, 8, 2, 24, 8, 2, 25,
	8, 2, 26, 8, 3, 4, 0, 1,
	3, 4, 14, 13, 3, 4, 35, 5,
	3, 19, 0, 1, 3, 19, 8, 20,
	3, 21, 0, 1, 3, 21, 1, 0,
	3, 21, 6, 11, 3, 21, 12, 6,
	3, 33, 0, 1, 4, 19, 33, 0,
	1, 4, 21, 6, 10, 11, 4, 21,
	6, 11, 10, 0
};

static const short _spss_commands_key_offsets[] = {
	0, 0, 1, 2, 7, 9, 10, 11,
	13, 14, 15, 16, 17, 18, 19, 20,
	21, 25, 27, 29, 35, 41, 47, 48,
	50, 52, 54, 58, 68, 78, 79, 81,
	85, 87, 92, 97, 98, 109, 124, 139,
	140, 141, 142, 147, 158, 169, 170, 176,
	184, 192, 193, 204, 210, 216, 217, 224,
	233, 242, 243, 247, 250, 254, 262, 270,
	271, 282, 288, 294, 295, 304, 315, 326,
	327, 331, 334, 340, 350, 360, 361, 365,
	367, 371, 377, 383, 384, 386, 388, 390,
	392, 396, 402, 408, 409, 411, 413, 415,
	417, 419, 421, 426, 431, 432, 434, 436,
	438, 440, 442, 446, 448, 450, 454, 460,
	466, 467, 469, 471, 473, 475, 477, 481,
	490, 499, 500, 504, 516, 521, 526, 527,
	539, 551, 552, 553, 554, 560, 566, 572,
	573, 574, 575, 583, 596, 607, 612, 617,
	618, 620, 622, 624, 626, 628, 632, 640,
	648, 649, 660, 669, 678, 679, 680, 682,
	685, 687, 690, 695, 701, 707, 708, 710,
	712, 716, 724, 732, 733, 735, 737, 739,
	743, 748, 753, 754, 760, 772, 777, 782,
	783, 795, 807, 808, 809, 810, 816, 822,
	828, 829, 830, 831, 839, 852, 866, 880,
	894, 908, 922, 936, 950, 964, 976, 981,
	986, 987, 999, 1011, 1012, 1025, 1037, 1049,
	1050, 1054, 1062, 1072, 1082, 1083, 1094, 1104,
	1114, 1115, 1117, 1119, 1121, 1123, 1131, 1133,
	1141, 1149, 1151, 1153, 1155, 1157, 1159, 1161,
	1163, 1165, 1167, 1171, 1177, 1183, 1184, 1186,
	1188, 1190, 1192, 1194, 1198, 1206, 1214, 1215,
	1226, 1231, 1236, 1237, 1239, 1240, 1241, 1242,
	1247, 1256, 1265, 1266, 1267, 1268, 1270, 1272,
	1274, 1276, 1278, 1282, 1290, 1298, 1299, 1310,
	1315, 1320, 1321, 1324, 1326, 1334, 1341, 1348,
	1349, 1351, 1358, 1363, 1368, 1369, 1370, 1371,
	1372, 1373, 1374, 1379, 1384, 1385, 1389, 1391,
	1393, 1397, 1405, 1413, 1414, 1416, 1418, 1420,
	1422, 1424, 1426, 1428, 1430, 1432, 1439, 1446,
	1447, 1448, 1449, 1455, 1461, 1467, 1468, 1473,
	1478, 1479, 1480, 1481, 1482, 1483, 1484, 1485,
	1486, 1487, 1488, 1495, 1502, 1503, 1504, 1505,
	1511, 1517, 1518, 1520, 1522, 1524, 1526, 1528,
	1530, 1534, 1536, 1538, 1540, 1544, 1550, 1556,
	1557, 1559, 1563, 1578, 1594, 1610, 1611, 1612,
	1613, 1629, 1630, 1631, 1633, 1649, 1666, 1683,
	1698, 1699, 1703, 1711, 1719, 1720, 1732, 1737,
	1742, 1743, 1755, 1767, 1768, 1769, 1770, 1775,
	1776, 1777, 1784, 1796, 1798, 1802, 1804, 1806,
	1810, 1816, 1822, 1823, 1825, 1827, 1829, 1831,
	1833, 1837, 1846, 1855, 1856, 1864, 1872, 1873,
	1884, 1898, 1912, 1913, 1914, 1915, 1919, 1925,
	1931, 1932, 1933, 1934, 1940, 1951, 1962, 1963,
	1964, 1965, 1967, 1973, 1984, 1995, 1996, 2009,
	2022, 2035, 2048, 2061, 2074, 2087, 2098, 2114,
	2130, 2131, 2135, 2141, 2148, 2155, 2156, 2157,
	2158, 2162, 2168, 2174, 2175, 2181, 2192, 2205,
	2218, 2231, 2244, 2255, 2269, 2283, 2284, 2295,
	2310, 2325, 2326, 2332, 2334, 2336, 2338, 2340,
	2342, 2344, 2345, 2351, 2357, 2358, 2366, 2374,
	2375, 2386, 2395, 2404, 2405, 2416, 2418, 2420,
	2422, 2424, 2426, 2428, 2439, 2441, 2443, 2445,
	2447, 2449, 2453, 2459, 2465, 2466, 2468, 2470,
	2472, 2474, 2480, 2488, 2496, 2497, 2508, 2514,
	2520, 2521, 2522, 2523, 2529, 2539, 2549, 2550,
	2555, 2564, 2573, 2574, 2575, 2576, 2580, 2582,
	2584, 2586, 2588, 2596, 2598, 2600, 2602, 2609,
	2616, 2617, 2623, 2629, 2630, 2633, 2639, 2642,
	2648, 2654, 2655, 2663, 2666, 2670, 2673, 2679,
	2685, 2686, 2692, 2698, 2700, 2702, 2704, 2706,
	2708, 2715, 2720, 2725, 2726, 2732, 2738, 2739,
	2746, 2748, 2750, 2752, 2754, 2759, 2760, 2761,
	2773, 2787, 2801, 2815, 2828, 2840, 2852, 2853,
	2867, 2881, 2895, 2909, 2923, 2938, 2950, 2962,
	2963, 2976, 2978, 2980, 2982, 2984, 2988, 2994,
	3000, 3001, 3003, 3005, 3007, 3011, 3021, 3031,
	3032, 3033, 3034, 3039, 3045, 3051, 3052, 3054,
	3056, 3058, 3060, 3062, 3067, 3072, 3073, 3081,
	3089, 3090, 3102, 3103, 3104, 3106, 3108, 3110,
	3112, 3114, 3119, 3128, 3137, 3138, 3150, 3177,
	3204, 3231, 0
};

static const char _spss_commands_trans_keys[] = {
	10, 46, 9, 10, 13, 32, 46, 10,
	46, 42, 42, 42, 47, 79, 77, 77,
	69, 78, 84, 32, 46, 65, 73, 97,
	105, 84, 116, 65, 97, 9, 10, 13,
	32, 83, 115, 9, 10, 13, 32, 76,
	108, 9, 10, 13, 32, 76, 108, 10,
	73, 105, 83, 115, 84, 116, 9, 10,
	13, 32, 9, 10, 13, 32, 70, 82,
	84, 102, 114, 116, 9, 10, 13, 32,
	70, 82, 84, 102, 114, 116, 10, 73,
	105, 76, 88, 108, 120, 69, 101, 9,
	10, 13, 32, 61, 9, 10, 13, 32,
	61, 10, 9, 10, 13, 32, 34, 39,
	47, 65, 90, 97, 122, 9, 10, 13,
	32, 34, 39, 47, 70, 82, 102, 114,
	65, 90, 97, 122, 9, 10, 13, 32,
	34, 39, 47, 70, 82, 102, 114, 65,
	90, 97, 122, 10, 34, 34, 9, 10,
	13, 32, 47, 9, 10, 13, 32, 47,
	70, 82, 84, 102, 114, 116, 9, 10,
	13, 32, 47, 70, 82, 84, 102, 114,
	116, 10, 9, 10, 13, 32, 48, 57,
	9, 10, 13, 32, 65, 90, 97, 122,
	9, 10, 13, 32, 65, 90, 97, 122,
	10, 9, 10, 13, 32, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	48, 57, 9, 10, 13, 32, 48, 57,
	10, 9, 10, 13, 32, 45, 48, 57,
	9, 10, 13, 32, 40, 65, 90, 97,
	122, 9, 10, 13, 32, 40, 65, 90,
	97, 122, 10, 65, 97, 48, 57, 41,
	48, 57, 9, 10, 13, 32, 9, 10,
	13, 32, 65, 90, 97, 122, 9, 10,
	13, 32, 65, 90, 97, 122, 10, 9,
	10, 13, 32, 95, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 48, 57,
	9, 10, 13, 32, 48, 57, 10, 9,
	10, 13, 32, 45, 46, 47, 48, 57,
	9, 10, 13, 32, 40, 46, 47, 65,
	90, 97, 122, 9, 10, 13, 32, 40,
	46, 47, 65, 90, 97, 122, 10, 65,
	97, 48, 57, 41, 48, 57, 9, 10,
	13, 32, 46, 47, 9, 10, 13, 32,
	46, 47, 65, 90, 97, 122, 9, 10,
	13, 32, 46, 47, 65, 90, 97, 122,
	10, 78, 88, 110, 120, 68, 100, 9,
	10, 13, 32, 9, 10, 13, 32, 73,
	105, 9, 10, 13, 32, 73, 105, 10,
	78, 110, 80, 112, 85, 117, 84, 116,
	9, 10, 13, 32, 9, 10, 13, 32,
	80, 112, 9, 10, 13, 32, 80, 112,
	10, 82, 114, 79, 111, 71, 103, 82,
	114, 65, 97, 77, 109, 9, 10, 13,
	32, 46, 9, 10, 13, 32, 46, 10,
	69, 101, 67, 99, 85, 117, 84, 116,
	69, 101, 73, 79, 105, 111, 76, 108,
	69, 101, 9, 10, 13, 32, 9, 10,
	13, 32, 72, 104, 9, 10, 13, 32,
	72, 104, 10, 65, 97, 78, 110, 68,
	100, 76, 108, 69, 101, 9, 10, 13,
	32, 9, 10, 13, 32, 47, 65, 90,
	97, 122, 9, 10, 13, 32, 47, 65,
	90, 97, 122, 10, 65, 90, 97, 122,
	9, 10, 13, 32, 61, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	61, 9, 10, 13, 32, 61, 10, 9,
	10, 13, 32, 34, 39, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 48, 57, 65, 90, 97, 122, 10,
	34, 34, 9, 10, 13, 32, 46, 47,
	9, 10, 13, 32, 46, 47, 9, 10,
	13, 32, 46, 47, 10, 39, 39, 9,
	10, 13, 32, 46, 47, 48, 57, 9,
	10, 13, 32, 46, 47, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	95, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 47, 9, 10, 13, 32,
	47, 10, 82, 114, 77, 109, 65, 97,
	84, 116, 83, 115, 9, 10, 13, 32,
	9, 10, 13, 32, 65, 90, 97, 122,
	9, 10, 13, 32, 65, 90, 97, 122,
	10, 9, 10, 13, 32, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	40, 65, 90, 97, 122, 9, 10, 13,
	32, 40, 65, 90, 97, 122, 10, 70,
	48, 57, 46, 48, 57, 48, 57, 41,
	48, 57, 9, 10, 13, 32, 46, 9,
	10, 13, 32, 46, 47, 9, 10, 13,
	32, 46, 47, 10, 69, 101, 84, 116,
	9, 10, 13, 32, 9, 10, 13, 32,
	68, 70, 100, 102, 9, 10, 13, 32,
	68, 70, 100, 102, 10, 65, 97, 84,
	116, 65, 97, 9, 10, 13, 32, 9,
	10, 13, 32, 47, 9, 10, 13, 32,
	47, 10, 86, 118, 65, 90, 97, 122,
	9, 10, 13, 32, 61, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	61, 9, 10, 13, 32, 61, 10, 9,
	10, 13, 32, 34, 39, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 48, 57, 65, 90, 97, 122, 10,
	34, 34, 9, 10, 13, 32, 46, 47,
	9, 10, 13, 32, 46, 47, 9, 10,
	13, 32, 46, 47, 10, 39, 39, 9,
	10, 13, 32, 46, 47, 48, 57, 9,
	10, 13, 32, 46, 47, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	61, 65, 95, 97, 48, 57, 66, 90,
	98, 122, 9, 10, 13, 32, 61, 82,
	95, 114, 48, 57, 65, 90, 97, 122,
	9, 10, 13, 32, 61, 73, 95, 105,
	48, 57, 65, 90, 97, 122, 9, 10,
	13, 32, 61, 65, 95, 97, 48, 57,
	66, 90, 98, 122, 9, 10, 13, 32,
	61, 66, 95, 98, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 61, 76,
	95, 108, 48, 57, 65, 90, 97, 122,
	9, 10, 13, 32, 61, 69, 95, 101,
	48, 57, 65, 90, 97, 122, 9, 10,
	13, 32, 61, 83, 95, 115, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	61, 95, 48, 57, 65, 90, 97, 122,
	9, 10, 13, 32, 61, 9, 10, 13,
	32, 61, 10, 9, 10, 13, 32, 34,
	39, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 34, 39, 48, 57, 65,
	90, 97, 122, 10, 9, 10, 13, 32,
	46, 47, 95, 48, 57, 65, 90, 97,
	122, 9, 10, 13, 32, 46, 47, 65,
	68, 70, 97, 100, 102, 9, 10, 13,
	32, 46, 47, 65, 68, 70, 97, 100,
	102, 10, 68, 100, 48, 57, 9, 10,
	13, 32, 46, 47, 48, 57, 9, 10,
	13, 32, 46, 47, 65, 90, 97, 122,
	9, 10, 13, 32, 46, 47, 65, 90,
	97, 122, 10, 9, 10, 13, 32, 95,
	48, 57, 65, 90, 97, 122, 9, 10,
	13, 32, 65, 68, 70, 97, 100, 102,
	9, 10, 13, 32, 65, 68, 70, 97,
	100, 102, 10, 65, 97, 84, 116, 69,
	101, 48, 57, 9, 10, 13, 32, 46,
	47, 48, 57, 48, 57, 9, 10, 13,
	32, 46, 47, 48, 57, 9, 10, 13,
	32, 46, 47, 48, 57, 73, 105, 83,
	115, 84, 116, 73, 105, 83, 115, 83,
	115, 73, 105, 78, 110, 71, 103, 9,
	10, 13, 32, 9, 10, 13, 32, 86,
	118, 9, 10, 13, 32, 86, 118, 10,
	65, 97, 76, 108, 85, 117, 69, 101,
	83, 115, 9, 10, 13, 32, 9, 10,
	13, 32, 65, 90, 97, 122, 9, 10,
	13, 32, 65, 90, 97, 122, 10, 9,
	10, 13, 32, 95, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 40, 9,
	10, 13, 32, 40, 10, 34, 39, 34,
	34, 41, 9, 10, 13, 32, 46, 9,
	10, 13, 32, 46, 65, 90, 97, 122,
	9, 10, 13, 32, 46, 65, 90, 97,
	122, 10, 39, 39, 69, 101, 67, 99,
	79, 111, 68, 100, 69, 101, 9, 10,
	13, 32, 9, 10, 13, 32, 65, 90,
	97, 122, 9, 10, 13, 32, 65, 90,
	97, 122, 10, 9, 10, 13, 32, 95,
	48, 57, 65, 90, 97, 122, 9, 10,
	13, 32, 40, 9, 10, 13, 32, 40,
	10, 45, 48, 57, 48, 57, 9, 10,
	13, 32, 46, 61, 48, 57, 9, 10,
	13, 32, 45, 48, 57, 9, 10, 13,
	32, 45, 48, 57, 10, 48, 57, 9,
	10, 13, 32, 61, 48, 57, 9, 10,
	13, 32, 83, 9, 10, 13, 32, 83,
	10, 89, 83, 77, 73, 83, 9, 10,
	13, 32, 41, 9, 10, 13, 32, 41,
	10, 65, 69, 97, 101, 86, 118, 69,
	101, 9, 10, 13, 32, 9, 10, 13,
	32, 68, 79, 100, 111, 9, 10, 13,
	32, 68, 79, 100, 111, 10, 73, 105,
	67, 99, 84, 116, 73, 105, 79, 111,
	78, 110, 65, 97, 82, 114, 89, 121,
	9, 10, 13, 32, 34, 39, 61, 9,
	10, 13, 32, 34, 39, 61, 10, 34,
	34, 9, 10, 13, 32, 46, 47, 9,
	10, 13, 32, 46, 47, 9, 10, 13,
	32, 46, 47, 10, 9, 10, 13, 32,
	67, 9, 10, 13, 32, 67, 10, 79,
	77, 80, 82, 69, 83, 83, 69, 68,
	9, 10, 13, 32, 46, 47, 67, 9,
	10, 13, 32, 46, 47, 67, 10, 39,
	39, 9, 10, 13, 32, 34, 39, 9,
	10, 13, 32, 34, 39, 10, 85, 117,
	84, 116, 70, 102, 73, 105, 76, 108,
	69, 101, 76, 84, 108, 116, 69, 101,
	67, 99, 84, 116, 9, 10, 13, 32,
	9, 10, 13, 32, 73, 105, 9, 10,
	13, 32, 73, 105, 10, 70, 102, 9,
	10, 13, 32, 9, 10, 13, 32, 34,
	39, 45, 40, 41, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 34, 39,
	45, 46, 40, 41, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 34, 39,
	45, 46, 40, 41, 48, 57, 65, 90,
	97, 122, 10, 34, 34, 9, 10, 13,
	32, 34, 39, 45, 46, 40, 41, 48,
	57, 65, 90, 97, 122, 39, 39, 48,
	57, 9, 10, 13, 32, 34, 39, 45,
	46, 40, 41, 48, 57, 65, 90, 97,
	122, 9, 10, 13, 32, 34, 39, 45,
	46, 95, 40, 41, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 34, 39,
	45, 46, 95, 40, 41, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 45, 40, 41, 48, 57, 65, 90,
	97, 122, 10, 9, 10, 13, 32, 9,
	10, 13, 32, 65, 90, 97, 122, 9,
	10, 13, 32, 65, 90, 97, 122, 10,
	9, 10, 13, 32, 61, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	61, 9, 10, 13, 32, 61, 10, 9,
	10, 13, 32, 34, 39, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 34,
	39, 48, 57, 65, 90, 97, 122, 10,
	34, 34, 9, 10, 13, 32, 46, 39,
	39, 9, 10, 13, 32, 46, 48, 57,
	9, 10, 13, 32, 46, 95, 48, 57,
	65, 90, 97, 122, 65, 97, 76, 82,
	108, 114, 85, 117, 69, 101, 9, 10,
	13, 32, 9, 10, 13, 32, 76, 108,
	9, 10, 13, 32, 76, 108, 10, 65,
	97, 66, 98, 69, 101, 76, 108, 83,
	115, 9, 10, 13, 32, 9, 10, 13,
	32, 47, 65, 90, 97, 122, 9, 10,
	13, 32, 47, 65, 90, 97, 122, 10,
	9, 10, 13, 32, 65, 90, 97, 122,
	9, 10, 13, 32, 65, 90, 97, 122,
	10, 9, 10, 13, 32, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	34, 39, 45, 46, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 34, 39,
	45, 46, 48, 57, 65, 90, 97, 122,
	10, 34, 34, 9, 10, 13, 32, 9,
	10, 13, 32, 34, 39, 9, 10, 13,
	32, 34, 39, 10, 34, 34, 9, 10,
	13, 32, 46, 47, 9, 10, 13, 32,
	34, 39, 45, 46, 47, 48, 57, 9,
	10, 13, 32, 34, 39, 45, 46, 47,
	48, 57, 10, 39, 39, 48, 57, 9,
	10, 13, 32, 48, 57, 9, 10, 13,
	32, 46, 86, 118, 65, 90, 97, 122,
	9, 10, 13, 32, 46, 86, 118, 65,
	90, 97, 122, 10, 9, 10, 13, 32,
	65, 95, 97, 48, 57, 66, 90, 98,
	122, 9, 10, 13, 32, 82, 95, 114,
	48, 57, 65, 90, 97, 122, 9, 10,
	13, 32, 73, 95, 105, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 65,
	95, 97, 48, 57, 66, 90, 98, 122,
	9, 10, 13, 32, 66, 95, 98, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 76, 95, 108, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 69, 95,
	101, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 95, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 34, 39,
	45, 46, 76, 108, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 34, 39,
	45, 46, 76, 108, 48, 57, 65, 90,
	97, 122, 10, 9, 10, 13, 32, 9,
	10, 13, 32, 48, 57, 9, 10, 13,
	32, 34, 39, 45, 9, 10, 13, 32,
	34, 39, 45, 10, 39, 39, 9, 10,
	13, 32, 9, 10, 13, 32, 48, 57,
	9, 10, 13, 32, 48, 57, 10, 9,
	10, 13, 32, 48, 57, 9, 10, 13,
	32, 95, 48, 57, 65, 90, 97, 122,
	9, 10, 13, 32, 69, 95, 101, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 86, 95, 118, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 69, 95,
	101, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 76, 95, 108, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	95, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 34, 39, 45, 46, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 34, 39, 45, 46, 48, 57, 65,
	90, 97, 122, 10, 9, 10, 13, 32,
	95, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 34, 39, 40, 45, 46,
	48, 57, 65, 90, 97, 122, 9, 10,
	13, 32, 34, 39, 40, 45, 46, 48,
	57, 65, 90, 97, 122, 10, 78, 79,
	83, 110, 111, 115, 79, 111, 77, 109,
	73, 105, 78, 110, 65, 97, 76, 108,
	41, 9, 10, 13, 32, 46, 47, 9,
	10, 13, 32, 46, 47, 10, 9, 10,
	13, 32, 65, 90, 97, 122, 9, 10,
	13, 32, 65, 90, 97, 122, 10, 9,
	10, 13, 32, 95, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 40, 65,
	90, 97, 122, 9, 10, 13, 32, 40,
	65, 90, 97, 122, 10, 9, 10, 13,
	32, 95, 48, 57, 65, 90, 97, 122,
	82, 114, 68, 100, 67, 99, 65, 97,
	76, 108, 69, 101, 9, 10, 13, 32,
	95, 48, 57, 65, 90, 97, 122, 73,
	105, 65, 97, 66, 98, 76, 108, 69,
	101, 9, 10, 13, 32, 9, 10, 13,
	32, 76, 108, 9, 10, 13, 32, 76,
	108, 10, 65, 97, 66, 98, 69, 101,
	76, 108, 9, 10, 13, 32, 83, 115,
	9, 10, 13, 32, 65, 90, 97, 122,
	9, 10, 13, 32, 65, 90, 97, 122,
	10, 9, 10, 13, 32, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	34, 39, 9, 10, 13, 32, 34, 39,
	10, 34, 34, 9, 10, 13, 32, 46,
	47, 9, 10, 13, 32, 46, 47, 65,
	90, 97, 122, 9, 10, 13, 32, 46,
	47, 65, 90, 97, 122, 10, 9, 10,
	13, 32, 46, 9, 10, 13, 32, 46,
	65, 90, 97, 122, 9, 10, 13, 32,
	46, 65, 90, 97, 122, 10, 39, 39,
	9, 10, 13, 32, 65, 97, 84, 116,
	69, 101, 48, 57, 9, 10, 13, 32,
	46, 47, 48, 57, 73, 105, 76, 108,
	69, 101, 9, 10, 13, 32, 34, 39,
	61, 9, 10, 13, 32, 34, 39, 61,
	10, 9, 10, 13, 32, 34, 39, 9,
	10, 13, 32, 34, 39, 10, 41, 48,
	57, 9, 10, 13, 32, 46, 47, 41,
	48, 57, 9, 10, 13, 32, 48, 57,
	9, 10, 13, 32, 48, 57, 10, 9,
	10, 13, 32, 46, 47, 48, 57, 41,
	48, 57, 9, 10, 13, 32, 41, 48,
	57, 9, 10, 13, 32, 48, 57, 9,
	10, 13, 32, 48, 57, 10, 9, 10,
	13, 32, 48, 57, 9, 10, 13, 32,
	48, 57, 69, 101, 67, 99, 79, 111,
	82, 114, 68, 100, 9, 10, 13, 32,
	61, 83, 115, 9, 10, 13, 32, 61,
	9, 10, 13, 32, 61, 10, 9, 10,
	13, 32, 48, 57, 9, 10, 13, 32,
	48, 57, 10, 9, 10, 13, 32, 47,
	48, 57, 65, 97, 66, 98, 76, 108,
	69, 101, 9, 10, 13, 32, 47, 39,
	39, 9, 10, 13, 32, 47, 95, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 47, 73, 95, 105, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 47,
	76, 95, 108, 48, 57, 65, 90, 97,
	122, 9, 10, 13, 32, 47, 69, 95,
	101, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 47, 61, 95, 48, 57,
	65, 90, 97, 122, 9, 10, 13, 32,
	47, 61, 70, 82, 84, 102, 114, 116,
	9, 10, 13, 32, 47, 61, 70, 82,
	84, 102, 114, 116, 10, 9, 10, 13,
	32, 47, 69, 95, 101, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 47,
	67, 95, 99, 48, 57, 65, 90, 97,
	122, 9, 10, 13, 32, 47, 79, 95,
	111, 48, 57, 65, 90, 97, 122, 9,
	10, 13, 32, 47, 82, 95, 114, 48,
	57, 65, 90, 97, 122, 9, 10, 13,
	32, 47, 68, 95, 100, 48, 57, 65,
	90, 97, 122, 9, 10, 13, 32, 47,
	61, 83, 95, 115, 48, 57, 65, 90,
	97, 122, 9, 10, 13, 32, 47, 61,
	70, 82, 84, 102, 114, 116, 9, 10,
	13, 32, 47, 61, 70, 82, 84, 102,
	114, 116, 10, 9, 10, 13, 32, 47,
	61, 95, 48, 57, 65, 90, 97, 122,
	69, 101, 68, 100, 69, 101, 84, 116,
	9, 10, 13, 32, 9, 10, 13, 32,
	78, 110, 9, 10, 13, 32, 78, 110,
	10, 65, 97, 77, 109, 69, 101, 9,
	10, 13, 32, 9, 10, 13, 32, 34,
	39, 65, 90, 97, 122, 9, 10, 13,
	32, 34, 39, 65, 90, 97, 122, 10,
	34, 34, 9, 10, 13, 32, 46, 9,
	10, 13, 32, 87, 119, 9, 10, 13,
	32, 87, 119, 10, 73, 105, 78, 110,
	68, 100, 79, 111, 87, 119, 9, 10,
	13, 32, 61, 9, 10, 13, 32, 61,
	10, 9, 10, 13, 32, 65, 90, 97,
	122, 9, 10, 13, 32, 65, 90, 97,
	122, 10, 9, 10, 13, 32, 46, 95,
	48, 57, 65, 90, 97, 122, 39, 39,
	83, 115, 80, 112, 76, 108, 65, 97,
	89, 121, 9, 10, 13, 32, 46, 9,
	10, 13, 32, 46, 65, 90, 97, 122,
	9, 10, 13, 32, 46, 65, 90, 97,
	122, 10, 9, 10, 13, 32, 46, 95,
	48, 57, 65, 90, 97, 122, 9, 10,
	13, 32, 42, 47, 67, 68, 69, 70,
	71, 73, 76, 77, 82, 83, 86, 100,
	101, 102, 103, 105, 108, 109, 114, 115,
	118, 9, 10, 13, 32, 42, 47, 67,
	68, 69, 70, 71, 73, 76, 77, 82,
	83, 86, 100, 101, 102, 103, 105, 108,
	109, 114, 115, 118, 9, 10, 13, 32,
	42, 47, 67, 68, 69, 70, 71, 73,
	76, 77, 82, 83, 86, 100, 101, 102,
	103, 105, 108, 109, 114, 115, 118, 9,
	10, 13, 32, 42, 47, 67, 68, 69,
	70, 71, 73, 76, 77, 82, 83, 86,
	100, 101, 102, 103, 105, 108, 109, 114,
	115, 118, 48, 57, 0
};

static const signed char _spss_commands_single_lengths[] = {
	0, 1, 1, 5, 2, 1, 1, 2,
	1, 1, 1, 1, 1, 1, 1, 1,
	4, 2, 2, 6, 6, 6, 1, 2,
	2, 2, 4, 10, 10, 1, 2, 4,
	2, 5, 5, 1, 7, 11, 11, 1,
	1, 1, 5, 11, 11, 1, 4, 4,
	4, 1, 5, 4, 4, 1, 5, 5,
	5, 1, 2, 1, 4, 4, 4, 1,
	5, 4, 4, 1, 7, 7, 7, 1,
	2, 1, 6, 6, 6, 1, 4, 2,
	4, 6, 6, 1, 2, 2, 2, 2,
	4, 6, 6, 1, 2, 2, 2, 2,
	2, 2, 5, 5, 1, 2, 2, 2,
	2, 2, 4, 2, 2, 4, 6, 6,
	1, 2, 2, 2, 2, 2, 4, 5,
	5, 1, 0, 6, 5, 5, 1, 6,
	6, 1, 1, 1, 6, 6, 6, 1,
	1, 1, 6, 7, 5, 5, 5, 1,
	2, 2, 2, 2, 2, 4, 4, 4,
	1, 5, 5, 5, 1, 1, 0, 1,
	0, 1, 5, 6, 6, 1, 2, 2,
	4, 8, 8, 1, 2, 2, 2, 4,
	5, 5, 1, 2, 6, 5, 5, 1,
	6, 6, 1, 1, 1, 6, 6, 6,
	1, 1, 1, 6, 7, 8, 8, 8,
	8, 8, 8, 8, 8, 6, 5, 5,
	1, 6, 6, 1, 7, 12, 12, 1,
	2, 6, 6, 6, 1, 5, 10, 10,
	1, 2, 2, 2, 0, 6, 0, 6,
	6, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 4, 6, 6, 1, 2, 2,
	2, 2, 2, 4, 4, 4, 1, 5,
	5, 5, 1, 2, 1, 1, 1, 5,
	5, 5, 1, 1, 1, 2, 2, 2,
	2, 2, 4, 4, 4, 1, 5, 5,
	5, 1, 1, 0, 6, 5, 5, 1,
	0, 5, 5, 5, 1, 1, 1, 1,
	1, 1, 5, 5, 1, 4, 2, 2,
	4, 8, 8, 1, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 7, 7, 1,
	1, 1, 6, 6, 6, 1, 5, 5,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 7, 7, 1, 1, 1, 6,
	6, 1, 2, 2, 2, 2, 2, 2,
	4, 2, 2, 2, 4, 6, 6, 1,
	2, 4, 7, 8, 8, 1, 1, 1,
	8, 1, 1, 0, 8, 9, 9, 7,
	1, 4, 4, 4, 1, 6, 5, 5,
	1, 6, 6, 1, 1, 1, 5, 1,
	1, 5, 6, 2, 4, 2, 2, 4,
	6, 6, 1, 2, 2, 2, 2, 2,
	4, 5, 5, 1, 4, 4, 1, 5,
	8, 8, 1, 1, 1, 4, 6, 6,
	1, 1, 1, 6, 9, 9, 1, 1,
	1, 0, 4, 7, 7, 1, 7, 7,
	7, 7, 7, 7, 7, 5, 10, 10,
	1, 4, 4, 7, 7, 1, 1, 1,
	4, 4, 4, 1, 4, 5, 7, 7,
	7, 7, 5, 8, 8, 1, 5, 9,
	9, 1, 6, 2, 2, 2, 2, 2,
	2, 1, 6, 6, 1, 4, 4, 1,
	5, 5, 5, 1, 5, 2, 2, 2,
	2, 2, 2, 5, 2, 2, 2, 2,
	2, 4, 6, 6, 1, 2, 2, 2,
	2, 6, 4, 4, 1, 5, 6, 6,
	1, 1, 1, 6, 6, 6, 1, 5,
	5, 5, 1, 1, 1, 4, 2, 2,
	2, 0, 6, 2, 2, 2, 7, 7,
	1, 6, 6, 1, 1, 6, 1, 4,
	4, 1, 6, 1, 4, 1, 4, 4,
	1, 4, 4, 2, 2, 2, 2, 2,
	7, 5, 5, 1, 4, 4, 1, 5,
	2, 2, 2, 2, 5, 1, 1, 6,
	8, 8, 8, 7, 12, 12, 1, 8,
	8, 8, 8, 8, 9, 12, 12, 1,
	7, 2, 2, 2, 2, 4, 6, 6,
	1, 2, 2, 2, 4, 6, 6, 1,
	1, 1, 5, 6, 6, 1, 2, 2,
	2, 2, 2, 5, 5, 1, 4, 4,
	1, 6, 1, 1, 2, 2, 2, 2,
	2, 5, 5, 5, 1, 6, 27, 27,
	27, 27, 0
};

static const signed char _spss_commands_range_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 2, 2, 0,
	0, 0, 0, 0, 0, 0, 1, 2,
	2, 0, 3, 1, 1, 0, 1, 2,
	2, 0, 1, 1, 0, 2, 2, 0,
	3, 1, 1, 0, 1, 2, 2, 0,
	1, 1, 0, 2, 2, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 2,
	2, 0, 2, 3, 0, 0, 0, 3,
	3, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 3, 3, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 2, 2,
	0, 3, 2, 2, 0, 0, 1, 1,
	1, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 2, 3, 0, 0, 0,
	3, 3, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 0, 0,
	0, 3, 3, 0, 3, 0, 0, 0,
	1, 1, 2, 2, 0, 3, 0, 0,
	0, 0, 0, 0, 1, 1, 1, 1,
	1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 2, 2, 0, 3,
	0, 0, 0, 0, 0, 0, 0, 0,
	2, 2, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 2, 2, 0, 3, 0,
	0, 0, 1, 1, 1, 1, 1, 0,
	1, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 4, 4, 4, 0, 0, 0,
	4, 0, 0, 1, 4, 4, 4, 4,
	0, 0, 2, 2, 0, 3, 0, 0,
	0, 3, 3, 0, 0, 0, 0, 0,
	0, 1, 3, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 2, 2, 0, 2, 2, 0, 3,
	3, 3, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 0, 0,
	0, 1, 1, 2, 2, 0, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3,
	0, 0, 1, 0, 0, 0, 0, 0,
	0, 1, 1, 0, 1, 3, 3, 3,
	3, 3, 3, 3, 3, 0, 3, 3,
	3, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 2, 2, 0,
	3, 2, 2, 0, 3, 0, 0, 0,
	0, 0, 0, 3, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 2, 2, 0, 3, 0, 0,
	0, 0, 0, 0, 2, 2, 0, 0,
	2, 2, 0, 0, 0, 0, 0, 0,
	0, 1, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 0, 1, 1,
	1, 0, 1, 1, 0, 1, 1, 1,
	0, 1, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 0, 1,
	0, 0, 0, 0, 0, 0, 0, 3,
	3, 3, 3, 3, 0, 0, 0, 3,
	3, 3, 3, 3, 3, 0, 0, 0,
	3, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 2, 2, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 2, 2,
	0, 3, 0, 0, 0, 0, 0, 0,
	0, 0, 2, 2, 0, 3, 0, 0,
	0, 1, 0
};

static const short _spss_commands_index_offsets[] = {
	0, 0, 2, 4, 10, 13, 15, 17,
	20, 22, 24, 26, 28, 30, 32, 34,
	36, 41, 44, 47, 54, 61, 68, 70,
	73, 76, 79, 84, 95, 106, 108, 111,
	116, 119, 125, 131, 133, 143, 157, 171,
	173, 175, 177, 183, 195, 207, 209, 215,
	222, 229, 231, 240, 246, 252, 254, 261,
	269, 277, 279, 283, 286, 291, 298, 305,
	307, 316, 322, 328, 330, 339, 349, 359,
	361, 365, 368, 375, 384, 393, 395, 400,
	403, 408, 415, 422, 424, 427, 430, 433,
	436, 441, 448, 455, 457, 460, 463, 466,
	469, 472, 475, 481, 487, 489, 492, 495,
	498, 501, 504, 509, 512, 515, 520, 527,
	534, 536, 539, 542, 545, 548, 551, 556,
	564, 572, 574, 577, 587, 593, 599, 601,
	611, 621, 623, 625, 627, 634, 641, 648,
	650, 652, 654, 662, 673, 682, 688, 694,
	696, 699, 702, 705, 708, 711, 716, 723,
	730, 732, 741, 749, 757, 759, 761, 763,
	766, 768, 771, 777, 784, 791, 793, 796,
	799, 804, 813, 822, 824, 827, 830, 833,
	838, 844, 850, 852, 857, 867, 873, 879,
	881, 891, 901, 903, 905, 907, 914, 921,
	928, 930, 932, 934, 942, 953, 965, 977,
	989, 1001, 1013, 1025, 1037, 1049, 1059, 1065,
	1071, 1073, 1083, 1093, 1095, 1106, 1119, 1132,
	1134, 1138, 1146, 1155, 1164, 1166, 1175, 1186,
	1197, 1199, 1202, 1205, 1208, 1210, 1218, 1220,
	1228, 1236, 1239, 1242, 1245, 1248, 1251, 1254,
	1257, 1260, 1263, 1268, 1275, 1282, 1284, 1287,
	1290, 1293, 1296, 1299, 1304, 1311, 1318, 1320,
	1329, 1335, 1341, 1343, 1346, 1348, 1350, 1352,
	1358, 1366, 1374, 1376, 1378, 1380, 1383, 1386,
	1389, 1392, 1395, 1400, 1407, 1414, 1416, 1425,
	1431, 1437, 1439, 1442, 1444, 1452, 1459, 1466,
	1468, 1470, 1477, 1483, 1489, 1491, 1493, 1495,
	1497, 1499, 1501, 1507, 1513, 1515, 1520, 1523,
	1526, 1531, 1540, 1549, 1551, 1554, 1557, 1560,
	1563, 1566, 1569, 1572, 1575, 1578, 1586, 1594,
	1596, 1598, 1600, 1607, 1614, 1621, 1623, 1629,
	1635, 1637, 1639, 1641, 1643, 1645, 1647, 1649,
	1651, 1653, 1655, 1663, 1671, 1673, 1675, 1677,
	1684, 1691, 1693, 1696, 1699, 1702, 1705, 1708,
	1711, 1716, 1719, 1722, 1725, 1730, 1737, 1744,
	1746, 1749, 1754, 1766, 1779, 1792, 1794, 1796,
	1798, 1811, 1813, 1815, 1817, 1830, 1844, 1858,
	1870, 1872, 1877, 1884, 1891, 1893, 1903, 1909,
	1915, 1917, 1927, 1937, 1939, 1941, 1943, 1949,
	1951, 1953, 1960, 1970, 1973, 1978, 1981, 1984,
	1989, 1996, 2003, 2005, 2008, 2011, 2014, 2017,
	2020, 2025, 2033, 2041, 2043, 2050, 2057, 2059,
	2068, 2080, 2092, 2094, 2096, 2098, 2103, 2110,
	2117, 2119, 2121, 2123, 2130, 2141, 2152, 2154,
	2156, 2158, 2160, 2166, 2176, 2186, 2188, 2199,
	2210, 2221, 2232, 2243, 2254, 2265, 2274, 2288,
	2302, 2304, 2309, 2315, 2323, 2331, 2333, 2335,
	2337, 2342, 2348, 2354, 2356, 2362, 2371, 2382,
	2393, 2404, 2415, 2424, 2436, 2448, 2450, 2459,
	2472, 2485, 2487, 2494, 2497, 2500, 2503, 2506,
	2509, 2512, 2514, 2521, 2528, 2530, 2537, 2544,
	2546, 2555, 2563, 2571, 2573, 2582, 2585, 2588,
	2591, 2594, 2597, 2600, 2609, 2612, 2615, 2618,
	2621, 2624, 2629, 2636, 2643, 2645, 2648, 2651,
	2654, 2657, 2664, 2671, 2678, 2680, 2689, 2696,
	2703, 2705, 2707, 2709, 2716, 2725, 2734, 2736,
	2742, 2750, 2758, 2760, 2762, 2764, 2769, 2772,
	2775, 2778, 2780, 2788, 2791, 2794, 2797, 2805,
	2813, 2815, 2822, 2829, 2831, 2834, 2841, 2844,
	2850, 2856, 2858, 2866, 2869, 2874, 2877, 2883,
	2889, 2891, 2897, 2903, 2906, 2909, 2912, 2915,
	2918, 2926, 2932, 2938, 2940, 2946, 2952, 2954,
	2961, 2964, 2967, 2970, 2973, 2979, 2981, 2983,
	2993, 3005, 3017, 3029, 3040, 3053, 3066, 3068,
	3080, 3092, 3104, 3116, 3128, 3141, 3154, 3167,
	3169, 3180, 3183, 3186, 3189, 3192, 3197, 3204,
	3211, 3213, 3216, 3219, 3222, 3227, 3236, 3245,
	3247, 3249, 3251, 3257, 3264, 3271, 3273, 3276,
	3279, 3282, 3285, 3288, 3294, 3300, 3302, 3309,
	3316, 3318, 3328, 3330, 3332, 3335, 3338, 3341,
	3344, 3347, 3353, 3361, 3369, 3371, 3381, 3409,
	3437, 3465, 0
};

static const short _spss_commands_cond_targs[] = {
	647, 0, 3, 2, 3, 647, 4, 3,
	3, 2, 647, 3, 2, 6, 0, 7,
	6, 7, 646, 6, 9, 0, 10, 0,
	11, 0, 12, 0, 13, 0, 14, 0,
	15, 0, 646, 15, 17, 636, 17, 636,
	0, 18, 18, 0, 19, 19, 0, 20,
	21, 22, 20, 603, 603, 0, 20, 21,
	22, 20, 23, 23, 0, 20, 21, 22,
	20, 23, 23, 0, 21, 0, 24, 24,
	0, 25, 25, 0, 26, 26, 0, 27,
	28, 29, 27, 0, 27, 28, 29, 27,
	30, 563, 576, 30, 563, 576, 0, 27,
	28, 29, 27, 30, 563, 576, 30, 563,
	576, 0, 28, 0, 31, 31, 0, 32,
	601, 32, 601, 0, 33, 33, 0, 33,
	34, 35, 33, 36, 0, 33, 34, 35,
	33, 36, 0, 34, 0, 37, 38, 39,
	37, 40, 581, 46, 583, 583, 0, 37,
	38, 39, 37, 40, 581, 46, 584, 591,
	584, 591, 583, 583, 0, 37, 38, 39,
	37, 40, 581, 46, 584, 591, 584, 591,
	583, 583, 0, 38, 0, 42, 41, 42,
	41, 43, 44, 45, 43, 46, 0, 43,
	44, 45, 43, 46, 30, 563, 576, 30,
	563, 576, 0, 43, 44, 45, 43, 46,
	30, 563, 576, 30, 563, 576, 0, 44,
	0, 47, 48, 49, 47, 562, 0, 47,
	48, 49, 47, 50, 50, 0, 47, 48,
	49, 47, 50, 50, 0, 48, 0, 51,
	52, 53, 51, 50, 50, 50, 50, 0,
	51, 52, 53, 51, 54, 0, 51, 52,
	53, 51, 54, 0, 52, 0, 55, 56,
	57, 55, 558, 54, 0, 55, 56, 57,
	55, 58, 64, 64, 0, 55, 56, 57,
	55, 58, 64, 64, 0, 56, 0, 555,
	555, 59, 0, 60, 59, 0, 61, 62,
	63, 61, 0, 61, 62, 63, 61, 64,
	64, 0, 61, 62, 63, 61, 64, 64,
	0, 62, 0, 65, 66, 67, 65, 64,
	64, 64, 64, 0, 65, 66, 67, 65,
	68, 0, 65, 66, 67, 65, 68, 0,
	66, 0, 69, 70, 71, 69, 551, 648,
	46, 68, 0, 69, 70, 71, 69, 72,
	648, 46, 64, 64, 0, 69, 70, 71,
	69, 72, 648, 46, 64, 64, 0, 70,
	0, 548, 548, 73, 0, 74, 73, 0,
	75, 76, 77, 75, 648, 46, 0, 75,
	76, 77, 75, 648, 46, 64, 64, 0,
	75, 76, 77, 75, 648, 46, 64, 64,
	0, 76, 0, 79, 101, 79, 101, 0,
	80, 80, 0, 81, 82, 83, 81, 0,
	81, 82, 83, 81, 84, 84, 0, 81,
	82, 83, 81, 84, 84, 0, 82, 0,
	85, 85, 0, 86, 86, 0, 87, 87,
	0, 88, 88, 0, 89, 90, 91, 89,
	0, 89, 90, 91, 89, 92, 92, 0,
	89, 90, 91, 89, 92, 92, 0, 90,
	0, 93, 93, 0, 94, 94, 0, 95,
	95, 0, 96, 96, 0, 97, 97, 0,
	98, 98, 0, 98, 99, 100, 98, 646,
	0, 98, 99, 100, 98, 646, 0, 99,
	0, 102, 102, 0, 103, 103, 0, 104,
	104, 0, 105, 105, 0, 98, 98, 0,
	107, 144, 107, 144, 0, 108, 108, 0,
	109, 109, 0, 110, 111, 112, 110, 0,
	110, 111, 112, 110, 113, 113, 0, 110,
	111, 112, 110, 113, 113, 0, 111, 0,
	114, 114, 0, 115, 115, 0, 116, 116,
	0, 117, 117, 0, 118, 118, 0, 119,
	120, 121, 119, 0, 119, 120, 121, 119,
	122, 140, 140, 0, 119, 120, 121, 119,
	122, 140, 140, 0, 120, 0, 123, 123,
	0, 124, 125, 126, 124, 127, 123, 123,
	123, 123, 0, 124, 125, 126, 124, 127,
	0, 124, 125, 126, 124, 127, 0, 125,
	0, 127, 128, 129, 127, 130, 136, 138,
	139, 139, 0, 127, 128, 129, 127, 130,
	136, 138, 139, 139, 0, 128, 0, 132,
	131, 132, 131, 133, 134, 135, 133, 646,
	122, 0, 133, 134, 135, 133, 646, 122,
	0, 133, 134, 135, 133, 646, 122, 0,
	134, 0, 132, 137, 132, 137, 133, 134,
	135, 133, 646, 122, 138, 0, 133, 134,
	135, 133, 646, 122, 139, 139, 139, 139,
	0, 141, 142, 143, 141, 140, 140, 140,
	140, 0, 141, 142, 143, 141, 122, 0,
	141, 142, 143, 141, 122, 0, 142, 0,
	145, 145, 0, 146, 146, 0, 147, 147,
	0, 148, 148, 0, 149, 149, 0, 150,
	151, 152, 150, 0, 150, 151, 152, 150,
	153, 153, 0, 150, 151, 152, 150, 153,
	153, 0, 151, 0, 154, 155, 156, 154,
	153, 153, 153, 153, 0, 154, 155, 156,
	154, 157, 153, 153, 0, 154, 155, 156,
	154, 157, 153, 153, 0, 155, 0, 158,
	0, 159, 0, 160, 159, 0, 161, 0,
	162, 161, 0, 163, 164, 165, 163, 646,
	0, 163, 164, 165, 163, 646, 149, 0,
	163, 164, 165, 163, 646, 149, 0, 164,
	0, 167, 167, 0, 168, 168, 0, 169,
	170, 171, 169, 0, 169, 170, 171, 169,
	172, 539, 172, 539, 0, 169, 170, 171,
	169, 172, 539, 172, 539, 0, 170, 0,
	173, 173, 0, 174, 174, 0, 175, 175,
	0, 176, 177, 178, 176, 0, 176, 177,
	178, 176, 179, 0, 176, 177, 178, 176,
	179, 0, 177, 0, 197, 197, 180, 180,
	0, 181, 182, 183, 181, 184, 180, 180,
	180, 180, 0, 181, 182, 183, 181, 184,
	0, 181, 182, 183, 181, 184, 0, 182,
	0, 184, 185, 186, 184, 187, 193, 195,
	196, 196, 0, 184, 185, 186, 184, 187,
	193, 195, 196, 196, 0, 185, 0, 189,
	188, 189, 188, 190, 191, 192, 190, 646,
	179, 0, 190, 191, 192, 190, 646, 179,
	0, 190, 191, 192, 190, 646, 179, 0,
	191, 0, 189, 194, 189, 194, 190, 191,
	192, 190, 646, 179, 195, 0, 190, 191,
	192, 190, 646, 179, 196, 196, 196, 196,
	0, 181, 182, 183, 181, 184, 198, 180,
	198, 180, 180, 180, 0, 181, 182, 183,
	181, 184, 199, 180, 199, 180, 180, 180,
	0, 181, 182, 183, 181, 184, 200, 180,
	200, 180, 180, 180, 0, 181, 182, 183,
	181, 184, 201, 180, 201, 180, 180, 180,
	0, 181, 182, 183, 181, 184, 202, 180,
	202, 180, 180, 180, 0, 181, 182, 183,
	181, 184, 203, 180, 203, 180, 180, 180,
	0, 181, 182, 183, 181, 184, 204, 180,
	204, 180, 180, 180, 0, 181, 182, 183,
	181, 184, 205, 180, 205, 180, 180, 180,
	0, 206, 207, 208, 206, 209, 180, 180,
	180, 180, 0, 206, 207, 208, 206, 209,
	0, 206, 207, 208, 206, 209, 0, 207,
	0, 209, 210, 211, 209, 187, 193, 195,
	212, 212, 0, 209, 210, 211, 209, 187,
	193, 195, 212, 212, 0, 210, 0, 213,
	214, 215, 213, 646, 179, 212, 212, 212,
	212, 0, 213, 214, 215, 213, 646, 179,
	216, 225, 230, 216, 225, 230, 0, 213,
	214, 215, 213, 646, 179, 216, 225, 230,
	216, 225, 230, 0, 214, 0, 534, 534,
	217, 0, 218, 219, 220, 218, 646, 179,
	217, 0, 218, 219, 220, 218, 646, 179,
	221, 221, 0, 218, 219, 220, 218, 646,
	179, 221, 221, 0, 219, 0, 222, 223,
	224, 222, 221, 221, 221, 221, 0, 222,
	223, 224, 222, 216, 225, 230, 216, 225,
	230, 0, 222, 223, 224, 222, 216, 225,
	230, 216, 225, 230, 0, 223, 0, 226,
	226, 0, 227, 227, 0, 228, 228, 0,
	229, 0, 218, 219, 220, 218, 646, 179,
	229, 0, 231, 0, 218, 219, 220, 218,
	649, 179, 231, 0, 218, 219, 220, 218,
	646, 179, 232, 0, 234, 234, 0, 235,
	235, 0, 98, 98, 0, 237, 237, 0,
	238, 238, 0, 239, 239, 0, 240, 240,
	0, 241, 241, 0, 242, 242, 0, 243,
	244, 245, 243, 0, 243, 244, 245, 243,
	246, 246, 0, 243, 244, 245, 243, 246,
	246, 0, 244, 0, 247, 247, 0, 248,
	248, 0, 249, 249, 0, 250, 250, 0,
	251, 251, 0, 252, 253, 254, 252, 0,
	252, 253, 254, 252, 255, 255, 0, 252,
	253, 254, 252, 255, 255, 0, 253, 0,
	256, 257, 258, 256, 255, 255, 255, 255,
	0, 256, 257, 258, 256, 259, 0, 256,
	257, 258, 256, 259, 0, 257, 0, 260,
	267, 0, 262, 261, 262, 261, 263, 0,
	264, 265, 266, 264, 646, 0, 264, 265,
	266, 264, 646, 255, 255, 0, 264, 265,
	266, 264, 646, 255, 255, 0, 265, 0,
	262, 268, 262, 268, 270, 270, 0, 271,
	271, 0, 272, 272, 0, 273, 273, 0,
	274, 274, 0, 275, 276, 277, 275, 0,
	275, 276, 277, 275, 278, 278, 0, 275,
	276, 277, 275, 278, 278, 0, 276, 0,
	279, 280, 281, 279, 278, 278, 278, 278,
	0, 279, 280, 281, 279, 282, 0, 279,
	280, 281, 279, 282, 0, 280, 0, 283,
	284, 0, 284, 0, 285, 286, 287, 285,
	288, 290, 284, 0, 285, 286, 287, 285,
	283, 284, 0, 285, 286, 287, 285, 283,
	284, 0, 286, 0, 289, 0, 285, 286,
	287, 285, 290, 289, 0, 290, 291, 292,
	290, 293, 0, 290, 291, 292, 290, 293,
	0, 291, 0, 294, 0, 295, 0, 296,
	0, 297, 0, 298, 0, 298, 299, 300,
	298, 98, 0, 298, 299, 300, 298, 98,
	0, 299, 0, 302, 352, 302, 352, 0,
	303, 303, 0, 304, 304, 0, 305, 306,
	307, 305, 0, 305, 306, 307, 305, 308,
	346, 308, 346, 0, 305, 306, 307, 305,
	308, 346, 308, 346, 0, 306, 0, 309,
	309, 0, 310, 310, 0, 311, 311, 0,
	312, 312, 0, 313, 313, 0, 314, 314,
	0, 315, 315, 0, 316, 316, 0, 317,
	317, 0, 317, 318, 319, 317, 320, 341,
	343, 0, 317, 318, 319, 317, 320, 341,
	343, 0, 318, 0, 322, 321, 322, 321,
	323, 324, 325, 323, 646, 338, 0, 323,
	324, 325, 323, 646, 326, 0, 323, 324,
	325, 323, 646, 326, 0, 324, 0, 326,
	327, 328, 326, 329, 0, 326, 327, 328,
	326, 329, 0, 327, 0, 330, 0, 331,
	0, 332, 0, 333, 0, 334, 0, 335,
	0, 336, 0, 337, 0, 98, 0, 338,
	339, 340, 338, 646, 326, 329, 0, 338,
	339, 340, 338, 646, 326, 329, 0, 339,
	0, 322, 342, 322, 342, 343, 344, 345,
	343, 320, 341, 0, 343, 344, 345, 343,
	320, 341, 0, 344, 0, 347, 347, 0,
	348, 348, 0, 349, 349, 0, 350, 350,
	0, 351, 351, 0, 317, 317, 0, 353,
	377, 353, 377, 0, 354, 354, 0, 355,
	355, 0, 356, 356, 0, 357, 358, 359,
	357, 0, 357, 358, 359, 357, 360, 360,
	0, 357, 358, 359, 357, 360, 360, 0,
	358, 0, 361, 361, 0, 362, 375, 376,
	362, 0, 363, 364, 365, 363, 366, 369,
	371, 363, 372, 373, 373, 0, 363, 364,
	365, 363, 366, 369, 371, 646, 363, 372,
	373, 373, 0, 363, 364, 365, 363, 366,
	369, 371, 646, 363, 372, 373, 373, 0,
	364, 0, 368, 367, 368, 367, 363, 364,
	365, 363, 366, 369, 371, 646, 363, 372,
	373, 373, 0, 368, 370, 368, 370, 372,
	0, 363, 364, 365, 363, 366, 369, 371,
	646, 363, 372, 373, 373, 0, 363, 364,
	365, 363, 366, 369, 371, 646, 373, 363,
	374, 373, 373, 0, 363, 364, 365, 363,
	366, 369, 371, 646, 373, 363, 374, 373,
	373, 0, 363, 364, 365, 363, 366, 369,
	371, 363, 372, 373, 373, 0, 375, 0,
	378, 379, 380, 378, 0, 378, 379, 380,
	378, 381, 381, 0, 378, 379, 380, 378,
	381, 381, 0, 379, 0, 382, 383, 384,
	382, 385, 381, 381, 381, 381, 0, 382,
	383, 384, 382, 385, 0, 382, 383, 384,
	382, 385, 0, 383, 0, 385, 386, 387,
	385, 388, 391, 393, 394, 394, 0, 385,
	386, 387, 385, 388, 391, 393, 394, 394,
	0, 386, 0, 390, 389, 390, 389, 98,
	99, 100, 98, 646, 0, 390, 392, 390,
	392, 98, 99, 100, 98, 646, 393, 0,
	98, 99, 100, 98, 646, 394, 394, 394,
	394, 0, 396, 396, 0, 397, 500, 397,
	500, 0, 398, 398, 0, 399, 399, 0,
	400, 401, 402, 400, 0, 400, 401, 402,
	400, 403, 403, 0, 400, 401, 402, 400,
	403, 403, 0, 401, 0, 404, 404, 0,
	405, 405, 0, 406, 406, 0, 407, 407,
	0, 408, 408, 0, 409, 410, 411, 409,
	0, 409, 410, 411, 409, 412, 415, 415,
	0, 409, 410, 411, 409, 412, 415, 415,
	0, 410, 0, 412, 413, 414, 412, 415,
	415, 0, 412, 413, 414, 412, 415, 415,
	0, 413, 0, 416, 417, 418, 416, 415,
	415, 415, 415, 0, 416, 417, 418, 416,
	419, 431, 433, 449, 450, 461, 461, 0,
	416, 417, 418, 416, 419, 431, 433, 449,
	450, 461, 461, 0, 417, 0, 421, 420,
	421, 420, 422, 423, 424, 422, 0, 422,
	423, 424, 422, 425, 454, 0, 422, 423,
	424, 422, 425, 454, 0, 423, 0, 427,
	426, 427, 426, 428, 429, 430, 428, 646,
	435, 0, 428, 429, 430, 428, 419, 431,
	433, 646, 435, 450, 0, 428, 429, 430,
	428, 419, 431, 433, 646, 435, 450, 0,
	429, 0, 421, 432, 421, 432, 434, 0,
	422, 423, 424, 422, 434, 0, 435, 436,
	437, 435, 646, 438, 438, 415, 415, 0,
	435, 436, 437, 435, 646, 438, 438, 415,
	415, 0, 436, 0, 416, 417, 418, 416,
	439, 415, 439, 415, 415, 415, 0, 416,
	417, 418, 416, 440, 415, 440, 415, 415,
	415, 0, 416, 417, 418, 416, 441, 415,
	441, 415, 415, 415, 0, 416, 417, 418,
	416, 442, 415, 442, 415, 415, 415, 0,
	416, 417, 418, 416, 443, 415, 443, 415,
	415, 415, 0, 416, 417, 418, 416, 444,
	415, 444, 415, 415, 415, 0, 416, 417,
	418, 416, 445, 415, 445, 415, 415, 415,
	0, 446, 447, 448, 446, 415, 415, 415,
	415, 0, 446, 447, 448, 446, 419, 431,
	433, 449, 462, 462, 450, 461, 461, 0,
	446, 447, 448, 446, 419, 431, 433, 449,
	462, 462, 450, 461, 461, 0, 447, 0,
	422, 423, 424, 422, 0, 451, 452, 453,
	451, 450, 0, 451, 452, 453, 451, 425,
	454, 456, 0, 451, 452, 453, 451, 425,
	454, 456, 0, 452, 0, 427, 455, 427,
	455, 457, 458, 459, 457, 0, 457, 458,
	459, 457, 460, 0, 457, 458, 459, 457,
	460, 0, 458, 0, 422, 423, 424, 422,
	460, 0, 416, 417, 418, 416, 461, 461,
	461, 461, 0, 416, 417, 418, 416, 463,
	461, 463, 461, 461, 461, 0, 416, 417,
	418, 416, 464, 461, 464, 461, 461, 461,
	0, 416, 417, 418, 416, 465, 461, 465,
	461, 461, 461, 0, 416, 417, 418, 416,
	466, 461, 466, 461, 461, 461, 0, 467,
	468, 469, 467, 461, 461, 461, 461, 0,
	467, 468, 469, 467, 419, 431, 433, 449,
	450, 470, 470, 0, 467, 468, 469, 467,
	419, 431, 433, 449, 450, 470, 470, 0,
	468, 0, 471, 472, 473, 471, 470, 470,
	470, 470, 0, 471, 472, 473, 471, 419,
	431, 474, 433, 449, 450, 499, 499, 0,
	471, 472, 473, 471, 419, 431, 474, 433,
	449, 450, 499, 499, 0, 472, 0, 475,
	493, 495, 475, 493, 495, 0, 476, 476,
	0, 477, 477, 0, 478, 478, 0, 479,
	479, 0, 480, 480, 0, 481, 481, 0,
	482, 0, 482, 483, 484, 482, 646, 485,
	0, 482, 483, 484, 482, 646, 485, 0,
	483, 0, 485, 486, 487, 485, 488, 488,
	0, 485, 486, 487, 485, 488, 488, 0,
	486, 0, 489, 490, 491, 489, 488, 488,
	488, 488, 0, 489, 490, 491, 489, 474,
	492, 492, 0, 489, 490, 491, 489, 474,
	492, 492, 0, 490, 0, 489, 490, 491,
	489, 492, 492, 492, 492, 0, 494, 494,
	0, 477, 477, 0, 496, 496, 0, 497,
	497, 0, 498, 498, 0, 481, 481, 0,
	471, 472, 473, 471, 499, 499, 499, 499,
	0, 501, 501, 0, 502, 502, 0, 503,
	503, 0, 504, 504, 0, 505, 505, 0,
	506, 507, 508, 506, 0, 506, 507, 508,
	506, 509, 509, 0, 506, 507, 508, 506,
	509, 509, 0, 507, 0, 510, 510, 0,
	511, 511, 0, 512, 512, 0, 513, 513,
	0, 514, 515, 516, 514, 533, 533, 0,
	514, 515, 516, 514, 517, 517, 0, 514,
	515, 516, 514, 517, 517, 0, 515, 0,
	518, 519, 520, 518, 517, 517, 517, 517,
	0, 518, 519, 520, 518, 521, 531, 0,
	518, 519, 520, 518, 521, 531, 0, 519,
	0, 523, 522, 523, 522, 524, 525, 526,
	524, 646, 527, 0, 524, 525, 526, 524,
	646, 527, 517, 517, 0, 524, 525, 526,
	524, 646, 527, 517, 517, 0, 525, 0,
	528, 529, 530, 528, 646, 0, 528, 529,
	530, 528, 646, 517, 517, 0, 528, 529,
	530, 528, 646, 517, 517, 0, 529, 0,
	523, 532, 523, 532, 514, 515, 516, 514,
	0, 535, 535, 0, 536, 536, 0, 537,
	537, 0, 538, 0, 218, 219, 220, 218,
	646, 179, 538, 0, 540, 540, 0, 541,
	541, 0, 542, 542, 0, 542, 543, 544,
	542, 388, 391, 545, 0, 542, 543, 544,
	542, 388, 391, 545, 0, 543, 0, 545,
	546, 547, 545, 388, 391, 0, 545, 546,
	547, 545, 388, 391, 0, 546, 0, 549,
	550, 0, 75, 76, 77, 75, 648, 46,
	0, 549, 550, 0, 551, 552, 553, 551,
	554, 0, 551, 552, 553, 551, 554, 0,
	552, 0, 69, 70, 71, 69, 648, 46,
	554, 0, 556, 557, 0, 61, 62, 63,
	61, 0, 556, 557, 0, 558, 559, 560,
	558, 561, 0, 558, 559, 560, 558, 561,
	0, 559, 0, 55, 56, 57, 55, 561,
	0, 47, 48, 49, 47, 562, 0, 564,
	564, 0, 565, 565, 0, 566, 566, 0,
	567, 567, 0, 568, 568, 0, 569, 570,
	571, 569, 572, 569, 569, 0, 569, 570,
	571, 569, 572, 0, 569, 570, 571, 569,
	572, 0, 570, 0, 572, 573, 574, 572,
	575, 0, 572, 573, 574, 572, 575, 0,
	573, 0, 43, 44, 45, 43, 46, 575,
	0, 577, 577, 0, 578, 578, 0, 579,
	579, 0, 580, 580, 0, 43, 44, 45,
	43, 46, 0, 42, 582, 42, 582, 43,
	44, 45, 43, 46, 583, 583, 583, 583,
	0, 43, 44, 45, 43, 46, 585, 583,
	585, 583, 583, 583, 0, 43, 44, 45,
	43, 46, 586, 583, 586, 583, 583, 583,
	0, 43, 44, 45, 43, 46, 587, 583,
	587, 583, 583, 583, 0, 588, 589, 590,
	588, 46, 36, 583, 583, 583, 583, 0,
	588, 589, 590, 588, 46, 36, 30, 563,
	576, 30, 563, 576, 0, 588, 589, 590,
	588, 46, 36, 30, 563, 576, 30, 563,
	576, 0, 589, 0, 43, 44, 45, 43,
	46, 592, 583, 592, 583, 583, 583, 0,
	43, 44, 45, 43, 46, 593, 583, 593,
	583, 583, 583, 0, 43, 44, 45, 43,
	46, 594, 583, 594, 583, 583, 583, 0,
	43, 44, 45, 43, 46, 595, 583, 595,
	583, 583, 583, 0, 43, 44, 45, 43,
	46, 596, 583, 596, 583, 583, 583, 0,
	597, 598, 599, 597, 46, 572, 600, 583,
	600, 583, 583, 583, 0, 597, 598, 599,
	597, 46, 572, 30, 563, 576, 30, 563,
	576, 0, 597, 598, 599, 597, 46, 572,
	30, 563, 576, 30, 563, 576, 0, 598,
	0, 597, 598, 599, 597, 46, 572, 583,
	583, 583, 583, 0, 602, 602, 0, 580,
	580, 0, 604, 604, 0, 605, 605, 0,
	606, 607, 608, 606, 0, 606, 607, 608,
	606, 609, 609, 0, 606, 607, 608, 606,
	609, 609, 0, 607, 0, 610, 610, 0,
	611, 611, 0, 612, 612, 0, 613, 614,
	615, 613, 0, 613, 614, 615, 613, 616,
	634, 633, 633, 0, 613, 614, 615, 613,
	616, 634, 633, 633, 0, 614, 0, 618,
	617, 618, 617, 619, 620, 621, 619, 646,
	0, 619, 620, 621, 619, 622, 622, 0,
	619, 620, 621, 619, 622, 622, 0, 620,
	0, 623, 623, 0, 624, 624, 0, 625,
	625, 0, 626, 626, 0, 627, 627, 0,
	627, 628, 629, 627, 630, 0, 627, 628,
	629, 627, 630, 0, 628, 0, 630, 631,
	632, 630, 633, 633, 0, 630, 631, 632,
	630, 633, 633, 0, 631, 0, 619, 620,
	621, 619, 646, 633, 633, 633, 633, 0,
	618, 635, 618, 635, 637, 637, 0, 638,
	638, 0, 639, 639, 0, 640, 640, 0,
	641, 641, 0, 642, 643, 644, 642, 646,
	0, 642, 643, 644, 642, 646, 645, 645,
	0, 642, 643, 644, 642, 646, 645, 645,
	0, 643, 0, 642, 643, 644, 642, 646,
	645, 645, 645, 645, 0, 646, 647, 1,
	646, 2, 5, 8, 16, 78, 106, 166,
	84, 233, 236, 269, 301, 395, 16, 78,
	106, 166, 84, 233, 236, 269, 301, 395,
	0, 646, 647, 1, 646, 2, 5, 8,
	16, 78, 106, 166, 84, 233, 236, 269,
	301, 395, 16, 78, 106, 166, 84, 233,
	236, 269, 301, 395, 0, 646, 647, 1,
	646, 2, 5, 8, 16, 78, 106, 166,
	84, 233, 236, 269, 301, 395, 16, 78,
	106, 166, 84, 233, 236, 269, 301, 395,
	0, 646, 647, 1, 646, 2, 5, 8,
	16, 78, 106, 166, 84, 233, 236, 269,
	301, 395, 16, 78, 106, 166, 84, 233,
	236, 269, 301, 395, 232, 0, 0, 1,
	2, 3, 4, 5, 6, 7, 8, 9,
	10, 11, 12, 13, 14, 15, 16, 17,
	18, 19, 20, 21, 22, 23, 24, 25,
	26, 27, 28, 29, 30, 31, 32, 33,
	34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65,
	66, 67, 68, 69, 70, 71, 72, 73,
	74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 85, 86, 87, 88, 89,
	90, 91, 92, 93, 94, 95, 96, 97,
	98, 99, 100, 101, 102, 103, 104, 105,
	106, 107, 108, 109, 110, 111, 112, 113,
	114, 115, 116, 117, 118, 119, 120, 121,
	122, 123, 124, 125, 126, 127, 128, 129,
	130, 131, 132, 133, 134, 135, 136, 137,
	138, 139, 140, 141, 142, 143, 144, 145,
	146, 147, 148, 149, 150, 151, 152, 153,
	154, 155, 156, 157, 158, 159, 160, 161,
	162, 163, 164, 165, 166, 167, 168, 169,
	170, 171, 172, 173, 174, 175, 176, 177,
	178, 179, 180, 181, 182, 183, 184, 185,
	186, 187, 188, 189, 190, 191, 192, 193,
	194, 195, 196, 197, 198, 199, 200, 201,
	202, 203, 204, 205, 206, 207, 208, 209,
	210, 211, 212, 213, 214, 215, 216, 217,
	218, 219, 220, 221, 222, 223, 224, 225,
	226, 227, 228, 229, 230, 231, 232, 233,
	234, 235, 236, 237, 238, 239, 240, 241,
	242, 243, 244, 245, 246, 247, 248, 249,
	250, 251, 252, 253, 254, 255, 256, 257,
	258, 259, 260, 261, 262, 263, 264, 265,
	266, 267, 268, 269, 270, 271, 272, 273,
	274, 275, 276, 277, 278, 279, 280, 281,
	282, 283, 284, 285, 286, 287, 288, 289,
	290, 291, 292, 293, 294, 295, 296, 297,
	298, 299, 300, 301, 302, 303, 304, 305,
	306, 307, 308, 309, 310, 311, 312, 313,
	314, 315, 316, 317, 318, 319, 320, 321,
	322, 323, 324, 325, 326, 327, 328, 329,
	330, 331, 332, 333, 334, 335, 336, 337,
	338, 339, 340, 341, 342, 343, 344, 345,
	346, 347, 348, 349, 350, 351, 352, 353,
	354, 355, 356, 357, 358, 359, 360, 361,
	362, 363, 364, 365, 366, 367, 368, 369,
	370, 371, 372, 373, 374, 375, 376, 377,
	378, 379, 380, 381, 382, 383, 384, 385,
	386, 387, 388, 389, 390, 391, 392, 393,
	394, 395, 396, 397, 398, 399, 400, 401,
	402, 403, 404, 405, 406, 407, 408, 409,
	410, 411, 412, 413, 414, 415, 416, 417,
	418, 419, 420, 421, 422, 423, 424, 425,
	426, 427, 428, 429, 430, 431, 432, 433,
	434, 435, 436, 437, 438, 439, 440, 441,
	442, 443, 444, 445, 446, 447, 448, 449,
	450, 451, 452, 453, 454, 455, 456, 457,
	458, 459, 460, 461, 462, 463, 464, 465,
	466, 467, 468, 469, 470, 471, 472, 473,
	474, 475, 476, 477, 478, 479, 480, 481,
	482, 483, 484, 485, 486, 487, 488, 489,
	490, 491, 492, 493, 494, 495, 496, 497,
	498, 499, 500, 501, 502, 503, 504, 505,
	506, 507, 508, 509, 510, 511, 512, 513,
	514, 515, 516, 517, 518, 519, 520, 521,
	522, 523, 524, 525, 526, 527, 528, 529,
	530, 531, 532, 533, 534, 535, 536, 537,
	538, 539, 540, 541, 542, 543, 544, 545,
	546, 547, 548, 549, 550, 551, 552, 553,
	554, 555, 556, 557, 558, 559, 560, 561,
	562, 563, 564, 565, 566, 567, 568, 569,
	570, 571, 572, 573, 574, 575, 576, 577,
	578, 579, 580, 581, 582, 583, 584, 585,
	586, 587, 588, 589, 590, 591, 592, 593,
	594, 595, 596, 597, 598, 599, 600, 601,
	602, 603, 604, 605, 606, 607, 608, 609,
	610, 611, 612, 613, 614, 615, 616, 617,
	618, 619, 620, 621, 622, 623, 624, 625,
	626, 627, 628, 629, 630, 631, 632, 633,
	634, 635, 636, 637, 638, 639, 640, 641,
	642, 643, 644, 645, 646, 647, 648, 649,
	0
};

static const short _spss_commands_cond_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 21, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 23, 23, 0, 0,
	0, 0, 0, 0, 0, 0, 23, 23,
	23, 23, 23, 23, 0, 21, 21, 21,
	21, 21, 21, 21, 81, 81, 81, 81,
	81, 81, 0, 0, 0, 75, 17, 19,
	0, 5, 5, 5, 5, 5, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 39, 0, 0,
	0, 0, 0, 23, 23, 0, 21, 21,
	21, 21, 81, 81, 0, 0, 0, 84,
	84, 84, 84, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 39, 0, 21, 21,
	21, 21, 120, 0, 0, 0, 45, 45,
	45, 45, 3, 1, 0, 0, 0, 0,
	0, 0, 69, 69, 0, 21, 21, 21,
	21, 21, 124, 124, 0, 0, 0, 0,
	0, 39, 0, 0, 1, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 69,
	69, 0, 21, 21, 21, 21, 124, 124,
	0, 0, 0, 84, 84, 84, 84, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	39, 0, 21, 21, 21, 21, 120, 0,
	0, 0, 48, 48, 48, 48, 3, 48,
	48, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 69, 69, 0, 21, 21, 21,
	21, 21, 21, 21, 124, 124, 0, 0,
	0, 0, 0, 39, 0, 0, 1, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 69, 69, 0,
	21, 21, 21, 21, 21, 21, 124, 124,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 21, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 21, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 23, 23, 0, 21, 21, 21, 21,
	21, 81, 81, 0, 0, 0, 23, 23,
	0, 87, 87, 87, 87, 87, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 39,
	23, 23, 0, 21, 21, 21, 21, 21,
	21, 120, 81, 81, 0, 0, 0, 75,
	17, 19, 0, 5, 5, 5, 5, 5,
	5, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 21, 0,
	0, 0, 72, 13, 15, 0, 0, 0,
	0, 0, 0, 0, 1, 0, 25, 25,
	25, 25, 25, 25, 0, 0, 0, 0,
	0, 25, 25, 25, 25, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	21, 21, 21, 21, 21, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	23, 23, 0, 21, 21, 21, 21, 81,
	81, 0, 0, 0, 25, 25, 25, 25,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 23, 23, 0, 21, 21, 21,
	21, 21, 81, 81, 0, 0, 0, 0,
	0, 39, 0, 0, 1, 0, 39, 0,
	0, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 21, 21, 21, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 21, 21, 21, 21,
	21, 0, 0, 0, 23, 23, 23, 23,
	0, 87, 87, 87, 87, 87, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 39,
	23, 23, 0, 21, 21, 21, 21, 21,
	21, 120, 81, 81, 0, 0, 0, 75,
	17, 19, 0, 60, 60, 60, 60, 60,
	60, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 21, 0,
	0, 0, 72, 13, 15, 0, 9, 9,
	9, 9, 9, 9, 1, 0, 90, 90,
	90, 90, 90, 90, 0, 0, 0, 0,
	0, 87, 87, 87, 87, 87, 0, 0,
	0, 0, 0, 0, 0, 87, 87, 87,
	87, 87, 0, 0, 0, 0, 0, 0,
	0, 87, 87, 87, 87, 87, 0, 0,
	0, 0, 0, 0, 0, 87, 87, 87,
	87, 87, 0, 0, 0, 0, 0, 0,
	0, 87, 87, 87, 87, 87, 0, 0,
	0, 0, 0, 0, 0, 87, 87, 87,
	87, 87, 0, 0, 0, 0, 0, 0,
	0, 87, 87, 87, 87, 87, 0, 0,
	0, 0, 0, 0, 0, 87, 87, 87,
	87, 87, 0, 0, 0, 0, 0, 0,
	0, 87, 87, 87, 87, 87, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 39,
	23, 23, 0, 21, 21, 21, 21, 21,
	21, 120, 81, 81, 0, 0, 0, 140,
	140, 140, 140, 90, 90, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 0, 0, 0, 0, 0,
	39, 0, 96, 96, 96, 96, 96, 96,
	1, 0, 0, 0, 0, 0, 0, 0,
	23, 23, 0, 21, 21, 21, 21, 21,
	21, 81, 81, 0, 0, 0, 84, 84,
	84, 84, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	39, 0, 102, 102, 102, 102, 102, 102,
	1, 0, 39, 0, 99, 99, 99, 99,
	99, 99, 1, 0, 7, 7, 7, 7,
	7, 7, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 23, 23, 0, 21,
	21, 21, 21, 81, 81, 0, 0, 0,
	84, 84, 84, 84, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	0, 0, 75, 17, 19, 0, 5, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 23, 23, 0, 21, 21,
	21, 21, 21, 81, 81, 0, 0, 0,
	72, 13, 15, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 23, 23, 0, 21,
	21, 21, 21, 81, 81, 0, 0, 0,
	25, 25, 25, 25, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	39, 0, 39, 0, 0, 0, 0, 0,
	0, 0, 1, 0, 0, 0, 0, 0,
	0, 39, 0, 21, 21, 21, 21, 21,
	120, 0, 0, 0, 39, 0, 0, 0,
	0, 0, 0, 1, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 21, 21, 21, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 21, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 75, 17, 19, 0,
	5, 5, 5, 5, 5, 5, 0, 0,
	0, 0, 0, 0, 0, 0, 21, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 21,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 72, 13, 15, 0, 0, 0, 0,
	0, 0, 0, 0, 21, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 21, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 39, 23, 23, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 39,
	23, 23, 0, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 120, 81, 81, 0,
	0, 0, 75, 17, 19, 0, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 108,
	66, 66, 0, 72, 13, 15, 0, 39,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 42, 23, 23, 0, 25, 25,
	25, 25, 25, 25, 25, 25, 0, 25,
	128, 93, 93, 0, 25, 25, 25, 25,
	25, 25, 25, 25, 0, 25, 132, 93,
	93, 0, 21, 21, 21, 21, 21, 21,
	21, 21, 120, 81, 81, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 23, 23, 0, 21, 21, 21, 21,
	81, 81, 0, 0, 0, 25, 25, 25,
	25, 25, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 39, 23, 23, 0, 21,
	21, 21, 21, 21, 21, 120, 81, 81,
	0, 0, 0, 75, 17, 19, 0, 5,
	5, 5, 5, 5, 0, 72, 13, 15,
	0, 0, 0, 0, 0, 0, 1, 0,
	25, 25, 25, 25, 25, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 21, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 23, 23,
	0, 21, 21, 21, 21, 21, 81, 81,
	0, 0, 0, 0, 0, 0, 0, 23,
	23, 0, 21, 21, 21, 21, 81, 81,
	0, 0, 0, 153, 153, 153, 153, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 39, 23, 23, 0,
	21, 21, 21, 21, 21, 21, 21, 21,
	120, 81, 81, 0, 0, 0, 75, 17,
	19, 0, 116, 116, 116, 116, 0, 0,
	0, 0, 0, 0, 0, 0, 21, 21,
	21, 21, 21, 21, 0, 0, 0, 75,
	17, 19, 0, 63, 63, 63, 63, 112,
	112, 0, 0, 0, 0, 0, 0, 0,
	0, 11, 11, 39, 0, 21, 21, 21,
	21, 21, 21, 21, 78, 78, 120, 0,
	0, 0, 72, 13, 15, 0, 39, 0,
	33, 33, 33, 33, 1, 0, 0, 0,
	0, 0, 0, 23, 23, 23, 23, 0,
	21, 21, 21, 21, 21, 81, 81, 81,
	81, 0, 0, 0, 153, 153, 153, 153,
	0, 0, 0, 0, 0, 0, 0, 153,
	153, 153, 153, 0, 0, 0, 0, 0,
	0, 0, 153, 153, 153, 153, 0, 0,
	0, 0, 0, 0, 0, 153, 153, 153,
	153, 0, 0, 0, 0, 0, 0, 0,
	153, 153, 153, 153, 0, 0, 0, 0,
	0, 0, 0, 153, 153, 153, 153, 0,
	0, 0, 0, 0, 0, 0, 153, 153,
	153, 153, 0, 0, 0, 0, 0, 0,
	0, 153, 153, 153, 153, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 23, 23, 39, 23, 23, 0,
	21, 21, 21, 21, 21, 21, 21, 21,
	81, 81, 120, 81, 81, 0, 0, 0,
	31, 31, 31, 31, 0, 35, 35, 35,
	35, 1, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 21, 21, 21, 21, 21,
	21, 21, 0, 0, 0, 72, 13, 15,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 144, 0, 21, 21, 21, 21,
	148, 0, 0, 0, 37, 37, 37, 37,
	1, 0, 136, 136, 136, 136, 0, 0,
	0, 0, 0, 136, 136, 136, 136, 0,
	0, 0, 0, 0, 0, 0, 136, 136,
	136, 136, 0, 0, 0, 0, 0, 0,
	0, 136, 136, 136, 136, 0, 0, 0,
	0, 0, 0, 0, 136, 136, 136, 136,
	0, 0, 0, 0, 0, 0, 0, 136,
	136, 136, 136, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	39, 23, 23, 0, 21, 21, 21, 21,
	21, 21, 21, 21, 120, 81, 81, 0,
	0, 0, 158, 158, 158, 158, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 39, 23, 23, 0,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 120, 81, 81, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 21, 0,
	0, 0, 0, 0, 0, 0, 23, 23,
	0, 21, 21, 21, 21, 81, 81, 0,
	0, 0, 153, 153, 153, 153, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	23, 23, 0, 21, 21, 21, 21, 21,
	81, 81, 0, 0, 0, 136, 136, 136,
	136, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	136, 136, 136, 136, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 21, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 23, 23, 0, 21,
	21, 21, 21, 81, 81, 0, 0, 0,
	84, 84, 84, 84, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 75, 17, 19, 0, 57, 57, 57,
	57, 57, 57, 0, 0, 0, 0, 0,
	0, 0, 23, 23, 0, 21, 21, 21,
	21, 21, 21, 81, 81, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 23, 23, 0, 21, 21,
	21, 21, 21, 81, 81, 0, 0, 0,
	72, 13, 15, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 39, 0, 105, 105, 105, 105,
	105, 105, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 21, 21,
	21, 21, 21, 21, 0, 0, 0, 0,
	39, 0, 27, 27, 27, 27, 27, 27,
	0, 0, 1, 0, 0, 0, 0, 0,
	39, 0, 21, 21, 21, 21, 120, 0,
	0, 0, 54, 54, 54, 54, 54, 54,
	1, 0, 0, 39, 0, 27, 27, 27,
	27, 0, 0, 1, 0, 0, 0, 0,
	0, 39, 0, 21, 21, 21, 21, 120,
	0, 0, 0, 51, 51, 51, 51, 1,
	0, 29, 29, 29, 29, 1, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 21, 21, 21, 21,
	21, 0, 0, 0, 0, 0, 0, 0,
	39, 0, 21, 21, 21, 21, 120, 0,
	0, 0, 0, 0, 0, 0, 0, 1,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 72, 13, 15, 0, 25,
	25, 25, 25, 25, 0, 0, 0, 0,
	0, 25, 25, 25, 25, 25, 0, 0,
	0, 0, 0, 0, 0, 25, 25, 25,
	25, 25, 0, 0, 0, 0, 0, 0,
	0, 25, 25, 25, 25, 25, 0, 0,
	0, 0, 0, 0, 0, 25, 25, 25,
	25, 25, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 0, 0, 0, 25, 25, 25, 25,
	25, 0, 0, 0, 0, 0, 0, 0,
	25, 25, 25, 25, 25, 0, 0, 0,
	0, 0, 0, 0, 25, 25, 25, 25,
	25, 0, 0, 0, 0, 0, 0, 0,
	25, 25, 25, 25, 25, 0, 0, 0,
	0, 0, 0, 0, 25, 25, 25, 25,
	25, 0, 0, 0, 0, 0, 0, 0,
	25, 25, 25, 25, 25, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 25, 25, 25, 25, 25, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 21, 21, 21, 21,
	21, 21, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 23, 23, 0, 21, 21, 21, 21,
	21, 21, 81, 81, 0, 0, 0, 75,
	17, 19, 0, 5, 5, 5, 5, 5,
	0, 0, 0, 0, 0, 0, 0, 0,
	21, 21, 21, 21, 21, 21, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 21, 21,
	21, 21, 21, 0, 0, 0, 0, 0,
	0, 0, 23, 23, 0, 21, 21, 21,
	21, 81, 81, 0, 0, 0, 25, 25,
	25, 25, 25, 0, 0, 0, 0, 0,
	72, 13, 15, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 23, 23,
	0, 21, 21, 21, 21, 21, 81, 81,
	0, 0, 0, 25, 25, 25, 25, 25,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 21, 21, 21, 21,
	21, 21, 21, 21, 0, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 39, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 21, 7, 0,
	0
};

static const short _spss_commands_eof_trans[] = {
	3495, 3496, 3497, 3498, 3499, 3500, 3501, 3502,
	3503, 3504, 3505, 3506, 3507, 3508, 3509, 3510,
	3511, 3512, 3513, 3514, 3515, 3516, 3517, 3518,
	3519, 3520, 3521, 3522, 3523, 3524, 3525, 3526,
	3527, 3528, 3529, 3530, 3531, 3532, 3533, 3534,
	3535, 3536, 3537, 3538, 3539, 3540, 3541, 3542,
	3543, 3544, 3545, 3546, 3547, 3548, 3549, 3550,
	3551, 3552, 3553, 3554, 3555, 3556, 3557, 3558,
	3559, 3560, 3561, 3562, 3563, 3564, 3565, 3566,
	3567, 3568, 3569, 3570, 3571, 3572, 3573, 3574,
	3575, 3576, 3577, 3578, 3579, 3580, 3581, 3582,
	3583, 3584, 3585, 3586, 3587, 3588, 3589, 3590,
	3591, 3592, 3593, 3594, 3595, 3596, 3597, 3598,
	3599, 3600, 3601, 3602, 3603, 3604, 3605, 3606,
	3607, 3608, 3609, 3610, 3611, 3612, 3613, 3614,
	3615, 3616, 3617, 3618, 3619, 3620, 3621, 3622,
	3623, 3624, 3625, 3626, 3627, 3628, 3629, 3630,
	3631, 3632, 3633, 3634, 3635, 3636, 3637, 3638,
	3639, 3640, 3641, 3642, 3643, 3644, 3645, 3646,
	3647, 3648, 3649, 3650, 3651, 3652, 3653, 3654,
	3655, 3656, 3657, 3658, 3659, 3660, 3661, 3662,
	3663, 3664, 3665, 3666, 3667, 3668, 3669, 3670,
	3671, 3672, 3673, 3674, 3675, 3676, 3677, 3678,
	3679, 3680, 3681, 3682, 3683, 3684, 3685, 3686,
	3687, 3688, 3689, 3690, 3691, 3692, 3693, 3694,
	3695, 3696, 3697, 3698, 3699, 3700, 3701, 3702,
	3703, 3704, 3705, 3706, 3707, 3708, 3709, 3710,
	3711, 3712, 3713, 3714, 3715, 3716, 3717, 3718,
	3719, 3720, 3721, 3722, 3723, 3724, 3725, 3726,
	3727, 3728, 3729, 3730, 3731, 3732, 3733, 3734,
	3735, 3736, 3737, 3738, 3739, 3740, 3741, 3742,
	3743, 3744, 3745, 3746, 3747, 3748, 3749, 3750,
	3751, 3752, 3753, 3754, 3755, 3756, 3757, 3758,
	3759, 3760, 3761, 3762, 3763, 3764, 3765, 3766,
	3767, 3768, 3769, 3770, 3771, 3772, 3773, 3774,
	3775, 3776, 3777, 3778, 3779, 3780, 3781, 3782,
	3783, 3784, 3785, 3786, 3787, 3788, 3789, 3790,
	3791, 3792, 3793, 3794, 3795, 3796, 3797, 3798,
	3799, 3800, 3801, 3802, 3803, 3804, 3805, 3806,
	3807, 3808, 3809, 3810, 3811, 3812, 3813, 3814,
	3815, 3816, 3817, 3818, 3819, 3820, 3821, 3822,
	3823, 3824, 3825, 3826, 3827, 3828, 3829, 3830,
	3831, 3832, 3833, 3834, 3835, 3836, 3837, 3838,
	3839, 3840, 3841, 3842, 3843, 3844, 3845, 3846,
	3847, 3848, 3849, 3850, 3851, 3852, 3853, 3854,
	3855, 3856, 3857, 3858, 3859, 3860, 3861, 3862,
	3863, 3864, 3865, 3866, 3867, 3868, 3869, 3870,
	3871, 3872, 3873, 3874, 3875, 3876, 3877, 3878,
	3879, 3880, 3881, 3882, 3883, 3884, 3885, 3886,
	3887, 3888, 3889, 3890, 3891, 3892, 3893, 3894,
	3895, 3896, 3897, 3898, 3899, 3900, 3901, 3902,
	3903, 3904, 3905, 3906, 3907, 3908, 3909, 3910,
	3911, 3912, 3913, 3914, 3915, 3916, 3917, 3918,
	3919, 3920, 3921, 3922, 3923, 3924, 3925, 3926,
	3927, 3928, 3929, 3930, 3931, 3932, 3933, 3934,
	3935, 3936, 3937, 3938, 3939, 3940, 3941, 3942,
	3943, 3944, 3945, 3946, 3947, 3948, 3949, 3950,
	3951, 3952, 3953, 3954, 3955, 3956, 3957, 3958,
	3959, 3960, 3961, 3962, 3963, 3964, 3965, 3966,
	3967, 3968, 3969, 3970, 3971, 3972, 3973, 3974,
	3975, 3976, 3977, 3978, 3979, 3980, 3981, 3982,
	3983, 3984, 3985, 3986, 3987, 3988, 3989, 3990,
	3991, 3992, 3993, 3994, 3995, 3996, 3997, 3998,
	3999, 4000, 4001, 4002, 4003, 4004, 4005, 4006,
	4007, 4008, 4009, 4010, 4011, 4012, 4013, 4014,
	4015, 4016, 4017, 4018, 4019, 4020, 4021, 4022,
	4023, 4024, 4025, 4026, 4027, 4028, 4029, 4030,
	4031, 4032, 4033, 4034, 4035, 4036, 4037, 4038,
	4039, 4040, 4041, 4042, 4043, 4044, 4045, 4046,
	4047, 4048, 4049, 4050, 4051, 4052, 4053, 4054,
	4055, 4056, 4057, 4058, 4059, 4060, 4061, 4062,
	4063, 4064, 4065, 4066, 4067, 4068, 4069, 4070,
	4071, 4072, 4073, 4074, 4075, 4076, 4077, 4078,
	4079, 4080, 4081, 4082, 4083, 4084, 4085, 4086,
	4087, 4088, 4089, 4090, 4091, 4092, 4093, 4094,
	4095, 4096, 4097, 4098, 4099, 4100, 4101, 4102,
	4103, 4104, 4105, 4106, 4107, 4108, 4109, 4110,
	4111, 4112, 4113, 4114, 4115, 4116, 4117, 4118,
	4119, 4120, 4121, 4122, 4123, 4124, 4125, 4126,
	4127, 4128, 4129, 4130, 4131, 4132, 4133, 4134,
	4135, 4136, 4137, 4138, 4139, 4140, 4141, 4142,
	4143, 4144, 0
};

static const int spss_commands_start = 646;

static const int spss_commands_en_main = 646;


#line 14 "src/txt/readstat_spss_commands_read.rl"


readstat_schema_t *readstat_parse_spss_commands(readstat_parser_t *parser,
const char *filepath, void *user_ctx, readstat_error_t *outError) {
	if (parser->io->open(filepath, parser->io->io_ctx) == -1) {
		if (outError)
			*outError = READSTAT_ERROR_OPEN;
		return NULL;
	}
	readstat_schema_t *schema = NULL;
	unsigned char *bytes = NULL;
	readstat_error_t error = READSTAT_OK;
	ssize_t len = parser->io->seek(0, READSTAT_SEEK_END, parser->io->io_ctx);
	if (len == -1) {
		error = READSTAT_ERROR_SEEK;
		goto cleanup;
	}
	parser->io->seek(0, READSTAT_SEEK_SET, parser->io->io_ctx);
	
	bytes = malloc(len);
	
	parser->io->read(bytes, len, parser->io->io_ctx);
	
	unsigned char *p = bytes;
	unsigned char *pe = bytes + len;
	
	unsigned char *eof = pe;
	
	unsigned char *str_start = NULL;
	
	size_t str_len = 0;
	
	int cs;
	
	int i;
	int line_no = 0;
	uint64_t first_integer = 0, integer = 0;
	double double_value = NAN;
	unsigned char *line_start = p;
	
	char varname[32];
	char argname[32];
	char string_value[32];
	char buf[1024];
	
	char var_list[1024][32];
	
	long var_col = 0;
	long var_row = 0;
	long var_len = 0;
	long var_count = 0;
	readstat_type_t var_type = READSTAT_TYPE_DOUBLE;
	label_type_t label_type = LABEL_TYPE_DOUBLE;
	
	int labelset_count = 0;
	
	if ((schema = calloc(1, sizeof(readstat_schema_t))) == NULL) {
		error = READSTAT_ERROR_MALLOC;
		goto cleanup;
	}
	
	schema->rows_per_observation = 1;
	
	
#line 1989 "src/txt/readstat_spss_commands_read.c"
	{
		cs = (int)spss_commands_start;
	}
	
#line 1994 "src/txt/readstat_spss_commands_read.c"
	{
		int _klen;
		unsigned int _trans = 0;
		const char * _keys;
		const signed char * _acts;
		unsigned int _nacts;
		_resume: {}
		if ( p == pe && p != eof )
			goto _out;
		if ( p == eof ) {
			if ( _spss_commands_eof_trans[cs] > 0 ) {
				_trans = (unsigned int)_spss_commands_eof_trans[cs] - 1;
			}
		}
		else {
			_keys = ( _spss_commands_trans_keys + (_spss_commands_key_offsets[cs]));
			_trans = (unsigned int)_spss_commands_index_offsets[cs];
			
			_klen = (int)_spss_commands_single_lengths[cs];
			if ( _klen > 0 ) {
				const char *_lower = _keys;
				const char *_upper = _keys + _klen - 1;
				const char *_mid;
				while ( 1 ) {
					if ( _upper < _lower ) {
						_keys += _klen;
						_trans += (unsigned int)_klen;
						break;
					}
					
					_mid = _lower + ((_upper-_lower) >> 1);
					if ( ( (*( p))) < (*( _mid)) )
						_upper = _mid - 1;
					else if ( ( (*( p))) > (*( _mid)) )
						_lower = _mid + 1;
					else {
						_trans += (unsigned int)(_mid - _keys);
						goto _match;
					}
				}
			}
			
			_klen = (int)_spss_commands_range_lengths[cs];
			if ( _klen > 0 ) {
				const char *_lower = _keys;
				const char *_upper = _keys + (_klen<<1) - 2;
				const char *_mid;
				while ( 1 ) {
					if ( _upper < _lower ) {
						_trans += (unsigned int)_klen;
						break;
					}
					
					_mid = _lower + (((_upper-_lower) >> 1) & ~1);
					if ( ( (*( p))) < (*( _mid)) )
						_upper = _mid - 2;
					else if ( ( (*( p))) > (*( _mid + 1)) )
						_lower = _mid + 2;
					else {
						_trans += (unsigned int)((_mid - _keys)>>1);
						break;
					}
				}
			}
			
			_match: {}
		}
		cs = (int)_spss_commands_cond_targs[_trans];
		
		if ( _spss_commands_cond_actions[_trans] != 0 ) {
			
			_acts = ( _spss_commands_actions + (_spss_commands_cond_actions[_trans]));
			_nacts = (unsigned int)(*( _acts));
			_acts += 1;
			while ( _nacts > 0 ) {
				switch ( (*( _acts)) )
				{
					case 0:  {
						{
#line 78 "src/txt/readstat_spss_commands_read.rl"
							
							integer = 0;
						}
						
#line 2079 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 1:  {
						{
#line 82 "src/txt/readstat_spss_commands_read.rl"
							
							integer = 10 * integer + ((( (*( p)))) - '0');
						}
						
#line 2090 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 2:  {
						{
#line 86 "src/txt/readstat_spss_commands_read.rl"
							
							var_col = integer - 1;
							var_len = 1;
						}
						
#line 2102 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 3:  {
						{
#line 91 "src/txt/readstat_spss_commands_read.rl"
							
							var_len = integer - var_col;
						}
						
#line 2113 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 4:  {
						{
#line 95 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_copy_quoted(buf, sizeof(buf), (char *)str_start, str_len);
						}
						
#line 2124 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 5:  {
						{
#line 99 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_copy_quoted(string_value, sizeof(string_value), (char *)str_start, str_len);
						}
						
#line 2135 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 6:  {
						{
#line 107 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_copy(varname, sizeof(varname), (char *)str_start, str_len);
						}
						
#line 2146 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 7:  {
						{
#line 111 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_copy(argname, sizeof(argname), (char *)str_start, str_len);
						}
						
#line 2157 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 8:  {
						{
#line 115 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_schema_entry_t *entry = readstat_schema_find_or_create_entry(schema, varname);
							entry->variable.type = var_type;
							entry->variable.storage_width = var_len;
							entry->row = var_row;
							entry->col = var_col;
							entry->len = var_len;
						}
						
#line 2173 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 9:  {
						{
#line 124 "src/txt/readstat_spss_commands_read.rl"
							
							readstat_schema_entry_t *entry = readstat_schema_find_or_create_entry(schema, varname);
							readstat_copy(entry->variable.label, sizeof(entry->variable.label), buf, sizeof(buf));
						}
						
#line 2185 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 10:  {
						{
#line 129 "src/txt/readstat_spss_commands_read.rl"
							
							var_count = 0;
						}
						
#line 2196 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 11:  {
						{
#line 133 "src/txt/readstat_spss_commands_read.rl"
							
							if (var_count < sizeof(var_list)/sizeof(var_list[0])) {
								memcpy(var_list[var_count++], varname, sizeof(varname));
							}
						}
						
#line 2209 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 12:  {
						{
#line 139 "src/txt/readstat_spss_commands_read.rl"
							
							if (strcasecmp(argname, "FIRSTCASE") == 0) {
								schema->first_line = integer;
							}
							if (strcasecmp(argname, "DELIMITERS") == 0) {
								schema->field_delimiter = buf[0];
							}
						}
						
#line 2225 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 13:  {
						{
#line 148 "src/txt/readstat_spss_commands_read.rl"
							
							char labelset_name[256];
							snprintf(labelset_name, sizeof(labelset_name), "labels%d", labelset_count++);
							for (i=0; i<var_count; i++) {
								readstat_schema_entry_t *entry = readstat_schema_find_or_create_entry(schema, varname);
								readstat_copy(entry->labelset, sizeof(entry->labelset), labelset_name, sizeof(labelset_name));
							}
						}
						
#line 2241 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 14:  {
						{
#line 157 "src/txt/readstat_spss_commands_read.rl"
							
							char labelset_name[256];
							snprintf(labelset_name, sizeof(labelset_name), "labels%d", labelset_count);
							error = submit_value_label(parser, labelset_name, label_type,
							first_integer, integer, double_value, string_value, buf, user_ctx);
							if (error != READSTAT_OK)
							goto cleanup;
						}
						
#line 2257 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 15:  {
						{
#line 166 "src/txt/readstat_spss_commands_read.rl"
							str_start = p; }
						
#line 2266 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 16:  {
						{
#line 166 "src/txt/readstat_spss_commands_read.rl"
							str_len = p - str_start; }
						
#line 2275 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 17:  {
						{
#line 168 "src/txt/readstat_spss_commands_read.rl"
							str_start = p; }
						
#line 2284 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 18:  {
						{
#line 168 "src/txt/readstat_spss_commands_read.rl"
							str_len = p - str_start; }
						
#line 2293 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 19:  {
						{
#line 172 "src/txt/readstat_spss_commands_read.rl"
							line_no++; line_start = p; }
						
#line 2302 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 20:  {
						{
#line 174 "src/txt/readstat_spss_commands_read.rl"
							str_start = p; }
						
#line 2311 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 21:  {
						{
#line 174 "src/txt/readstat_spss_commands_read.rl"
							str_len = p - str_start; }
						
#line 2320 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 22:  {
						{
#line 192 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_STRING; }
						
#line 2329 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 23:  {
						{
#line 195 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_STRING; }
						
#line 2338 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 24:  {
						{
#line 196 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_DOUBLE; }
						
#line 2347 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 25:  {
						{
#line 197 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_DOUBLE; }
						
#line 2356 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 26:  {
						{
#line 198 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_STRING; }
						
#line 2365 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 27:  {
						{
#line 219 "src/txt/readstat_spss_commands_read.rl"
							var_row = integer - 1; }
						
#line 2374 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 28:  {
						{
#line 220 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_DOUBLE; }
						
#line 2383 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 29:  {
						{
#line 221 "src/txt/readstat_spss_commands_read.rl"
							var_type = READSTAT_TYPE_DOUBLE; }
						
#line 2392 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 30:  {
						{
#line 254 "src/txt/readstat_spss_commands_read.rl"
							label_type = -1; }
						
#line 2401 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 31:  {
						{
#line 260 "src/txt/readstat_spss_commands_read.rl"
							label_type = LABEL_TYPE_DOUBLE; double_value = -(double)integer; }
						
#line 2410 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 32:  {
						{
#line 261 "src/txt/readstat_spss_commands_read.rl"
							label_type = LABEL_TYPE_DOUBLE; double_value = integer; }
						
#line 2419 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 33:  {
						{
#line 262 "src/txt/readstat_spss_commands_read.rl"
							first_integer = integer; }
						
#line 2428 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 34:  {
						{
#line 262 "src/txt/readstat_spss_commands_read.rl"
							label_type = LABEL_TYPE_RANGE; }
						
#line 2437 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
					case 35:  {
						{
#line 263 "src/txt/readstat_spss_commands_read.rl"
							label_type = LABEL_TYPE_STRING; }
						
#line 2446 "src/txt/readstat_spss_commands_read.c"
						
						break; 
					}
				}
				_nacts -= 1;
				_acts += 1;
			}
			
		}
		
		if ( p == eof ) {
			if ( cs >= 646 )
				goto _out;
		}
		else {
			if ( cs != 0 ) {
				p += 1;
				goto _resume;
			}
		}
		_out: {}
	}
	
#line 313 "src/txt/readstat_spss_commands_read.rl"
	
	
	/* suppress warnings */
	(void)spss_commands_en_main;
	
	if (cs < 
#line 2477 "src/txt/readstat_spss_commands_read.c"
	646
#line 318 "src/txt/readstat_spss_commands_read.rl"
	) {
		char error_buf[1024];
		if (p == pe) {
			snprintf(error_buf, sizeof(error_buf), "Error parsing SPSS command file (end-of-file unexpectedly reached)");
		} else {
			snprintf(error_buf, sizeof(error_buf), "Error parsing SPSS command file around line #%d, col #%ld (%c)",
			line_no + 1, (long)(p - line_start + 1), *p);
		}
		if (parser->handlers.error) {
			parser->handlers.error(error_buf, user_ctx);
		}
		error = READSTAT_ERROR_PARSE;
		goto cleanup;
	}
	
	error = submit_columns(parser, schema, user_ctx);
	
	cleanup:
	parser->io->close(parser->io->io_ctx);
	free(bytes);
	if (error != READSTAT_OK) {
		if (outError)
			*outError = error;
		readstat_schema_free(schema);
		schema = NULL;
	}
	
	return schema;
}
