/*
 *	recite - english text speech synthesizer
 *	Copyright (C) 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: interface definition for klatt/parwave.c
 */

#ifndef PARWAVE_H
#define PARWAVE_H

#include <main.h>

#define SAMP_RATE 8000 /* samples/second */
#define N_MSEC_FRAME 10 /* ms/frame */
#define NSAMP_PER_FRAME (SAMP_RATE * N_MSEC_FRAME / 1000)

typedef struct pars_ty pars_ty;
struct pars_ty
{
	short	F0hz10;	/* 0 */
	short	AVdb;	/* 1 */
	short	F1hz;	/* 2 */
	short	B1hz;	/* 3 */
	short	F2hz;	/* 4 */
	short	B2hz;	/* 5 */
	short	F3hz;	/* 6 */
	short	B3hz;	/* 7 */
	short	F4hz;	/* 8 */
	short	B4hz;	/* 9 */
	short	F5hz;	/* 10 */
	short	B5hz;	/* 11 */
	short	F6hz;	/* 12 */
	short	B6hz;	/* 13 */
	short	FNZhz;	/* 14 */
	short	BNZhz;	/* 15 */
	short	FNPhz;	/* 16 */
	short	BNPhz;	/* 17 */
	short	AP;	/* 18 */
	short	Kopen;	/* 19 */
	short	Aturb;	/* 20 */
	short	TLTdb;	/* 21 */
	short	AF;	/* 22 */
	short	Kskew;	/* 23 */
	short	A1;	/* 24 */
	short	B1phz;	/* 25 */
	short	A2;	/* 26 */
	short	B2phz;	/* 27 */
	short	A3;	/* 28 */
	short	B3phz;	/* 29 */
	short	A4;	/* 30 */
	short	B4phz;	/* 31 */
	short	A5;	/* 32 */
	short	B5phz;	/* 33 */
	short	A6;	/* 34 */
	short	B6phz;	/* 35 */
	short	ANP;	/* 36 */
	short	AB;	/* 37 */
	short	AVpdb;	/* 38 */
	short	Gain0;	/* 39 */
};

typedef struct spkrdef_ty spkrdef_ty;
struct spkrdef_ty
{
	long	OUTs;	/* 0 */
	long	Srat;	/* 1 */
	long	NSfr;	/* 2 */
	long	Flp;	/* 3 */
	long	BWlp;	/* 4 */
	long	NFca;	/* 6 */
	long	VSsw;	/* 7 */
};

/* spkrdef.VSsw choices */
#define IMPULSIVE 1
#define NATURAL 2

extern spkrdef_ty spkrdef;

void parwav _((pars_ty *, short *));

#endif /* PARWAVE_H */
