#!/usr/bin/python
# -*-coding: UTF-8 -*-
# bbou@ac-toulouse.fr
# GPL license
# 2005-08-09 19:07:41 
# users.py

import pygtk
pygtk.require("2.0")
from gtk import *
import gtk.glade
import string
import re
import stat

import runner

import warnings
#warnings.filterwarnings(action='ignore',category='libglade-WARNING',message='unknown property',module='_main_')

#######################################################################
#	GLOBALS
#######################################################################

sysSetting={
	'getUsers':"getent passwd | grep -v '^$' | sort",
	'getGroups':"getent group | grep -v '^$' | sort",
	'getGroupMap':'net groupmap list',
	'docs':{'default':'file:///usr/share/doc/sadms-%s/%s',
		'redhat':'file:///usr/share/doc/sadms-%s/%s',
		'debian':'file:///usr/share/doc/sadms/%s',
		'suse':'file:///usr/share/doc/packages/sadms/%s',
		'mandriva':'file:///usr/share/doc/sadms-%s/%s'},
	'browser':{'default':'/usr/bin/firefox',
		'redhat':'/usr/bin/firefox',
		'debian':'/usr/bin/firefox',
		'suse':'/usr/bin/firefox',
		'mandriva':'/usr/bin/mozilla-firefox'},

	'getHomes':"find %HOME% -maxdepth 1 -mindepth 1 -type d -exec stat -c '%n:%U:%G:%A;' {} \; | sort 2> /dev/null",
	'getUserGroups':'id -G -n %USER%',
	'mkdir':'mkdir -p "%FSOBJECT%"',
	'rmdir':'rm -fR "%FSOBJECT%"',
	'chown':'chown -R "%USER%" "%FSOBJECT%"',
	'chgrp':'chgrp -R "%GROUP%" "%FSOBJECT%"',
	'chmod':'chmod u=%UMODE%,g=%GMODE%,o=%OMODE% "%FSOBJECT%"',
	'isDirectory':'sh -c \'if [ -d "%FSOBJECT%" ]; then echo true; else echo false; fi\'',
	'exists':'sh -c \'if [ -e "%FSOBJECT%" ]; then echo true; else echo false; fi\'',
	'getVersion':'cat version | head -n 1',
	'getDistribution':'sh -c \'if [ -f /etc/debian_version ]; then echo "debian"; else if [ -f /etc/SuSE-release ]; then echo "suse"; else if [ -e /etc/mandrake-release -o -e /etc/mandriva-release ]; then echo "mandriva"; else if [ -e /etc/redhat-release ]; then echo "redhat"; else echo "default"; fi; fi; fi; fi\'',
}

setting={
	'usersFilter':'int(u[2])>=500',
	'usersNotFilter':'u[0].find("HOST")!=-1 or u[0].find("$")!=-1',
	'groupsFilter':'int(g[2])>=10000',
	'groupsNotFilter':'g[0].find("BUILTIN")!=-1',
}

#######################################################################
#	LISTVIEWS
#######################################################################

class ListView:
	
	def __init__(self,listview):

		self.listview=listview
		return

	def setup(self,columns):	

		types=[t[1] for t in columns]

		# model
		self.model=ListStore(*types)
		self.listview.set_model(self.model)

		# columns
		for rank,datatype,header,expand in columns:
			column=gtk.TreeViewColumn(header)
			if datatype==str:
				column.set_sort_column_id(rank)
				column.connect('clicked',self.columnClicked,self.listview)
				cell=gtk.CellRendererText()
				attr='text'
			if datatype==int:
				column.set_sort_column_id(rank)
				column.connect('clicked',self.columnClicked,self.listview)
				cell=gtk.CellRendererText()
				attr='text'
			elif datatype==bool:
				cell=gtk.CellRendererToggle()
				cell.set_property('activatable',True)
				cell.connect('toggled',self.toggle_acl_callback,(rank))
				attr='active'
			elif datatype==gtk.gdk.Pixbuf:
				cell=gtk.CellRendererPixbuf()
				attr='pixbuf'
			else:
				cell=gtk.CellRendererText()
				attr='text'	
			column.pack_start(cell,expand)
			column.add_attribute(cell,attr,rank)
			column.set_cell_data_func(cell,self.render)
			self.listview.append_column(column)

		# header
		self.listview.set_headers_visible(True)
		self.listview.set_headers_clickable(True)
		
		# selection
		self.listview.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
		return

	def setupImages(self,imageFile):
		pixbufs=[]
		for i in range(len(imageFile)):
        		pixbufs.append(gtk.gdk.pixbuf_new_from_file('pixmaps/'+imageFile[i]))
		return pixbufs

	# render callback
	def render(self,column,cell,model,i):
		r=model.get_path(i)
		toggle=r[0] % 2 == 0
		if toggle:
			cell.set_property('cell-background','lightGray')
		else:
			cell.set_property('cell-background','white')
		return

	# toggle callback
	def toggle_acl_callback(self,cell,r,(c)):
		#print "path=%s,%s" % (r,c)
		self.model[r][c]=not self.model[r][c]
		return       
	
	# click column call back
	def columnClicked(self,c,data):	
		pass

	def clear(self):
		self.model.clear()
		return
	
	def getSelection(self):
		selection=self.listview.get_selection()
		(model,pathlist)=selection.get_selected_rows()
		return [model.get_value(model.get_iter(path),ListView.TEXT) for path in pathlist]

	def setupImages(self,imageFile):
		pixbufs=[]
		for i in range(len(imageFile)):
        		pixbufs.append(gtk.gdk.pixbuf_new_from_file('pixmaps/'+imageFile[i]))
		return pixbufs

class UsersView(ListView):

	SELECT=0
	IMAGE=1
	USER=2
	UID=3
	GID=4
	HOME=5
	GECOS=6
	MEMBEROF=7

	pixbufs=[]

	columns=(
		[SELECT,bool,'',False],
		[IMAGE,gtk.gdk.Pixbuf,'',False],
		[USER,str,'user',True],
		[UID,int,'uid',True],
		[GID,int,'gid',True],
		[HOME,str,'home',True],
		[GECOS,str,'gecos',True],
		[MEMBEROF,str,'group',True]
		)

	def __init__(self,listview):
		ListView.__init__(self,listview)
		self.setup(UsersView.columns)
	
		# images
		if UsersView.pixbufs==[]:
			UsersView.pixbufs=self.setupImages(['user.png','user-hidden.png'])
		return

	def getPixbuf(self,index):
		return UsersView.pixbufs[index]

	def set(self,items):
		for i in items:
			login,password,uid,gid,gecos,home,shell=i
			self.model.append([False,self.getPixbuf(0),login,int(uid),int(gid),home,gecos,''])
		return
	
	def setMemberOf(self,index,memberOf):
		self.model[index][UsersView.MEMBEROF]=memberOf
		return
	
class GroupsView(ListView):

	IMAGE=0
	GROUP=1
	GID=2
	MEMBERS=3

	pixbufs=[]

	columns=(
		[IMAGE,gtk.gdk.Pixbuf,'',False],
		[GROUP,str,'groups',True],
		[GID,int,'gid',True],
		[MEMBERS,str,'members',True]
		)

	def __init__(self,listview):
		ListView.__init__(self,listview)
		self.setup(GroupsView.columns)

		# images
		if GroupsView.pixbufs==[]:
			GroupsView.pixbufs=self.setupImages(['group.png','group-hidden.png'])
		return
	
	def getPixbuf(self,index):
		return GroupsView.pixbufs[index]

	def set(self,items):
		for i in items:
			group,password,gid,members=i
			self.model.append([self.getPixbuf(0),group,int(gid),members])
		return
	
class HomesView(ListView):

	IMAGE=0
	HOME=1
	OWNER=2
	GROUP=3
	UPERMS=4
	GPERMS=5
	OPERMS=6

	pixbufs=[]

	columns=(
		[IMAGE,gtk.gdk.Pixbuf,'',False],
		[HOME,str,'home',True],
		[OWNER,str,'owner',True],
		[GROUP,str,'group',True],
		[UPERMS,str,'u',True],
		[GPERMS,str,'g',True],
		[OPERMS,str,'o',True]
		)

	def __init__(self,listview):
		ListView.__init__(self,listview)
		self.setup(HomesView.columns)
	
		# images
		if HomesView.pixbufs==[]:
			HomesView.pixbufs=self.setupImages(['home.png'])
		return

	def getPixbuf(self,index):
		return HomesView.pixbufs[index]

	def set(self,items):
		for i in items:
			home,owner,group,uperms,gperms,operms=i
			self.model.append([self.getPixbuf(0),home,owner,group,uperms,gperms,operms])
		return
	
	def get(self):
		return [s[HomesView.TEXT] for s in self.model]
	
class SubjectChooser:

	IMAGE=0
	TEXT=1

	USER=0
	GROUP=1

	pixbufs=[]

	def __init__(self,dialog,listview):
		self.dialog=dialog
		self.listview=listview
		
		# header
		self.listview.set_headers_visible(False)

		# selection
		self.listview.get_selection().set_mode(gtk.SELECTION_SINGLE)

		# model
		self.model=ListStore(gtk.gdk.Pixbuf,str)
		self.listview.set_model(self.model)

		# columns
		column=gtk.TreeViewColumn('')
		cell=gtk.CellRendererPixbuf()
		column.pack_start(cell,True)
		column.add_attribute(cell,'pixbuf',SubjectChooser.IMAGE)
		self.listview.append_column(column)

		column=gtk.TreeViewColumn('subject')
		cell=gtk.CellRendererText()
		column.pack_start(cell,True)
		column.add_attribute(cell,'text',SubjectChooser.TEXT)
		self.listview.append_column(column)

		# images
		if SubjectChooser.pixbufs==[]:
			SubjectChooser.pixbufs=self.setupImages()
                return
        
	def setupImages(self):
		imageFile=['user-hidden.png','group-hidden.png']
		pixbufs=[]
		for i in range(len(imageFile)):
        		pixbufs.append(gtk.gdk.pixbuf_new_from_file('pixmaps/'+imageFile[i]))
		return pixbufs

	def set(self,subjects,subjecttype):
		self.model.clear()
		for i in subjects:
			self.model.append([SubjectChooser.pixbufs[subjecttype],i])
		return

	def getSelection(self):
		selection=self.listview.get_selection()
		(model,pathlist)=selection.get_selected_rows()
		return [model[model.get_iter(path)][SubjectChooser.TEXT] for path in pathlist]

	# wrappers 
	
	def run(self):
		return self.dialog.run()

	def hide(self):
		self.dialog.hide()
		return

#######################################################################
#	USERMANAGER
#######################################################################

class UserManager:
	
	def __init__(self):
	
		handlers={
			'on_destroy':			self.exit,
			'on_ok_clicked':		self.exit,
			'on_cancel_clicked':		self.exit,

			'on_about_activate':		self.about,
			'on_help_clicked':		self.help,

			'on_browseHomedir_clicked':	self.browseHomedir,
			'on_usersFilter_clicked':	self.usersFilter,
			'on_usersMemberOf_clicked':	self.usersMemberOf,
			'on_groupsFilter_clicked':	self.groupsFilter,
			'on_refreshUsers_clicked':	self.forceRefreshUsers,
			'on_refreshGroups_clicked':	self.forceRefreshGroups,
			'on_refreshHomes_clicked':	self.forceRefreshHomes,

			'on_makeHomes_clicked':		self.makeHomes,
			'on_deleteHomes_clicked':	self.deleteHomes,
			'on_resetHomes_clicked':	self.resetHomes,
			'on_groupMap_clicked':		self.groupMap,
		}

		self.runner=runner.GtkRunner();

		self.widgets=gtk.glade.XML('users.glade')
		self.widgets.signal_autoconnect(handlers)
		self.dialog=self['users']

		self.usersView=UsersView(self['usersView'])
		self.groupsView=GroupsView(self['groupsView'])
		self.homesView=HomesView(self['homesView'])
		self.subjectChooser=SubjectChooser(self['subjectDialog'],self['subjectDialogView'])
				
		self.forAllUsers=self['forAllUsersRadio']
		self.forSelectedUsers=self['forSelectedUsersRadio']
		self.forSelectedHomes=self['forSelectedHomesRadio']

		self.filterEntry=self['filterEntry']
		self.notFilterEntry=self['notFilterEntry']

		self.homeDirEntry=self['homeDirEntry']

		self.filterDialog=self['filterDialog']
		self.permsDialog=self['permsDialog']
		self.aboutDialog=self['aboutDialog']
		return

	# widget access

	def __getitem__(self, key):
        	return self.widgets.get_widget(key)

	# termination

	def exit(self,*options):
		if __name__ == "__main__":
			gtk.main_quit()
		else:
			self.dialog.destroy()	
		return
				
	# refresh

	def forceRefreshUsers(self,*options):
		self.refreshUsers()
		return

	def forceRefreshGroups(self,*options):
		self.refreshGroups()
		return

	def forceRefreshHomes(self,*options):
		self.refreshHomes()
		return

	def refresh(self):
		self.refreshUsers()
		self.refreshGroups()
		self.refreshHomes()
		return	

	def refreshUsers(self):
		self.usersView.clear()
		users=self.getUsers()
		self.usersView.set(users)
		return

	def refreshGroups(self):
		self.groupsView.clear()
		groups=self.getGroups()
		self.groupsView.set(groups)
		return	

	def refreshHomes(self):
		self.homesView.clear()
		homes=self.getHomes()
		self.homesView.set(homes)
		return	

	def usersMemberOf(self,*options):
		for i in range(0,len(self.usersView.model)): 
			user=self.usersView.model[i][UsersView.USER]
			cl=sysSetting['getUserGroups']
			cl=cl.replace('%USER%',user)
			status,output=self.runToString(cl)
			if status:
				output=output.strip('\n\r ')
			else:
				output='?'
			self.usersView.setMemberOf(i,output)
		return

	# filter

	def usersFilter(self,*options):
		self.filterEntry.set_text(setting['usersFilter'])
		self.notFilterEntry.set_text(setting['usersNotFilter'])
		response=self.filterDialog.run()
		self.filterDialog.hide()
		if response!=gtk.RESPONSE_OK:
			return
		f=self.filterEntry.get_text()
		nf=self.notFilterEntry.get_text()
		try:
			u=['dummy','x','499','499','Dummy','/home/dummy','/bin/false','some groups']
			eval(f)
			eval(nf)
		except:
			return
		setting['usersFilter']=f
		setting['usersNotFilter']=nf
		self.refreshUsers()
		self.refreshHomes()
		return

	def groupsFilter(self,*options):
		self.filterEntry.set_text(setting['groupsFilter'])
		self.notFilterEntry.set_text(setting['groupsNotFilter'])
		response=self.filterDialog.run()
		self.filterDialog.hide()
		if response!=gtk.RESPONSE_OK:
			return
		setting['groupsFilter']=self.filterEntry.get_text()
		setting['groupsNotFilter']=self.notFilterEntry.get_text()
		self.refreshGroups()
		return

	# home
	
	def makeHomes(self,*options):
		homes=self.getHomeSelection()
		homeDir=self.homeDirEntry.get_text()
		umode,gmode,omode=self.getMode()
		if (umode,gmode,omode)==(None,None,None):
			return
		group=self.getGroup()
		if group==None:
			return

		for item in homes:
			home=homeDir+'/'+item
			#print home
			if self.exists(home):
				continue
			self.mkdir(home)
			if not self.exists(home):
				continue
			self.chown(home,item,group)
			self.chmod(home,umode,gmode,omode)
		self.refreshHomes()
		return

	def deleteHomes(self,*options):
		homes=self.getHomeSelection()
		homeDir=self.homeDirEntry.get_text()
		for item in homes:
			home=homeDir+'/'+item
			if not self.exists(home):
				continue
			self.rmdir(home)
		self.refreshHomes()
		return

	def resetHomes(self,*options):
		homes=self.getHomeSelection()
		homeDir=self.homeDirEntry.get_text()
		umode,gmode,omode=self.getMode()
		if (umode,gmode,omode)==(None,None,None):
			return
		group=self.getGroup()
		if group==None:
			return
		for item in homes:
			home=homeDir+'/'+item
			#print home
			if not self.exists(home):
				continue
			self.chown(home,item,group)
			self.chmod(home,umode,gmode,omode)
		self.refreshHomes()
		return

	def normalizeHome(self,home):
		index=home.rfind('/')
		if index!=-1:
			home=home[index+1:]
		return home

	def getHomeSelection(self):
		if self.forAllUsers.get_active():
			homes=[u[UsersView.USER] for u in self.usersView.model]
		elif self.forSelectedUsers.get_active():
			homes=[u[UsersView.USER] for u in self.usersView.model if u[UsersView.SELECT]]
		elif self.forSelectedHomes.get_active():
			(model,pathlist)=self.homesView.listview.get_selection().get_selected_rows()
			homes=[model[model.get_iter(path)][HomesView.HOME] for path in pathlist]
		else:
			return []
		homes=[self.normalizeHome(h) for h in homes]
		return homes
	
	def browseHomedir(self,*options):
		dialog=gtk.FileChooserDialog("Open folder...",None,gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN,gtk.RESPONSE_OK))
		dialog.set_default_response(gtk.RESPONSE_OK)
		response = dialog.run()
		if response == gtk.RESPONSE_OK:
			self.homeDirEntry.set_text(dialog.get_filename())
			self.refreshHomes()
		dialog.destroy()
		return

	def getMode(self):
		response=self.permsDialog.run()
		self.permsDialog.hide()
		if response==gtk.RESPONSE_OK:
			ur=self['permsURCheck'].get_active()
			uw=self['permsUWCheck'].get_active()
			ux=self['permsUXCheck'].get_active()
			gr=self['permsGRCheck'].get_active()
			gw=self['permsGWCheck'].get_active()
			gx=self['permsGXCheck'].get_active()
			wr=self['permsWRCheck'].get_active()
			ww=self['permsWWCheck'].get_active()
			wx=self['permsWXCheck'].get_active()
			return self.modeToStringMode(ur,uw,ux,gr,gw,gx,wr,ww,wx)
		return None,None,None

	def getGroup(self):
		groups=[g[0] for g in self.getGroups()]
		self.subjectChooser.set(groups,SubjectChooser.GROUP)
		response=self.subjectChooser.run()
		self.subjectChooser.hide()
		if response==gtk.RESPONSE_OK:
			selection=self.subjectChooser.getSelection()
			if selection!=[]:
				return selection[0]
		return None

	# group map
	
	def groupMap(self,*options):
		cl=sysSetting['getGroupMap']
		status,output=self.runToString(cl)
		if not status:
			message="Group map failed"
		else:
			message=output
		dialog=gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_INFO,gtk.BUTTONS_CLOSE,message)
		dialog.run()
		dialog.destroy()
		return

	# help

	def help(self,*options):
		distribution=self.getDistribution()
		browser=sysSetting['browser'][distribution]
		urlbase=sysSetting['docs'][distribution]
		if distribution=="suse" or distribution=="debian":
			url=urlbase % ('users.html')
		else:
			url=urlbase % (self.getVersion(),'users.html')
		os.spawnv(os.P_NOWAIT,browser,[browser,url])
		return

	def getVersion(self):
		cl=sysSetting['getVersion']
		status,output=self.runToString(cl)
		return output

	def about(self,*options):
		self.aboutDialog.show()
		return

	#######################################################################
	#	HELPERS
	#######################################################################
	
	def runToString(self,cl):
		status,output=self.runner.runToString(cl)
		return status,output

	def getUsers(self):
		cl=sysSetting['getUsers']
		status,output=self.runToString(cl)
		if not status:
			return []
		output=output.strip('\n\r ')
		users=output.splitlines()	
		users=[u.strip('\n\r ').split(':') for u in users]
		# filter
		f=setting['usersFilter']
		nf=setting['usersNotFilter']
		users=[u for u in users if eval(f) and not eval(nf) and u[0] not in ('nfsnobody')]
		return users
	
	def getGroups(self):
		status,output=self.runToString(sysSetting['getGroups'])
		if not status:
			return []
		output=output.strip('\n\r ')
		groups=output.splitlines()
		groups=[g.strip('\n\r ').split(':') for g in groups]
		for g in groups:
			members=g[3]
			members=members.split(',')
			members.sort()
			members=','.join(members)
			g[3]=members
		# filter
		f=setting['groupsFilter']
		nf=setting['groupsNotFilter']
		groups=[g for g in groups if eval(f) and not eval(nf) and g[0] not in ('nfsnobody')]
		return groups
		
	def getHomes(self):
		homeDir=self.homeDirEntry.get_text()
		cl=sysSetting['getHomes']
		cl=cl.replace('%HOME%',homeDir)
		status,output=self.runToString(cl)
		if not status:
			return []
		output=output.strip('\n\r ;')
		if output == "":
			return []
		homes=output.split(";")
		homes=[h.strip('\n\r ').split(':') for h in homes]
		for h in homes:
			perms=h[3]
			del h[3]
			h.append(perms[1:4])
			h.append(perms[4:7])
			h.append(perms[7:10])
		# filter
		users=[u[UsersView.USER] for u in self.usersView.model]
		homes=[h for h in homes if h[1] in users]
		return homes

	def getDistribution(self):
		cl=sysSetting['getDistribution']
		status,output=self.runToString(cl)
		if status:
			return output.strip('\n\r ')
		return 'default'

	def isDir(self,path):
		cl=sysSetting['isDirectory']
		cl=cl.replace('%FSOBJECT%',path)
		status,output=self.runToString(cl)
		if not status:
			return False
		output=output.strip('\n\r ')
		return output=='true'
		
	def exists(self,path):
		cl=sysSetting['exists']
		cl=cl.replace('%FSOBJECT%',path)
		status,output=self.runToString(cl)
		if not status:
			return False
		output=output.strip('\n\r ')
		return output=='true'
		
	def mkdir(self,path):
		cl=sysSetting['mkdir']
		cl=cl.replace('%FSOBJECT%',path)
		status,output=self.runToString(cl)
		return status
		
	def rmdir(self,path):
		cl=sysSetting['rmdir']
		cl=cl.replace('%FSOBJECT%',path)
		status,output=self.runToString(cl)
		return status
		
	def chown(self,path,user,group):
		cl=sysSetting['chown']
		cl=cl.replace('%FSOBJECT%',path)
		cl=cl.replace('%USER%',user)
		status1,output=self.runToString(cl)
		cl=sysSetting['chgrp']
		cl=cl.replace('%FSOBJECT%',path)
		cl=cl.replace('%GROUP%',group)
		status2,output=self.runToString(cl)
		return status1 and status2

	def chmod(self,path,umode,gmode,omode):
		cl=sysSetting['chmod']
		cl=cl.replace('%FSOBJECT%',path)
		cl=cl.replace('%UMODE%',umode)
		cl=cl.replace('%GMODE%',gmode)
		cl=cl.replace('%OMODE%',omode)
		status,output=self.runToString(cl)
		return status
				
	def intToMode(self,m):
		#print oct(m)
		ur=m & stat.S_IRUSR!=0
		uw=m & stat.S_IWUSR!=0
		ux=m & stat.S_IXUSR!=0
		gr=m & stat.S_IRGRP!=0
		gw=m & stat.S_IWGRP!=0
		gx=m & stat.S_IXGRP!=0
		wr=m & stat.S_IROTH!=0
		ww=m & stat.S_IWOTH!=0
		wx=m & stat.S_IXOTH!=0
		return ur,uw,ux,gr,gw,gx,wr,ww,wx

	def modeToString(self,ur,uw,ux,gr,gw,gx,wr,ww,wx):
		mapRead={True:'r',False:'-'}
		mapWrite={True:'w',False:'-'}
		mapExec={True:'x',False:'-'}
		ur=mapRead[ur]
		uw=mapWrite[uw]
		ux=mapExec[ux]
		gr=mapRead[gr]
		gw=mapWrite[gw]
		gx=mapExec[gx]
		wr=mapRead[wr]
		ww=mapWrite[ww]
		wx=mapExec[wx]
		return '%s%s%s' % (ur,uw,ux),'%s%s%s' % (gr,gw,gx),'%s%s%s' % (wr,ww,wx)

	def modeToStringMode(self,ur,uw,ux,gr,gw,gx,wr,ww,wx):
		mapRead={True:'r',False:''}
		mapWrite={True:'w',False:''}
		mapExec={True:'x',False:''}
		ur=mapRead[ur]
		uw=mapWrite[uw]
		ux=mapExec[ux]
		gr=mapRead[gr]
		gw=mapWrite[gw]
		gx=mapExec[gx]
		wr=mapRead[wr]
		ww=mapWrite[ww]
		wx=mapExec[wx]
		return '%s%s%s' % (ur,uw,ux),'%s%s%s' % (gr,gw,gx),'%s%s%s' % (wr,ww,wx)

	def modeToInt(self,ur,uw,ux,gr,gw,gx,wr,ww,wx):
		mode=0
		if ur:
			mode=mode | stat.S_IRUSR
		if uw:
			mode=mode | stat.S_IWUSR
		if ux:
			mode=mode | stat.S_IXUSR
		if gr:
			mode=mode | stat.S_IRGRP
		if gw:
			mode=mode | stat.S_IWGRP
		if gx:
			mode=mode | stat.S_IXGRP
		if wr:
			mode=mode | stat.S_IROTH
		if ww:
			mode=mode | stat.S_IWOTH
		if wx:
			mode=mode | stat.S_IXOTH
		return mode

#######################################################################
#	MAIN
#######################################################################

import sys
import os

if __name__ == "__main__":
	
	e=sys.argv[0]
	e=os.path.realpath(e)
	d=os.path.dirname(e)
	os.chdir(d)
	s=UserManager()
	s.refresh()

	gtk.main()

__author__='Bernard Bou <bou@ac-toulouse.fr>'
