r"""
Sage categories quickref
------------------------

- sage.categories.primer?             A primer on Elements, Parents, and Categories
- sage.categories.tutorial?           A tutorial on Elements, Parents, and Categories
- Category?                           Technical background on categories
- Sets() Semigroups() Algebras(QQ)    Some categories
- SemiGroups().example()??            Sample implementation of a semigroup
- Hom(A, B), End(A, Algebras())       Homomorphisms sets
- tensor, cartesian_product           Functorial constructions

Module layout:

- sage.categories.basic:              the basic categories
- sage.categories.all:                all categories
- sage.categories.semigroups:         the Semigroups() category
- sage.categories.examples.semigroups the example of Semigroups()
- sage.categories.homset, map,
                  morphism, functors: morphisms, ...
- sage.categories.cartesian_product, tensor,
                  dual:               functorial constructions


Todo: put the quickref in quickref.py, and only some pointers here?

"""

from . import primer
