// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_GRAPH_ALIGN_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_ALIGN_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AlignConfig

template <bool TTop , bool TLeft , bool TRight , bool TBottom , typename TSpec > class AlignConfig;       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(65)

//____________________________________________________________________________
// AlignTraceback

template <typename TSize> struct AlignTraceback;       	// "seqan-1.3.1/seqan/graph_align/graph_align_base.h"(96)

//____________________________________________________________________________
// TraceBack_

struct TraceBack_;       	// "seqan-1.3.1/seqan/graph_align/graph_align_base.h"(85)

//____________________________________________________________________________
// TranslateTableByteToTraceback_

template <typename T > struct TranslateTableByteToTraceback_;       	// "seqan-1.3.1/seqan/graph_align/graph_align_base.h"(47)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// TraceBack

typedef SimpleType<unsigned char, TraceBack_> TraceBack;       	// "seqan-1.3.1/seqan/graph_align/graph_align_base.h"(86)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _alignBandedGotoh

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TDiagonal, typename TAlignConfig> inline typename Value<TScore>::Type _alignBandedGotoh(TTrace& trace, TStringSet const& str, TScore const & sc, TValPair& overallMaxValue, TIndexPair& overallMaxIndex, TDiagonal diagL, TDiagonal diagU, TAlignConfig const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_gotoh.h"(158)

//____________________________________________________________________________
// _alignBandedGotohTrace

template <typename TAlign, typename TStringSet, typename TTrace, typename TValPair, typename TIndexPair, typename TDiagonal> inline void _alignBandedGotohTrace(TAlign& align, TStringSet const& str, TTrace const& trace, TValPair const& overallMaxValue, TIndexPair const& overallMaxIndex, TDiagonal const diagL, TDiagonal const diagU);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_gotoh.h"(54)

//____________________________________________________________________________
// _alignBandedNeedlemanWunsch

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TDiagonal, typename TAlignConfig> inline typename Value<TScore>::Type _alignBandedNeedlemanWunsch(TTrace& trace, TStringSet const& str, TScore const & sc, TValPair& overallMaxValue, TIndexPair& overallMaxIndex, TDiagonal diagL, TDiagonal diagU, TAlignConfig const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(176)
template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TDiagonal, typename TAlignConfig> inline typename Value<TScore>::Type _alignBandedNeedlemanWunsch(TTrace& trace, TStringSet const& str, TScore const & sc, TValPair& overallMaxValue, TIndexPair& overallMaxIndex, TDiagonal diagL, TDiagonal diagU, TAlignConfig const, String<Pair<typename Value<TScore>::Type,int> > & maxCols, unsigned minColNum);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(284)

//____________________________________________________________________________
// _alignBandedNeedlemanWunschTrace

template <typename TAlign, typename TStringSet, typename TTrace, typename TValPair, typename TIndexPair, typename TDiagonal> inline void _alignBandedNeedlemanWunschTrace(TAlign& align, TStringSet const& str, TTrace const& trace, TValPair const& overallMaxValue, TIndexPair const& overallMaxIndex, TDiagonal const diagL, TDiagonal const diagU);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(53)

//____________________________________________________________________________
// _alignBandedSmithWaterman

template <typename TTrace, typename TStringSet, typename TScore, typename TIndexPair, typename TDiagonal, typename TForbidden> inline typename Value<TScore>::Type _alignBandedSmithWaterman(TTrace& trace, TStringSet const& str, TScore const& sc, typename Value<TTrace>::Type& initialDir, TIndexPair& indexPair, TDiagonal diagL, TDiagonal diagU, TForbidden forbidden);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_smith_waterman_clump.h"(151)

//____________________________________________________________________________
// _alignBandedSmithWatermanTrace

template <typename TStringSet, typename TAlign, typename TTrace, typename TVal, typename TIndexPair, typename TDiagonal, typename TForbidden> inline void _alignBandedSmithWatermanTrace(TStringSet const& str, TAlign& align, TTrace const& trace, TVal const initialDir, TIndexPair const& indexPair, TDiagonal diagL, TDiagonal diagU, TForbidden& forbidden);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_smith_waterman_clump.h"(73)

//____________________________________________________________________________
// _alignGotoh

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TAlignConfig> inline typename Value<TScore>::Type _alignGotoh(TTrace& trace, TStringSet const& str, TScore const & sc, TValPair& overallMaxValue, TIndexPair& overallMaxIndex, typename Value<TTrace>::Type& initialDir, TAlignConfig const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_gotoh.h"(163)

//____________________________________________________________________________
// _alignGotohTrace

template <typename TAlign, typename TStringSet, typename TTrace, typename TIndexPair, typename TVal> inline void _alignGotohTrace(TAlign& align, TStringSet const& str, TTrace const& trace, TIndexPair const& overallMaxIndex, TVal const initialDir);       	// "seqan-1.3.1/seqan/graph_align/graph_align_gotoh.h"(52)

//____________________________________________________________________________
// _alignHirschberg

template <typename TTrace, typename TStringSet, typename TScoreValue, typename TSpec> TScoreValue _alignHirschberg(TTrace& trace, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, Hirschberg);       	// "seqan-1.3.1/seqan/graph_align/graph_align_hirschberg.h"(134)

//____________________________________________________________________________
// _alignHirschbergTrace

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTrace> void _alignHirschbergTrace(TAlign& align, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTrace& trace);       	// "seqan-1.3.1/seqan/graph_align/graph_align_hirschberg.h"(53)

//____________________________________________________________________________
// _alignNeedlemanWunsch

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TAlignConfig> inline typename Value<TScore>::Type _alignNeedlemanWunsch(TTrace & trace, TStringSet const & str, TScore const & _sc, TValPair & overallMaxValue, TIndexPair & overallMaxIndex, TAlignConfig const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_needleman_wunsch.h"(144)

//____________________________________________________________________________
// _alignNeedlemanWunschMatrix

template <typename TAlign, typename TStringSet, typename TTrace, typename TIndexPair> inline void _alignNeedlemanWunschMatrix(TAlign&, TStringSet const&, TTrace const&, TIndexPair const&);       	// "seqan-1.3.1/seqan/graph_align/graph_align_needleman_wunsch.h"(50)

//____________________________________________________________________________
// _alignNeedlemanWunschTrace

template <typename TAlign, typename TStringSet, typename TTrace, typename TIndexPair> void _alignNeedlemanWunschTrace(TAlign& align, TStringSet const& str, TTrace const& trace, TIndexPair const& overallMaxIndex);       	// "seqan-1.3.1/seqan/graph_align/graph_align_needleman_wunsch.h"(60)

//____________________________________________________________________________
// _alignSmithWaterman

template <typename TTrace, typename TStringSet, typename TScore, typename TIndexPair, typename TForbidden> inline typename Value<TScore>::Type _alignSmithWaterman(TTrace& trace, TStringSet const& str, TScore const & sc, typename Value<TTrace>::Type& initialDir, TIndexPair& indexPair, TForbidden& forbidden);       	// "seqan-1.3.1/seqan/graph_align/graph_align_smith_waterman.h"(212)

//____________________________________________________________________________
// _alignSmithWatermanTrace

template <typename TAlign, typename TStringSet, typename TTrace, typename TVal, typename TIndexPair, typename TForbidden> inline void _alignSmithWatermanTrace(TAlign& align, TStringSet const& str, TTrace const& trace, TVal const initialDir, TIndexPair const& indexPair, TForbidden& forbidden);       	// "seqan-1.3.1/seqan/graph_align/graph_align_smith_waterman.h"(102)

//____________________________________________________________________________
// _alignTracePrint

template <typename TFile, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _alignTracePrint(TFile& file, TStringSet const& str, TId const , TPos const pos1, TId const , TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "seqan-1.3.1/seqan/graph_align/graph_align_base.h"(117)
template <typename TStringSet, typename TCargo, typename TSpec, typename TStringSet2, typename TId, typename TPos, typename TTraceValue> inline void _alignTracePrint(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TStringSet2 const&, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "seqan-1.3.1/seqan/graph_align/graph_align_base.h"(170)
template <typename TFragment, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _alignTracePrint(String<TFragment>& matches, TStringSet const&, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const seqLen, TTraceValue const tv);       	// "seqan-1.3.1/seqan/graph_align/graph_align_base.h"(196)
template <typename TVertexDescriptor, typename TSpec, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _alignTracePrint(String<String<TVertexDescriptor, TSpec> >& nodeString, TStringSet const& str, TId const, TPos const pos1, TId const, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "seqan-1.3.1/seqan/graph_align/graph_align_base.h"(216)

//____________________________________________________________________________
// _configValueBottom

template <bool TTop, bool TLeft, bool TRight, typename TSpec> inline bool _configValueBottom(AlignConfig<TTop, TLeft, TRight, true, TSpec> const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(462)
template <bool TTop, bool TLeft, bool TRight, typename TSpec> inline bool _configValueBottom(AlignConfig<TTop, TLeft, TRight, false, TSpec> const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(469)

//____________________________________________________________________________
// _configValueLeft

template <bool TTop, bool TRight, bool TBottom, typename TSpec> inline bool _configValueLeft(AlignConfig<TTop, true, TRight, TBottom, TSpec> const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(430)
template <bool TTop, bool TRight, bool TBottom, typename TSpec> inline bool _configValueLeft(AlignConfig<TTop, false, TRight, TBottom, TSpec> const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(437)

//____________________________________________________________________________
// _configValueRight

template <bool TTop, bool TLeft, bool TBottom, typename TSpec> inline bool _configValueRight(AlignConfig<TTop, TLeft, true, TBottom, TSpec> const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(446)
template <bool TTop, bool TLeft, bool TBottom, typename TSpec> inline bool _configValueRight(AlignConfig<TTop, TLeft, false, TBottom, TSpec> const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(453)

//____________________________________________________________________________
// _configValueTop

template <bool TLeft, bool TRight, bool TBottom, typename TSpec> inline bool _configValueTop(AlignConfig<true, TLeft, TRight, TBottom, TSpec> const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(414)
template <bool TLeft, bool TRight, bool TBottom, typename TSpec> inline bool _configValueTop(AlignConfig<false, TLeft, TRight, TBottom, TSpec> const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(421)

//____________________________________________________________________________
// _finishAlign

template <typename TString, typename TPos> inline void _finishAlign(Graph<Alignment<StringSet<TString, Dependent<> > > >&, TPos, TPos, TPos, TPos);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_smith_waterman_clump.h"(55)

//____________________________________________________________________________
// _globalAlignment

template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, Gotoh);       	// "seqan-1.3.1/seqan/graph_align/graph_align_gotoh.h"(285)
template <typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, Gotoh);       	// "seqan-1.3.1/seqan/graph_align/graph_align_gotoh.h"(312)
template <typename TAlign, typename TStringSet, typename TScore, typename TSpec> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, AlignConfig<false, false, false, false, TSpec> const, Hirschberg);       	// "seqan-1.3.1/seqan/graph_align/graph_align_hirschberg.h"(497)
template <typename TStringSet, typename TScore, typename TSpec> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, AlignConfig<false, false, false, false, TSpec> const, Hirschberg);       	// "seqan-1.3.1/seqan/graph_align/graph_align_hirschberg.h"(520)
template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, NeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_needleman_wunsch.h"(248)
template <typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, NeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_needleman_wunsch.h"(273)
template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig, typename TDiagonal> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_gotoh.h"(302)
template <typename TStringSet, typename TScore, typename TAlignConfig, typename TDiagonal> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_gotoh.h"(331)
template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig, typename TDiagonal> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, String<Pair<typename Value<TScore>::Type,int> > &maxCols, unsigned minColNum, BandedNeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(403)
template <typename TStringSet, typename TScore, typename TAlignConfig, typename TDiagonal> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, String<Pair<typename Value<TScore>::Type,int> > &maxCols, unsigned minColNum, BandedNeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(434)
template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig, typename TDiagonal> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(461)
template <typename TStringSet, typename TScore, typename TAlignConfig, typename TDiagonal> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(490)

//____________________________________________________________________________
// _initAlign

template <typename TString> inline void _initAlign(Graph<Alignment<StringSet<TString, Dependent<> > > >& align, StringSet<TString, Dependent<> > const& str);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_smith_waterman_clump.h"(44)

//____________________________________________________________________________
// _initFirstColumn

template <bool TTop, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstColumn(AlignConfig<TTop, false, TRight, TBottom, TSpec> const, TElement& element, TCost const cost);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(175)
template <bool TTop, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstColumn(AlignConfig<TTop, true, TRight, TBottom, TSpec> const, TElement& element, TCost const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(187)

//____________________________________________________________________________
// _initFirstRow

template <bool TLeft, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstRow(AlignConfig<false, TLeft, TRight, TBottom, TSpec> const, TElement& element, TCost const cost);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(199)
template <bool TLeft, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstRow(AlignConfig<true, TLeft, TRight, TBottom, TSpec> const, TElement& element, TCost const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(211)

//____________________________________________________________________________
// _isClumping

template <typename TSpec, typename TSize> inline bool _isClumping(String<bool, TSpec> const& forbidden, TSize row, TSize col, TSize len2);       	// "seqan-1.3.1/seqan/graph_align/graph_align_smith_waterman.h"(76)
template <typename TSize> inline bool _isClumping(Nothing&, TSize, TSize, TSize);       	// "seqan-1.3.1/seqan/graph_align/graph_align_smith_waterman.h"(88)

//____________________________________________________________________________
// _lastColumn

template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TColumn> inline void _lastColumn(AlignConfig<TTop, TLeft, false, TBottom, TSpec> const, TValue1& maxValue, TIndex1&, TColumn const& column);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(258)
template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TColumn> inline void _lastColumn(AlignConfig<TTop, TLeft, true, TBottom, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TColumn const& column);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(271)
template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastColumn(AlignConfig<TTop, TLeft, false, TBottom, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const row, TIndex2 const col);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(358)
template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastColumn(AlignConfig<TTop, TLeft, true, TBottom, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const row, TIndex2 const col);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(373)

//____________________________________________________________________________
// _lastRow

template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastRow(AlignConfig<TTop, TLeft, TRight, false, TSpec> const, TValue1&, TIndex1&, TValue2 const, TIndex2 const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(228)
template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastRow(AlignConfig<TTop, TLeft, TRight, true, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const index);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(242)
template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastRow(AlignConfig<TTop, TLeft, TRight, false, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const row, TIndex2 const col);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(388)
template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastRow(AlignConfig<TTop, TLeft, TRight, true, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const row, TIndex2 const col);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(403)

//____________________________________________________________________________
// _localAlignment

template <typename TAlign, typename TStringSet, typename TScore> inline typename Value<TScore>::Type _localAlignment(TAlign& align, TStringSet const& str, TScore const& sc, SmithWaterman);       	// "seqan-1.3.1/seqan/graph_align/graph_align_smith_waterman.h"(345)
template <typename TStringSet, typename TScore> inline typename Value<TScore>::Type _localAlignment(TStringSet const& str, TScore const& sc, SmithWaterman);       	// "seqan-1.3.1/seqan/graph_align/graph_align_smith_waterman.h"(373)
template <typename TAlign, typename TStringSet, typename TForbidden, typename TScore, typename TDiagonal> inline typename Value<TScore>::Type _localAlignment(TStringSet& str, TAlign& align, TForbidden& forbidden, TScore const& sc, TDiagonal diag1, TDiagonal diag2, BandedSmithWatermanClump);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_smith_waterman_clump.h"(284)
template <typename TString, typename TAlignments, typename TScores, typename TScoreValue, typename TSpec2, typename TDiagonal> inline void _localAlignment(StringSet<TString, Dependent<> > const& str, TAlignments& alignments, TScores& scores, Score<TScoreValue, TSpec2> const& sc, TScoreValue minScore, TDiagonal diag1, TDiagonal diag2, BandedSmithWatermanClump);       	// "seqan-1.3.1/seqan/graph_align/graph_align_banded_smith_waterman_clump.h"(314)
template <typename TAlign, typename TStringSet, typename TForbidden, typename TScore> inline typename Value<TScore>::Type _localAlignment(TAlign& align, TStringSet& str, TForbidden& forbidden, TScore const& sc, SmithWatermanClump);       	// "seqan-1.3.1/seqan/graph_align/graph_align_smith_waterman_clump.h"(53)
template <typename TString, typename TMatches, typename TScores, typename TScore, typename TSize1> inline void _localAlignment(StringSet<TString, Dependent<> > const& str, TMatches& matches, TScores& scores, TScore const& sc, TSize1 numAlignments, SmithWatermanClump);       	// "seqan-1.3.1/seqan/graph_align/graph_align_smith_waterman_clump.h"(94)

//____________________________________________________________________________
// _maxOfAlignment

template <typename TScoreValue, bool TTop, bool TLeft, typename TSpec, typename TValue, typename TIndex, typename TSize> inline TScoreValue _maxOfAlignment(AlignConfig<TTop, TLeft, false, false, TSpec> const, TValue& maxValue, TIndex&, TSize const, TSize const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(296)
template <typename TScoreValue, bool TTop, bool TLeft, typename TSpec, typename TValue, typename TIndex, typename TSize> inline TScoreValue _maxOfAlignment(AlignConfig<TTop, TLeft, true, false, TSpec> const, TValue& maxValue, TIndex& maxIndex, TSize const len1, TSize const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(310)
template <typename TScoreValue, bool TTop, bool TLeft, typename TSpec, typename TValue, typename TIndex, typename TSize> inline TScoreValue _maxOfAlignment(AlignConfig<TTop, TLeft, false, true, TSpec> const, TValue& maxValue, TIndex& maxIndex, TSize const, TSize const len2);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(325)
template <typename TScoreValue, bool TTop, bool TLeft, typename TSpec, typename TValue, typename TIndex, typename TSize> inline TScoreValue _maxOfAlignment(AlignConfig<TTop, TLeft, true, true, TSpec> const, TValue& maxValue, TIndex& maxIndex, TSize const len1, TSize const len2);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(340)

//____________________________________________________________________________
// _pairWiseSumOfPairsScore

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _pairWiseSumOfPairsScore(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& sc, TAlignConfig const);       	// "seqan-1.3.1/seqan/graph_align/graph_align_config.h"(481)

//____________________________________________________________________________
// _setForbiddenCell

template <typename TSpec, typename TSize> inline void _setForbiddenCell(String<bool, TSpec>& forbidden, TSize len1, TSize len2, TSize numRows);       	// "seqan-1.3.1/seqan/graph_align/graph_align_smith_waterman.h"(53)
template <typename TSize> inline void _setForbiddenCell(Nothing&, TSize, TSize, TSize);       	// "seqan-1.3.1/seqan/graph_align/graph_align_smith_waterman.h"(65)

//____________________________________________________________________________
// globalAlignment

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(80)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(94)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(106)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(119)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TTag> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(131)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TAlignConfig const, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(145)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(161)
template <typename TString, typename TAlignSpec, typename TStringSet, typename TScoreValue, typename TScoreSpec, typename TDiagonal> inline TScoreValue globalAlignment(Align<TString, TAlignSpec> & align, TStringSet const & stringSet, Score<TScoreValue, TScoreSpec> const & sc, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(177)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TDiagonal> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(195)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(210)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TDiagonal> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(226)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(242)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(258)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TDiagonal> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(273)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(288)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TDiagonal> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(304)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(320)
template <typename TStringSet, typename TCargo, typename TSpec> inline int globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Lcs);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(331)

//____________________________________________________________________________
// localAlignment

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue localAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(365)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue localAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(376)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TTag> inline TScoreValue localAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(388)

//____________________________________________________________________________
// multiLocalAlignment

template <typename TString, typename TMatches, typename TScores, typename TScoreValue, typename TSpec2, typename TSize, typename TTag> inline void multiLocalAlignment(StringSet<TString, Dependent<> > const& str, TMatches& matches, TScores& scores, Score<TScoreValue, TSpec2> const& sc, TSize numAlignments, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(431)
template <typename TString, typename TAlignments, typename TScores, typename TScoreValue, typename TSpec2, typename TDiagonal, typename TTag> inline void multiLocalAlignment(StringSet<TString, Dependent<> > const& str, TAlignments& alignments, TScores& scores, Score<TScoreValue, TSpec2> const& sc, TScoreValue minScore, TDiagonal diag1, TDiagonal diag2, TTag);       	// "seqan-1.3.1/seqan/graph_align/graph_align_interface.h"(445)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

