#version 330

layout(points) in;
layout(triangle_strip, max_vertices = 56) out;
//layout(line_strip, max_vertices = 51) out;

int inl = gl_in.length();//triangles
in vec3 mid[];
in vec3 nor[];
in vec3 vert0[];
in vec3 vert1[];
in vec3 col[];
in float an[];
in float intra[];

uniform mat4 pmv;
uniform mat3 normalMatrix;

out vec3 Normal;
out vec4 color;
out float distfrommit;


out gl_PerVertex{
  vec4 gl_Position;
};

void main(void){
    float alpha = (intra[0] > 0) ? 0.03 : (intra[0] < 0) ? 0.2 : 0.6;
    vec4 c = vec4(col[0], alpha);
    vec4 cs = vec4(col[0], 1);
    float w = 0.02;
    //outer "line"
    gl_Position = pmv * vec4(vert0[0],1);
    Normal = normalize(normalMatrix * nor[0]);
    color = cs;
    distfrommit = 0;

    EmitVertex();

    gl_Position = pmv * vec4(vert1[0], 1);
    Normal = normalize(normalMatrix * nor[0]);
    color = cs;
    distfrommit = 0;

    EmitVertex();
    gl_Position = pmv * vec4(vert0[0] + w * mid[0],1);
    Normal = normalize(normalMatrix * nor[0]);
    color = cs;
    distfrommit = 0;

    EmitVertex();

    gl_Position = pmv * vec4(vert1[0] + w * mid[0],1);
    Normal = normalize(normalMatrix * nor[0]);
    color = cs;
    distfrommit = 0;

    EmitVertex();
    EndPrimitive();


//triangle
    gl_Position = pmv * vec4(mid[0],1);
    Normal = normalize(normalMatrix * nor[0]);
    color = c;
    distfrommit = 0;
    EmitVertex();

    gl_Position = pmv * vec4(vert0[0],1);
    Normal = normalize(normalMatrix * nor[0]);
    color = c;
    distfrommit = distance(mid[0],vert0[0]);

    EmitVertex();

    gl_Position = pmv * vec4(vert1[0],1);
    Normal = normalize(normalMatrix * nor[0]);
    color = c;
    distfrommit = distance(mid[0],vert1[0]);

    EmitVertex();
    EndPrimitive();


}
