6.2 エフェクトの実践

# エフェクトの実践 

外観は一見シンプルですが、 エフェクト内部は実際には異常に複雑なモンスターです。そのシンプルさは、しばしば、この機能を酷使させようと誘惑します。もしもあなたが強力なマシンを持っている場合は問題は無いかもしれませんが、ラズベリーパイで動作させる場合、確実にビートを刻み続けるようにしたいのであれば、どのくらいの負荷をかけているのか注意する必要があります。

このコードを考えてみましょう。

```
loop do
 with_fx :reverb do
   play 60, release: 0.1
   sleep 0.125
 end
end
```

このコードは非常に短いリリースタイムで音符`60`を演奏します。そして、リバーブを加えたいために、コードをリバーブで囲んでいます。問題はなさそうには見えますが…。

コードが何をするかを見ていきましょう。まず、`loop`は内側のすべてが永遠に繰り返すことを意味します。次に、`with_fx`ブロックがあります。これはループが繰り返される度に、新しいリバーブエフェクトを作成することを意味します。ギターの弦を弾くたびに別々のリバーブエフェクターを用意して演奏しているようなものです。そんなことができたらかっこいいかもしれませんが、それはあなたが望むものとは限らないということです。たとえば、次のコードは、ラズベリーパイで実行させるためにはとても労力を要します。リバーブは`with_fx`によって制御され、停止か消去されるまで、生成され続け、スム−ズな演奏に必要とする大切なCPUパワーを奪うことになりかねません。

ギタリストのように、すべての音が1つのリバーブエフェクターを通る従来の設定と同様の流れを作るには、どうしたら良いでしょうか？

以下、サンプルです。

```
with_fx :reverb do
 loop do
   play 60, release: 0.1
   sleep 0.125
 end
end
```

`with_fx` ブロックの内部に`loop`を配置しす。この方法では、ループ内すべての音符の再生にリバーブを一つだけ作成します。このコードは効率的で、ラズベリーパイで正常に動作します。

`loop`内の繰り返しの上位に`with_fx`を使うことで折り合いを付けます。

```
loop do
 with_fx :reverb do
   16.times do
     play 60, release: 0.1
     sleep 0.125
   end
 end
end
```

`loop`の外部に`with_fx`を引き上げることで、16の音程ごとに新しいリバーブを作成しています。

これらの異なるアプローチからは、違うサウンド、また異なる性能をもたらします。だから、間違いでもなく可能性であることを覚えておいてください。あなたのプラットフォームに応じた制約の中で、最も適切に働くアプローチを使いわけながら演奏を心がけましょう。
