/*
 * Copyright (C) 2009-2010  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */

#include <QSettings>

#include "sourcehighlightideframe.h"

SourceHighlightIdeFrame::SourceHighlightIdeFrame(QWidget *parent) :
    QFrame(parent),
    m_ui(new Ui::SourceHighlightIdeFrame)
{
    m_ui->setupUi(this);
}

SourceHighlightIdeFrame::~SourceHighlightIdeFrame()
{
    delete m_ui;
}

void SourceHighlightIdeFrame::changeEvent(QEvent *e)
{
    QFrame::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

srchiliteqt::TextEditHighlighted *SourceHighlightIdeFrame::getLangTextEdit() const {
    return m_ui->langTextEdit;
}

QTextEdit *SourceHighlightIdeFrame::getInputTextEdit() const {
    return m_ui->inputTextEdit;
}

srchiliteqt::TextEditHighlighted *SourceHighlightIdeFrame::getOutputTextEdit() const {
    return m_ui->outputTextEdit;
}

void SourceHighlightIdeFrame::readSettings(QSettings &settings)
{
      m_ui->verticalSplitter->restoreState(settings.value("verticalSplitterSizes").toByteArray());
      m_ui->horizontalSplitter->restoreState(settings.value("horizontalSplitterSizes").toByteArray());
}

void SourceHighlightIdeFrame::saveSettings(QSettings &settings)
{
      settings.setValue("verticalSplitterSizes", m_ui->verticalSplitter->saveState());
      settings.setValue("horizontalSplitterSizes", m_ui->horizontalSplitter->saveState());
}

void SourceHighlightIdeFrame::setPreviewContents(const QString &contents) {
    m_ui->previewWebView->setHtml(contents);
}

void SourceHighlightIdeFrame::goToEndOfPreviewContents() {
    m_ui->previewWebView->page()->setContentEditable(true);
    // this does not seem to work!
    m_ui->previewWebView->page()->triggerAction(QWebPage::MoveToEndOfDocument);
}

void SourceHighlightIdeFrame::setNoPreview() {
    m_ui->previewWebView->setHtml(
            "<html><body>Sorry, no preview available for this output format.</body></html>"
            );
}
