/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_29 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 23034, "epsg", 23034,
        "ED50 / UTM zone 34N");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 34N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",21],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23034\"]]");
    p = add_epsg_def (filter, first, last, 23035, "epsg", 23035,
        "ED50 / UTM zone 35N");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 35N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",27],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23035\"]]");
    p = add_epsg_def (filter, first, last, 23036, "epsg", 23036,
        "ED50 / UTM zone 36N");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 36N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",33],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23036\"]]");
    p = add_epsg_def (filter, first, last, 23037, "epsg", 23037,
        "ED50 / UTM zone 37N");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 37N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",39],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23037\"]]");
    p = add_epsg_def (filter, first, last, 23038, "epsg", 23038,
        "ED50 / UTM zone 38N");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 38N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-");
    add_srs_wkt (p, 3,
        "121,0,0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",45],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23038\"]]");
    p = add_epsg_def (filter, first, last, 23090, "epsg", 23090,
        "ED50 / TM 0 N");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM 0 N\",GEOGCS[\"ED50\",DATUM[\"Europea");
    add_srs_wkt (p, 1,
        "n_Datum_1950\",SPHEROID[\"International 1924\",6378388,2");
    add_srs_wkt (p, 2,
        "97,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0,");
    add_srs_wkt (p, 3,
        "0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",0],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"23090\"]]");
    p = add_epsg_def (filter, first, last, 23095, "epsg", 23095,
        "ED50 / TM 5 NE");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=5 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM 5 NE\",GEOGCS[\"ED50\",DATUM[\"Europe");
    add_srs_wkt (p, 1,
        "an_Datum_1950\",SPHEROID[\"International 1924\",6378388,");
    add_srs_wkt (p, 2,
        "297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0");
    add_srs_wkt (p, 3,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",5],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23095\"]]");
    p = add_epsg_def (filter, first, last, 23239, "epsg", 23239,
        "Fahud / UTM zone 39N");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-346,-1,224,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fahud / UTM zone 39N\",GEOGCS[\"Fahud\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Fahud\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-346,-1,224,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6232\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4232\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23239\"]]");
    p = add_epsg_def (filter, first, last, 23240, "epsg", 23240,
        "Fahud / UTM zone 40N");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-346,-1,224,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fahud / UTM zone 40N\",GEOGCS[\"Fahud\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Fahud\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-346,-1,224,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6232\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4232\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"23240\"]]");
    p = add_epsg_def (filter, first, last, 23433, "epsg", 23433,
        "Garoua / UTM zone 33N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Garoua / UTM zone 33N (deprecated)\",GEOGCS[\"G");
    add_srs_wkt (p, 1,
        "aroua\",DATUM[\"Garoua\",SPHEROID[\"Clarke 1880 (IGN)\",");
    add_srs_wkt (p, 2,
        "6378249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6234\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4234\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"23433\"]]");
    p = add_epsg_def (filter, first, last, 23700, "epsg", 23700,
        "HD72 / EOV");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=47.14439372222222 +lon_0=19.04857177");
    add_proj4text (p, 1,
        "777778 +k_0=0.99993 +x_0=650000 +y_0=200000 +ellps=GRS67");
    add_proj4text (p, 2,
        " +towgs84=52.17,-71.82,-14.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"HD72 / EOV\",GEOGCS[\"HD72\",DATUM[\"Hungarian_");
    add_srs_wkt (p, 1,
        "Datum_1972\",SPHEROID[\"GRS 1967\",6378160,298.247167427");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7036\"]],TOWGS84[52.17,-71.82,-14.");
    add_srs_wkt (p, 3,
        "9,0,0,0,0],AUTHORITY[\"EPSG\",\"6237\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4237\"]],PROJECTION[\"Hotine_Oblique_Mercato");
    add_srs_wkt (p, 7,
        "r\"],PARAMETER[\"latitude_of_center\",47.14439372222222]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"longitude_of_center\",19.04857177777778],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"azimuth\",90],PARAMETER[\"rectified_grid_angle");
    add_srs_wkt (p, 10,
        "\",90],PARAMETER[\"scale_factor\",0.99993],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",650000],PARAMETER[\"false_northing\",2000");
    add_srs_wkt (p, 12,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Y\",EAST],AXIS[\"X\",NORTH],AUTHORITY[\"EPSG\",\"23700");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def (filter, first, last, 23830, "epsg", 23830,
        "DGN95 / Indonesia TM-3 zone 46.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=94.5 +k=0.9999 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 46.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",94.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9999],PARAMETER[\"false_easting\",200000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"23830\"]]");
    p = add_epsg_def (filter, first, last, 23831, "epsg", 23831,
        "DGN95 / Indonesia TM-3 zone 47.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=97.5 +k=0.9999 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 47.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",97.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9999],PARAMETER[\"false_easting\",200000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"23831\"]]");
    p = add_epsg_def (filter, first, last, 23832, "epsg", 23832,
        "DGN95 / Indonesia TM-3 zone 47.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=100.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 47.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",100.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23832\"]]");
    p = add_epsg_def (filter, first, last, 23833, "epsg", 23833,
        "DGN95 / Indonesia TM-3 zone 48.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=103.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 48.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",103.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23833\"]]");
    p = add_epsg_def (filter, first, last, 23834, "epsg", 23834,
        "DGN95 / Indonesia TM-3 zone 48.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 48.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",106.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23834\"]]");
    p = add_epsg_def (filter, first, last, 23835, "epsg", 23835,
        "DGN95 / Indonesia TM-3 zone 49.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=109.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 49.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",109.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23835\"]]");
    p = add_epsg_def (filter, first, last, 23836, "epsg", 23836,
        "DGN95 / Indonesia TM-3 zone 49.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=112.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 49.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",112.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23836\"]]");
    p = add_epsg_def (filter, first, last, 23837, "epsg", 23837,
        "DGN95 / Indonesia TM-3 zone 50.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=115.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 50.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",115.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23837\"]]");
    p = add_epsg_def (filter, first, last, 23838, "epsg", 23838,
        "DGN95 / Indonesia TM-3 zone 50.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=118.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 50.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",118.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23838\"]]");
    p = add_epsg_def (filter, first, last, 23839, "epsg", 23839,
        "DGN95 / Indonesia TM-3 zone 51.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 51.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",121.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23839\"]]");
    p = add_epsg_def (filter, first, last, 23840, "epsg", 23840,
        "DGN95 / Indonesia TM-3 zone 51.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=124.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 51.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",124.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23840\"]]");
    p = add_epsg_def (filter, first, last, 23841, "epsg", 23841,
        "DGN95 / Indonesia TM-3 zone 52.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=127.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 52.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",127.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23841\"]]");
    p = add_epsg_def (filter, first, last, 23842, "epsg", 23842,
        "DGN95 / Indonesia TM-3 zone 52.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=130.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 52.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",130.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23842\"]]");
    p = add_epsg_def (filter, first, last, 23843, "epsg", 23843,
        "DGN95 / Indonesia TM-3 zone 53.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=133.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 53.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",133.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23843\"]]");
    p = add_epsg_def (filter, first, last, 23844, "epsg", 23844,
        "DGN95 / Indonesia TM-3 zone 53.2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=136.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 53.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",136.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23844\"]]");
    p = add_epsg_def (filter, first, last, 23845, "epsg", 23845,
        "DGN95 / Indonesia TM-3 zone 54.1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=139.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 54.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",139.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"23845\"]]");
    p = add_epsg_def (filter, first, last, 23846, "epsg", 23846,
        "ID74 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 46N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",93],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"23846\"]]");
    p = add_epsg_def (filter, first, last, 23847, "epsg", 23847,
        "ID74 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 47N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",99],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"23847\"]]");
    p = add_epsg_def (filter, first, last, 23848, "epsg", 23848,
        "ID74 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 48N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",105],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23848\"]]");
    p = add_epsg_def (filter, first, last, 23849, "epsg", 23849,
        "ID74 / UTM zone 49N");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 49N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",111],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23849\"]]");
    p = add_epsg_def (filter, first, last, 23850, "epsg", 23850,
        "ID74 / UTM zone 50N");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 50N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",117],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23850\"]]");
    p = add_epsg_def (filter, first, last, 23851, "epsg", 23851,
        "ID74 / UTM zone 51N");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 51N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",123],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23851\"]]");
    p = add_epsg_def (filter, first, last, 23852, "epsg", 23852,
        "ID74 / UTM zone 52N");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 52N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",129],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23852\"]]");
    p = add_epsg_def (filter, first, last, 23853, "epsg", 23853,
        "ID74 / UTM zone 53N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 53N (deprecated)\",GEOGCS[\"ID7");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Indonesian_Datum_1974\",SPHEROID[\"Indonesia");
    add_srs_wkt (p, 2,
        "n National Spheroid\",6378160,298.247,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7021\"]],TOWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",135],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"23853\"]]");
    p = add_epsg_def (filter, first, last, 23866, "epsg", 23866,
        "DGN95 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 46N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",93],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23866\"]]");
    p = add_epsg_def (filter, first, last, 23867, "epsg", 23867,
        "DGN95 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 47N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",99],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23867\"]]");
    p = add_epsg_def (filter, first, last, 23868, "epsg", 23868,
        "DGN95 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 48N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",105],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23868\"]]");
    p = add_epsg_def (filter, first, last, 23869, "epsg", 23869,
        "DGN95 / UTM zone 49N");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 49N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",111],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23869\"]]");
    p = add_epsg_def (filter, first, last, 23870, "epsg", 23870,
        "DGN95 / UTM zone 50N");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 50N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",117],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23870\"]]");
    p = add_epsg_def (filter, first, last, 23871, "epsg", 23871,
        "DGN95 / UTM zone 51N");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 51N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",123],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23871\"]]");
    p = add_epsg_def (filter, first, last, 23872, "epsg", 23872,
        "DGN95 / UTM zone 52N");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 52N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",129],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23872\"]]");
    p = add_epsg_def (filter, first, last, 23877, "epsg", 23877,
        "DGN95 / UTM zone 47S");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 47S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",99],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"23877\"]]");
    p = add_epsg_def (filter, first, last, 23878, "epsg", 23878,
        "DGN95 / UTM zone 48S");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 48S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",105],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23878\"]]");
    p = add_epsg_def (filter, first, last, 23879, "epsg", 23879,
        "DGN95 / UTM zone 49S");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 49S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",111],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23879\"]]");
    p = add_epsg_def (filter, first, last, 23880, "epsg", 23880,
        "DGN95 / UTM zone 50S");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 50S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",117],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23880\"]]");
    p = add_epsg_def (filter, first, last, 23881, "epsg", 23881,
        "DGN95 / UTM zone 51S");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 51S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",123],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23881\"]]");
    p = add_epsg_def (filter, first, last, 23882, "epsg", 23882,
        "DGN95 / UTM zone 52S");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 52S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",129],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23882\"]]");
    p = add_epsg_def (filter, first, last, 23883, "epsg", 23883,
        "DGN95 / UTM zone 53S");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 53S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",135],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23883\"]]");
    p = add_epsg_def (filter, first, last, 23884, "epsg", 23884,
        "DGN95 / UTM zone 54S");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 54S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",141],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23884\"]]");
    p = add_epsg_def (filter, first, last, 23886, "epsg", 23886,
        "ID74 / UTM zone 46S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 46S (deprecated)\",GEOGCS[\"ID7");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Indonesian_Datum_1974\",SPHEROID[\"Indonesia");
    add_srs_wkt (p, 2,
        "n National Spheroid\",6378160,298.247,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7021\"]],TOWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",93],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"23886\"]]");
    p = add_epsg_def (filter, first, last, 23887, "epsg", 23887,
        "ID74 / UTM zone 47S");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 47S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",99],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"23887\"]]");
    p = add_epsg_def (filter, first, last, 23888, "epsg", 23888,
        "ID74 / UTM zone 48S");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 48S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",105],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23888\"]]");
    p = add_epsg_def (filter, first, last, 23889, "epsg", 23889,
        "ID74 / UTM zone 49S");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 49S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",111],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23889\"]]");
    p = add_epsg_def (filter, first, last, 23890, "epsg", 23890,
        "ID74 / UTM zone 50S");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 50S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",117],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23890\"]]");
    p = add_epsg_def (filter, first, last, 23891, "epsg", 23891,
        "ID74 / UTM zone 51S");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 51S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",123],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23891\"]]");
    p = add_epsg_def (filter, first, last, 23892, "epsg", 23892,
        "ID74 / UTM zone 52S");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 52S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",129],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23892\"]]");
    p = add_epsg_def (filter, first, last, 23893, "epsg", 23893,
        "ID74 / UTM zone 53S");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 53S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",135],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23893\"]]");
    p = add_epsg_def (filter, first, last, 23894, "epsg", 23894,
        "ID74 / UTM zone 54S");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 54S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",141],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23894\"]]");
    p = add_epsg_def (filter, first, last, 23946, "epsg", 23946,
        "Indian 1954 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377276.345 +b=6356075.413140239 +");
    add_proj4text (p, 1,
        "towgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 46N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[217,823,299,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6239\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4239\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",93],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23946\"]]");
    p = add_epsg_def (filter, first, last, 23947, "epsg", 23947,
        "Indian 1954 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377276.345 +b=6356075.413140239 +");
    add_proj4text (p, 1,
        "towgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 47N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[217,823,299,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6239\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4239\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",99],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23947\"]]");
    p = add_epsg_def (filter, first, last, 23948, "epsg", 23948,
        "Indian 1954 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377276.345 +b=6356075.413140239 +");
    add_proj4text (p, 1,
        "towgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 48N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[217,823,299,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6239\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4239\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"23948\"]]");
    p = add_epsg_def (filter, first, last, 24047, "epsg", 24047,
        "Indian 1975 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377276.345 +b=6356075.413140239 +");
    add_proj4text (p, 1,
        "towgs84=210,814,289,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1975 / UTM zone 47N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Indian_1975\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[210,814,289,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6240\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4240\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",99],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"24047\"]]");
    p = add_epsg_def (filter, first, last, 24048, "epsg", 24048,
        "Indian 1975 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377276.345 +b=6356075.413140239 +");
    add_proj4text (p, 1,
        "towgs84=210,814,289,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1975 / UTM zone 48N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Indian_1975\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[210,814,289,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6240\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4240\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"24048\"]]");
    p = add_epsg_def (filter, first, last, 24100, "epsg", 24100,
        "Jamaica 1875 / Jamaica (Old Grid)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=167");
    add_proj4text (p, 1,
        "638.49597 +y_0=121918.90616 +a=6378249.144808011 +b=6356");
    add_proj4text (p, 2,
        "514.966204134 +to_meter=0.3047972654 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Jamaica 1875 / Jamaica (Old Grid)\",GEOGCS[\"Ja");
    add_srs_wkt (p, 1,
        "maica 1875\",DATUM[\"Jamaica_1875\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80\",6378249.144808011,293.4663076556303,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7034\"]],AUTHORITY[\"EPSG\",\"6241\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4241\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",18],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-77],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"false_easting\",550000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",400000],UNIT[\"Clarke's foot\",0.3047972654,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9005\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24100\"]]");
    p = add_epsg_def (filter, first, last, 24200, "epsg", 24200,
        "JAD69 / Jamaica National Grid");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=250");
    add_proj4text (p, 1,
        "000 +y_0=150000 +ellps=clrk66 +towgs84=70,207,389.5,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JAD69 / Jamaica National Grid\",GEOGCS[\"JAD69\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Jamaica_1969\",SPHEROID[\"Clarke 1866\",6378206");
    add_srs_wkt (p, 2,
        ".4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[70,207,389.5,0,0,0,0],AUTHORITY[\"EPSG\",\"6242\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4242\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "18],PARAMETER[\"central_meridian\",-77],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",250000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",150000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24200\"]]");
    p = add_epsg_def (filter, first, last, 24305, "epsg", 24305,
        "Kalianpur 1937 / UTM zone 45N");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +a=6377276.345 +b=6356075.413140239 +");
    add_proj4text (p, 1,
        "towgs84=282,726,254,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / UTM zone 45N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7015\"]],TOWGS84[282,726,254,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4144\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",87],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24305\"]]");
    p = add_epsg_def (filter, first, last, 24306, "epsg", 24306,
        "Kalianpur 1937 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377276.345 +b=6356075.413140239 +");
    add_proj4text (p, 1,
        "towgs84=282,726,254,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / UTM zone 46N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7015\"]],TOWGS84[282,726,254,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4144\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",93],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24306\"]]");
    p = add_epsg_def (filter, first, last, 24311, "epsg", 24311,
        "Kalianpur 1962 / UTM zone 41N");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +a=6377301.243 +b=6356100.230165385 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 41N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4145");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",63],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24311");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24312, "epsg", 24312,
        "Kalianpur 1962 / UTM zone 42N");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +a=6377301.243 +b=6356100.230165385 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 42N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4145");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",69],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24312");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24313, "epsg", 24313,
        "Kalianpur 1962 / UTM zone 43N");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +a=6377301.243 +b=6356100.230165385 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 43N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4145");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",75],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24313");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24342, "epsg", 24342,
        "Kalianpur 1975 / UTM zone 42N");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 42N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",69],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24342");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24343, "epsg", 24343,
        "Kalianpur 1975 / UTM zone 43N");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 43N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",75],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24343");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24344, "epsg", 24344,
        "Kalianpur 1975 / UTM zone 44N");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 44N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",81],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24344");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24345, "epsg", 24345,
        "Kalianpur 1975 / UTM zone 45N");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 45N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",87],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24345");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24346, "epsg", 24346,
        "Kalianpur 1975 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 46N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",93],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24346");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24347, "epsg", 24347,
        "Kalianpur 1975 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 47N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",99],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24347");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 24370, "epsg", 24370,
        "Kalianpur 1880 / India zone 0");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_0=39.5 +lon_0=68 +k_0=0.99846");
    add_proj4text (p, 1,
        "154 +x_0=2153865.73916853 +y_0=2368292.194628102 +a=6377");
    add_proj4text (p, 2,
        "299.36559538 +b=6356098.359005156 +to_meter=0.9143985307");
    add_proj4text (p, 3,
        "444408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone 0\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest (");
    add_srs_wkt (p, 2,
        "1830 Definition)\",6377299.36559538,300.8017255433612,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",39.5],PARAMETER[\"central_meridian\",68],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99846154],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "355500],PARAMETER[\"false_northing\",2590000],UNIT[\"Ind");
    add_srs_wkt (p, 11,
        "ian yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24370\"]]");
    p = add_epsg_def (filter, first, last, 24371, "epsg", 24371,
        "Kalianpur 1880 / India zone I");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=637");
    add_proj4text (p, 2,
        "7299.36559538 +b=6356098.359005156 +to_meter=0.914398530");
    add_proj4text (p, 3,
        "7444408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest (");
    add_srs_wkt (p, 2,
        "1830 Definition)\",6377299.36559538,300.8017255433612,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",32.5],PARAMETER[\"central_meridian\",68],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99878641],PARAMETER[\"false_easting\",3");
    add_srs_wkt (p, 10,
        "000000],PARAMETER[\"false_northing\",1000000],UNIT[\"Ind");
    add_srs_wkt (p, 11,
        "ian yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24371\"]]");
    p = add_epsg_def (filter, first, last, 24372, "epsg", 24372,
        "Kalianpur 1880 / India zone IIa");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.8017255433612,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",26],PARAMETER[\"central_meridian\",74],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24372\"]]");
    p = add_epsg_def (filter, first, last, 24373, "epsg", 24373,
        "Kalianpur 1880 / India zone III");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone III\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.8017255433612,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",19],PARAMETER[\"central_meridian\",80],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24373\"]]");
    p = add_epsg_def (filter, first, last, 24374, "epsg", 24374,
        "Kalianpur 1880 / India zone IV");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IV\",GEOGCS[\"Kalia");
    add_srs_wkt (p, 1,
        "npur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest ");
    add_srs_wkt (p, 2,
        "(1830 Definition)\",6377299.36559538,300.8017255433612,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",12],PARAMETER[\"central_meridian\",80],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24374\"]]");
    p = add_epsg_def (filter, first, last, 24375, "epsg", 24375,
        "Kalianpur 1937 / India zone IIb");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743185.69 +y_0=914395.23 +a=6377276.345 +b=6356075");
    add_proj4text (p, 2,
        ".413140239 +towgs84=282,726,254,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7015\"]],TOWGS84[282,726,254,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4144\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",26],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",90],PARAMETER[\"scale_factor\",0.99878641],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",2743185.69],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",914395.23],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"24375\"]]");
    p = add_epsg_def (filter, first, last, 24376, "epsg", 24376,
        "Kalianpur 1962 / India zone I");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=63561");
    add_proj4text (p, 2,
        "00.230165385 +towgs84=283,682,231,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4145");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"latitude_of_origin\",32.5],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",68],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743196.4],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.8],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24376\"]]");
    p = add_epsg_def (filter, first, last, 24377, "epsg", 24377,
        "Kalianpur 1962 / India zone IIa");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=6356100.2");
    add_proj4text (p, 2,
        "30165385 +towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1962 Definition)\",6377301.243,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "45\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",26],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",74],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743196.4],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.8],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24377\"]]");
    p = add_epsg_def (filter, first, last, 24378, "epsg", 24378,
        "Kalianpur 1975 / India zone I");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=63560");
    add_proj4text (p, 2,
        "98.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4146");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"latitude_of_origin\",32.5],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",68],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743195.5],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24378\"]]");
    p = add_epsg_def (filter, first, last, 24379, "epsg", 24379,
        "Kalianpur 1975 / India zone IIa");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "46\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",26],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",74],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743195.5],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24379\"]]");
    p = add_epsg_def (filter, first, last, 24380, "epsg", 24380,
        "Kalianpur 1975 / India zone IIb");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "46\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",26],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",90],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743195.5],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24380\"]]");
    p = add_epsg_def (filter, first, last, 24381, "epsg", 24381,
        "Kalianpur 1975 / India zone III");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone III\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "46\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",19],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",80],PARAMETER[\"scale_factor\",0.99878641],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",2743195.5],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"24381\"]]");
    p = add_epsg_def (filter, first, last, 24382, "epsg", 24382,
        "Kalianpur 1880 / India zone IIb");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.8017255433612,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",26],PARAMETER[\"central_meridian\",90],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99878641],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",1000000],UNIT[\"Indi");
    add_srs_wkt (p, 11,
        "an yard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"24382\"]]");
    p = add_epsg_def (filter, first, last, 24383, "epsg", 24383,
        "Kalianpur 1975 / India zone IV");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IV\",GEOGCS[\"Kalia");
    add_srs_wkt (p, 1,
        "npur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest ");
    add_srs_wkt (p, 2,
        "1830 (1975 Definition)\",6377299.151,300.8017255,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"414");
    add_srs_wkt (p, 7,
        "6\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",12],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",80],PARAMETER[\"scale_factor\",0.99878641],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",2743195.5],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"24383\"]]");
    p = add_epsg_def (filter, first, last, 24500, "epsg", 24500,
        "Kertau 1968 / Singapore Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=1.287646666666667 +lon_0=103.853002222");
    add_proj4text (p, 1,
        "2222 +x_0=30000 +y_0=30000 +a=6377304.063 +b=6356103.038");
    add_proj4text (p, 2,
        "993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Singapore Grid\",GEOGCS[\"Kertau ");
    add_srs_wkt (p, 1,
        "1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Mod");
    add_srs_wkt (p, 2,
        "ified\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Cass");
    add_srs_wkt (p, 7,
        "ini_Soldner\"],PARAMETER[\"latitude_of_origin\",1.287646");
    add_srs_wkt (p, 8,
        "666666667],PARAMETER[\"central_meridian\",103.8530022222");
    add_srs_wkt (p, 9,
        "222],PARAMETER[\"false_easting\",30000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",30000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"24500\"]]");
    p = add_epsg_def (filter, first, last, 24547, "epsg", 24547,
        "Kertau 1968 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 1,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / UTM zone 47N\",GEOGCS[\"Kertau 19");
    add_srs_wkt (p, 1,
        "68\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modif");
    add_srs_wkt (p, 2,
        "ied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",99],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"24547\"]]");
    p = add_epsg_def (filter, first, last, 24548, "epsg", 24548,
        "Kertau 1968 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 1,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / UTM zone 48N\",GEOGCS[\"Kertau 19");
    add_srs_wkt (p, 1,
        "68\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modif");
    add_srs_wkt (p, 2,
        "ied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",105],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"24548\"]]");
    p = add_epsg_def (filter, first, last, 24571, "epsg", 24571,
        "Kertau / R.S.O. Malaya (ch) (deprecated)");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=");
    add_proj4text (p, 1,
        "0.99984 +x_0=804671.2997750348 +y_0=0 +gamma=323.1301023");
    add_proj4text (p, 2,
        "611111 +a=6377304.063 +b=6356103.038993155 +towgs84=-11,");
    add_proj4text (p, 3,
        "851,5,0,0,0,0 +to_meter=20.11678249437587 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau / R.S.O. Malaya (ch) (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Kertau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Ever");
    add_srs_wkt (p, 2,
        "est 1830 Modified\",6377304.063,300.8017,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7018\"]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6245\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4245\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_center\",4],PARAMETER[\"longitude_of_center\",102.25]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"azimuth\",323.0257905],PARAMETER[\"rectifie");
    add_srs_wkt (p, 10,
        "d_grid_angle\",323.1301023611111],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 11,
        "or\",0.99984],PARAMETER[\"false_easting\",40000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"British chain (Benoit 18");
    add_srs_wkt (p, 13,
        "95 B)\",20.11678249437587,AUTHORITY[\"EPSG\",\"9062\"]],");
    add_srs_wkt (p, 14,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"24571\"]]");
    p = add_epsg_def (filter, first, last, 24600, "epsg", 24600,
        "KOC Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.99878");
    add_proj4text (p, 1,
        "64078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +tow");
    add_proj4text (p, 2,
        "gs84=-294.7,-200.1,525.5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KOC Lambert\",GEOGCS[\"KOC\",DATUM[\"Kuwait_Oil");
    add_srs_wkt (p, 1,
        "_Company\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,29");
    add_srs_wkt (p, 2,
        "3.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-294.7,-200.");
    add_srs_wkt (p, 3,
        "1,525.5,0,0,0,0],AUTHORITY[\"EPSG\",\"6246\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4246\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",32.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",45],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9987864078],PARAMETER[\"false_easting\",1500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",1166200],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24600\"]]");
    p = add_epsg_def (filter, first, last, 24718, "epsg", 24718,
        "La Canoa / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 18N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-273.5,110.6");
    add_srs_wkt (p, 3,
        ",-357.9,0,0,0,0],AUTHORITY[\"EPSG\",\"6247\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4247\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-75],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"24718\"]]");
    p = add_epsg_def (filter, first, last, 24719, "epsg", 24719,
        "La Canoa / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 19N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-273.5,110.6");
    add_srs_wkt (p, 3,
        ",-357.9,0,0,0,0],AUTHORITY[\"EPSG\",\"6247\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4247\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"24719\"]]");
    p = add_epsg_def (filter, first, last, 24720, "epsg", 24720,
        "La Canoa / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 20N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-273.5,110.6");
    add_srs_wkt (p, 3,
        ",-357.9,0,0,0,0],AUTHORITY[\"EPSG\",\"6247\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4247\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-63],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"24720\"]]");
    p = add_epsg_def (filter, first, last, 24817, "epsg", 24817,
        "PSAD56 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 17N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24817\"]]");
    p = add_epsg_def (filter, first, last, 24818, "epsg", 24818,
        "PSAD56 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 18N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24818\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

