/* ====================================================================
 * Copyright (c) 1995-2000 Carnegie Mellon University.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * This work was supported in part by funding from the Defense Advanced 
 * Research Projects Agency and the National Science Foundation of the 
 * United States of America, and the CMU Sphinx Speech Consortium.
 *
 * THIS SOFTWARE IS PROVIDED BY CARNEGIE MELLON UNIVERSITY ``AS IS'' AND 
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY
 * NOR ITS EMPLOYEES BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ====================================================================
 *
 */
/*********************************************************************
 *
 * File: parse_cmd_ln.c
 * 
 * Description: 
 * 
 * Author: 
 * 	Eric H. Thayer (eht@cs.cmu.edu)
 *********************************************************************/

#include "parse_cmd_ln.h"

#include <s3/common.h>
#include <s3/s3.h>

#include <stdio.h>
#include <assert.h>

#include <sys/stat.h>
#include <sys/types.h>

/* defines, parses and (partially) validates the arguments
   given on the command line */

int
parse_cmd_ln(int argc, char *argv[])
{
  uint32      isHelp;
  uint32      isExample;

    const char helpstr[] =  
"Description: \n\
\n\
Display numerical values of resources generated by Sphinx \n\
Current we supoort the following formats \n\
\n\
-tmatfn : transition matrix \n\
\n\
-mixwfn : mixture weight file  \n\
\n\
-gaufn  : mean or variance \n\
\n\
-fullgaufn  : full covariance \n\
\n\
-gaucntn : sufficient statistics for mean and diagonal covariance \n\
\n\
-lambdafn : interpolation weight \n\
\n\
Currently, some parameters can be specified as intervals such as mixture weight.  \n\
\n\
You can also specified -sigfig the number of significant digits by you would like to see. \n\
\n\
and normalize the parameters by -norm";

    const char examplestr[] = 
"Example: \n\
\n\
Print the mean of a Gaussian: \n\
printp -gaufn mean \n\
\n\
Print the variance of a Gaussian: \n\
printp -gaufn var \n\
\n\
Print the sufficient statistic: \n\
printp -gaucntfn gaucnt: \n\
\n\
Print the mixture weights: \n\
printp -mixw mixw\n\
\n\
Print the LDA transformation matrix(es): \n\
printp -lda lda\n\
\n\
Print the interpolation weight: \n\
printp -lambdafn lambda ";

    static arg_t defn[] = {
	{ "-help",
	  ARG_BOOLEAN,
	  "no",
	  "Shows the usage of the tool"},

	{ "-example",
	  ARG_BOOLEAN,
	  "no",
	  "Shows example of how to use the tool"},

	{ "-tmatfn",
	  ARG_STRING,
	  NULL,
	  "The transition matrix parameter file name"},

	{ "-mixwfn",
	  ARG_STRING,
	  NULL,
	  "The mixture weight parameter file name"},

	{ "-mixws",
	  ARG_INT32,
	  NULL,
	  "Start id of mixing weight subinterval"},

	{ "-mixwe",
	  ARG_INT32,
	  NULL,
	  "End id of mixing weight subinterval"},

	{ "-gaufn",
	  ARG_STRING,
	  NULL,
	  "A Gaussian parameter file name (either for means or vars)"},

	{ "-fullgaufn",
	  ARG_STRING,
	  NULL,
	  "A full Gaussian covariance file name"},

	{ "-gaucntfn",
	  ARG_STRING,
	  NULL,
	  "A Gaussian parameter weighted vector file"},

	{ "-regmatcntfn",
	  ARG_STRING,
	  NULL,
	  "MLLR regression matrix count file"},

	{ "-lda",
	  ARG_STRING,
	  NULL,
	  "An LDA transformation file name"},

	{ "-moddeffn",
	  ARG_STRING,
	  NULL,
	  "The model definition file"},

	{ "-lambdafn",
	  ARG_STRING,
	  NULL,
	  "The interpolation weight file"},

	{ "-lambdamin",
	  ARG_FLOAT32,
	  "0",
	  "Print int. wt. >= this"},

	{ "-lambdamax",
	  ARG_FLOAT32,
	  "1",
	  "Print int. wt. <= this"},

	{ "-ts2cbfn",
	  ARG_STRING,
	  NULL,
	  "The tied state to codebook mapping file"},

	{ "-norm",
	  ARG_BOOLEAN,
	  "yes",
	  "Print normalized parameters"},

	{ "-sigfig",
	  ARG_INT32,
	  "4",
	  "Number of significant digits in 'e' notation" },

	{NULL, 0, NULL, NULL},
    };

    cmd_ln_parse(defn, argc, argv, TRUE);

    isHelp    = cmd_ln_int32("-help");
    isExample    = cmd_ln_int32("-example");

    if(isHelp){
      printf("%s\n\n",helpstr);
    }

    if(isExample){
      printf("%s\n\n",examplestr);
    }

    if(isHelp || isExample){
      E_INFO("User asked for help or example.\n");
      exit(0);
    }

    return 0;
}
