/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.BaseHash;
import cds.healpix.BaseHashes;
import cds.healpix.CompassPoint;
import cds.healpix.FlatHashList;
import cds.healpix.HashBits;
import cds.healpix.HashParts;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.NeighbourList;
import cds.healpix.NeighbourSelector;
import cds.healpix.common.math.Math;
import cds.healpix.fillingcurve.FillingCurve2D;
import java.util.EnumSet;

final class HealpixNestedNeighbourSelector
implements NeighbourSelector {
    private final HealpixNested hn;
    private final FillingCurve2D fc;

    HealpixNestedNeighbourSelector(HealpixNested healpixNested) {
        this.hn = healpixNested;
        this.fc = this.hn.fc;
    }

    private final void checkHashRange(long hash) {
        if (hash < 0L || this.hn.nHash <= hash) {
            throw new IllegalArgumentException("Hash value " + hash + " must be in [0, " + this.hn.nHash + "[");
        }
    }

    @Override
    public long neighbour(long hash, CompassPoint.MainWind direction) {
        this.checkHashRange(hash);
        HashParts hashParts = this.hn.decodeRegularHash(hash);
        return this.neighbour(hashParts, direction);
    }

    private long neighbour(HashParts hashParts, CompassPoint.MainWind direction) {
        return this.neighbour(hashParts.baseCellHash(), hashParts.iInBaseCell(), hashParts.jInBaseCell(), direction);
    }

    private long neighbour(int baseCellHash, int iInBaseCell, int jInBaseCell, CompassPoint.MainWind direction) {
        BaseHash baseHash = BaseHashes.get(baseCellHash);
        CompassPoint.MainWind neigBaseCellDirection = this.getNeighbourBaseCellDirection(iInBaseCell += direction.getOffsetSE(), jInBaseCell += direction.getOffsetSW());
        baseCellHash = iInBaseCell;
        iInBaseCell = baseHash.pickRightIndexOnNeighbourSouthToEastAxis(neigBaseCellDirection, iInBaseCell, jInBaseCell, this.hn.nsideRemainderMask);
        jInBaseCell = baseHash.pickRightIndexOnNeighbourSouthToWestAxis(neigBaseCellDirection, baseCellHash, jInBaseCell, this.hn.nsideRemainderMask);
        baseCellHash = baseHash.getNeighbour(neigBaseCellDirection);
        return this.hn.encodeRegularHash(baseCellHash, iInBaseCell, jInBaseCell);
    }

    private CompassPoint.MainWind getNeighbourBaseCellDirection(int iInBaseCell, int jInBaseCell) {
        int neigBaseCellOffsetSE = this.neighbourBaseCellOffset(iInBaseCell);
        int neigBaseCellOffsetSW = this.neighbourBaseCellOffset(jInBaseCell);
        return CompassPoint.MainWind.getFromOffset(neigBaseCellOffsetSE, neigBaseCellOffsetSW);
    }

    private int neighbourBaseCellOffset(int cooInBaseCell) {
        int off = cooInBaseCell >> 31 | cooInBaseCell >> this.hn.depth;
        assert (cooInBaseCell == -1 && off == -1 || cooInBaseCell == this.hn.nside && off == 1 || 0 <= cooInBaseCell && cooInBaseCell < this.hn.nside && off == 0);
        return off;
    }

    @Override
    public NeighbourList neighbours(long hash) {
        NeighbourList result = new NeighbourList(this.hn.depth);
        this.neighbours(hash, result);
        return result;
    }

    @Override
    public void neighbours(long hash, FlatHashList result) {
        this.checkHashRange(hash);
        result.clear();
        HashBits hBits = this.hn.pullBitsApart(hash);
        if (this.isInBaseCellBorderFromBits(hBits.iInD0hBits, hBits.jInD0hBits)) {
            this.edgeCellNeighbours(hash, result);
        } else {
            this.innerCellNeighbours(hBits.d0hBits, hBits.iInD0hBits, hBits.jInD0hBits, result);
        }
    }

    @Override
    public void neighbours(long hash, NeighbourList result) {
        this.checkHashRange(hash);
        result.clear();
        HashBits hBits = this.hn.pullBitsApart(hash);
        if (this.isInBaseCellBorderFromBits(hBits.iInD0hBits, hBits.jInD0hBits)) {
            this.edgeCellNeighbours(hash, result);
        } else {
            this.innerCellNeighbours(hBits.d0hBits, hBits.iInD0hBits, hBits.jInD0hBits, result);
        }
    }

    @Override
    public NeighbourList neighbours(long hash, EnumSet<CompassPoint.MainWind> directions) {
        NeighbourList result = new NeighbourList(this.hn.depth);
        this.neighbours(hash, directions, result);
        return result;
    }

    @Override
    public void neighbours(long hash, EnumSet<CompassPoint.MainWind> directions, NeighbourList result) {
        this.checkHashRange(hash);
        HashBits hBits = this.hn.pullBitsApart(hash);
        result.clear();
        if (this.isInBaseCellBorderFromBits(hBits.iInD0hBits, hBits.jInD0hBits)) {
            this.edgeCellNeighbours(hash, directions, result);
        } else {
            this.innerCellNeighbours(hBits.d0hBits, hBits.iInD0hBits, hBits.jInD0hBits, directions, result);
        }
    }

    private boolean isInBaseCellBorderFromBits(long iInBaseCellBits, long jInBaseCellBits) {
        return 0L == iInBaseCellBits || iInBaseCellBits == this.hn.xMask || 0L == jInBaseCellBits || jInBaseCellBits == this.hn.yMask;
    }

    private void innerCellNeighbours(long d0hBits, long iBits, long jBits, FlatHashList result) {
        long ij = this.fc.hash2ij(iBits | jBits);
        int i = this.fc.ij2i(ij);
        int j = this.fc.ij2j(ij);
        ij = this.fc.ij2hash(i - 1, j - 1);
        long jm1Bits = ij & this.hn.yMask;
        long im1Bits = ij & this.hn.xMask;
        ij = this.fc.ij2hash(i + 1, j + 1);
        long jp1Bits = ij & this.hn.yMask;
        long ip1Bits = ij & this.hn.xMask;
        result.put(HealpixNested.bits2hash(d0hBits, im1Bits, jm1Bits));
        result.put(HealpixNested.bits2hash(d0hBits, iBits, jm1Bits));
        result.put(HealpixNested.bits2hash(d0hBits, ip1Bits, jm1Bits));
        result.put(HealpixNested.bits2hash(d0hBits, im1Bits, jBits));
        result.put(HealpixNested.bits2hash(d0hBits, ip1Bits, jBits));
        result.put(HealpixNested.bits2hash(d0hBits, im1Bits, jp1Bits));
        result.put(HealpixNested.bits2hash(d0hBits, iBits, jp1Bits));
        result.put(HealpixNested.bits2hash(d0hBits, ip1Bits, jp1Bits));
    }

    private void innerCellNeighbours(long d0hBits, long iBits, long jBits, NeighbourList result) {
        long ij = this.fc.hash2ij(iBits | jBits);
        int i = this.fc.ij2i(ij);
        int j = this.fc.ij2j(ij);
        ij = this.fc.ij2hash(i - 1, j - 1);
        long jm1Bits = ij & this.hn.yMask;
        long im1Bits = ij & this.hn.xMask;
        ij = this.fc.ij2hash(i + 1, j + 1);
        long jp1Bits = ij & this.hn.yMask;
        long ip1Bits = ij & this.hn.xMask;
        result.put(HealpixNested.bits2hash(d0hBits, im1Bits, jm1Bits), CompassPoint.MainWind.S);
        result.put(HealpixNested.bits2hash(d0hBits, iBits, jm1Bits), CompassPoint.MainWind.SE);
        result.put(HealpixNested.bits2hash(d0hBits, ip1Bits, jm1Bits), CompassPoint.MainWind.E);
        result.put(HealpixNested.bits2hash(d0hBits, im1Bits, jBits), CompassPoint.MainWind.SW);
        result.put(HealpixNested.bits2hash(d0hBits, ip1Bits, jBits), CompassPoint.MainWind.NE);
        result.put(HealpixNested.bits2hash(d0hBits, im1Bits, jp1Bits), CompassPoint.MainWind.W);
        result.put(HealpixNested.bits2hash(d0hBits, iBits, jp1Bits), CompassPoint.MainWind.NW);
        result.put(HealpixNested.bits2hash(d0hBits, ip1Bits, jp1Bits), CompassPoint.MainWind.N);
    }

    private void innerCellNeighbours(long d0hBits, long iBits, long jBits, EnumSet<CompassPoint.MainWind> directions, NeighbourList result) {
        long ij = this.fc.hash2ij(iBits | jBits);
        int i = this.fc.ij2i(ij);
        int j = this.fc.ij2j(ij);
        ij = this.fc.ij2hash(i - 1, j - 1);
        long jm1Bits = ij & this.hn.yMask;
        long im1Bits = ij & this.hn.xMask;
        ij = this.fc.ij2hash(i + 1, j + 1);
        long jp1Bits = ij & this.hn.yMask;
        long ip1Bits = ij & this.hn.xMask;
        for (CompassPoint.MainWind mw : directions) {
            long nHash = HealpixNested.bits2hash(d0hBits, mw.pickRightSouthToEastLongValue(im1Bits, iBits, ip1Bits), mw.pickRightSouthToWestLongValue(jm1Bits, jBits, jp1Bits));
            HealpixNestedNeighbourSelector.addNeighbour(nHash, CompassPoint.MainWind.SE, result);
        }
    }

    private void edgeCellNeighbours(long hash, FlatHashList result) {
        HashParts hashParts = this.hn.decodeRegularHash(hash);
        this.edgeCellNeighbours(hashParts, result);
    }

    private void edgeCellNeighbours(long hash, NeighbourList result) {
        HashParts hashParts = this.hn.decodeRegularHash(hash);
        this.edgeCellNeighbours(hashParts, result);
    }

    private void edgeCellNeighbours(HashParts hashParts, FlatHashList result) {
        HealpixNestedNeighbourSelector.addNeighbourIfExists(this.neighbour(hashParts, CompassPoint.MainWind.S), result);
        HealpixNestedNeighbourSelector.addNeighbour(this.neighbour(hashParts, CompassPoint.MainWind.SE), result);
        HealpixNestedNeighbourSelector.addNeighbourIfExists(this.neighbour(hashParts, CompassPoint.MainWind.E), result);
        HealpixNestedNeighbourSelector.addNeighbour(this.neighbour(hashParts, CompassPoint.MainWind.SW), result);
        HealpixNestedNeighbourSelector.addNeighbour(this.neighbour(hashParts, CompassPoint.MainWind.NE), result);
        HealpixNestedNeighbourSelector.addNeighbourIfExists(this.neighbour(hashParts, CompassPoint.MainWind.W), result);
        HealpixNestedNeighbourSelector.addNeighbour(this.neighbour(hashParts, CompassPoint.MainWind.NW), result);
        HealpixNestedNeighbourSelector.addNeighbourIfExists(this.neighbour(hashParts, CompassPoint.MainWind.N), result);
    }

    private void edgeCellNeighbours(HashParts hashParts, NeighbourList result) {
        HealpixNestedNeighbourSelector.addNeighbourIfExists(this.neighbour(hashParts, CompassPoint.MainWind.S), CompassPoint.MainWind.S, result);
        HealpixNestedNeighbourSelector.addNeighbour(this.neighbour(hashParts, CompassPoint.MainWind.SE), CompassPoint.MainWind.SE, result);
        HealpixNestedNeighbourSelector.addNeighbourIfExists(this.neighbour(hashParts, CompassPoint.MainWind.E), CompassPoint.MainWind.E, result);
        HealpixNestedNeighbourSelector.addNeighbour(this.neighbour(hashParts, CompassPoint.MainWind.SW), CompassPoint.MainWind.SW, result);
        HealpixNestedNeighbourSelector.addNeighbour(this.neighbour(hashParts, CompassPoint.MainWind.NE), CompassPoint.MainWind.NE, result);
        HealpixNestedNeighbourSelector.addNeighbourIfExists(this.neighbour(hashParts, CompassPoint.MainWind.W), CompassPoint.MainWind.W, result);
        HealpixNestedNeighbourSelector.addNeighbour(this.neighbour(hashParts, CompassPoint.MainWind.NW), CompassPoint.MainWind.NW, result);
        HealpixNestedNeighbourSelector.addNeighbourIfExists(this.neighbour(hashParts, CompassPoint.MainWind.N), CompassPoint.MainWind.N, result);
    }

    private void edgeCellNeighbours(long hash, EnumSet<CompassPoint.MainWind> directions, NeighbourList neighbours) {
        HashParts hashParts = this.hn.decodeRegularHash(hash);
        for (CompassPoint.MainWind direction : directions) {
            long neigHash = this.neighbour(hashParts, direction);
            HealpixNestedNeighbourSelector.addNeighbourIfExists(neigHash, direction, neighbours);
        }
    }

    private static void addNeighbour(long neighbourHash, CompassPoint.MainWind direction, NeighbourList neighbours) {
        neighbours.put(neighbourHash, direction);
    }

    private static void addNeighbourIfExists(long neighbourHash, CompassPoint.MainWind direction, NeighbourList neighbours) {
        if (neighbourHash >= 0L) {
            HealpixNestedNeighbourSelector.addNeighbour(neighbourHash, direction, neighbours);
        }
    }

    private static void addNeighbour(long neighbourHash, FlatHashList result) {
        result.put(neighbourHash);
    }

    private static void addNeighbourIfExists(long neighbourHash, FlatHashList result) {
        if (neighbourHash >= 0L) {
            HealpixNestedNeighbourSelector.addNeighbour(neighbourHash, result);
        }
    }

    @Override
    public FlatHashList internalEdges(long hash, int deltaDepth) {
        assert (1 < deltaDepth && deltaDepth < 30);
        int n = (1 << deltaDepth) - 1 << 2;
        FlatHashList result = new FlatHashList(this.hn.depth + deltaDepth, n);
        this.internalEdges(hash, deltaDepth, result);
        return result;
    }

    @Override
    public FlatHashList sortedInternalEdges(long hash, int deltaDepth) {
        assert (1 < deltaDepth && deltaDepth < 30);
        int n = (1 << deltaDepth) - 1 << 1;
        FlatHashList result = new FlatHashList(this.hn.depth + deltaDepth, n);
        this.sortedInternalEdges(hash, deltaDepth, result);
        return result;
    }

    @Override
    public FlatHashList sortedInternalEdge(long hash, int deltaDepth, CompassPoint.Ordinal direction) {
        FlatHashList result = new FlatHashList(this.hn.depth + deltaDepth, 1 << deltaDepth);
        this.sortedInternalEdge(hash, deltaDepth, direction, result);
        return result;
    }

    @Override
    public void sortedInternalEdge(long hash, int deltaDepth, CompassPoint.Ordinal direction, FlatHashList result) {
        direction.orderedInternalEdge(this, hash, deltaDepth, result);
    }

    @Override
    public FlatHashList sortedInternalEdgeSE(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.hn.depth + deltaDepth, 1 << deltaDepth);
        this.sortedInternalEdgeSE(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedInternalEdgeSE(long hash, int deltaDepth, FlatHashList result) {
        hash <<= deltaDepth << 1;
        int nSide = 1 << deltaDepth;
        for (int x = 0; x < nSide; ++x) {
            result.hList[x] = hash | Healpix.getNested((int)deltaDepth).fc.i02hash(x);
        }
        result.size = nSide;
    }

    @Override
    public FlatHashList sortedInternalEdgeNE(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.hn.depth + deltaDepth, 1 << deltaDepth);
        this.sortedInternalEdgeNE(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedInternalEdgeNE(long hash, int deltaDepth, FlatHashList result) {
        hash <<= deltaDepth << 1;
        int nSide = 1 << deltaDepth;
        int x = java.lang.Math.max(0, nSide - 1);
        for (int y = 0; y < nSide; ++y) {
            result.hList[y] = hash | Healpix.getNested((int)deltaDepth).fc.ij2hash(x, y);
        }
        result.size = nSide;
    }

    @Override
    public FlatHashList sortedInternalEdgeNW(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.hn.depth + deltaDepth, 1 << deltaDepth);
        this.sortedInternalEdgeNW(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedInternalEdgeNW(long hash, int deltaDepth, FlatHashList result) {
        hash <<= deltaDepth << 1;
        int nSide = 1 << deltaDepth;
        int y = java.lang.Math.max(0, nSide - 1);
        for (int x = 0; x < nSide; ++x) {
            result.hList[x] = hash | Healpix.getNested((int)deltaDepth).fc.ij2hash(x, y);
        }
        result.size = nSide;
    }

    @Override
    public FlatHashList sortedInternalEdgeSW(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.hn.depth + deltaDepth, 1 << deltaDepth);
        this.sortedInternalEdgeSW(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedInternalEdgeSW(long hash, int deltaDepth, FlatHashList result) {
        hash <<= deltaDepth << 1;
        int nSide = 1 << deltaDepth;
        for (int y = 0; y < nSide; ++y) {
            result.hList[y] = hash | Healpix.getNested((int)deltaDepth).fc.i02hash(y) << 1;
        }
        result.size = nSide;
    }

    @Override
    public void internalEdges(long hash, int toEdgeDeltaDepth, FlatHashList result) {
        long xMaskDD = HealpixNestedNeighbourSelector.xMask(toEdgeDeltaDepth);
        long yMaskDD = HealpixNestedNeighbourSelector.yMask(toEdgeDeltaDepth);
        hash <<= toEdgeDeltaDepth << 1;
        assert (toEdgeDeltaDepth << 1 == 2 * toEdgeDeltaDepth);
        int am1 = (1 << toEdgeDeltaDepth) - 1;
        assert ((double)(1 << toEdgeDeltaDepth) == Math.pow(2.0, toEdgeDeltaDepth));
        int k1 = am1;
        int k2 = am1 << 1;
        int k3 = am1 << 2;
        result.hList[0] = hash;
        result.hList[k1++] = hash | xMaskDD;
        result.hList[k2] = hash | yMaskDD | xMaskDD;
        k2 += k1;
        result.hList[--k2] = hash | yMaskDD;
        for (int k0 = 1; k0 < am1; ++k0) {
            long kx = this.fc.i02hash(k0);
            long ky = kx << 1;
            result.hList[k0] = hash | kx;
            result.hList[k1++] = hash | ky | xMaskDD;
            result.hList[--k2] = hash | yMaskDD | kx;
            result.hList[--k3] = hash | ky;
        }
        result.size = am1 << 2;
        assert (result.size == 4 * am1);
    }

    @Override
    public void sortedInternalEdges(long hash, int toEdgeDeltaDepth, FlatHashList result) {
        long xMaskDD = HealpixNestedNeighbourSelector.xMask(toEdgeDeltaDepth);
        long yMaskDD = HealpixNestedNeighbourSelector.yMask(toEdgeDeltaDepth);
        hash <<= toEdgeDeltaDepth << 1;
        assert (toEdgeDeltaDepth << 1 == 2 * toEdgeDeltaDepth);
        int nSide = 1 << toEdgeDeltaDepth;
        int am1 = nSide - 1;
        int nHalfSide = nSide >>> 1;
        int x = 1;
        int k0 = 0;
        int lim = 2;
        int k1 = 2;
        int k2 = am1 + nHalfSide;
        int k3 = (am1 << 1) + nHalfSide;
        int size = am1 << 2;
        result.hList[k0++] = hash;
        result.hList[k2 - 1] = hash | xMaskDD;
        result.hList[k3 - 1] = hash | yMaskDD;
        result.hList[size - k0] = hash | yMaskDD | xMaskDD;
        while (x < nHalfSide) {
            long xs = this.fc.ij2hash(x++, nSide - x);
            long xn = xs & yMaskDD;
            result.hList[k0++] = hash | (xs &= xMaskDD);
            result.hList[k1++] = hash | xs << 1;
            result.hList[k2++] = hash | xs << 1 | xMaskDD;
            result.hList[k3++] = hash | yMaskDD | xs;
            result.hList[size - k0] = hash | yMaskDD | xn >> 1;
            result.hList[size - k1] = hash | xn | xMaskDD;
            result.hList[size - k2] = hash | xn;
            result.hList[size - k3] = hash | xn >> 1;
            int tmp = x & lim;
            assert (x < lim && tmp == 0 || x == lim && tmp == x);
            k0 += tmp >> 1;
            k1 += tmp;
            assert (x < lim && (tmp -= x) < 0 || x == lim && tmp == 0);
            tmp = 1 >> tmp;
            assert (x < lim && tmp == 0 || x == lim && tmp == 1);
            lim <<= tmp;
        }
        result.size = am1 << 2;
        assert (result.size == 4 * (nSide - 1));
    }

    @Override
    public long internalCorner(long hash, int toEdgeDeltaDepth, CompassPoint.Cardinal direction) {
        return direction.internalCorner(this, hash, toEdgeDeltaDepth);
    }

    @Override
    public long internalCornerN(long hash, int toEdgeDeltaDepth) {
        return (hash <<= toEdgeDeltaDepth << 1) | HealpixNestedNeighbourSelector.xyMask(toEdgeDeltaDepth);
    }

    @Override
    public long internalCornerS(long hash, int toEdgeDeltaDepth) {
        return hash <<= toEdgeDeltaDepth << 1;
    }

    @Override
    public long internalCornerE(long hash, int toEdgeDeltaDepth) {
        return (hash <<= toEdgeDeltaDepth << 1) | HealpixNestedNeighbourSelector.xMask(toEdgeDeltaDepth);
    }

    @Override
    public long internalCornerW(long hash, int toEdgeDeltaDepth) {
        return (hash <<= toEdgeDeltaDepth << 1) | HealpixNestedNeighbourSelector.yMask(toEdgeDeltaDepth);
    }

    void appendSortedInternalEdgeElement(long hash, int toEdgeDeltaDepth, CompassPoint.MainWind direction, FlatHashList result) {
        if (direction.isCardinal()) {
            result.put(this.internalCorner(hash, toEdgeDeltaDepth, direction.toCardinal()));
        } else if (direction.isOrdinal()) {
            result.put(this.sortedInternalEdge(hash, toEdgeDeltaDepth, direction.toOrdinal()));
        } else {
            throw new IllegalArgumentException("Main wind " + (Object)((Object)direction) + " is neither ordinal not cardinal.");
        }
    }

    @Override
    public FlatHashList externalEdges(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.hn.depth + deltaDepth, 4 + (4 << deltaDepth));
        this.externalEdges(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void externalEdges(long hash, int toEdgeDeltaDepth, FlatHashList result) {
        this.externalEdges(hash, toEdgeDeltaDepth, result, false);
    }

    @Override
    public FlatHashList sortedExternalEdges(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.hn.depth + deltaDepth, 4 + (4 << deltaDepth));
        this.sortedExternalEdges(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedExternalEdges(long hash, int toEdgeDeltaDepth, FlatHashList result) {
        this.externalEdges(hash, toEdgeDeltaDepth, result, true);
    }

    private void externalEdges(long hash, int toEdgeDeltaDepth, FlatHashList result, boolean sorted) {
        this.checkHashRange(hash);
        result.clear();
        NeighbourList neihbours = new NeighbourList(this.hn.depth);
        HashBits hBits = this.hn.pullBitsApart(hash);
        if (this.isInBaseCellBorderFromBits(hBits.iInD0hBits, hBits.jInD0hBits)) {
            HashParts hashParts = this.hn.decodeRegularHash(hash);
            BaseHash baseHash = BaseHashes.get(hashParts.baseCellHash());
            this.edgeCellNeighbours(hashParts, neihbours);
            if (sorted) {
                neihbours.sortByHashAsc();
            }
            for (int i = 0; i < neihbours.size(); ++i) {
                long neigHash = neihbours.get(i);
                CompassPoint.MainWind neigDirection = neihbours.getDirection(i);
                CompassPoint.MainWind dirFromNeig = (long)hashParts.baseCellHash() == neigHash >> (this.hn.depth << 1) ? neigDirection.getOppositeDirection() : (this.hn.depth == 0 ? baseHash.getDirectionFromNeighbour(neigDirection) : baseHash.getEdgeCellDirectionFromNeighbour(this.directionInBaseCellBorder(hBits.iInD0hBits, hBits.jInD0hBits), neigDirection));
                this.appendSortedInternalEdgeElement(neigHash, toEdgeDeltaDepth, dirFromNeig, result);
            }
        } else {
            this.innerCellNeighbours(hBits.d0hBits, hBits.iInD0hBits, hBits.jInD0hBits, neihbours);
            if (sorted) {
                neihbours.sortByHashAsc();
            }
            for (int i = 0; i < neihbours.size(); ++i) {
                long neigHash = neihbours.get(i);
                CompassPoint.MainWind neigDirection = neihbours.getDirection(i);
                this.appendSortedInternalEdgeElement(neigHash, toEdgeDeltaDepth, neigDirection.getOppositeDirection(), result);
            }
        }
    }

    private CompassPoint.MainWind directionInBaseCellBorder(long iInD0hBits, long jInD0hBits) {
        int i = 1;
        int j = 1;
        if (iInD0hBits == 0L) {
            i = 0;
        } else if (iInD0hBits == this.hn.xMask) {
            i = 2;
        }
        if (jInD0hBits == 0L) {
            j = 0;
        } else if (jInD0hBits == this.hn.yMask) {
            j = 2;
        }
        return CompassPoint.MainWind.getFromCoo(i, j);
    }

    private static long xMask(int depth) {
        return 0x5555555555555555L >>> 64 - (depth << 1);
    }

    private static long yMask(int depth) {
        return -6148914691236517206L >>> 64 - (depth << 1);
    }

    private static long xyMask(int depth) {
        return -1L >>> 64 - (depth << 1);
    }
}

