#region License
/*
MIT License
Copyright 2003-2006 Tao Framework Team
http://www.taoframework.com
All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
#endregion License

using System;
using System.Runtime.InteropServices;
using System.Security;

namespace Tao.OpenGl {
    #region Class Documentation
    /// <summary>
    ///     GLU (OpenGL Utility) binding for .NET, implementing GLU 1.3.
    /// </summary>
    /// <remarks>
    ///     <para>
    ///         Binds functions and definitions in glu32.dll or libGLU.so.
    ///     </para>
    ///     <para>
    ///         The OpenGL Utility (GLU) library contains several groups of functions that
    ///         complement the core OpenGL interface by providing support for auxiliary features.
    ///         These features include: mipmapping, matrix manipulation, polygon tessellation,
    ///         quadrics, NURBS, and error handling.
    ///     </para>
    ///     <para>
    ///         Mipmapping routines include image scaling and automatic mipmap generation.  A
    ///         variety of matrix manipulation functions build projection and viewing matrices,
    ///         or project vertices from one coordinate system to another.  Polygon tessellation
    ///         routines convert concave polygons into triangles for easy rendering.  Quadrics
    ///         support renders a few basic quadrics such as spheres and cones.  NURBS code maps
    ///         complicated NURBS curves and trimmed surfaces into simpler OpenGL evaluators.
    ///         Lastly, an error lookup routine translates OpenGL and GLU error codes into
    ///         strings.  GLU library routines may call OpenGL library routines.  Thus, an OpenGL
    ///         context should be made current before calling any GLU functions.  Otherwise an
    ///         OpenGL error may occur.
    ///     </para>
    ///     <para>
    ///         These utility functions make use of core OpenGL functions, so any OpenGL
    ///         implementation is guaranteed to support the utility functions.
    ///     </para>
    /// </remarks>
    #endregion Class Documentation
    public static class Glu
    {
        // --- Fields ---
        #region Private Constants
        #region CallingConvention CALLING_CONVENTION
        /// <summary>
        ///     Specifies the calling convention.
        /// </summary>
        /// <remarks>
        ///     Specifies <see cref="CallingConvention.Winapi" /> for Windows and
        ///     Linux, to indicate that the default should be used.
        /// </remarks>
        private const CallingConvention CALLING_CONVENTION = CallingConvention.Winapi;
        #endregion CallingConvention CALLING_CONVENTION
        #endregion Private Constants

        #region Public Constants
        #region Version
        #region bool GLU_VERSION_1_1
        /// <summary>
        ///     GLU API revision.
        /// </summary>
        /// <remarks>
        ///     Specifies GLU 1.1.
        /// </remarks>
        // #define GLU_VERSION_1_1 1
        public const bool GLU_VERSION_1_1 = true;
        #endregion bool GLU_VERSION_1_1

        #region bool GLU_VERSION_1_2
        /// <summary>
        ///     GLU API revision.
        /// </summary>
        /// <remarks>
        ///     Specifies GLU 1.2.
        /// </remarks>
        // #define GLU_VERSION_1_2 1
        public const bool GLU_VERSION_1_2 = true;
        #endregion bool GLU_VERSION_1_2

        #region bool GLU_VERSION_1_3
        /// <summary>
        ///     GLU API revision.
        /// </summary>
        /// <remarks>
        ///     Specifies GLU 1.3.
        /// </remarks>
        // #define GLU_VERSION_1_3 1
        public const bool GLU_VERSION_1_3 = true;
        #endregion bool GLU_VERSION_1_3
        #endregion Version

        #region Errors
        #region int GLU_INVALID_ENUM
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_INVALID_ENUM 100900
        public const int GLU_INVALID_ENUM = 100900;
        #endregion int GLU_INVALID_ENUM

        #region int GLU_INVALID_VALUE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_INVALID_VALUE 100901
        public const int GLU_INVALID_VALUE = 100901;
        #endregion int GLU_INVALID_VALUE

        #region int GLU_OUT_OF_MEMORY
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_OUT_OF_MEMORY 100902
        public const int GLU_OUT_OF_MEMORY = 100902;
        #endregion int GLU_OUT_OF_MEMORY

        #region int GLU_INCOMPATIBLE_GL_VERSION
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_INCOMPATIBLE_GL_VERSION 100903
        public const int GLU_INCOMPATIBLE_GL_VERSION = 100903;
        #endregion int GLU_INCOMPATIBLE_GL_VERSION

        #region int GLU_INVALID_OPERATION
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_INVALID_OPERATION 100904
        public const int GLU_INVALID_OPERATION = 100904;
        #endregion int GLU_INVALID_OPERATION
        #endregion Errors

        #region StringName
        #region int GLU_VERSION
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_VERSION 100800
        public const int GLU_VERSION = 100800;
        #endregion int GLU_VERSION

        #region int GLU_EXTENSIONS
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_EXTENSIONS 100801
        public const int GLU_EXTENSIONS = 100801;
        #endregion int GLU_EXTENSIONS
        #endregion StringName

        #region bool
        #region int GLU_TRUE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TRUE GL_TRUE
        public const int GLU_TRUE = 1;
        #endregion int GLU_TRUE

        #region int GLU_FALSE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_FALSE GL_FALSE
        public const int GLU_FALSE = 0;
        #endregion int GLU_FALSE
        #endregion bool

        #region QuadricNormal
        #region int GLU_SMOOTH
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_SMOOTH 100000
        public const int GLU_SMOOTH = 100000;
        #endregion int GLU_SMOOTH

        #region int GLU_FLAT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_FLAT 100001
        public const int GLU_FLAT = 100001;
        #endregion int GLU_FLAT

        #region int GLU_NONE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NONE 100002
        public const int GLU_NONE = 100002;
        #endregion int GLU_NONE
        #endregion QuadricNormal

        #region QuadricDrawStyle
        #region int GLU_POINT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_POINT 100010
        public const int GLU_POINT = 100010;
        #endregion int GLU_POINT

        #region int GLU_LINE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_LINE 100011
        public const int GLU_LINE = 100011;
        #endregion int GLU_LINE

        #region int GLU_FILL
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_FILL 100012
        public const int GLU_FILL = 100012;
        #endregion int GLU_FILL

        #region int GLU_SILHOUETTE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_SILHOUETTE 100013
        public const int GLU_SILHOUETTE = 100013;
        #endregion int GLU_SILHOUETTE
        #endregion QuadricDrawStyle

        #region QuadraticOrientation
        #region int GLU_OUTSIDE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_OUTSIDE 100020
        public const int GLU_OUTSIDE = 100020;
        #endregion int GLU_OUTSIDE

        #region int GLU_INSIDE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_INSIDE 100021
        public const int GLU_INSIDE = 100021;
        #endregion int GLU_INSIDE
        #endregion QuadraticOrientation

        #region Tesselation Limits
        #region double GLU_TESS_MAX_COORD
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_MAX_COORD 1.0e150
        public const double GLU_TESS_MAX_COORD = 1.0e150;
        #endregion double GLU_TESS_MAX_COORD
        #endregion Tesselation Limits

        #region TessProperty
        #region int GLU_TESS_WINDING_RULE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_WINDING_RULE 100140
        public const int GLU_TESS_WINDING_RULE = 100140;
        #endregion int GLU_TESS_WINDING_RULE

        #region int GLU_TESS_BOUNDARY_ONLY
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_BOUNDARY_ONLY 100141
        public const int GLU_TESS_BOUNDARY_ONLY = 100141;
        #endregion int GLU_TESS_BOUNDARY_ONLY

        #region int GLU_TESS_TOLERANCE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_TOLERANCE 100142
        public const int GLU_TESS_TOLERANCE = 100142;
        #endregion int GLU_TESS_TOLERANCE
        #endregion TessProperty

        #region TessWinding
        #region int GLU_TESS_WINDING_ODD
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_WINDING_ODD 100130
        public const int GLU_TESS_WINDING_ODD = 100130;
        #endregion int GLU_TESS_WINDING_ODD

        #region int GLU_TESS_WINDING_NONZERO
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_WINDING_NONZERO 100131
        public const int GLU_TESS_WINDING_NONZERO = 100131;
        #endregion int GLU_TESS_WINDING_NONZERO

        #region int GLU_TESS_WINDING_POSITIVE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_WINDING_POSITIVE 100132
        public const int GLU_TESS_WINDING_POSITIVE = 100132;
        #endregion int GLU_TESS_WINDING_POSITIVE

        #region int GLU_TESS_WINDING_NEGATIVE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_WINDING_NEGATIVE 100133
        public const int GLU_TESS_WINDING_NEGATIVE = 100133;
        #endregion int GLU_TESS_WINDING_NEGATIVE

        #region int GLU_TESS_WINDING_ABS_GEQ_TWO
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_WINDING_ABS_GEQ_TWO 100134
        public const int GLU_TESS_WINDING_ABS_GEQ_TWO = 100134;
        #endregion int GLU_TESS_WINDING_ABS_GEQ_TWO
        #endregion TessWinding

        #region TessCallback
        #region int GLU_TESS_BEGIN
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_BEGIN 100100
        public const int GLU_TESS_BEGIN = 100100;
        #endregion int GLU_TESS_BEGIN

        #region int GLU_BEGIN
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_BEGIN 100100
        public const int GLU_BEGIN = 100100;
        #endregion int GLU_BEGIN

        #region int GLU_TESS_VERTEX
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_VERTEX 100101
        public const int GLU_TESS_VERTEX = 100101;
        #endregion int GLU_TESS_VERTEX

        #region int GLU_VERTEX
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_VERTEX 100101
        public const int GLU_VERTEX = 100101;
        #endregion int GLU_VERTEX

        #region int GLU_TESS_END
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_END 100102
        public const int GLU_TESS_END = 100102;
        #endregion int GLU_TESS_END

        #region int GLU_END
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_END 100102
        public const int GLU_END = 100102;
        #endregion int GLU_END

        #region int GLU_TESS_ERROR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_ERROR 100103
        public const int GLU_TESS_ERROR = 100103;
        #endregion int GLU_TESS_ERROR

        #region int GLU_TESS_EDGE_FLAG
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_EDGE_FLAG 100104
        public const int GLU_TESS_EDGE_FLAG = 100104;
        #endregion int GLU_TESS_EDGE_FLAG

        #region int GLU_EDGE_FLAG
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_EDGE_FLAG 100104
        public const int GLU_EDGE_FLAG = 100104;
        #endregion int GLU_EDGE_FLAG

        #region int GLU_TESS_COMBINE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_COMBINE 100105
        public const int GLU_TESS_COMBINE = 100105;
        #endregion int GLU_TESS_COMBINE

        #region int GLU_TESS_BEGIN_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_BEGIN_DATA 100106
        public const int GLU_TESS_BEGIN_DATA = 100106;
        #endregion int GLU_TESS_BEGIN_DATA

        #region int GLU_TESS_VERTEX_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_VERTEX_DATA 100107
        public const int GLU_TESS_VERTEX_DATA = 100107;
        #endregion int GLU_TESS_VERTEX_DATA

        #region int GLU_TESS_END_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_END_DATA 100108
        public const int GLU_TESS_END_DATA = 100108;
        #endregion int GLU_TESS_END_DATA

        #region int GLU_TESS_ERROR_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_ERROR_DATA 100109
        public const int GLU_TESS_ERROR_DATA = 100109;
        #endregion int GLU_TESS_ERROR_DATA

        #region int GLU_TESS_EDGE_FLAG_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_EDGE_FLAG_DATA 100110
        public const int GLU_TESS_EDGE_FLAG_DATA = 100110;
        #endregion int GLU_TESS_EDGE_FLAG_DATA

        #region int GLU_TESS_COMBINE_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_COMBINE_DATA 100111
        public const int GLU_TESS_COMBINE_DATA = 100111;
        #endregion int GLU_TESS_COMBINE_DATA
        #endregion TessCallback

        #region TessError
        #region int GLU_TESS_ERROR1
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_ERROR1 100151
        public const int GLU_TESS_ERROR1 = 100151;
        #endregion int GLU_TESS_ERROR1

        #region int GLU_TESS_ERROR2
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_ERROR2 100152
        public const int GLU_TESS_ERROR2 = 100152;
        #endregion int GLU_TESS_ERROR2

        #region int GLU_TESS_ERROR3
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_ERROR3 100153
        public const int GLU_TESS_ERROR3 = 100153;
        #endregion int GLU_TESS_ERROR3

        #region int GLU_TESS_ERROR4
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_ERROR4 100154
        public const int GLU_TESS_ERROR4 = 100154;
        #endregion int GLU_TESS_ERROR4

        #region int GLU_TESS_ERROR5
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_ERROR5 100155
        public const int GLU_TESS_ERROR5 = 100155;
        #endregion int GLU_TESS_ERROR5

        #region int GLU_TESS_ERROR6
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_ERROR6 100156
        public const int GLU_TESS_ERROR6 = 100156;
        #endregion int GLU_TESS_ERROR6

        #region int GLU_TESS_ERROR7
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_ERROR7 100157
        public const int GLU_TESS_ERROR7 = 100157;
        #endregion int GLU_TESS_ERROR7

        #region int GLU_TESS_ERROR8
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_ERROR8 100158
        public const int GLU_TESS_ERROR8 = 100158;
        #endregion int GLU_TESS_ERROR8

        #region int GLU_TESS_MISSING_BEGIN_POLYGON
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_MISSING_BEGIN_POLYGON GLU_TESS_ERROR1
        public const int GLU_TESS_MISSING_BEGIN_POLYGON = GLU_TESS_ERROR1;
        #endregion int GLU_TESS_MISSING_BEGIN_POLYGON

        #region int GLU_TESS_MISSING_BEGIN_CONTOUR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_MISSING_BEGIN_CONTOUR GLU_TESS_ERROR2
        public const int GLU_TESS_MISSING_BEGIN_CONTOUR = GLU_TESS_ERROR2;
        #endregion int GLU_TESS_MISSING_BEGIN_CONTOUR

        #region int GLU_TESS_MISSING_END_POLYGON
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_MISSING_END_POLYGON GLU_TESS_ERROR3
        public const int GLU_TESS_MISSING_END_POLYGON = GLU_TESS_ERROR3;
        #endregion int GLU_TESS_MISSING_END_POLYGON

        #region int GLU_TESS_MISSING_END_CONTOUR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_MISSING_END_CONTOUR GLU_TESS_ERROR4
        public const int GLU_TESS_MISSING_END_CONTOUR = GLU_TESS_ERROR4;
        #endregion int GLU_TESS_MISSING_END_CONTOUR

        #region int GLU_TESS_COORD_TOO_LARGE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_COORD_TOO_LARGE GLU_TESS_ERROR5
        public const int GLU_TESS_COORD_TOO_LARGE = GLU_TESS_ERROR5;
        #endregion int GLU_TESS_COORD_TOO_LARGE

        #region int GLU_TESS_NEED_COMBINE_CALLBACK
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_TESS_NEED_COMBINE_CALLBACK GLU_TESS_ERROR6
        public const int GLU_TESS_NEED_COMBINE_CALLBACK = GLU_TESS_ERROR6;
        #endregion int GLU_TESS_NEED_COMBINE_CALLBACK
        #endregion TessError

        #region NurbsProperty
        #region int GLU_AUTO_LOAD_MATRIX
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_AUTO_LOAD_MATRIX 100200
        public const int GLU_AUTO_LOAD_MATRIX = 100200;
        #endregion int GLU_AUTO_LOAD_MATRIX

        #region int GLU_CULLING
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_CULLING 100201
        public const int GLU_CULLING = 100201;
        #endregion int GLU_CULLING

        #region int GLU_PARAMETRIC_TOLERANCE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_PARAMETRIC_TOLERANCE 100202
        public const int GLU_PARAMETRIC_TOLERANCE = 100202;
        #endregion int GLU_PARAMETRIC_TOLERANCE

        #region int GLU_SAMPLING_TOLERANCE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_SAMPLING_TOLERANCE 100203
        public const int GLU_SAMPLING_TOLERANCE = 100203;
        #endregion int GLU_SAMPLING_TOLERANCE

        #region int GLU_DISPLAY_MODE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_DISPLAY_MODE 100204
        public const int GLU_DISPLAY_MODE = 100204;
        #endregion int GLU_DISPLAY_MODE

        #region int GLU_SAMPLING_METHOD
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_SAMPLING_METHOD 100205
        public const int GLU_SAMPLING_METHOD = 100205;
        #endregion int GLU_SAMPLING_METHOD

        #region int GLU_U_STEP
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_U_STEP 100206
        public const int GLU_U_STEP = 100206;
        #endregion int GLU_U_STEP

        #region int GLU_V_STEP
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_V_STEP 100207
        public const int GLU_V_STEP = 100207;
        #endregion int GLU_V_STEP

        #region int GLU_NURBS_MODE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_MODE 100160
        public const int GLU_NURBS_MODE = 100160;
        #endregion int GLU_NURBS_MODE

        #region int GLU_NURBS_MODE_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_MODE_EXT 100160
        public const int GLU_NURBS_MODE_EXT = 100160;
        #endregion int GLU_NURBS_MODE_EXT

        #region int GLU_NURBS_TESSELLATOR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_TESSELLATOR 100161
        public const int GLU_NURBS_TESSELLATOR = 100161;
        #endregion int GLU_NURBS_TESSELLATOR

        #region int GLU_NURBS_TESSELLATOR_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_TESSELLATOR_EXT 100161
        public const int GLU_NURBS_TESSELLATOR_EXT = 100161;
        #endregion int GLU_NURBS_TESSELLATOR_EXT

        #region int GLU_NURBS_RENDERER
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_RENDERER 100162
        public const int GLU_NURBS_RENDERER = 100162;
        #endregion int GLU_NURBS_RENDERER

        #region int GLU_NURBS_RENDERER_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_RENDERER_EXT 100162
        public const int GLU_NURBS_RENDERER_EXT = 100162;
        #endregion int GLU_NURBS_RENDERER_EXT
        #endregion NurbsProperty

        #region NurbsSampling
        #region int GLU_OBJECT_PARAMETRIC_ERROR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_OBJECT_PARAMETRIC_ERROR 100208
        public const int GLU_OBJECT_PARAMETRIC_ERROR = 100208;
        #endregion int GLU_OBJECT_PARAMETRIC_ERROR

        #region int GLU_OBJECT_PARAMETRIC_ERROR_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_OBJECT_PARAMETRIC_ERROR_EXT 100208
        public const int GLU_OBJECT_PARAMETRIC_ERROR_EXT = 100208;
        #endregion int GLU_OBJECT_PARAMETRIC_ERROR_EXT

        #region int GLU_OBJECT_PATH_LENGTH
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_OBJECT_PATH_LENGTH 100209
        public const int GLU_OBJECT_PATH_LENGTH = 100209;
        #endregion int GLU_OBJECT_PATH_LENGTH

        #region int GLU_OBJECT_PATH_LENGTH_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_OBJECT_PATH_LENGTH_EXT 100209
        public const int GLU_OBJECT_PATH_LENGTH_EXT = 100209;
        #endregion int GLU_OBJECT_PATH_LENGTH_EXT

        #region int GLU_PATH_LENGTH
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_PATH_LENGTH 100215
        public const int GLU_PATH_LENGTH = 100215;
        #endregion int GLU_PATH_LENGTH

        #region int GLU_PARAMETRIC_ERROR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_PARAMETRIC_ERROR 100216
        public const int GLU_PARAMETRIC_ERROR = 100216;
        #endregion int GLU_PARAMETRIC_ERROR

        #region int GLU_DOMAIN_DISTANCE
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_DOMAIN_DISTANCE 100217
        public const int GLU_DOMAIN_DISTANCE = 100217;
        #endregion int GLU_DOMAIN_DISTANCE
        #endregion NurbsSampling

        #region NurbsTrim
        #region int GLU_MAP1_TRIM_2
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_MAP1_TRIM_2 100210
        public const int GLU_MAP1_TRIM_2 = 100210;
        #endregion int GLU_MAP1_TRIM_2

        #region int GLU_MAP1_TRIM_3
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_MAP1_TRIM_3 100211
        public const int GLU_MAP1_TRIM_3 = 100211;
        #endregion int GLU_MAP1_TRIM_3
        #endregion NurbsTrim

        #region NurbsDisplay
        #region int GLU_OUTLINE_POLYGON
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_OUTLINE_POLYGON 100240
        public const int GLU_OUTLINE_POLYGON = 100240;
        #endregion int GLU_OUTLINE_POLYGON

        #region int GLU_OUTLINE_PATCH
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_OUTLINE_PATCH 100241
        public const int GLU_OUTLINE_PATCH = 100241;
        #endregion int GLU_OUTLINE_PATCH
        #endregion NurbsDisplay

        #region NurbsCallback
        #region int GLU_NURBS_ERROR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR 100103
        public const int GLU_NURBS_ERROR = 100103;
        #endregion int GLU_NURBS_ERROR

        #region int GLU_ERROR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_ERROR 100103
        public const int GLU_ERROR = 100103;
        #endregion int GLU_ERROR

        #region int GLU_NURBS_BEGIN
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_BEGIN 100164
        public const int GLU_NURBS_BEGIN = 100164;
        #endregion int GLU_NURBS_BEGIN

        #region int GLU_NURBS_BEGIN_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_BEGIN_EXT 100164
        public const int GLU_NURBS_BEGIN_EXT = 100164;
        #endregion int GLU_NURBS_BEGIN_EXT

        #region int GLU_NURBS_VERTEX
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_VERTEX 100165
        public const int GLU_NURBS_VERTEX = 100165;
        #endregion int GLU_NURBS_VERTEX

        #region int GLU_NURBS_VERTEX_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_VERTEX_EXT 100165
        public const int GLU_NURBS_VERTEX_EXT = 100165;
        #endregion int GLU_NURBS_VERTEX_EXT

        #region int GLU_NURBS_NORMAL
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_NORMAL 100166
        public const int GLU_NURBS_NORMAL = 100166;
        #endregion int GLU_NURBS_NORMAL

        #region int GLU_NURBS_NORMAL_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_NORMAL_EXT 100166
        public const int GLU_NURBS_NORMAL_EXT = 100166;
        #endregion int GLU_NURBS_NORMAL_EXT

        #region int GLU_NURBS_COLOR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_COLOR 100167
        public const int GLU_NURBS_COLOR = 100167;
        #endregion int GLU_NURBS_COLOR

        #region int GLU_NURBS_COLOR_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_COLOR_EXT 100167
        public const int GLU_NURBS_COLOR_EXT = 100167;
        #endregion int GLU_NURBS_COLOR_EXT

        #region int GLU_NURBS_TEXTURE_COORD
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_TEXTURE_COORD 100168
        public const int GLU_NURBS_TEXTURE_COORD = 100168;
        #endregion int GLU_NURBS_TEXTURE_COORD

        #region int GLU_NURBS_TEX_COORD_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_TEX_COORD_EXT 100168
        public const int GLU_NURBS_TEX_COORD_EXT = 100168;
        #endregion int GLU_NURBS_TEX_COORD_EXT

        #region int GLU_NURBS_END
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_END 100169
        public const int GLU_NURBS_END = 100169;
        #endregion int GLU_NURBS_END

        #region int GLU_NURBS_END_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_END_EXT 100169
        public const int GLU_NURBS_END_EXT = 100169;
        #endregion int GLU_NURBS_END_EXT

        #region int GLU_NURBS_BEGIN_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_BEGIN_DATA 100170
        public const int GLU_NURBS_BEGIN_DATA = 100170;
        #endregion int GLU_NURBS_BEGIN_DATA

        #region int GLU_NURBS_BEGIN_DATA_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_BEGIN_DATA_EXT 100170
        public const int GLU_NURBS_BEGIN_DATA_EXT = 100170;
        #endregion int GLU_NURBS_BEGIN_DATA_EXT

        #region int GLU_NURBS_VERTEX_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_VERTEX_DATA 100171
        public const int GLU_NURBS_VERTEX_DATA = 100171;
        #endregion int GLU_NURBS_VERTEX_DATA

        #region int GLU_NURBS_VERTEX_DATA_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_VERTEX_DATA_EXT 100171
        public const int GLU_NURBS_VERTEX_DATA_EXT = 100171;
        #endregion int GLU_NURBS_VERTEX_DATA_EXT

        #region int GLU_NURBS_NORMAL_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_NORMAL_DATA 100172
        public const int GLU_NURBS_NORMAL_DATA = 100172;
        #endregion int GLU_NURBS_NORMAL_DATA

        #region int GLU_NURBS_NORMAL_DATA_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_NORMAL_DATA_EXT 100172
        public const int GLU_NURBS_NORMAL_DATA_EXT = 100172;
        #endregion int GLU_NURBS_NORMAL_DATA_EXT

        #region int GLU_NURBS_COLOR_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_COLOR_DATA 100173
        public const int GLU_NURBS_COLOR_DATA = 100173;
        #endregion int GLU_NURBS_COLOR_DATA

        #region int GLU_NURBS_COLOR_DATA_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_COLOR_DATA_EXT 100173
        public const int GLU_NURBS_COLOR_DATA_EXT = 100173;
        #endregion int GLU_NURBS_COLOR_DATA_EXT

        #region int GLU_NURBS_TEXTURE_COORD_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_TEXTURE_COORD_DATA 100174
        public const int GLU_NURBS_TEXTURE_COORD_DATA = 100174;
        #endregion int GLU_NURBS_TEXTURE_COORD_DATA

        #region int GLU_NURBS_TEX_COORD_DATA_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_TEX_COORD_DATA_EXT 100174
        public const int GLU_NURBS_TEX_COORD_DATA_EXT = 100174;
        #endregion int GLU_NURBS_TEX_COORD_DATA_EXT

        #region int GLU_NURBS_END_DATA
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_END_DATA 100175
        public const int GLU_NURBS_END_DATA = 100175;
        #endregion int GLU_NURBS_END_DATA

        #region int GLU_NURBS_END_DATA_EXT
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_END_DATA_EXT 100175
        public const int GLU_NURBS_END_DATA_EXT = 100175;
        #endregion int GLU_NURBS_END_DATA_EXT
        #endregion NurbsCallback

        #region NurbsErrors
        #region int GLU_NURBS_ERROR1
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR1 100251
        public const int GLU_NURBS_ERROR1 = 100251;
        #endregion int GLU_NURBS_ERROR1

        #region int GLU_NURBS_ERROR2
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR2 100252
        public const int GLU_NURBS_ERROR2 = 100252;
        #endregion int GLU_NURBS_ERROR2

        #region int GLU_NURBS_ERROR3
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR3 100253
        public const int GLU_NURBS_ERROR3 = 100253;
        #endregion int GLU_NURBS_ERROR3

        #region int GLU_NURBS_ERROR4
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR4 100254
        public const int GLU_NURBS_ERROR4 = 100254;
        #endregion int GLU_NURBS_ERROR4

        #region int GLU_NURBS_ERROR5
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR5 100255
        public const int GLU_NURBS_ERROR5 = 100255;
        #endregion int GLU_NURBS_ERROR5

        #region int GLU_NURBS_ERROR6
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR6 100256
        public const int GLU_NURBS_ERROR6 = 100256;
        #endregion int GLU_NURBS_ERROR6

        #region int GLU_NURBS_ERROR7
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR7 100257
        public const int GLU_NURBS_ERROR7 = 100257;
        #endregion int GLU_NURBS_ERROR7

        #region int GLU_NURBS_ERROR8
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR8 100258
        public const int GLU_NURBS_ERROR8 = 100258;
        #endregion int GLU_NURBS_ERROR8

        #region int GLU_NURBS_ERROR9
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR9 100259
        public const int GLU_NURBS_ERROR9 = 100259;
        #endregion int GLU_NURBS_ERROR9

        #region int GLU_NURBS_ERROR10
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR10 100260
        public const int GLU_NURBS_ERROR10 = 100260;
        #endregion int GLU_NURBS_ERROR10

        #region int GLU_NURBS_ERROR11
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR11 100261
        public const int GLU_NURBS_ERROR11 = 100261;
        #endregion int GLU_NURBS_ERROR11

        #region int GLU_NURBS_ERROR12
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR12 100262
        public const int GLU_NURBS_ERROR12 = 100262;
        #endregion int GLU_NURBS_ERROR12

        #region int GLU_NURBS_ERROR13
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR13 100263
        public const int GLU_NURBS_ERROR13 = 100263;
        #endregion int GLU_NURBS_ERROR13

        #region int GLU_NURBS_ERROR14
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR14 100264
        public const int GLU_NURBS_ERROR14 = 100264;
        #endregion int GLU_NURBS_ERROR14

        #region int GLU_NURBS_ERROR15
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR15 100265
        public const int GLU_NURBS_ERROR15 = 100265;
        #endregion int GLU_NURBS_ERROR15

        #region int GLU_NURBS_ERROR16
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR16 100266
        public const int GLU_NURBS_ERROR16 = 100266;
        #endregion int GLU_NURBS_ERROR16

        #region int GLU_NURBS_ERROR17
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR17 100267
        public const int GLU_NURBS_ERROR17 = 100267;
        #endregion int GLU_NURBS_ERROR17

        #region int GLU_NURBS_ERROR18
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR18 100268
        public const int GLU_NURBS_ERROR18 = 100268;
        #endregion int GLU_NURBS_ERROR18

        #region int GLU_NURBS_ERROR19
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR19 100269
        public const int GLU_NURBS_ERROR19 = 100269;
        #endregion int GLU_NURBS_ERROR19

        #region int GLU_NURBS_ERROR20
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR20 100270
        public const int GLU_NURBS_ERROR20 = 100270;
        #endregion int GLU_NURBS_ERROR20

        #region int GLU_NURBS_ERROR21
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR21 100271
        public const int GLU_NURBS_ERROR21 = 100271;
        #endregion int GLU_NURBS_ERROR21

        #region int GLU_NURBS_ERROR22
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR22 100272
        public const int GLU_NURBS_ERROR22 = 100272;
        #endregion int GLU_NURBS_ERROR22

        #region int GLU_NURBS_ERROR23
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR23 100273
        public const int GLU_NURBS_ERROR23 = 100273;
        #endregion int GLU_NURBS_ERROR23

        #region int GLU_NURBS_ERROR24
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR24 100274
        public const int GLU_NURBS_ERROR24 = 100274;
        #endregion int GLU_NURBS_ERROR24

        #region int GLU_NURBS_ERROR25
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR25 100275
        public const int GLU_NURBS_ERROR25 = 100275;
        #endregion int GLU_NURBS_ERROR25

        #region int GLU_NURBS_ERROR26
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR26 100276
        public const int GLU_NURBS_ERROR26 = 100276;
        #endregion int GLU_NURBS_ERROR26

        #region int GLU_NURBS_ERROR27
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR27 100277
        public const int GLU_NURBS_ERROR27 = 100277;
        #endregion int GLU_NURBS_ERROR27

        #region int GLU_NURBS_ERROR28
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR28 100278
        public const int GLU_NURBS_ERROR28 = 100278;
        #endregion int GLU_NURBS_ERROR28

        #region int GLU_NURBS_ERROR29
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR29 100279
        public const int GLU_NURBS_ERROR29 = 100279;
        #endregion int GLU_NURBS_ERROR29

        #region int GLU_NURBS_ERROR30
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR30 100280
        public const int GLU_NURBS_ERROR30 = 100280;
        #endregion int GLU_NURBS_ERROR30

        #region int GLU_NURBS_ERROR31
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR31 100281
        public const int GLU_NURBS_ERROR31 = 100281;
        #endregion int GLU_NURBS_ERROR31

        #region int GLU_NURBS_ERROR32
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR32 100282
        public const int GLU_NURBS_ERROR32 = 100282;
        #endregion int GLU_NURBS_ERROR32

        #region int GLU_NURBS_ERROR33
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR33 100283
        public const int GLU_NURBS_ERROR33 = 100283;
        #endregion int GLU_NURBS_ERROR33

        #region int GLU_NURBS_ERROR34
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR34 100284
        public const int GLU_NURBS_ERROR34 = 100284;
        #endregion int GLU_NURBS_ERROR34

        #region int GLU_NURBS_ERROR35
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR35 100285
        public const int GLU_NURBS_ERROR35 = 100285;
        #endregion int GLU_NURBS_ERROR35

        #region int GLU_NURBS_ERROR36
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR36 100286
        public const int GLU_NURBS_ERROR36 = 100286;
        #endregion int GLU_NURBS_ERROR36

        #region int GLU_NURBS_ERROR37
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_NURBS_ERROR37 100287
        public const int GLU_NURBS_ERROR37 = 100287;
        #endregion int GLU_NURBS_ERROR37
        #endregion NurbsErrors

        #region Contours types
        #region int GLU_CW
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_CW 100120
        public const int GLU_CW = 100120;
        #endregion int GLU_CW

        #region int GLU_CCW
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_CCW 100121
        public const int GLU_CCW = 100121;
        #endregion int GLU_CCW

        #region int GLU_INTERIOR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_INTERIOR 100122
        public const int GLU_INTERIOR = 100122;
        #endregion int GLU_INTERIOR

        #region int GLU_EXTERIOR
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_EXTERIOR 100123
        public const int GLU_EXTERIOR = 100123;
        #endregion int GLU_EXTERIOR

        #region int GLU_UNKNOWN
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_UNKNOWN 100124
        public const int GLU_UNKNOWN = 100124;
        #endregion int GLU_UNKNOWN
        #endregion Contours types

        #region Extensions
        #region int GLU_EXT_object_space_tess
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_EXT_object_space_tess 1
        public const int GLU_EXT_object_space_tess = 1;
        #endregion int GLU_EXT_object_space_tess

        #region int GLU_EXT_nurbs_tessellator
        /// <summary>
        ///     Unknown.  Unable to locate definitive documentation on this constant.
        /// </summary>
        // #define GLU_EXT_nurbs_tessellator 1
        public const int GLU_EXT_nurbs_tessellator = 1;
        #endregion int GLU_EXT_nurbs_tessellator
        #endregion Extensions
        #endregion Public Constants

        #region Public Structs
        #region GLUnurbs
        /// <summary>
        ///     Defines a GLU NURBS object.
        /// </summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct GLUnurbs {
            /// <summary>
            ///     Keeps the struct from being garbage collected prematurely.
            /// </summary>
            private IntPtr Data;
        }
        #endregion GLUnurbs

        #region GLUquadric
        /// <summary>
        ///     Defines a GLU quadric object.
        /// </summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct GLUquadric {
            /// <summary>
            ///     Keeps the struct from being garbage collected prematurely.
            /// </summary>
            private IntPtr Data;
        }
        #endregion GLUquadric

        #region GLUtesselator
        /// <summary>
        ///     Defines a GLU tesselator object.
        /// </summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct GLUtesselator {
            /// <summary>
            ///     Keeps the struct from being garbage collected prematurely.
            /// </summary>
            private IntPtr Data;
        }
        #endregion GLUtesselator

        #region GLUnurbsObj
        /// <summary>
        ///     Defines a GLU NURBS object.
        /// </summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct GLUnurbsObj {
            /// <summary>
            ///     Keeps the struct from being garbage collected prematurely.
            /// </summary>
            private IntPtr Data;
        }
        #endregion GLUnurbsObj

        #region GLUquadricObj
        /// <summary>
        ///     Defines a GLU quadric object.
        /// </summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct GLUquadricObj {
            /// <summary>
            ///     Keeps the struct from being garbage collected prematurely.
            /// </summary>
            private IntPtr Data;
        }
        #endregion GLUquadricObj

        #region GLUtesselatorObj
        /// <summary>
        ///     Defines a GLU tesselator object.
        /// </summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct GLUtesselatorObj {
            /// <summary>
            ///     Keeps the struct from being garbage collected prematurely.
            /// </summary>
            private IntPtr Data;
        }
        #endregion GLUtesselatorObj

        #region GLUtriangulatorObj
        /// <summary>
        ///     Defines a GLU triangulator object.
        /// </summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct GLUtriangulatorObj {
            /// <summary>
            ///     Keeps the struct from being garbage collected prematurely.
            /// </summary>
            private IntPtr Data;
        }
        #endregion GLUtriangulatorObj
        #endregion Public Structs

        #region Private Fields
        // These fields hold references to any callbacks used so as to prevent the garbage
        // collector from sweeping the delegates even though the application may not be done
        // with them.
        private static NurbsBeginCallback nurbsBeginCallback;
        private static NurbsBeginDataCallback nurbsBeginDataCallback;
        private static NurbsColorCallback nurbsColorCallback;
        private static NurbsColorDataCallback nurbsColorDataCallback;
        private static NurbsEndCallback nurbsEndCallback;
        private static NurbsEndDataCallback nurbsEndDataCallback;
        private static NurbsErrorCallback nurbsErrorCallback;
        private static NurbsNormalCallback nurbsNormalCallback;
        private static NurbsNormalDataCallback nurbsNormalDataCallback;
        private static NurbsTexCoordCallback nurbsTexCoordCallback;
        private static NurbsTexCoordDataCallback nurbsTexCoordDataCallback;
        private static NurbsVertexCallback nurbsVertexCallback;
        private static NurbsVertexDataCallback nurbsVertexDataCallback;
        private static QuadricErrorCallback quadricErrorCallback;
        private static TessBeginCallback tessBeginCallback;
        private static TessBeginDataCallback tessBeginDataCallback;
        private static TessCombineCallback tessCombineCallback;
        private static TessCombineCallback1 tessCombineCallback1;
        private static TessCombineDataCallback tessCombineDataCallback;
        private static TessEdgeFlagCallback tessEdgeFlagCallback;
        private static TessEdgeFlagDataCallback tessEdgeFlagDataCallback;
        private static TessEndCallback tessEndCallback;
        private static TessEndDataCallback tessEndDataCallback;
        private static TessErrorCallback tessErrorCallback;
        private static TessErrorDataCallback tessErrorDataCallback;
        private static TessVertexCallback tessVertexCallback;
        private static TessVertexCallback1 tessVertexCallback1;
        private static TessVertexDataCallback tessVertexDataCallback;
        #endregion Private Fields

        // --- Public Delegates ---
        #region NurbsBeginCallback(int type)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void begin(GLenum type);
        public delegate void NurbsBeginCallback(int type);
        #endregion NurbsBeginCallback(int type)

        #region NurbsBeginDataCallback(int type, [In] IntPtr[] userData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void beginData(GLenum type, void *userData);
        public delegate void NurbsBeginDataCallback(int type, [In] IntPtr[] userData);
        #endregion NurbsBeginDataCallback(int type, [In] IntPtr[] userData)

        #region NurbsColorCallback([In] float[] colorData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void color(GLfloat *color);
        public delegate void NurbsColorCallback([In] float[] colorData);
        #endregion NurbsColorCallback([In] float[] colorData)

        #region NurbsColorDataCallback([In] float[] colorData, [In] IntPtr[] userData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void colorData(GLfloat *color, void *userData);
        public delegate void NurbsColorDataCallback([In] float[] colorData, [In] IntPtr[] userData);
        #endregion NurbsColorDataCallback([In] float[] colorData, [In] IntPtr[] userData)

        #region NurbsEndCallback()
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void end(void);
        public delegate void NurbsEndCallback();
        #endregion NurbsEndCallback()

        #region NurbsEndDataCallback([In] IntPtr[] userData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void endData(void *userData);
        public delegate void NurbsEndDataCallback([In] IntPtr[] userData);
        #endregion NurbsEndDataCallback([In] IntPtr[] userData)

        #region NurbsErrorCallback(int type)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // typedef void (CALLBACK* GLUnurbsErrorProc) (GLenum);
        public delegate void NurbsErrorCallback(int type);
        #endregion NurbsErrorCallback(int type)

        #region NurbsNormalCallback([In] float[] normalData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void normal(GLfloat *normal);
        public delegate void NurbsNormalCallback([In] float[] normalData);
        #endregion NurbsNormalCallback([In] float[] normalData)

        #region NurbsNormalDataCallback([In] float[] normalData, [In] IntPtr[] userData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void normalData(GLfloat *normal, void *userData);
        public delegate void NurbsNormalDataCallback([In] float[] normalData, [In] IntPtr[] userData);
        #endregion NurbsNormalDataCallback([In] float[] normalData, [In] IntPtr[] userData)

        #region NurbsTexCoordCallback([In] float[] texCoord)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void texCoord(GLfloat *tex coord);
        public delegate void NurbsTexCoordCallback([In] float[] texCoord);
        #endregion NurbsTexCoordCallback([In] float[] texCoord)

        #region NurbsTexCoordDataCallback([In] float[] texCoord, [In] IntPtr[] userData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void texCoordData(GLfloat *tex coord, void *userData);
        public delegate void NurbsTexCoordDataCallback([In] float[] texCoord, [In] IntPtr[] userData);
        #endregion NurbsTexCoordDataCallback([In] float[] texCoord, [In] IntPtr[] userData)

        #region NurbsVertexCallback([In] float[] vertexData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void vertex(GLfloat *vertex);
        public delegate void NurbsVertexCallback([In] float[] vertexData);
        #endregion NurbsVertexCallback([In] float[] vertexData)

        #region NurbsVertexDataCallback([In] float[] vertexData, [In] IntPtr[] userData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        // void vertexData(GLfloat *vertex, void *userData);
        public delegate void NurbsVertexDataCallback([In] float[] vertexData, [In] IntPtr[] userData);
        #endregion NurbsVertexDataCallback([In] float[] vertexData, [In] IntPtr[] userData)

        #region QuadricErrorCallback(int errorCode)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluQuadricCallback" />.
        /// </summary>
        /// <seealso cref="gluQuadricCallback" />
        // typedef void (CALLBACK* GLUquadricErrorProc) (GLenum);
        public delegate void QuadricErrorCallback(int errorCode);
        #endregion QuadricErrorCallback(int errorCode)

        #region TessBeginCallback(int type)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessBeginProc) (GLenum);
        public delegate void TessBeginCallback(int type);
        #endregion TessBeginCallback(int type)

        #region TessBeginDataCallback(int type, [In] IntPtr polygonData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessBeginDataProc) (GLenum, void *);
        public delegate void TessBeginDataCallback(int type, [In] IntPtr polygonData);
        #endregion TessBeginDataCallback(int type, [In] IntPtr polygonData)

        #region TessCombineCallback([In] double[] coordinates, [In] IntPtr[] vertexData, [In] float[] weight, [Out] IntPtr[] outData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessCombineProc) (GLdouble[3], void*[4], GLfloat[4], void**);
        public delegate void TessCombineCallback([In] double[] coordinates, [In] IntPtr[] vertexData, [In] float[] weight, [Out] IntPtr[] outData);
        #endregion TessCombineCallback([In] double[] coordinates, [In] IntPtr[] vertexData, [In] float[] weight, [Out] IntPtr[] outData)

        #region TessCombineCallback1([In] double[] coordinates, [In] double[][] vertexData, [In] float[] weight, [Out] double[] outData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessCombineProc) (GLdouble[3], void*[4], GLfloat[4], void**);
        public delegate void TessCombineCallback1([MarshalAs(UnmanagedType.LPArray, SizeConst=3)] [In] double[] coordinates, [MarshalAs(UnmanagedType.LPArray, SizeConst=4)] [In] double[] vertexData, [MarshalAs(UnmanagedType.LPArray, SizeConst=4)] [In] float[] weight, [Out] double[] outData);
        #endregion TessCombineCallback1([In] double[] coordinates, [In] double[][] vertexData, [In] float[] weight, [Out] double[] outData)

        #region TessCombineDataCallback([In] double[] coordinates, [In] IntPtr[] vertexData, [In] float[] weight, [Out] IntPtr[] outData, [In] IntPtr polygonData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessCombineDataProc) (GLdouble[3], void*[4], GLfloat[4], void**, void*);
        public delegate void TessCombineDataCallback([In] double[] coordinates, [In] IntPtr[] vertexData, [In] float[] weight, [Out] IntPtr[] outData, [In] IntPtr polygonData);
        #endregion TessCombineDataCallback([In] double[] coordinates, [In] IntPtr[] vertexData, [In] float[] weight, [Out] IntPtr[] outData, [In] IntPtr polygonData)

        #region TessEdgeFlagCallback(int flag)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessEdgeFlagProc) (GLboolean);
        public delegate void TessEdgeFlagCallback(int flag);
        #endregion TessEdgeFlagCallback(int flag)

        #region TessEdgeFlagDataCallback(int flag, [In] IntPtr polygonData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessEdgeFlagDataProc) (GLboolean, void *);
        public delegate void TessEdgeFlagDataCallback(int flag, [In] IntPtr polygonData);
        #endregion TessEdgeFlagDataCallback(int flag, [In] IntPtr polygonData)

        #region TessEndCallback()
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessEndProc) (void);
        public delegate void TessEndCallback();
        #endregion TessEndCallback()

        #region TessEndDataCallback([In] IntPtr polygonData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessEndDataProc) (void *);
        public delegate void TessEndDataCallback(IntPtr polygonData);
        #endregion TessEndDataCallback(IntPtr polygonData)

        #region TessErrorCallback(int errorCode)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessErrorProc) (GLenum);
        public delegate void TessErrorCallback(int errorCode);
        #endregion TessErrorCallback(int errorCode)

        #region TessErrorDataCallback(int errorCode, [In] IntPtr polygonData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessErrorDataProc) (GLenum, void *);
        public delegate void TessErrorDataCallback(int errorCode, [In] IntPtr polygonData);
        #endregion TessErrorDataCallback(int errorCode, [In] IntPtr polygonData)

        #region TessVertexCallback([In] IntPtr vertexData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessVertexProc) (void *);
        public delegate void TessVertexCallback([In] IntPtr vertexData);
        #endregion TessVertexCallback([In] IntPtr vertexData)

        #region TessVertexCallback1([In] double[] vertexData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessVertexProc) (void *);
        public delegate void TessVertexCallback1([In] double[] vertexData);
        #endregion TessVertexCallback1([In] double[] vertexData)

        #region TessVertexDataCallback([In] IntPtr vertexData, [In] IntPtr polygonData)
        /// <summary>
        ///     Callback (delegate) for use with <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        // typedef void (CALLBACK* GLUtessVertexDataProc) (void *, void *);
        public delegate void TessVertexDataCallback([In] IntPtr vertexData, [In] IntPtr polygonData);
        #endregion TessVertexDataCallback([In] IntPtr vertexData, [In] IntPtr polygonData)

        // --- Private Externs ---
        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsBeginCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsBeginCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsBeginCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsBeginDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsBeginDataCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsBeginDataCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsColorCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsColorCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsColorCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsColorDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsColorDataCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsColorDataCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsEndCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsEndCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsEndCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsEndDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsEndDataCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsEndDataCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsErrorCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsErrorCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsErrorCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsNormalCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsNormalCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsNormalCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsNormalDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsNormalDataCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsNormalDataCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsTexCoordCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsTexCoordCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsTexCoordCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsTexCoordDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsTexCoordDataCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsTexCoordDataCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsVertexCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsVertexCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsVertexCallback func)

        #region __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsVertexDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluNurbsCallback(GLUnurbs *nobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluNurbsCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsVertexDataCallback func);
        #endregion __gluNurbsCallback([In] GLUnurbs nurb, int which, [In] NurbsVertexDataCallback func)

        #region __gluQuadricCallback([In] GLUquadric quad, int which, [In] QuadricErrorCallback func)
        /// <summary>
        ///     Called from <see cref="gluQuadricCallback" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluQuadricCallback(GLUquadric *qobj, GLenum which, void (CALLBACK* fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluQuadricCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluQuadricCallback([In] GLUquadric quad, int which, [In] QuadricErrorCallback func);
        #endregion __gluQuadricCallback([In] GLUquadric quad, int which, [In] QuadricErrorCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessBeginCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessBeginCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessBeginCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessBeginDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessBeginDataCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessBeginDataCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessCombineCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessCombineCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessCombineCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessCombineCallback1 func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessCombineCallback1 func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessCombineCallback1 func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessCombineDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessCombineDataCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessCombineDataCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEdgeFlagCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEdgeFlagCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEdgeFlagCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEdgeFlagDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEdgeFlagDataCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEdgeFlagDataCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEndCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEndCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEndCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEndDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEndDataCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessEndDataCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessErrorCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessErrorCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessErrorCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessErrorDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessErrorDataCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessErrorDataCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessVertexCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessVertexCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessVertexCallback func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessVertexCallback1 func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessVertexCallback1 func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessVertexCallback1 func)

        #region __gluTessCallback([In] GLUtesselator tess, int which, [In] TessVertexDataCallback func)
        /// <summary>
        ///     Called from <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />.
        /// </summary>
        /// <remarks>
        ///     <b>This method is not CLS-compliant due to naming conventions.</b>
        /// </remarks>
        // void APIENTRY gluTessCallback(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)());
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION, EntryPoint="gluTessCallback"), SuppressUnmanagedCodeSecurity]
        private static extern void __gluTessCallback([In] GLUtesselator tess, int which, [In] TessVertexDataCallback func);
        #endregion __gluTessCallback([In] GLUtesselator tess, int which, [In] TessVertexDataCallback func)

        // --- Public Externs ---
        #region gluBeginCurve([In] GLUnurbs nurb)
        /// <summary>
        ///     Delimits a Non-Uniform Rational B-Spline (NURBS) curve definition.
        /// </summary>
        /// <param name="nurb">
        ///     The NURBS object (created with <see cref="gluNewNurbsRenderer" />).
        /// </param>
        /// <remarks>
        ///     <para>
        ///         Use <b>gluBeginCurve</b> to mark the beginning of a NURBS curve definition.
        ///         After calling <b>gluBeginCurve</b>, make one or more calls to
        ///         <see cref="gluNurbsCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int)" /> to define the attributes of the curve.  Exactly
        ///         one of the calls to <see cref="gluNurbsCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int)" /> must have a curve type of
        ///         <see cref="Gl.GL_MAP1_VERTEX_3" /> or <see cref="Gl.GL_MAP1_VERTEX_4" />.  To
        ///         mark the end of the NURBS curve definition, call <see cref="gluEndCurve" />.
        ///     </para>
        ///     <para>
        ///         OpenGL evaluators are used to render the NURBS curve as a series of line
        ///         segments.  Evaluator state is preserved during rendering with
        ///         <c>Gl.glPushAttrib(Gl.GL_EVAL_BIT)</c> and <c>Gl.glPopAttrib</c>.  For
        ///         information on exactly what state these calls preserve, see
        ///         <see cref="Gl.glPushAttrib" />.
        ///     </para>
        ///     <para>
        ///         <b>EXAMPLE</b>
        ///     </para>
        ///     <para>
        ///         The following commands render a textured NURBS curve with normals; texture
        ///         coordinates and normals are also specified as NURBS curves:
        ///     </para>
        ///     <para>
        ///         <code>
        ///             Glu.gluBeginCurve(nobj);
        ///                 Glu.gluNurbsCurve(nobj, ..., Gl.GL_MAP1_TEXTURE_COORD_2);
        ///                 Glu.gluNurbsCurve(nobj, ..., Gl.GL_MAP1_NORMAL);
        ///                 Glu.gluNurbsCurve(nobj, ..., Gl.GL_MAP1_VERTEX_4);
        ///             Glu.gluEndCurve(nobj);
        ///         </code>
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glPopAttrib" />
        /// <seealso cref="Gl.glPushAttrib" />
        /// <seealso cref="gluBeginSurface" />
        /// <seealso cref="gluBeginTrim" />
        /// <seealso cref="gluNewNurbsRenderer" />
        /// <seealso cref="gluNurbsCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int)" />
        // void APIENTRY gluBeginCurve(GLUnurbs *nobj);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern void gluBeginCurve([In] GLUnurbs nurb);
        #endregion gluBeginCurve([In] GLUnurbs nurb)

        #region gluBeginPolygon([In] GLUtesselator tess)
        /// <summary>
        ///     Delimits a polygon description.
        /// </summary>
        /// <param name="tess">
        ///     The tessellation object (created with <see cref="gluNewTess" />).
        /// </param>
        /// <remarks>
        ///     <para>
        ///         <b>gluBeginPolygon</b> delimits the definition of a nonconvex polygon.  To
        ///         define such a polygon, first call <b>gluBeginPolygon</b>.  Then define the
        ///         contours of the polygon by calling <see cref="gluTessVertex(Tao.OpenGl.Glu.GLUtesselator, double[], byte[])" /> for each
        ///         vertex and <see cref="gluNextContour" /> to start each new contour.  Finally,
        ///         call <see cref="gluEndPolygon" /> to signal the end of the definition.  See
        ///         the <see cref="gluTessVertex(Tao.OpenGl.Glu.GLUtesselator, double[], byte[])" /> and <see cref="gluNextContour" /> reference
        ///         pages for more details.
        ///     </para>
        ///     <para>
        ///         Once <see cref="gluEndPolygon" /> is called, the polygon is tessellated, and
        ///         the resulting triangles are described through callbacks.  See
        ///         <see cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" /> for descriptions of the callback functions.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         This command is obsolete and is provided for backward compatibility only.
        ///         Calls to <b>gluBeginPolygon</b> are mapped to
        ///         <see cref="gluTessBeginPolygon(Tao.OpenGl.Glu.GLUtesselator, byte[])" /> followed by
        ///         <see cref="gluTessBeginContour" />.  Calls to <see cref="gluEndPolygon" />
        ///         are mapped to <see cref="gluTessEndContour" /> followed by
        ///         <see cref="gluTessEndPolygon" />.
        ///     </para>
        ///     <para>
        ///         <b>EXAMPLE</b>
        ///     </para>
        ///     <para>
        ///         A quadrilateral with a triangular hole in it can be described like this:
        ///     </para>
        ///     <para>
        ///         <code>
        ///             Glu.gluBeginPolygon(tobj);
        ///                 Glu.gluTessVertex(tobj, v1, v1);
        ///                 Glu.gluTessVertex(tobj, v2, v2);
        ///                 Glu.gluTessVertex(tobj, v3, v3);
        ///                 Glu.gluTessVertex(tobj, v4, v4);
        ///             Glu.gluNextContour(tobj, Glu.GLU_INTERIOR);
        ///                 Glu.gluTessVertex(tobj, v5, v5);
        ///                 Glu.gluTessVertex(tobj, v6, v6);
        ///                 Glu.gluTessVertex(tobj, v7, v7);
        ///             Glu.gluEndPolygon(tobj);
        ///         </code>
        ///     </para>
        /// </remarks>
        /// <seealso cref="gluNewTess" />
        /// <seealso cref="gluNextContour" />
        /// <seealso cref="gluTessBeginContour" />
        /// <seealso cref="gluTessBeginPolygon(Tao.OpenGl.Glu.GLUtesselator, byte[])" />
        /// <seealso cref="gluTessCallback(Tao.OpenGl.Glu.GLUtesselator, int, Tao.OpenGl.Glu.TessBeginCallback)" />
        /// <seealso cref="gluTessVertex(Tao.OpenGl.Glu.GLUtesselator, double[], byte[])" />
        // void APIENTRY gluBeginPolygon(GLUtesselator *tess);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern void gluBeginPolygon([In] GLUtesselator tess);
        #endregion gluBeginPolygon([In] GLUtesselator tess)

        #region gluBeginSurface([In] GLUnurbs nurb)
        /// <summary>
        ///     Delimits a NURBS surface definition.
        /// </summary>
        /// <param name="nurb">
        ///     The NURBS object (created with <see cref="gluNewNurbsRenderer" />).
        /// </param>
        /// <remarks>
        ///     <para>
        ///         Use <b>gluBeginSurface</b> to mark the beginning of a NURBS surface
        ///         definition.  After calling <b>gluBeginSurface</b>, make one or more calls to
        ///         <see cref="gluNurbsSurface(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int, float[], int, int, int)" /> to define the attributes of the surface.
        ///         Exactly one of these calls to <see cref="gluNurbsSurface(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int, float[], int, int, int)" /> must have a
        ///         surface type of <see cref="Gl.GL_MAP2_VERTEX_3" /> or
        ///         <see cref="Gl.GL_MAP2_VERTEX_4" />.  To mark the end of the NURBS surface
        ///         definition, call <see cref="gluEndSurface" />.
        ///     </para>
        ///     <para>
        ///         Trimming of NURBS surfaces is supported with <see cref="gluBeginTrim" />,
        ///         <see cref="gluPwlCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, int)" />, <see cref="gluNurbsCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int)" />, and
        ///         <see cref="gluEndTrim" />.  See the <see cref="gluBeginTrim" /> reference
        ///         page for details. 
        ///     </para>
        ///     <para>
        ///         OpenGL evaluators are used to render the NURBS surface as a set of polygons.
        ///         Evaluator state is preserved during rendering with
        ///         <c>Gl.glPushAttrib(Gl.GL_EVAL_BIT)</c> and <c>Gl.glPopAttrib()</c>.  See the
        ///         <see cref="Gl.glPushAttrib" /> reference page for details on exactly what
        ///         state these calls preserve.
        ///     </para>
        ///     <para>
        ///         <b>EXAMPLE</b>
        ///     </para>
        ///     <para>
        ///         The following commands render a textured NURBS surface with normals; the
        ///         texture coordinates and normals are also described as NURBS surfaces:
        ///     </para>
        ///     <para>
        ///         <code>
        ///             Glu.gluBeginSurface(nobj);
        ///                 Glu.gluNurbsSurface(nobj, ..., Gl.GL_MAP2_TEXTURE_COORD_2);
        ///                 Glu.gluNurbsSurface(nobj, ..., Gl.GL_MAP2_NORMAL);
        ///                 Glu.gluNurbsSurface(nobj, ..., Gl.GL_MAP2_VERTEX_4);
        ///             Glu.gluEndSurface(nobj);
        ///         </code>
        ///     </para>
        /// </remarks>
        /// <seealso cref="gluBeginCurve" />
        /// <seealso cref="gluBeginTrim" />
        /// <seealso cref="gluNewNurbsRenderer" />
        /// <seealso cref="gluNurbsCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int)" />
        /// <see cref="gluNurbsSurface(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int, float[], int, int, int)" />
        /// <seealso cref="gluPwlCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, int)" />
        // void APIENTRY gluBeginSurface(GLUnurbs *nobj);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern void gluBeginSurface([In] GLUnurbs nurb);
        #endregion gluBeginSurface([In] GLUnurbs nurb)

        #region gluBeginTrim([In] GLUnurbs nurb)
        /// <summary>
        ///     Delimits a NURBS trimming loop definition.
        /// </summary>
        /// <param name="nurb">
        ///     The NURBS object (created with <see cref="gluNewNurbsRenderer" />). 
        /// </param>
        /// <remarks>
        ///     <para>
        ///         Use <b>gluBeginTrim</b> to mark the beginning of a trimming loop, and
        ///         <see cref="gluEndTrim" /> to mark the end of a trimming loop.  A trimming
        ///         loop is a set of oriented curve segments (forming a closed curve) that define
        ///         boundaries of a NURBS surface.  You include these trimming loops in the
        ///         definition of a NURBS surface, between calls to
        ///         <see cref="gluBeginSurface" /> and <see cref="gluEndSurface" />.
        ///     </para>
        ///     <para>
        ///         The definition for a NURBS surface can contain many trimming loops.  For
        ///         example, if you wrote a definition for a NURBS surface that resembled a
        ///         rectangle with a hole punched out, the definition would contain two trimming
        ///         loops.  One loop would define the outer edge of the rectangle; the other
        ///         would define the hole punched out of the rectangle.  The definitions of each
        ///         of these trimming loops would be bracketed by a <b>gluBeginTrim</b> and
        ///         <see cref="gluEndTrim" /> pair.
        ///     </para>
        ///     <para>
        ///         The definition of a single closed trimming loop can consist of multiple curve
        ///         segments, each described as a piecewise linear curve (see
        ///         <see cref="gluPwlCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, int)" />) or as a single NURBS curve (see
        ///         <see cref="gluNurbsCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int)" />), or as a combination of both in any order.  The
        ///         only library calls that can appear in a trimming loop definition (between the
        ///         calls to <b>gluBeginTrim</b> and <see cref="gluEndTrim" />) are
        ///         <see cref="gluPwlCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, int)" /> and <see cref="gluNurbsCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int)" />.
        ///     </para>
        ///     <para>
        ///         The area of the NURBS surface that is displayed is the region in the domain
        ///         to the left of the trimming curve as the curve parameter increases.  Thus,
        ///         the retained region of the NURBS surface is inside a counterclockwise
        ///         trimming loop and outside a clockwise trimming loop.  For the rectangle
        ///         mentioned earlier, the trimming loop for the outer edge of the rectangle runs
        ///         counterclockwise, while the trimming loop for the punched-out hole runs
        ///         clockwise.
        ///     </para>
        ///     <para>
        ///         If you use more than one curve to define a single trimming loop, the curve
        ///         segments must form a closed loop (that is, the endpoint of each curve must be
        ///         the starting point of the next curve, and the endpoint of the final curve
        ///         must be the starting point of the first curve).  If the endpoints of the
        ///         curve are sufficiently close together but not exactly coincident, they will
        ///         be coerced to match.  If the endpoints are not sufficiently close, an error
        ///         results (see <see cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />).
        ///     </para>
        ///     <para>
        ///         If a trimming loop definition contains multiple curves, the direction of the
        ///         curves must be consistent (that is, the inside must be to the left of all of
        ///         the curves).  Nested trimming loops are legal as long as the curve
        ///         orientations alternate correctly.  If trimming curves are self-intersecting,
        ///         or intersect one another, an error results.
        ///     </para>
        ///     <para>
        ///         If no trimming information is given for a NURBS surface, the entire surface
        ///         is drawn.
        ///     </para>
        ///     <para>
        ///         <b>EXAMPLE</b>
        ///     </para>
        ///     <para>
        ///         This code fragment defines a trimming loop that consists of one piecewise
        ///         linear curve, and two NURBS curves:
        ///     </para>
        ///     <para>
        ///         <code>
        ///             Glu.gluBeginTrim(nobj);
        ///                 Glu.gluPwlCurve(..., Glu.GLU_MAP1_TRIM_2);
        ///                 Glu.gluNurbsCurve(..., Glu.GLU_MAP1_TRIM_2);
        ///                 Glu.gluNurbsCurve(..., Glu.GLU_MAP1_TRIM_3);
        ///             Glu.gluEndTrim(nobj);
        ///         </code>
        ///     </para>
        /// </remarks>
        /// <seealso cref="gluBeginSurface" />
        /// <seealso cref="gluEndSurface" />
        /// <seealso cref="gluNewNurbsRenderer" />
        /// <seealso cref="gluNurbsCallback(Tao.OpenGl.Glu.GLUnurbs, int, Tao.OpenGl.Glu.NurbsBeginCallback)" />
        /// <seealso cref="gluNurbsCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, float[], int, int)" />
        /// <seealso cref="gluPwlCurve(Tao.OpenGl.Glu.GLUnurbs, int, float[], int, int)" />
        // void APIENTRY gluBeginTrim(GLUnurbs *nobj);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern void gluBeginTrim([In] GLUnurbs nurb);
        #endregion gluBeginTrim([In] GLUnurbs nurb)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] byte[] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
		/// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
		/// <seealso cref="Gl.glGetTexLevelParameterfv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] byte[] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] byte[] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] byte[ , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
		/// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
		/// <seealso cref="Gl.glGetTexLevelParameterfv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] byte[ , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] byte[ , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] byte[ , , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glGetTexLevelParameterfv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] byte[ , , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] byte[ , , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] double[] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] double[] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] double[] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] double[ , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
		/// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
		/// <seealso cref="Gl.glGetTexLevelParameterfv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] double[ , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] double[ , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] double[ , , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
		/// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
		/// <seealso cref="Gl.glGetTexLevelParameterfv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] double[ , , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] double[ , , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] short[] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] short[] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] short[] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] short[ , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] short[ , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] short[ , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] short[ , , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] short[ , , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] short[ , , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] int[] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] int[] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] int[] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] int[ , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] int[ , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] int[ , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] int[ , , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] int[ , , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] int[ , , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] float[] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] float[] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] float[] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] float[ , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] float[ , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] float[ , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] float[ , , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
		/// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
		/// <seealso cref="Gl.glGetTexLevelParameterfv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] float[ , , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] float[ , , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] ushort[] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] ushort[] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] ushort[] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] ushort[ , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] ushort[ , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] ushort[ , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] ushort[ , , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] ushort[ , , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] ushort[ , , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] uint[] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] uint[] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] uint[] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] uint[ , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] uint[ , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] uint[ , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] uint[ , , ] data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] uint[ , , ] data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] uint[ , , ] data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] IntPtr data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] IntPtr data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] IntPtr data)

        #region int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] void *data)
        /// <summary>
        ///     Builds a subset of one-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     or 4 or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />, <see cref="Gl.GL_INTENSITY" />,
        ///     <see cref="Gl.GL_INTENSITY4" />, <see cref="Gl.GL_INTENSITY8" />,
        ///     <see cref="Gl.GL_INTENSITY12" />, <see cref="Gl.GL_INTENSITY16" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_R3_G3_B2" />,
        ///     <see cref="Gl.GL_RGB4" />, <see cref="Gl.GL_RGB5" />,
        ///     <see cref="Gl.GL_RGB8" />, <see cref="Gl.GL_RGB10" />,
        ///     <see cref="Gl.GL_RGB12" />, <see cref="Gl.GL_RGB16" />,
        ///     <see cref="Gl.GL_RGBA" />, <see cref="Gl.GL_RGBA2" />,
        ///     <see cref="Gl.GL_RGBA4" />, <see cref="Gl.GL_RGB5_A1" />,
        ///     <see cref="Gl.GL_RGBA8" />, <see cref="Gl.GL_RGB10_A2" />,
        ///     <see cref="Gl.GL_RGBA12" /> or <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width in pixels of the texture image.  This should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of:
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for data.  Must be one of:
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> builds a subset of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating data in half until size 11 is reached.  At each level, each texel
        ///         in the halved mipmap level is an average of the corresponding two texels in
        ///         the larger mipmap level.  <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load
        ///         these mipmap levels from <i>min</i> to <i>max</i>.  If <i>max</i> is larger
        ///         than the highest mipmap level for the texture of the specified size, then a
        ///         GLU error code is returned (see <see cref="gluErrorString" />) and nothing is
        ///         loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16, the following
        ///         levels are possible: 161, 81, 41, 21, 11.  These correspond to levels 2
        ///         through 6 respectively.  If <i>min</i> is 3 and <i>max</i> is 5, then only
        ///         mipmap levels 81, 41 and 21 are loaded.  However, if <i>max</i> is 7 then
        ///         an error is returned and nothing is loaded since <i>max</i> is larger than
        ///         the highest mipmap level which is, in this case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2((width)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>level</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild1DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> are not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public unsafe static extern int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] void *data);
        #endregion int gluBuild1DMipmapLevels(int target, int internalFormat, int width, int format, int type, int level, int min, int max, [In] void *data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] byte[] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] byte[] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] byte[] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] byte[ , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] byte[ , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] byte[ , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] byte[ , , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] byte[ , , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] byte[ , , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] double[] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] double[] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] double[] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] double[ , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] double[ , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] double[ , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] double[ , , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] double[ , , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] double[ , , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] short[] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] short[] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] short[] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] short[ , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] short[ , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] short[ , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] short[ , , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] short[ , , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] short[ , , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] int[] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] int[] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] int[] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] int[ , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] int[ , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] int[ , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] int[ , , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] int[ , , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] int[ , , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] float[] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] float[] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] float[] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] float[ , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] float[ , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] float[ , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] float[ , , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] float[ , , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] float[ , , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] ushort[] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] ushort[] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] ushort[] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] ushort[ , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] ushort[ , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] ushort[ , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] ushort[ , , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] ushort[ , , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] ushort[ , , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] uint[] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] uint[] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] uint[] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] uint[ , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] uint[ , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] uint[ , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] uint[ , , ] data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] uint[ , , ] data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] uint[ , , ] data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] IntPtr data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] IntPtr data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] IntPtr data)

        #region int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] void *data)
        /// <summary>
        ///     Builds a one-dimensional mipmap.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_1D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" />, or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild1DMipmaps</b> builds a series of prefiltered one-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         Initially, the <i>width</i> of <i>data</i> is checked to see if it is a power
        ///         of 2.  If not, a copy of <i>data</i> is scaled up or down to the nearest
        ///         power of 2.  (If <i>width</i> is exactly between powers of 2, then the copy
        ///         of <i>data</i> will scale upwards.)  This copy will be used for subsequent
        ///         mipmapping operations described below.  For example, if <i>width</i> is 57
        ///         then a copy of <i>data</i> will scale up to 64 before mipmapping takes place.
        ///     </para>
        ///     <para>
        ///         Then, proxy textures (see <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />) are used to
        ///         determine if the implementation can fit the requested texture.  If not, width
        ///         is continually halved until it fits.
        ///     </para>
        ///     <para>
        ///         Next, a series of mipmap levels is built by decimating a copy of <i>data</i>
        ///         in half until size 11 is reached.  At each level, each texel in the halved
        ///         mipmap level is an average of the corresponding two texels in the larger
        ///         mipmap level.
        ///     </para>
        ///     <para>
        ///         <b>glTexImage1D</b> is called to load each of these mipmap levels.  Level 0
        ///         is a copy of <i>data</i>.  The highest level is <c>log2(width)</c>.  For
        ///         example, if <i>width</i> is 64 and the implementation can store a texture of
        ///         this size, the following mipmap levels are built: 641, 321, 161, 81, 41,
        ///         21 and 11.  These correspond to levels 0 through 6, respectively.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for the <i>type</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for the <i>data</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         Note that there is no direct way of querying the maximum level.  This can be
        ///         derived indirectly via <see cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />.  First,
        ///         query for the width actually used at level 0.  (The width may not be equal to
        ///         <i>width</i> since proxy textures might have scaled it to fit the
        ///         implementation.)  Then the maximum level can be derived from the formula
        ///         <c>log2(width)</c>.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater, and if the GLU version is 1.3 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>format</i> or <i>type</i>
        ///         are not legal. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmapLevels(int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild1DMipmaps (GLenum target, GLint internalFormat, GLsizei width, GLenum format, GLenum type, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public unsafe static extern int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] void *data);
        #endregion int gluBuild1DMipmaps(int target, int internalFormat, int width, int format, int type, [In] void *data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] byte[] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] byte[] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] byte[] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] byte[ , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] byte[ , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] byte[ , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] byte[ , , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] byte[ , , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] byte[ , , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] double[] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] double[] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] double[] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] double[ , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] double[ , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] double[ , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] double[ , , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] double[ , , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] double[ , , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] short[] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] short[] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] short[] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] short[ , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] short[ , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] short[ , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] short[ , , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] short[ , , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] short[ , , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] int[] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] int[] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] int[] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] int[ , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] int[ , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] int[ , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] int[ , , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] int[ , , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] int[ , , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] float[] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] float[] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] float[] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] float[ , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] float[ , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] float[ , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] float[ , , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] float[ , , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] float[ , , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] ushort[] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] ushort[] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] ushort[] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] ushort[ , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] ushort[ , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] ushort[ , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] ushort[ , , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] ushort[ , , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] ushort[ , , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] uint[] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] uint[] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] uint[] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] uint[ , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFormat">
        ///     Requests the internal storage format of the texture image.  Must be 1, 2, 3,
        ///     4, or one of the following symbolic constants: <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_ALPHA4" />, <see cref="Gl.GL_ALPHA8" />,
        ///     <see cref="Gl.GL_ALPHA12" />, <see cref="Gl.GL_ALPHA16" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, <see cref="Gl.GL_LUMINANCE4" />,
        ///     <see cref="Gl.GL_LUMINANCE8" />, <see cref="Gl.GL_LUMINANCE12" />,
        ///     <see cref="Gl.GL_LUMINANCE16" />, <see cref="Gl.GL_LUMINANCE_ALPHA" />,
        ///     <see cref="Gl.GL_LUMINANCE4_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE6_ALPHA2" />,
        ///     <see cref="Gl.GL_LUMINANCE8_ALPHA8" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA4" />,
        ///     <see cref="Gl.GL_LUMINANCE12_ALPHA12" />,
        ///     <see cref="Gl.GL_LUMINANCE16_ALPHA16" />,
        ///     <see cref="Gl.GL_INTENSITY" />, <see cref="Gl.GL_INTENSITY4" />,
        ///     <see cref="Gl.GL_INTENSITY8" />, <see cref="Gl.GL_INTENSITY12" />,
        ///     <see cref="Gl.GL_INTENSITY16" />, <see cref="Gl.GL_RGB" />,
        ///     <see cref="Gl.GL_R3_G3_B2" />, <see cref="Gl.GL_RGB4" />,
        ///     <see cref="Gl.GL_RGB5" />, <see cref="Gl.GL_RGB8" />,
        ///     <see cref="Gl.GL_RGB10" />, <see cref="Gl.GL_RGB12" />,
        ///     <see cref="Gl.GL_RGB16" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_RGBA2" />, <see cref="Gl.GL_RGBA4" />,
        ///     <see cref="Gl.GL_RGB5_A1" />, <see cref="Gl.GL_RGBA8" />,
        ///     <see cref="Gl.GL_RGB10_A2" />, <see cref="Gl.GL_RGBA12" /> or
        ///     <see cref="Gl.GL_RGBA16" />.
        /// </param>
        /// <param name="width">
        ///     Specifies the width, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="height">
        ///     Specifies the height, in pixels, of the texture image.  Should be a power of 2.
        /// </param>
        /// <param name="format">
        ///     Specifies the format of the pixel data.  Must be one of
        ///     <see cref="Gl.GL_COLOR_INDEX" />, <see cref="Gl.GL_DEPTH_COMPONENT" />,
        ///     <see cref="Gl.GL_RED" />, <see cref="Gl.GL_GREEN" />,
        ///     <see cref="Gl.GL_BLUE" />, <see cref="Gl.GL_ALPHA" />,
        ///     <see cref="Gl.GL_RGB" />, <see cref="Gl.GL_RGBA" />,
        ///     <see cref="Gl.GL_BGR" />, <see cref="Gl.GL_BGRA" />,
        ///     <see cref="Gl.GL_LUMINANCE" />, or <see cref="Gl.GL_LUMINANCE_ALPHA" />.
        /// </param>
        /// <param name="type">
        ///     Specifies the data type for <i>data</i>.  Must be one of
        ///     <see cref="Gl.GL_UNSIGNED_BYTE" />, <see cref="Gl.GL_BYTE" />,
        ///     <see cref="Gl.GL_BITMAP" />, <see cref="Gl.GL_UNSIGNED_SHORT" />,
        ///     <see cref="Gl.GL_SHORT" />, <see cref="Gl.GL_UNSIGNED_INT" />,
        ///     <see cref="Gl.GL_INT" />, <see cref="Gl.GL_FLOAT" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///     <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///     <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///     <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///     <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" />.
        /// </param>
        /// <param name="level">
        ///     Specifies the mipmap level of the image data.
        /// </param>
        /// <param name="min">
        ///     Specifies the minimum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="max">
        ///     Specifies the maximum mipmap level to pass to <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />.
        /// </param>
        /// <param name="data">
        ///     Specifies a pointer to the image data in memory.
        /// </param>
        /// <returns>
        ///     A return value of zero indicates success, otherwise a GLU error code is
        ///     returned (see <see cref="gluErrorString" />).
        /// </returns>
        /// <remarks>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> builds a subset of prefiltered two-dimensional
        ///         texture maps of decreasing resolutions called a mipmap.  This is used for the
        ///         antialiasing of texture mapped primitives.
        ///     </para>
        ///     <para>
        ///         A return value of zero indicates success, otherwise a GLU error code is
        ///         returned (see <see cref="gluErrorString" />).
        ///     </para>
        ///     <para>
        ///         A series of mipmap levels from <i>min</i> to <i>max</i> is built by
        ///         decimating <i>data</i> in half along both dimensions until size 11 is
        ///         reached.  At each level, each texel in the halved mipmap level is an average
        ///         of the corresponding four texels in the larger mipmap level.  (In the case of
        ///         rectangular images, the decimation will ultimately reach an N1 or 1N
        ///         configuration.  Here, two texels are averaged instead.)
        ///         <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> is called to load these mipmap levels from
        ///         <i>min</i> to <i>max</i>.  If <i>max</i> is larger than the highest mipmap
        ///         level for the texture of the specified size, then a GLU error code is
        ///         returned (see <see cref="gluErrorString" />) and nothing is loaded.
        ///     </para>
        ///     <para>
        ///         For example, if <i>level</i> is 2 and <i>width</i> is 16 and <i>height</i> is
        ///         8, the following levels are possible: 168, 84, 42, 21, 11.  These
        ///         correspond to levels 2 through 6 respectively.  If <i>min</i> is 3 and
        ///         <i>max</i> is 5, then only mipmap levels 84, 42 and 21 are loaded.
        ///         However, if <i>max</i> is 7 then an error is returned and nothing is loaded
        ///         since <i>max</i> is larger than the highest mipmap level which is, in this
        ///         case, 6.
        ///     </para>
        ///     <para>
        ///         The highest mipmap level can be derived from the formula
        ///         <c>log2(max(width,height)*(2^level))</c>.
        ///     </para>
        ///     <para>
        ///         See the <see cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" /> reference page for a description of
        ///         the acceptable values for <i>format</i> parameter.  See the
        ///         <see cref="Gl.glDrawPixels(int, int, int, int, object)" /> reference page for a description of the
        ///         acceptable values for <i>type</i> parameter.
        ///     </para>
        ///     <para>
        ///         <b>NOTES</b>
        ///     </para>
        ///     <para>
        ///         <b>gluBuild2DMipmapLevels</b> is only available if the GLU version is 1.3 or
        ///         greater.
        ///     </para>
        ///     <para>
        ///         Formats <see cref="Gl.GL_BGR" />, and <see cref="Gl.GL_BGRA" />, and types
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" />,
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" />,
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" />,
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" />, and
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> are only available if the GL
        ///         version is 1.2 or greater.
        ///     </para>
        ///     <para>
        ///         <b>ERRORS</b>
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>level</i> &gt; <i>min</i>,
        ///         <i>min</i> &lt; 0, <i>max</i> &lt; <i>min</i> or <i>max</i> is &gt; the
        ///         highest mipmap level for <i>data</i>.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_VALUE" /> is returned if <i>width</i> or <i>height</i>
        ///         is &lt; 1.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_ENUM" /> is returned if <i>internalFormat</i>,
        ///         <i>format</i>, or <i>type</i> is not legal.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_3_3_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_BYTE_2_3_3_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_6_5_REV" /> and <i>format</i> is not
        ///         <see cref="Gl.GL_RGB" />. 
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_4_4_4_4_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_5_5_5_1" /> or
        ///         <see cref="Gl.GL_UNSIGNED_SHORT_1_5_5_5_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_8_8_8_8_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        ///     <para>
        ///         <see cref="GLU_INVALID_OPERATION" /> is returned if <i>type</i> is
        ///         <see cref="Gl.GL_UNSIGNED_INT_10_10_10_2" /> or
        ///         <see cref="Gl.GL_UNSIGNED_INT_2_10_10_10_REV" /> and <i>format</i> is neither
        ///         <see cref="Gl.GL_RGBA" /> nor <see cref="Gl.GL_BGRA" />.
        ///     </para>
        /// </remarks>
        /// <seealso cref="Gl.glDrawPixels(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexImage(int, int, int, int, object)" />
        /// <seealso cref="Gl.glGetTexLevelParameteriv(int, int, int, IntPtr)" />
        /// <seealso cref="Gl.glTexImage1D(int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage2D(int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="Gl.glTexImage3D(int, int, int, int, int, int, int, int, int, object)" />
        /// <seealso cref="gluBuild1DMipmapLevels(int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild1DMipmaps(int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild2DMipmaps(int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmapLevels(int, int, int, int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluBuild3DMipmaps(int, int, int, int, int, int, int, byte[])" />
        /// <seealso cref="gluErrorString" />
        // GLAPI GLint GLAPIENTRY gluBuild2DMipmapLevels (GLenum target, GLint internalFormat, GLsizei width, GLsizei height, GLenum format, GLenum type, GLint level, GLint base, GLint max, const void *data);
        [DllImport("glu32.dll", CallingConvention=CALLING_CONVENTION), CLSCompliant(false), SuppressUnmanagedCodeSecurity]
        public static extern int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] uint[ , ] data);
        #endregion int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] uint[ , ] data)

        #region int gluBuild2DMipmapLevels(int target, int internalFormat, int width, int height, int format, int type, int level, int min, int max, [In] uint[ , , ] data)
        /// <summary>
        ///     Builds a subset of two-dimensional mipmap levels.
        /// </summary>
        /// <param name="target">
        ///     Specifies the target texture.  Must be <see cref="Gl.GL_TEXTURE_2D" />.
        /// </param>
        /// <param name="internalFor