from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


date_default = _Mock()

default_handlers = _Mock()

json_errors = _Mock()

jsonapi = _Mock()

logging = _Mock()

url_escape = _Mock()

url_path_join = _Mock()

web = _Mock()

_kernel_action_regex = '(?P<action>restart|interrupt)'

_kernel_id_regex = '(?P<kernel_id>\\w+-\\w+-\\w+-\\w+-\\w+)'

class AuthenticatedZMQStreamHandler(_Mock):
  pass


class IOPubHandler(_Mock):
  pass
  channel = 'iopub'

class IPythonHandler(_Mock):
  pass


class KernelActionHandler(_Mock):
  pass


class KernelHandler(_Mock):
  pass


class MainKernelHandler(_Mock):
  pass


class ShellHandler(_Mock):
  pass
  channel = 'shell'

class StdinHandler(_Mock):
  pass
  channel = 'stdin'

class ZMQChannelHandler(_Mock):
  pass


