package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUserBackupFile invokes the rds.DeleteUserBackupFile API synchronously
func (client *Client) DeleteUserBackupFile(request *DeleteUserBackupFileRequest) (response *DeleteUserBackupFileResponse, err error) {
	response = CreateDeleteUserBackupFileResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUserBackupFileWithChan invokes the rds.DeleteUserBackupFile API asynchronously
func (client *Client) DeleteUserBackupFileWithChan(request *DeleteUserBackupFileRequest) (<-chan *DeleteUserBackupFileResponse, <-chan error) {
	responseChan := make(chan *DeleteUserBackupFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUserBackupFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUserBackupFileWithCallback invokes the rds.DeleteUserBackupFile API asynchronously
func (client *Client) DeleteUserBackupFileWithCallback(request *DeleteUserBackupFileRequest, callback func(response *DeleteUserBackupFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUserBackupFileResponse
		var err error
		defer close(result)
		response, err = client.DeleteUserBackupFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUserBackupFileRequest is the request struct for api DeleteUserBackupFile
type DeleteUserBackupFileRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	BackupId             string           `position:"Query" name:"BackupId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OpsServiceVersion    string           `position:"Query" name:"OpsServiceVersion"`
	Engine               string           `position:"Query" name:"Engine"`
}

// DeleteUserBackupFileResponse is the response struct for api DeleteUserBackupFile
type DeleteUserBackupFileResponse struct {
	*responses.BaseResponse
	BackupId  string `json:"BackupId" xml:"BackupId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteUserBackupFileRequest creates a request to invoke DeleteUserBackupFile API
func CreateDeleteUserBackupFileRequest() (request *DeleteUserBackupFileRequest) {
	request = &DeleteUserBackupFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DeleteUserBackupFile", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteUserBackupFileResponse creates a response to parse from DeleteUserBackupFile response
func CreateDeleteUserBackupFileResponse() (response *DeleteUserBackupFileResponse) {
	response = &DeleteUserBackupFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
