---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, colonnes, 
---

# Comment écrire un texte sur plusieurs colonnes d'un tableau ?

La commande `\multicolumn{⟨nb⟩}{⟨col⟩}{⟨contenu⟩}` permet d'obtenir 
une cellule s'étalant sur plusieurs colonnes. Le premier argument 
indique le nombre de colonnes à utiliser, le deuxième argument décrit 
la colonne ainsi que ses séparateurs, le troisième argument contient 
le texte de la cellule. Voir l'exemple suivant pour la pratique.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{eurosym}        % Symboles de l'euro

\begin{document}
\begin{center}
  \begin{tabular}{|l|*{3}{c|}}
    \hline
    Tarifs             & 0h--8h      &  8h--19h    & 19h--24h    \\
    \hline
    lundi--vendredi    & \EUR{0,018} & \EUR{0,033} & \EUR{0,018} \\
    \hline
    week-end \& fêtes  & \multicolumn{3}{c|}{\EUR{0,018}}        \\
    \hline
  \end{tabular}
\end{center}
\end{document}
```