// Copyright 2016 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/xfa_basic_data.h"

#include "xfa/fxfa/include/fxfa_basic.h"

static const CXFA_Measurement g_XFAMeasurementData[] = {
    CXFA_Measurement(0, XFA_UNIT_In),
    CXFA_Measurement(0, XFA_UNIT_Pt),
    CXFA_Measurement(5, XFA_UNIT_Mm),
    CXFA_Measurement(0.25, XFA_UNIT_Mm),
    CXFA_Measurement(-1, XFA_UNIT_Unknown),
    CXFA_Measurement(0, XFA_UNIT_Angle),
    CXFA_Measurement(10, XFA_UNIT_Pt),
    CXFA_Measurement(360, XFA_UNIT_Angle),
    CXFA_Measurement(0.5, XFA_UNIT_Pt),
};

const XFA_ATTRIBUTEINFO g_XFAAttributeData[] = {
    {0x68, L"h", XFA_ATTRIBUTE_H, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x77, L"w", XFA_ATTRIBUTE_W, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x78, L"x", XFA_ATTRIBUTE_X, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x79, L"y", XFA_ATTRIBUTE_Y, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x21aed, L"id", XFA_ATTRIBUTE_Id, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_Form,
     nullptr},
    {0x25363, L"to", XFA_ATTRIBUTE_To, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Config, nullptr},
    {0xcb0ac9, L"lineThrough", XFA_ATTRIBUTE_LineThrough,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x2282c73, L"hAlign", XFA_ATTRIBUTE_HAlign, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Left},
    {0x2c1c7f1, L"typeface", XFA_ATTRIBUTE_Typeface, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"Courier"},
    {0x3106c3a, L"beforeTarget", XFA_ATTRIBUTE_BeforeTarget,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x31b19c1, L"name", XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet |
         XFA_XDPPACKET_Template | XFA_XDPPACKET_Datasets | XFA_XDPPACKET_Form |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_Form,
     nullptr},
    {0x3848b3f, L"next", XFA_ATTRIBUTE_Next, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_None},
    {0x43e349b, L"dataRowCount", XFA_ATTRIBUTE_DataRowCount,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x5518c25, L"break", XFA_ATTRIBUTE_Break, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Close},
    {0x5ce6195, L"vScrollPolicy", XFA_ATTRIBUTE_VScrollPolicy,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0x8c74ae9, L"fontHorizontalScale", XFA_ATTRIBUTE_FontHorizontalScale,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"100%"},
    {0x8d4f1c7, L"textIndent", XFA_ATTRIBUTE_TextIndent,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x97c1c65, L"context", XFA_ATTRIBUTE_Context, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_UNKNOWN, (void*)0},
    {0x9876578, L"trayOut", XFA_ATTRIBUTE_TrayOut, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xa2e3514, L"cap", XFA_ATTRIBUTE_Cap, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Square},
    {0xb3543a6, L"max", XFA_ATTRIBUTE_Max, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xb356ca4, L"min", XFA_ATTRIBUTE_Min, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)1},
    {0xbb8df5d, L"ref", XFA_ATTRIBUTE_Ref, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Config | XFA_XDPPACKET_Template |
         XFA_XDPPACKET_Form,
     nullptr},
    {0xbb8f3df, L"rid", XFA_ATTRIBUTE_Rid, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xc080cd3, L"url", XFA_ATTRIBUTE_Url, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xc0811ed, L"use", XFA_ATTRIBUTE_Use, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_Form,
     nullptr},
    {0xcfea02e, L"leftInset", XFA_ATTRIBUTE_LeftInset,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x1026c59d, L"widows", XFA_ATTRIBUTE_Widows, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x1059ec18, L"level", XFA_ATTRIBUTE_Level, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Config, (void*)0},
    {0x1356caf8, L"bottomInset", XFA_ATTRIBUTE_BottomInset,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x13a08bdb, L"overflowTarget", XFA_ATTRIBUTE_OverflowTarget,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x1414d431, L"allowMacro", XFA_ATTRIBUTE_AllowMacro,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x14a32d52, L"pagePosition", XFA_ATTRIBUTE_PagePosition,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Any},
    {0x1517dfa1, L"columnWidths", XFA_ATTRIBUTE_ColumnWidths,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x169134a1, L"overflowLeader", XFA_ATTRIBUTE_OverflowLeader,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x1b8dce3e, L"action", XFA_ATTRIBUTE_Action, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Include},
    {0x1e459b8f, L"nonRepudiation", XFA_ATTRIBUTE_NonRepudiation,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x1ec8ab2c, L"rate", XFA_ATTRIBUTE_Rate, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)50},
    {0x1ef3a64a, L"allowRichText", XFA_ATTRIBUTE_AllowRichText,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x2038c9b2, L"role", XFA_ATTRIBUTE_Role, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x20914367, L"overflowTrailer", XFA_ATTRIBUTE_OverflowTrailer,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x226ca8f1, L"operation", XFA_ATTRIBUTE_Operation,
     XFA_ATTRIBUTETYPE_NOTSURE, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x24d85167, L"timeout", XFA_ATTRIBUTE_Timeout, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_SourceSet, nullptr},
    {0x25764436, L"topInset", XFA_ATTRIBUTE_TopInset, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x25839852, L"access", XFA_ATTRIBUTE_Access, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Open},
    {0x268b7ec1, L"commandType", XFA_ATTRIBUTE_CommandType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_SourceSet,
     (void*)XFA_ATTRIBUTEENUM_Unknown},
    {0x28dee6e9, L"format", XFA_ATTRIBUTE_Format, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x28e17e91, L"dataPrep", XFA_ATTRIBUTE_DataPrep, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_None},
    {0x292b88fe, L"widgetData", XFA_ATTRIBUTE_WidgetData,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_UNKNOWN, (void*)0},
    {0x29418bb7, L"abbr", XFA_ATTRIBUTE_Abbr, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_LocaleSet, (void*)0},
    {0x2a82d99c, L"marginRight", XFA_ATTRIBUTE_MarginRight,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x2b5df51e, L"dataDescription", XFA_ATTRIBUTE_DataDescription,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_ConnectionSet, nullptr},
    {0x2bb3f470, L"encipherOnly", XFA_ATTRIBUTE_EncipherOnly,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x2cd79033, L"kerningMode", XFA_ATTRIBUTE_KerningMode,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_None},
    {0x2ee7678f, L"rotate", XFA_ATTRIBUTE_Rotate, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 5)},
    {0x2f105f72, L"wordCharacterCount", XFA_ATTRIBUTE_WordCharacterCount,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)7},
    {0x2f16a382, L"type", XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x34ae103c, L"reserve", XFA_ATTRIBUTE_Reserve, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 4)},
    {0x3650557e, L"textLocation", XFA_ATTRIBUTE_TextLocation,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Below},
    {0x39cdb0a2, L"priority", XFA_ATTRIBUTE_Priority, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Custom},
    {0x3a0273a6, L"underline", XFA_ATTRIBUTE_Underline,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x3b582286, L"moduleWidth", XFA_ATTRIBUTE_ModuleWidth,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 3)},
    {0x3d123c26, L"hyphenate", XFA_ATTRIBUTE_Hyphenate,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x3e7af94f, L"listen", XFA_ATTRIBUTE_Listen, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_RefOnly},
    {0x4156ee3f, L"delimiter", XFA_ATTRIBUTE_Delimiter, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x42fed1fd, L"contentType", XFA_ATTRIBUTE_ContentType,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template |
                                  XFA_XDPPACKET_Datasets | XFA_XDPPACKET_Form,
     nullptr},
    {0x453eaf38, L"startNew", XFA_ATTRIBUTE_StartNew, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x45a6daf8, L"eofAction", XFA_ATTRIBUTE_EofAction, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_SourceSet, (void*)XFA_ATTRIBUTEENUM_MoveLast},
    {0x47cfa43a, L"allowNeutral", XFA_ATTRIBUTE_AllowNeutral,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x47d03490, L"connection", XFA_ATTRIBUTE_Connection,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x4873c601, L"baselineShift", XFA_ATTRIBUTE_BaselineShift,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x4b319767, L"overlinePeriod", XFA_ATTRIBUTE_OverlinePeriod,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_All},
    {0x4b8bc840, L"fracDigits", XFA_ATTRIBUTE_FracDigits,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)2},
    {0x4ef3d02c, L"orientation", XFA_ATTRIBUTE_Orientation,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Portrait},
    {0x4fdc3454, L"timeStamp", XFA_ATTRIBUTE_TimeStamp, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_XDP, nullptr},
    {0x52666f1c, L"printCheckDigit", XFA_ATTRIBUTE_PrintCheckDigit,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x534729c9, L"marginLeft", XFA_ATTRIBUTE_MarginLeft,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x5392ea58, L"stroke", XFA_ATTRIBUTE_Stroke, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Solid},
    {0x5404d6df, L"moduleHeight", XFA_ATTRIBUTE_ModuleHeight,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 2)},
    {0x54fa722c, L"transferEncoding", XFA_ATTRIBUTE_TransferEncoding,
     XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x552d9ad5, L"usage", XFA_ATTRIBUTE_Usage, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_ExportAndImport},
    {0x570ce835, L"presence", XFA_ATTRIBUTE_Presence, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Visible},
    {0x5739d1ff, L"radixOffset", XFA_ATTRIBUTE_RadixOffset,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x577682ac, L"preserve", XFA_ATTRIBUTE_Preserve, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x58be2870, L"aliasNode", XFA_ATTRIBUTE_AliasNode,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_UNKNOWN, (void*)0},
    {0x5a32e493, L"multiLine", XFA_ATTRIBUTE_MultiLine,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x5a50e9e6, L"version", XFA_ATTRIBUTE_Version, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x5ab23b6c, L"startChar", XFA_ATTRIBUTE_StartChar, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x5b707a35, L"scriptTest", XFA_ATTRIBUTE_ScriptTest,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Error},
    {0x5c054755, L"startAngle", XFA_ATTRIBUTE_StartAngle,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 5)},
    {0x5ec958c0, L"cursorType", XFA_ATTRIBUTE_CursorType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_SourceSet,
     (void*)XFA_ATTRIBUTEENUM_ForwardOnly},
    {0x5f760b50, L"digitalSignature", XFA_ATTRIBUTE_DigitalSignature,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x60a61edd, L"codeType", XFA_ATTRIBUTE_CodeType, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x60d4c8b1, L"output", XFA_ATTRIBUTE_Output, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_ConnectionSet, nullptr},
    {0x64110ab5, L"bookendTrailer", XFA_ATTRIBUTE_BookendTrailer,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x65e30c67, L"imagingBBox", XFA_ATTRIBUTE_ImagingBBox,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"none"},
    {0x66539c48, L"excludeInitialCap", XFA_ATTRIBUTE_ExcludeInitialCap,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x66642f8f, L"force", XFA_ATTRIBUTE_Force, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Config, nullptr},
    {0x69aa2292, L"crlSign", XFA_ATTRIBUTE_CrlSign, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x6a3405dd, L"previous", XFA_ATTRIBUTE_Previous, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_None},
    {0x6a95c976, L"pushCharacterCount", XFA_ATTRIBUTE_PushCharacterCount,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)3},
    {0x6b6ddcfb, L"nullTest", XFA_ATTRIBUTE_NullTest, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Disabled},
    {0x6cfa828a, L"runAt", XFA_ATTRIBUTE_RunAt, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Client},
    {0x731e0665, L"spaceBelow", XFA_ATTRIBUTE_SpaceBelow,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x74788f8b, L"sweepAngle", XFA_ATTRIBUTE_SweepAngle,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 7)},
    {0x78bff531, L"numberOfCells", XFA_ATTRIBUTE_NumberOfCells,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0x79543055, L"letterSpacing", XFA_ATTRIBUTE_LetterSpacing,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x79975f2b, L"lockType", XFA_ATTRIBUTE_LockType, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_SourceSet, (void*)XFA_ATTRIBUTEENUM_ReadOnly},
    {0x7a0cc471, L"passwordChar", XFA_ATTRIBUTE_PasswordChar,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"*"},
    {0x7a7cc341, L"vAlign", XFA_ATTRIBUTE_VAlign, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)XFA_ATTRIBUTEENUM_Top},
    {0x7b29630a, L"sourceBelow", XFA_ATTRIBUTE_SourceBelow,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Config,
     (void*)XFA_ATTRIBUTEENUM_Update},
    {0x7b95e661, L"inverted", XFA_ATTRIBUTE_Inverted, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x7c2fd80b, L"mark", XFA_ATTRIBUTE_Mark, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Default},
    {0x7c2ff6ae, L"maxH", XFA_ATTRIBUTE_MaxH, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x7c2ff6bd, L"maxW", XFA_ATTRIBUTE_MaxW, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x7c732a66, L"truncate", XFA_ATTRIBUTE_Truncate, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x7d02356c, L"minH", XFA_ATTRIBUTE_MinH, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x7d02357b, L"minW", XFA_ATTRIBUTE_MinW, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x7d0b5fca, L"initial", XFA_ATTRIBUTE_Initial, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)1},
    {0x7d9fd7c5, L"mode", XFA_ATTRIBUTE_Mode, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Config, (void*)XFA_ATTRIBUTEENUM_UsePrinterSetting},
    {0x7e7e845e, L"layout", XFA_ATTRIBUTE_Layout, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Position},
    {0x7f6fd3d7, L"server", XFA_ATTRIBUTE_Server, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x824f21b7, L"embedPDF", XFA_ATTRIBUTE_EmbedPDF, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x8340ea66, L"oddOrEven", XFA_ATTRIBUTE_OddOrEven, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)XFA_ATTRIBUTEENUM_Any},
    {0x836d4d7c, L"tabDefault", XFA_ATTRIBUTE_TabDefault,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x8855805f, L"contains", XFA_ATTRIBUTE_Contains, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Datasets, (void*)XFA_ATTRIBUTEENUM_Data},
    {0x8a692521, L"rightInset", XFA_ATTRIBUTE_RightInset,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x8af2e657, L"maxChars", XFA_ATTRIBUTE_MaxChars, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x8b90e1f2, L"open", XFA_ATTRIBUTE_Open, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_UserControl},
    {0x8c99377e, L"relation", XFA_ATTRIBUTE_Relation, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x8d181d61, L"wideNarrowRatio", XFA_ATTRIBUTE_WideNarrowRatio,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"3:1"},
    {0x8e1c2921, L"relevant", XFA_ATTRIBUTE_Relevant, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x8e29d794, L"signatureType", XFA_ATTRIBUTE_SignatureType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Filter},
    {0x8ec6204c, L"lineThroughPeriod", XFA_ATTRIBUTE_LineThroughPeriod,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_All},
    {0x8ed182d1, L"shape", XFA_ATTRIBUTE_Shape, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Square},
    {0x8fa01790, L"tabStops", XFA_ATTRIBUTE_TabStops, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0x8fc36c0a, L"outputBelow", XFA_ATTRIBUTE_OutputBelow,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Config,
     (void*)XFA_ATTRIBUTEENUM_Warn},
    {0x9041d4b0, L"short", XFA_ATTRIBUTE_Short, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0x907c7719, L"fontVerticalScale", XFA_ATTRIBUTE_FontVerticalScale,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"100%"},
    {0x94446dcc, L"thickness", XFA_ATTRIBUTE_Thickness,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 8)},
    {0x957fa006, L"commitOn", XFA_ATTRIBUTE_CommitOn, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Select},
    {0x982bd892, L"remainCharacterCount", XFA_ATTRIBUTE_RemainCharacterCount,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)3},
    {0x98fd4d81, L"keyAgreement", XFA_ATTRIBUTE_KeyAgreement,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x99800d7a, L"errorCorrectionLevel", XFA_ATTRIBUTE_ErrorCorrectionLevel,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0x9a63da3d, L"upsMode", XFA_ATTRIBUTE_UpsMode, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_UsCarrier},
    {0x9cc17d75, L"mergeMode", XFA_ATTRIBUTE_MergeMode, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_ConsumeData},
    {0x9d833d75, L"circular", XFA_ATTRIBUTE_Circular, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0x9d8ee204, L"psName", XFA_ATTRIBUTE_PsName, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Config, nullptr},
    {0x9dcc3ab3, L"trailer", XFA_ATTRIBUTE_Trailer, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xa0933954, L"unicodeRange", XFA_ATTRIBUTE_UnicodeRange,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Config, nullptr},
    {0xa1b0d2f5, L"executeType", XFA_ATTRIBUTE_ExecuteType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Import},
    {0xa25a883d, L"duplexImposition", XFA_ATTRIBUTE_DuplexImposition,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_LongEdge},
    {0xa42ca1b7, L"trayIn", XFA_ATTRIBUTE_TrayIn, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xa433f001, L"bindingNode", XFA_ATTRIBUTE_BindingNode,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_UNKNOWN, (void*)0},
    {0xa5340ff5, L"bofAction", XFA_ATTRIBUTE_BofAction, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_SourceSet, (void*)XFA_ATTRIBUTEENUM_MoveFirst},
    {0xa5b410cf, L"save", XFA_ATTRIBUTE_Save, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0xa6118c89, L"targetType", XFA_ATTRIBUTE_TargetType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xa66404cb, L"keyEncipherment", XFA_ATTRIBUTE_KeyEncipherment,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xa6710262, L"credentialServerPolicy",
     XFA_ATTRIBUTE_CredentialServerPolicy, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {0xa686975b, L"size", XFA_ATTRIBUTE_Size, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 6)},
    {0xa85e74f3, L"initialNumber", XFA_ATTRIBUTE_InitialNumber,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)1},
    {0xabef37e3, L"slope", XFA_ATTRIBUTE_Slope, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Backslash},
    {0xabfa6c4f, L"cSpace", XFA_ATTRIBUTE_CSpace, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)L"SRGB"},
    {0xac06e2b0, L"colSpan", XFA_ATTRIBUTE_ColSpan, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)1},
    {0xadc4c77b, L"binding", XFA_ATTRIBUTE_Binding, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xaf754613, L"checksum", XFA_ATTRIBUTE_Checksum, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form | XFA_XDPPACKET_Form, nullptr},
    {0xb045fbc5, L"charEncoding", XFA_ATTRIBUTE_CharEncoding,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)L"UTF-8"},
    {0xb0e5485d, L"bind", XFA_ATTRIBUTE_Bind, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet, nullptr},
    {0xb12128b7, L"textEntry", XFA_ATTRIBUTE_TextEntry,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0xb373a862, L"archive", XFA_ATTRIBUTE_Archive, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xb598a1f7, L"uuid", XFA_ATTRIBUTE_Uuid, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_XDP, nullptr},
    {0xb5e49bf2, L"posture", XFA_ATTRIBUTE_Posture, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Normal},
    {0xb6b44172, L"after", XFA_ATTRIBUTE_After, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xb716467b, L"orphans", XFA_ATTRIBUTE_Orphans, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0xbc0c4695, L"qualifiedName", XFA_ATTRIBUTE_QualifiedName,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_UNKNOWN, nullptr},
    {0xbc254332, L"usehref", XFA_ATTRIBUTE_Usehref, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Template |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_Form,
     nullptr},
    {0xbc8fa350, L"locale", XFA_ATTRIBUTE_Locale, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xbd6e1d88, L"weight", XFA_ATTRIBUTE_Weight, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Normal},
    {0xbd96a0e9, L"underlinePeriod", XFA_ATTRIBUTE_UnderlinePeriod,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_All},
    {0xbde9abda, L"data", XFA_ATTRIBUTE_Data, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Link},
    {0xbe52dfbf, L"desc", XFA_ATTRIBUTE_Desc, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet, nullptr},
    {0xbe9ba472, L"numbered", XFA_ATTRIBUTE_Numbered, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)1},
    {0xc035c6b1, L"dataColumnCount", XFA_ATTRIBUTE_DataColumnCount,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xc0ec9fa4, L"overline", XFA_ATTRIBUTE_Overline, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0xc2ba0923, L"urlPolicy", XFA_ATTRIBUTE_UrlPolicy, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xc2bd40fd, L"anchorType", XFA_ATTRIBUTE_AnchorType,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_TopLeft},
    {0xc39a88bd, L"labelRef", XFA_ATTRIBUTE_LabelRef, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xc3c1442f, L"bookendLeader", XFA_ATTRIBUTE_BookendLeader,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xc4547a08, L"maxLength", XFA_ATTRIBUTE_MaxLength,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)-1},
    {0xc4fed09b, L"accessKey", XFA_ATTRIBUTE_AccessKey, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xc5762157, L"cursorLocation", XFA_ATTRIBUTE_CursorLocation,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_SourceSet,
     (void*)XFA_ATTRIBUTEENUM_Client},
    {0xc860f30a, L"delayedOpen", XFA_ATTRIBUTE_DelayedOpen,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_SourceSet, nullptr},
    {0xc8da4da7, L"target", XFA_ATTRIBUTE_Target, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xca5dc27c, L"dataEncipherment", XFA_ATTRIBUTE_DataEncipherment,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xcb150479, L"afterTarget", XFA_ATTRIBUTE_AfterTarget,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xcbcaf66d, L"leader", XFA_ATTRIBUTE_Leader, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xcca7897e, L"picker", XFA_ATTRIBUTE_Picker, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Host},
    {0xcd7f7b54, L"from", XFA_ATTRIBUTE_From, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Config, nullptr},
    {0xcea5e62c, L"baseProfile", XFA_ATTRIBUTE_BaseProfile,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Full},
    {0xd171b240, L"aspect", XFA_ATTRIBUTE_Aspect, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)XFA_ATTRIBUTEENUM_Fit},
    {0xd3c84d25, L"rowColumnRatio", XFA_ATTRIBUTE_RowColumnRatio,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xd4b01921, L"lineHeight", XFA_ATTRIBUTE_LineHeight,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 1)},
    {0xd4cc53f8, L"highlight", XFA_ATTRIBUTE_Highlight, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Inverted},
    {0xd50f903a, L"valueRef", XFA_ATTRIBUTE_ValueRef, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xd52482e0, L"maxEntries", XFA_ATTRIBUTE_MaxEntries,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Config, (void*)5},
    {0xd57c513c, L"dataLength", XFA_ATTRIBUTE_DataLength,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xd6128d8d, L"activity", XFA_ATTRIBUTE_Activity, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Click},
    {0xd6a39990, L"input", XFA_ATTRIBUTE_Input, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_ConnectionSet, nullptr},
    {0xd6e27f1d, L"value", XFA_ATTRIBUTE_Value, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_SourceSet | XFA_XDPPACKET_Config | XFA_XDPPACKET_LocaleSet |
         XFA_XDPPACKET_Template | XFA_XDPPACKET_Datasets |
         XFA_XDPPACKET_ConnectionSet | XFA_XDPPACKET_Form,
     nullptr},
    {0xd70798c2, L"blankOrNotBlank", XFA_ATTRIBUTE_BlankOrNotBlank,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Any},
    {0xd861f8af, L"addRevocationInfo", XFA_ATTRIBUTE_AddRevocationInfo,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xd8f982bf, L"genericFamily", XFA_ATTRIBUTE_GenericFamily,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Config,
     (void*)XFA_ATTRIBUTEENUM_Serif},
    {0xd996fa9b, L"hand", XFA_ATTRIBUTE_Hand, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Even},
    {0xdb55fec5, L"href", XFA_ATTRIBUTE_Href, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xdc75676c, L"textEncoding", XFA_ATTRIBUTE_TextEncoding,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xde7f92ba, L"leadDigits", XFA_ATTRIBUTE_LeadDigits,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)-1},
    {0xe11a2cbc, L"permissions", XFA_ATTRIBUTE_Permissions,
     XFA_ATTRIBUTETYPE_Integer, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)2},
    {0xe18b5659, L"spaceAbove", XFA_ATTRIBUTE_SpaceAbove,
     XFA_ATTRIBUTETYPE_Measure, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0xe1a26b56, L"codeBase", XFA_ATTRIBUTE_CodeBase, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xe349d044, L"stock", XFA_ATTRIBUTE_Stock, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xe372ae97, L"isNull", XFA_ATTRIBUTE_IsNull, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Datasets, (void*)0},
    {0xe4c3a5e5, L"restoreState", XFA_ATTRIBUTE_RestoreState,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Manual},
    {0xe5c96d6a, L"excludeAllCaps", XFA_ATTRIBUTE_ExcludeAllCaps,
     XFA_ATTRIBUTETYPE_Boolean, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)0},
    {0xe64b1129, L"formatTest", XFA_ATTRIBUTE_FormatTest,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Warning},
    {0xe6f99487, L"hScrollPolicy", XFA_ATTRIBUTE_HScrollPolicy,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xe8dddf50, L"join", XFA_ATTRIBUTE_Join, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Square},
    {0xe8f118a8, L"keyCertSign", XFA_ATTRIBUTE_KeyCertSign,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xe948b9a8, L"radius", XFA_ATTRIBUTE_Radius, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0xe996b2fe, L"sourceAbove", XFA_ATTRIBUTE_SourceAbove,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Config,
     (void*)XFA_ATTRIBUTEENUM_Warn},
    {0xea7090a0, L"override", XFA_ATTRIBUTE_Override, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xeb091003, L"classId", XFA_ATTRIBUTE_ClassId, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xeb511b54, L"disable", XFA_ATTRIBUTE_Disable, XFA_ATTRIBUTETYPE_Boolean,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, (void*)0},
    {0xeda9017a, L"scope", XFA_ATTRIBUTE_Scope, XFA_ATTRIBUTETYPE_NOTSURE,
     XFA_XDPPACKET_Config | XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xf197844d, L"match", XFA_ATTRIBUTE_Match, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Once},
    {0xf2009339, L"placement", XFA_ATTRIBUTE_Placement, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Left},
    {0xf4ffce73, L"before", XFA_ATTRIBUTE_Before, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_Auto},
    {0xf531b059, L"writingScript", XFA_ATTRIBUTE_WritingScript,
     XFA_ATTRIBUTETYPE_Enum, XFA_XDPPACKET_Config,
     (void*)XFA_ATTRIBUTEENUM_Asterisk},
    {0xf575ca75, L"endChar", XFA_ATTRIBUTE_EndChar, XFA_ATTRIBUTETYPE_Cdata,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form, nullptr},
    {0xf6b47749, L"lock", XFA_ATTRIBUTE_Lock, XFA_ATTRIBUTETYPE_Integer,
     XFA_XDPPACKET_Config, (void*)0},
    {0xf6b4afb0, L"long", XFA_ATTRIBUTE_Long, XFA_ATTRIBUTETYPE_Measure,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)(g_XFAMeasurementData + 0)},
    {0xf6b59543, L"intact", XFA_ATTRIBUTE_Intact, XFA_ATTRIBUTETYPE_Enum,
     XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     (void*)XFA_ATTRIBUTEENUM_None},
    {0xf889e747, L"xdpContent", XFA_ATTRIBUTE_XdpContent,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
    {0xfea53ec6, L"decipherOnly", XFA_ATTRIBUTE_DecipherOnly,
     XFA_ATTRIBUTETYPE_Cdata, XFA_XDPPACKET_Template | XFA_XDPPACKET_Form,
     nullptr},
};
const int32_t g_iXFAAttributeCount =
    sizeof(g_XFAAttributeData) / sizeof(XFA_ATTRIBUTEINFO);

const XFA_NOTSUREATTRIBUTE g_XFANotsureAttributes[] = {
    {XFA_Element::SubformSet, XFA_ATTRIBUTE_Relation, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Ordered},
    {XFA_Element::NumberPattern, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Numeric},
    {XFA_Element::KeyUsage, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::LabelPrinter, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Zpl},
    {XFA_Element::CalendarSymbols, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Gregorian},
    {XFA_Element::Barcode, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Cdata,
     nullptr},
    {XFA_Element::Barcode, XFA_ATTRIBUTE_Checksum, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_None},
    {XFA_Element::TimePattern, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Med},
    {XFA_Element::BatchOutput, XFA_ATTRIBUTE_Format, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_None},
    {XFA_Element::SubjectDNs, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Issuers, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::EncryptionMethods, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Pattern, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_CrossHatch},
    {XFA_Element::Compress, XFA_ATTRIBUTE_Scope, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_ImageOnly},
    {XFA_Element::Image, XFA_ATTRIBUTE_TransferEncoding, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Base64},
    {XFA_Element::TimeStamp, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Subform, XFA_ATTRIBUTE_Scope, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Name},
    {XFA_Element::Handler, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Record, XFA_ATTRIBUTE_Max, XFA_ATTRIBUTETYPE_Integer,
     (void*)0},
    {XFA_Element::Command, XFA_ATTRIBUTE_Timeout, XFA_ATTRIBUTETYPE_Integer,
     (void*)30},
    {XFA_Element::DigestMethods, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::PageSet, XFA_ATTRIBUTE_Relation, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_OrderedOccurrence},
    {XFA_Element::Equate, XFA_ATTRIBUTE_From, XFA_ATTRIBUTETYPE_Cdata, nullptr},
    {XFA_Element::Equate, XFA_ATTRIBUTE_To, XFA_ATTRIBUTETYPE_Cdata, nullptr},
    {XFA_Element::Traverse, XFA_ATTRIBUTE_Operation, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Next},
    {XFA_Element::Encodings, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Signing, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Oids, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Signature, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_PDF1_3},
    {XFA_Element::ExData, XFA_ATTRIBUTE_TransferEncoding,
     XFA_ATTRIBUTETYPE_Enum, (void*)XFA_ATTRIBUTEENUM_None},
    {XFA_Element::Linear, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_ToRight},
    {XFA_Element::CurrencySymbol, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Symbol},
    {XFA_Element::EquateRange, XFA_ATTRIBUTE_From, XFA_ATTRIBUTETYPE_Cdata,
     nullptr},
    {XFA_Element::EquateRange, XFA_ATTRIBUTE_To, XFA_ATTRIBUTETYPE_Cdata,
     nullptr},
    {XFA_Element::SignData, XFA_ATTRIBUTE_Operation, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Sign},
    {XFA_Element::DatePattern, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Med},
    {XFA_Element::Bind, XFA_ATTRIBUTE_TransferEncoding, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_None},
    {XFA_Element::Reasons, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::AppearanceFilter, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Form, XFA_ATTRIBUTE_Checksum, XFA_ATTRIBUTETYPE_Cdata,
     nullptr},
    {XFA_Element::Value, XFA_ATTRIBUTE_Override, XFA_ATTRIBUTETYPE_Boolean,
     (void*)0},
    {XFA_Element::Calculate, XFA_ATTRIBUTE_Override, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Error},
    {XFA_Element::Connect, XFA_ATTRIBUTE_Timeout, XFA_ATTRIBUTETYPE_Integer,
     (void*)15},
    {XFA_Element::Submit, XFA_ATTRIBUTE_Format, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Xdp},
    {XFA_Element::Radial, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_ToEdge},
    {XFA_Element::LockDocument, XFA_ATTRIBUTE_Type, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Optional},
    {XFA_Element::Occur, XFA_ATTRIBUTE_Max, XFA_ATTRIBUTETYPE_Integer,
     (void*)1},
    {XFA_Element::NumberSymbol, XFA_ATTRIBUTE_Name, XFA_ATTRIBUTETYPE_Enum,
     (void*)XFA_ATTRIBUTEENUM_Decimal},
};
const int32_t g_iXFANotsureCount =
    sizeof(g_XFANotsureAttributes) / sizeof(XFA_NOTSUREATTRIBUTE);
