/*
 * $Id: AttributeEvaluator.java 644022 2008-04-02 19:46:59Z apetrelli $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tiles.evaluator;

import java.util.Map;

import org.apache.tiles.Attribute;
import org.apache.tiles.context.TilesRequestContext;

/**
 * It represents an object that resolves a string to return an object.
 *
 * @version $Rev: 644022 $ $Date: 2008-04-02 21:46:59 +0200 (mer, 02 apr 2008) $
 * @since 2.1.0
 */
public interface AttributeEvaluator {

    /**
     * Initializes the attribute evaluator.
     *
     * @param initParameters The initialization parameters.
     * @since 2.1.0
     */
    void init(Map<String, String> initParameters);

    /**
     * Evaluates an expression.
     *
     * @param expression The expression to evaluate.
     * @param request The request object.
     * @return The evaluated object.
     * @since 2.1.0
     */
    Object evaluate(String expression, TilesRequestContext request);

    /**
     * Evaluates an attribute value.
     *
     * @param attribute The attribute to evaluate.
     * @param request The request object.
     * @return The evaluated object.
     * @since 2.1.0
     */
    Object evaluate(Attribute attribute, TilesRequestContext request);
}
