/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.mviz;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.LineBorder;
import net.tinyos.mviz.DDocument;
import net.tinyos.mviz.DLink;
import net.tinyos.mviz.DLinkModel;
import net.tinyos.mviz.DMote;
import net.tinyos.mviz.DMoteModel;
import net.tinyos.mviz.DNavigate;
import net.tinyos.mviz.DShape;

public class DLayer
extends JPanel
implements ActionListener {
    public static final int MOTE = 0;
    public static final int LINK = 1;
    public static final int FIELD = 2;
    private static final Color[] COLORS = new Color[]{new Color(231, 220, 206), new Color(250, 210, 99), new Color(209, 230, 179)};
    private int type;
    protected int index;
    protected int zIndex;
    protected int z_index = 0;
    private ArrayList layer = new ArrayList();
    private JLabel label;
    private JCheckBox check;
    private String[][] DISPLAYS = new String[][]{{"circle", "img", "txt"}, {"line", "line+label", "label"}, {"color 256", "color 1024", "color 4096", "color 16384"}};
    private JComboBox displays;
    private ArrayList models;
    private ArrayList linkModels;
    private JButton up;
    private JButton down;
    protected int paintMode = 0;
    public static final int COLOR_256 = 0;
    public static final int OVAL = 1;
    public static final int COLOR_1024 = 2;
    public static final int IMG = 3;
    public static final int COLOR_4096 = 4;
    public static final int TXT_MOTE = 5;
    public static final int COLOR_16384 = 6;
    public static final int LINE = 7;
    public static final int LABEL = 8;
    public static final int LINE_LABEL = 9;
    protected DNavigate navigator;
    private String name;
    private DDocument parent;

    public DLayer(int n, int n2, String string, int n3, DDocument dDocument, ArrayList arrayList, DNavigate dNavigate) {
        this.parent = dDocument;
        this.type = n3;
        this.models = arrayList;
        this.zIndex = n;
        this.index = n2;
        this.navigator = dNavigate;
        this.name = string;
        if (n3 == 0) {
            this.paintMode = 1;
        } else if (n3 == 1) {
            this.paintMode = 7;
        }
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.setMaximumSize(new Dimension(350, 25));
        this.setPreferredSize(new Dimension(350, 25));
        this.setSize(new Dimension(350, 25));
        this.setDoubleBuffered(true);
        this.setBackground(COLORS[n3]);
        this.setBorder(new LineBorder(new Color(155, 155, 155)));
        this.check = new JCheckBox();
        this.check.setSize(35, 25);
        this.check.setMaximumSize(new Dimension(35, 25));
        this.check.setMinimumSize(new Dimension(35, 25));
        this.check.setPreferredSize(new Dimension(35, 25));
        this.up = new JButton("^");
        this.up.setFont(new Font("Times", 0, 9));
        this.up.setSize(25, 25);
        this.up.setMaximumSize(new Dimension(25, 25));
        this.up.setMinimumSize(new Dimension(25, 25));
        this.up.setPreferredSize(new Dimension(25, 25));
        this.up.setMargin(new Insets(2, 2, 2, 2));
        this.down = new JButton("v");
        this.down.setFont(new Font("Times", 0, 8));
        this.down.setSize(25, 25);
        this.down.setMaximumSize(new Dimension(25, 25));
        this.down.setMinimumSize(new Dimension(25, 25));
        this.down.setPreferredSize(new Dimension(25, 25));
        this.down.setMargin(new Insets(2, 2, 2, 2));
        this.label = new JLabel(" " + string, 2);
        this.label.setSize(125, 25);
        this.label.setMaximumSize(new Dimension(125, 25));
        this.label.setMinimumSize(new Dimension(125, 25));
        this.label.setPreferredSize(new Dimension(125, 25));
        switch (n3) {
            case 0: {
                this.label.setBackground(new Color(255, 200, 200));
                break;
            }
            case 2: {
                this.label.setBackground(new Color(200, 255, 200));
                break;
            }
            case 1: {
                this.label.setBackground(new Color(200, 200, 255));
                break;
            }
        }
        this.displays = new JComboBox<String>(this.DISPLAYS[n3]);
        this.displays.setSize(100, 25);
        this.displays.setMinimumSize(new Dimension(125, 25));
        this.displays.setPreferredSize(new Dimension(125, 25));
        this.check.addActionListener(this);
        this.up.addActionListener(this);
        this.down.addActionListener(this);
        this.displays.addActionListener(this);
        springLayout.putConstraint("West", (Component)this, 0, "West", (Component)this.down);
        springLayout.putConstraint("East", (Component)this.check, 0, "West", (Component)this.down);
        springLayout.putConstraint("East", (Component)this.down, 0, "West", (Component)this.up);
        springLayout.putConstraint("East", (Component)this.up, 0, "West", (Component)this.label);
        springLayout.putConstraint("East", (Component)this.label, 0, "West", (Component)this.displays);
        springLayout.putConstraint("East", (Component)this.displays, 0, "East", (Component)this);
        this.add(this.check);
        this.add(this.down);
        this.add(this.up);
        this.add(this.label);
        this.add(this.displays);
    }

    public boolean isFieldSelected() {
        return this.type == 2 && this.check.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.check) {
            if (this.check.isSelected()) {
                this.parent.selectedFieldIndex = this.index;
            } else if (this.type == 2) {
                // empty if block
            }
        } else if (actionEvent.getSource() == this.up) {
            this.parent.navigator.moveLayerUp(this.zIndex);
        } else if (actionEvent.getSource() == this.down) {
            this.parent.navigator.moveLayerDown(this.zIndex);
        } else if (actionEvent.getSource() == this.displays) {
            String string = (String)this.displays.getSelectedItem();
            if (string.equals("circle")) {
                this.paintMode = 1;
            } else if (string.equals("img")) {
                this.paintMode = 3;
            } else if (string.equals("txt")) {
                this.paintMode = 5;
            } else if (string.equals("color 256")) {
                this.paintMode = 0;
            } else if (string.equals("color 1024")) {
                this.paintMode = 2;
            } else if (string.equals("color 4096")) {
                this.paintMode = 4;
            } else if (string.equals("color 16384")) {
                this.paintMode = 6;
            } else if (string.equals("line")) {
                this.paintMode = 7;
            } else if (string.equals("label")) {
                this.paintMode = 8;
            } else if (string.equals("line+label")) {
                this.paintMode = 9;
            }
        }
    }

    public void init() {
        if (this.type != 1) {
            this.addMotes(true);
        }
    }

    public String toString() {
        return "Layer " + this.name + " " + this.type;
    }

    protected void addMote(DMoteModel dMoteModel, boolean bl) {
        DMote dMote = new DMote(dMoteModel, this.parent, this);
        this.layer.add(dMote);
    }

    private void addMotes(boolean bl) {
        Iterator iterator = this.models.iterator();
        while (iterator.hasNext()) {
            this.addMote((DMoteModel)iterator.next(), bl);
        }
    }

    public void updateIndex(int n, boolean bl) {
        this.zIndex = n;
        this.z_index = (this.navigator.totalLayers - this.zIndex) * 100;
    }

    public void paintScreenBefore(Graphics graphics) {
        Dimension dimension = this.parent.canvas.getSize();
        int n = 0;
        int n2 = dimension.width / 40;
        int n3 = dimension.height / 40;
        for (int i = 0; i < dimension.width; i += n2) {
            for (n = 0; n < dimension.height; n += n3) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 1.0E7;
                for (DMoteModel dMoteModel : this.models) {
                    double d5 = this.distance(i, n, dMoteModel.x, dMoteModel.y);
                    if (d5 < d4) {
                        d4 = d5;
                    }
                    d += (double)((int)dMoteModel.getValue(this.index) >> this.paintMode) / d5 / d5;
                    d2 += 1.0 / d5 / d5;
                }
                int n4 = (int)(d / d2);
                if (n4 > 255) {
                    n4 = 255;
                }
                graphics.setColor(new Color(n4, n4, n4));
                graphics.fillRect(i, n, n2, n3);
            }
        }
    }

    public double distance(int n, int n2, int n3, int n4) {
        return Math.sqrt((n - n3) * (n - n3) + (n2 - n4) * (n2 - n4));
    }

    protected void repaintLayer(Graphics graphics) {
        block2: {
            block4: {
                block3: {
                    if (!this.check.isSelected()) break block2;
                    if (this.type != 2) break block3;
                    this.paintScreenBefore(graphics);
                    break block2;
                }
                if (this.type != 1) break block4;
                for (DLinkModel dLinkModel : this.models) {
                    DLink dLink = new DLink(dLinkModel, this.parent, this);
                    dLink.paintShape(graphics);
                }
                break block2;
            }
            if (this.type != 0) break block2;
            for (DMoteModel dMoteModel : this.models) {
                DMote dMote = new DMote(dMoteModel, this.parent, this);
                ((DShape)dMote).paintShape(graphics);
            }
        }
    }
}

