/*
 * Copyright (c) 2008 Johns Hopkins University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the copyright holders nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
 * LoadFromRAM is a simple program that dynamically loads two loadable
 * programs hardcoded in the byte arrays; One program is Blink, and the
 * other one is Basestation.
 *
 * @author Chieh-Jan Mike Liang <cliang4@cs.jhu.edu>
 */

module LoadFromRAMP 
{
  uses {
    interface Boot;
    interface DynamicLoader;
    interface Leds;
  }
}

implementation
{
  // The following blinks led 2
  uint8_t code1[] = {
    0x1c, 0x00, 0x01, 0x00, 0x03, 0x00, 0x05, 0x00, 0x01, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x00,
    0x28, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x01, 0x00, 0x2c, 0x00, 0x08, 0x00, 0x44, 0x00, 0x09, 0x00,
    0x56, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x30, 0x00, 0x24, 0x00, 0x0f, 0x42, 0x12, 0xc3, 0x0f, 0x10,
    0x0f, 0x11, 0x0f, 0x11, 0x5f, 0xf3, 0x32, 0xc2, 0x03, 0x43, 0x7f, 0xf3, 0x30, 0x41, 0x4f, 0x93,
    0x01, 0x24, 0x32, 0xd2, 0x30, 0x41, 0x3c, 0x40, 0xf4, 0x01, 0x0d, 0x43, 0x3e, 0x40, 0x00, 0x00,
    0x3f, 0x40, 0x00, 0x00, 0xb0, 0x12, 0x00, 0x00, 0x30, 0x41, 0xb0, 0x12, 0x00, 0x00, 0x3e, 0x40,
    0xe8, 0x03, 0x0f, 0x43, 0xb0, 0x12, 0x4e, 0x00, 0xf8, 0x3f, 0x30, 0x41, 0xb0, 0x12, 0x00, 0x00,
    0x3e, 0x40, 0xe8, 0x03, 0x0f, 0x43, 0xb0, 0x12, 0x60, 0x00, 0xf8, 0x3f, 0x30, 0x41, 0xb0, 0x12,
    0x00, 0x00, 0x3e, 0x40, 0xe8, 0x03, 0x0f, 0x43, 0xb0, 0x12, 0x00, 0x00, 0xf8, 0x3f, 0x30, 0x41
  };

  // The following is BaseStationForC
  uint8_t code2[] = {
    0x1c, 0x00, 0x05, 0x00, 0x58, 0x01, 0x1e, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x26, 0x03, 0xac, 0x00,
    0x26, 0x00, 0xae, 0x00, 0x88, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x01, 0x00, 0x52, 0x00, 0x02, 0x00,
    0x64, 0x00, 0x01, 0x00, 0x44, 0x00, 0x08, 0x00, 0xe2, 0x00, 0x09, 0x00, 0x00, 0x02, 0x0a, 0x00,
    0xdc, 0x00, 0x0b, 0x00, 0x32, 0x00, 0x0d, 0x00, 0x10, 0x03, 0x0e, 0x00, 0x98, 0x01, 0x11, 0x00,
    0xd6, 0x02, 0x12, 0x00, 0xce, 0x02, 0x14, 0x00, 0x9c, 0x02, 0x16, 0x00, 0xc6, 0x02, 0x1a, 0x00,
    0x94, 0x02, 0x1b, 0x00, 0xde, 0x02, 0x22, 0x00, 0x2e, 0x00, 0x24, 0x00, 0xb6, 0x00, 0x25, 0x00,
    0xfa, 0x02, 0x28, 0x00, 0x84, 0x02, 0x29, 0x00, 0x7c, 0x02, 0x2b, 0x00, 0xee, 0x02, 0x2d, 0x00,
    0x74, 0x02, 0x31, 0x00, 0xe6, 0x02, 0x32, 0x00, 0x8c, 0x02, 0x3f, 0x00, 0xa2, 0x00, 0x40, 0x00,
    0x04, 0x01, 0x42, 0x00, 0x18, 0x01, 0x44, 0x00, 0x98, 0x00, 0x45, 0x00, 0xec, 0x00, 0x46, 0x00,
    0x0e, 0x01, 0x51, 0x00, 0x8a, 0x01, 0x6d, 0x00, 0x6c, 0x01, 0x90, 0x00, 0x22, 0x00, 0xb0, 0x00,
    0x3c, 0x00, 0x84, 0x01, 0x4e, 0x00, 0x92, 0x01, 0x60, 0x00, 0x0a, 0x03, 0x72, 0x00, 0x18, 0x03,
    0x84, 0x00, 0xbe, 0x00, 0xba, 0x00, 0x28, 0x01, 0xf4, 0x00, 0x00, 0x00, 0x46, 0x01, 0xa0, 0x01,
    0x9c, 0x01, 0x18, 0x02, 0xbc, 0x01, 0xb8, 0x02, 0xfc, 0x01, 0x66, 0x02, 0x08, 0x02, 0x0f, 0x42,
    0x12, 0xc3, 0x0f, 0x10, 0x0f, 0x11, 0x0f, 0x11, 0x5f, 0xf3, 0x32, 0xc2, 0x03, 0x43, 0x7f, 0xf3,
    0x30, 0x41, 0x4f, 0x93, 0x01, 0x24, 0x32, 0xd2, 0x30, 0x41, 0x3f, 0x40, 0x40, 0x00, 0xb0, 0x12,
    0x2a, 0x00, 0x3f, 0x40, 0x76, 0x00, 0xb0, 0x12, 0x00, 0x00, 0xb0, 0x12, 0x00, 0x00, 0xb0, 0x12,
    0x00, 0x00, 0x3c, 0x40, 0xc8, 0x00, 0x0d, 0x43, 0x3e, 0x40, 0x00, 0x00, 0x3f, 0x40, 0xb2, 0x00,
    0xb0, 0x12, 0x56, 0x00, 0x3c, 0x40, 0xc8, 0x00, 0x0d, 0x43, 0x3e, 0x40, 0x00, 0x00, 0x3f, 0x40,
    0x00, 0x00, 0xb0, 0x12, 0x68, 0x00, 0x3c, 0x40, 0xc8, 0x00, 0x0d, 0x43, 0x3e, 0x40, 0x00, 0x00,
    0x3f, 0x40, 0x00, 0x00, 0xb0, 0x12, 0x7a, 0x00, 0x3c, 0x40, 0xc8, 0x00, 0x0d, 0x43, 0x3e, 0x40,
    0x00, 0x00, 0x3f, 0x40, 0x0c, 0x03, 0xb0, 0x12, 0x8c, 0x00, 0x3c, 0x40, 0xc8, 0x00, 0x0d, 0x43,
    0x3e, 0x40, 0x00, 0x00, 0x3f, 0x40, 0x00, 0x00, 0xb0, 0x12, 0x00, 0x00, 0x30, 0x41, 0x0b, 0x12,
    0x0b, 0x4f, 0x2f, 0x52, 0xb0, 0x12, 0x00, 0x00, 0x0f, 0x4b, 0x3f, 0x50, 0x0a, 0x00, 0xb0, 0x12,
    0x00, 0x00, 0xcb, 0x43, 0xaa, 0x00, 0xcb, 0x43, 0xab, 0x00, 0x3b, 0x41, 0x30, 0x41, 0x3e, 0x40,
    0x86, 0x01, 0x3f, 0x40, 0x00, 0x00, 0xb0, 0x12, 0x8e, 0x01, 0x30, 0x41, 0x0b, 0x12, 0x0a, 0x12,
    0x09, 0x12, 0x31, 0x80, 0x34, 0x00, 0x09, 0x4f, 0x0b, 0x4e, 0x7c, 0x43, 0x0d, 0x43, 0x0e, 0x43,
    0x0f, 0x41, 0x89, 0x12, 0x4f, 0x93, 0x03, 0x24, 0xb0, 0x12, 0x00, 0x00, 0xf6, 0x3f, 0xb0, 0x12,
    0x00, 0x00, 0x0a, 0x4b, 0x2a, 0x52, 0x0f, 0x4a, 0xb0, 0x12, 0xb6, 0x01, 0x0e, 0x41, 0x0f, 0x4b,
    0xb0, 0x12, 0x00, 0x00, 0x5f, 0x93, 0x07, 0x20, 0x0e, 0x4a, 0x0f, 0x4b, 0x3f, 0x50, 0x0a, 0x00,
    0xb0, 0x12, 0xcc, 0x01, 0xf3, 0x3f, 0x0f, 0x4b, 0x2f, 0x52, 0xb0, 0x12, 0xe6, 0x01, 0x0f, 0x4b,
    0x3f, 0x50, 0x0a, 0x00, 0xb0, 0x12, 0xf0, 0x01, 0xd8, 0x3f, 0x31, 0x50, 0x34, 0x00, 0x39, 0x41,
    0x3a, 0x41, 0x3b, 0x41, 0x30, 0x41, 0x0b, 0x12, 0x0a, 0x12, 0x09, 0x12, 0x09, 0x4f, 0x0d, 0x4e,
    0xff, 0x90, 0x03, 0x00, 0xaa, 0x00, 0x20, 0x2c, 0x5f, 0x4f, 0xab, 0x00, 0x0a, 0x4f, 0x3c, 0x40,
    0x34, 0x00, 0xb0, 0x12, 0x48, 0x02, 0x0e, 0x59, 0x3e, 0x50, 0x0e, 0x00, 0x0f, 0x4d, 0x3d, 0x40,
    0x34, 0x00, 0xfe, 0x4f, 0x00, 0x00, 0x1e, 0x53, 0x1d, 0x83, 0xfb, 0x23, 0x5f, 0x49, 0xab, 0x00,
    0x1f, 0x53, 0x0c, 0x4f, 0x3a, 0x40, 0x03, 0x00, 0xb0, 0x12, 0x3e, 0x02, 0xc9, 0x4e, 0xab, 0x00,
    0xd9, 0x53, 0xaa, 0x00, 0x0f, 0x43, 0x01, 0x3c, 0x1f, 0x43, 0x39, 0x41, 0x3a, 0x41, 0x3b, 0x41,
    0x30, 0x41, 0x3e, 0x40, 0x94, 0x01, 0x3f, 0x40, 0x00, 0x00, 0xb0, 0x12, 0x14, 0x03, 0x30, 0x41,
    0x3e, 0x40, 0x00, 0x00, 0x3f, 0x40, 0xf4, 0x01, 0xb0, 0x12, 0x22, 0x03, 0x30, 0x41, 0x0b, 0x12,
    0x0a, 0x12, 0x09, 0x12, 0x31, 0x80, 0x34, 0x00, 0x09, 0x4f, 0x0b, 0x4e, 0x0a, 0x4b, 0x2a, 0x52,
    0x0f, 0x4a, 0xb0, 0x12, 0x00, 0x00, 0x0f, 0x4b, 0xb0, 0x12, 0x00, 0x00, 0x0f, 0x93, 0x07, 0x20,
    0x0e, 0x4a, 0x0f, 0x4b, 0x3f, 0x50, 0x0a, 0x00, 0xb0, 0x12, 0x00, 0x00, 0xf4, 0x3f, 0x0d, 0x41,
    0x3e, 0x40, 0x34, 0x00, 0xfd, 0x4f, 0x00, 0x00, 0x1d, 0x53, 0x1e, 0x83, 0xfb, 0x23, 0x0f, 0x4b,
    0x2f, 0x52, 0xb0, 0x12, 0x00, 0x00, 0x0f, 0x4b, 0x3f, 0x50, 0x0a, 0x00, 0xb0, 0x12, 0x00, 0x00,
    0x39, 0x90, 0xa8, 0x02, 0x06, 0x24, 0x0f, 0x41, 0xb0, 0x12, 0x00, 0x00, 0xb0, 0x12, 0x00, 0x00,
    0xd5, 0x3f, 0x0f, 0x41, 0xb0, 0x12, 0x00, 0x00, 0xf9, 0x3f, 0x31, 0x50, 0x34, 0x00, 0x39, 0x41,
    0x3a, 0x41, 0x3b, 0x41, 0x30, 0x41, 0x0b, 0x12, 0x0a, 0x12, 0x09, 0x12, 0x08, 0x12, 0x09, 0x4f,
    0x58, 0x4f, 0xaa, 0x00, 0x48, 0x93, 0x18, 0x24, 0x5f, 0x4f, 0xab, 0x00, 0x4e, 0x48, 0x0f, 0x8e,
    0x3f, 0x50, 0x03, 0x00, 0x0c, 0x4f, 0x3a, 0x40, 0x03, 0x00, 0xb0, 0x12, 0x00, 0x00, 0x0a, 0x4e,
    0x3c, 0x40, 0x34, 0x00, 0xb0, 0x12, 0x00, 0x00, 0x0f, 0x4e, 0x0f, 0x59, 0x78, 0x53, 0xc9, 0x48,
    0xaa, 0x00, 0x3f, 0x50, 0x0e, 0x00, 0x01, 0x3c, 0x0f, 0x43, 0x38, 0x41, 0x39, 0x41, 0x3a, 0x41,
    0x3b, 0x41, 0x30, 0x41, 0x0b, 0x12, 0x0a, 0x12, 0x09, 0x12, 0x08, 0x12, 0x07, 0x12, 0x0b, 0x4f,
    0xb0, 0x12, 0x00, 0x00, 0x47, 0x4f, 0x0f, 0x4b, 0xb0, 0x12, 0x00, 0x00, 0x09, 0x4f, 0x0f, 0x4b,
    0xb0, 0x12, 0x00, 0x00, 0x08, 0x4f, 0x0f, 0x4b, 0xb0, 0x12, 0x00, 0x00, 0x4a, 0x4f, 0x0f, 0x4b,
    0xb0, 0x12, 0x00, 0x00, 0x0e, 0x49, 0x0f, 0x4b, 0xb0, 0x12, 0x00, 0x00, 0x4c, 0x47, 0x4d, 0x4a,
    0x0e, 0x4b, 0x0f, 0x48, 0xb0, 0x12, 0x00, 0x00, 0x7f, 0xf3, 0x37, 0x41, 0x38, 0x41, 0x39, 0x41,
    0x3a, 0x41, 0x3b, 0x41, 0x30, 0x41, 0x0b, 0x12, 0x0a, 0x12, 0x09, 0x12, 0x08, 0x12, 0x07, 0x12,
    0x0b, 0x4f, 0xb0, 0x12, 0x00, 0x00, 0x47, 0x4f, 0x0f, 0x4b, 0xb0, 0x12, 0x00, 0x00, 0x09, 0x4f,
    0x0f, 0x4b, 0xb0, 0x12, 0x00, 0x00, 0x08, 0x4f, 0x0f, 0x4b, 0xb0, 0x12, 0x00, 0x00, 0x4a, 0x4f,
    0x0f, 0x4b, 0xb0, 0x12, 0x00, 0x00, 0x0e, 0x49, 0x0f, 0x4b, 0xb0, 0x12, 0x00, 0x00, 0x4c, 0x47,
    0x4d, 0x4a, 0x0e, 0x4b, 0x0f, 0x48, 0xb0, 0x12, 0x1e, 0x03, 0x7f, 0xf3, 0x37, 0x41, 0x38, 0x41,
    0x39, 0x41, 0x3a, 0x41, 0x3b, 0x41, 0x30, 0x41, 0x3e, 0x40, 0x1a, 0x03, 0x3f, 0x40, 0x00, 0x00,
    0xb0, 0x12, 0x00, 0x00, 0x30, 0x41, 0x3e, 0x40, 0x00, 0x00, 0x3f, 0x40, 0x00, 0x00, 0xb0, 0x12,
    0x00, 0x00, 0x30, 0x41
  };

  task void loadCode1() {
    call DynamicLoader.loadFromMemory(code1);
  }

  task void loadCode2() {
    call DynamicLoader.loadFromMemory(code2);
  }

  event void DynamicLoader.loadFromMemoryDone(void *addr, tosthread_t id, error_t error)
  {
    if (addr == code1) {
      post loadCode2();
    }
  }

  event void Boot.booted() {
    post loadCode1();
  }
  
  event void DynamicLoader.loadFromFlashDone(uint8_t volumeId, tosthread_t id, error_t error) {}
}
