// $Id: LqiForwardingEngineP.nc,v 1.16 2010-06-29 22:07:50 scipio Exp $

/* Copyright (c) 2010 Stanford University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the Stanford University nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL STANFORD
 * UNIVERSITY OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @author Omprakash Gnawali
 */


/* applications use this interface to get/set metadata for source routing */

  interface SourceRoutePacket
  {
    command error_t clearRoute(message_t *msg);

    //NOTE: mismatch with SourceRouteSend.send (nx_am_addr_t vs. am_addr_t)
    command error_t setRoute(message_t *msg, nx_am_addr_t *path, uint8_t len);
    command nx_am_addr_t* getRoute(message_t *msg);

    command uint8_t getRouteLen(message_t *msg);
    command error_t setRouteLen(message_t *msg, uint8_t len);

    command am_addr_t getNextHop(message_t *msg);
    command am_addr_t getDest(message_t *msg);
    command am_addr_t getSource(message_t *msg);

    command uint8_t getHopsLeft(message_t *msg);
    command error_t setHopsLeft(message_t *msg, uint8_t hopsLeft);
    
    command uint8_t getSeqNo(message_t *msg);
  }
