/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CHANGEUSERNICKNAME_H
#define CHANGEUSERNICKNAME_H

#include <QDialog>

class QHBoxLayout;
class QVBoxLayout;
class QLabel;
class QLineEdit;
class QPushButton;
class QMouseEvent;
class QKeyEvent;

class QDBusInterface;

class ChangeUserNickname : public QDialog
{
    Q_OBJECT

public:
    explicit ChangeUserNickname(QString nn, QStringList ns, QString op, QWidget *parent = nullptr);
    ~ChangeUserNickname();

public:
    void initUI();
    void setConnect();
    void setupStatus();

public:
    QVBoxLayout * mainVerLayout;
    QHBoxLayout * titleHorLayout;
    QVBoxLayout * contentVerLayout;
    QHBoxLayout * userNameHorLayout;
    QHBoxLayout * nickNameHorLayout;
    QHBoxLayout * tipHorLayout;
    QVBoxLayout * nickNameWithTipVerLayout;
    QHBoxLayout * computerNameHorLayout;
    QHBoxLayout * bottomBtnsHorLayout;

    QPushButton * closeBtn;
    QPushButton * cancelBtn;
    QPushButton * confirmBtn;

    QLabel * userNameLabel;
    QLabel * nickNameLabel;
    QLabel * computerNameLabel;
    QLabel * tipLabel;

    QLineEdit * userNameLineEdit;
    QLineEdit * nickNameLineEdit;
    QLineEdit * computerNameLineEdit;

protected:
    bool eventFilter(QObject *watched, QEvent *event);
    void keyPressEvent(QKeyEvent *);

private:
    bool setTextDynamicInNick(QLabel * label, QString string);
    void nameLegalityCheck(QString nickname);
    void refreshConfirmBtnStatus();

private:
    QString realname;
    QStringList namesIsExists;
    QString tipString;
    QString oldNickName;

    QDBusInterface * cniface;

};

#endif // CHANGEUSERNICKNAME_H
